---
name: managing-timelines
description: Help users set and hit realistic deadlines. Use when someone is planning project timelines, struggling to hit deadlines, dealing with timeline pressure from stakeholders, or trying to improve estimation accuracy.
---

# Managing Timelines

Help the user set and hit realistic project timelines using approaches from 13 product leaders.

## How to Help

When the user asks for help with timelines:

1. **Understand the context** - Ask about the nature of the deadline (external commitment, internal target, manufactured milestone), the stage of the work, and what's driving the timeline pressure
2. **Diagnose the problem** - Determine if this is an estimation issue, a scoping issue, a distraction issue, or unrealistic stakeholder expectations
3. **Apply the right framework** - Help them use phase-based commitments, hill charts, or early shipping strategies depending on their situation
4. **Build healthy habits** - Guide them toward sustainable timeline practices rather than one-time fixes

## Core Principles

### Treat real deadlines as P0 - nothing else matters
Nan Yu: "The only way to make deadlines real is to take them so seriously that they are basically like a P0 problem, and everything else has to not matter in comparison." Don't have too many deadlines. Reserve them for critical external events and protect the team from all other distractions once set.

### Commit to phases, not distant delivery dates
Annie Pearl: "We've moved to committing to dates that are within our control. We can commit to a discovery effort... versus making a commitment around a project six months out when we haven't done enough discovery." Break work into Discovery, Solutioning, Build, and Launch. Only provide engineering delivery dates once solutioning is complete.

### Ship early, iterate with remaining time
Nan Yu: "We do almost no estimating. What we do is ship as early as we can. If by 10% of the time you have a working thing, you can spend the rest deciding whether to iterate or polish." Focus on getting to a "yes or no" shippable state quickly rather than front-loading estimation.

### Use hill charts to track uncertainty
Jason Fried: "A project's more like a hill. The left side means you're still figuring it out. Once work gets to the top, it's downhill from there - pure execution." Visualize work as a hill where left side is discovery and right side is execution. Items stuck on the uphill side are high-risk for missing deadlines.

### Manufacture deadlines to create momentum
Laura Modi: "Your job is not just to keep people going on momentum. Your job is to make momentum. Sometimes that has to be manufactured." Set arbitrary deadlines and launch dates to force progress. Use milestones to prevent over-perfecting.

### Challenge hidden padding in estimates
Dylan Field: "If timelines are maybe not well reasoned through from first principles and there's padding that has been well intentionally added, you have to understand the assumptions of how long things will actually take." Ask "why" to uncover hidden constraints or unnecessary padding. Work through assumptions from first principles.

### Account for the planning fallacy
Nir Eyal: "Tasks take people three times longer to finish than they estimate. When you work on something for five minutes and then get an email and a notification, you never actually track how long it took." Measure productivity by whether you did what you said you would without distraction. Use time-boxing to create feedback loops on actual duration.

### Don't ask for extensions
Seth Godin: "The professional doesn't ask for an extension because the professional understands that things you didn't expect are going to happen." Treat deadlines and budgets as hard constraints. Build buffers into plans to handle the unexpected without extensions.

### Review weekly with RAG status
Brian Chesky: "I had a head program manager that would score all projects green, yellow, or red. I'd review the work every week and if something wasn't happening, I'd stop the meeting and ask 'Why isn't this happening?'" Elevate program management. Use simple RAG status and weekly reviews to identify and unblock issues early.

### Expect AI timelines to be uneven
Aparna Chennapragada: "Time to first demo is much shorter, but time to full deployment is going to take longer. There's an uneven cadence." Plan for a shortened inner loop for prototyping but allocate significant time for the outer loop of scaling. Manage expectations about the gap between demo and shippable product.

## Questions to Help Users

- "Is this an external commitment or an internal target? What happens if you miss it?"
- "What phase is the work in - discovery, solutioning, or build?"
- "Have you shipped a 'working version' yet, or is the team still figuring things out?"
- "Where is the padding in this estimate? What assumptions are baked in?"
- "How much of your time is actually going to focused work vs. meetings and distractions?"
- "Are there too many 'P0 deadlines' competing for attention?"

## Common Mistakes to Flag

- **Committing to dates before discovery is done** - You can't estimate what you haven't scoped. Commit to phases, not distant delivery dates
- **Too many high-priority deadlines** - If everything is P0, nothing is. Reserve real deadlines for critical external events
- **Front-loading estimation instead of shipping early** - Get to a working version fast and use remaining time to iterate
- **Ignoring the planning fallacy** - Tasks take 3x longer than estimated due to distractions. Time-box and measure actual focused work
- **Asking for extensions** - Professionals account for the unexpected. Build buffers rather than extending timelines

## Deep Dive

For all 14 insights from 13 guests, see `references/guest-insights.md`

## Related Skills

- Scoping and Cutting
- Prioritizing Roadmap
- Running Effective Meetings
- Planning Under Uncertainty
