# Managing Timelines - All Guest Insights

*13 guests, 14 mentions*

---

## Ada Chen Rekhi
*Ada Chen Rekhi*

> "Figure out, maybe the night before, the one thing that you want to get done in your day, and then at the earliest opportunity, just try to give yourself five minutes on it."

**Insight:** Overcome 'productive procrastination' by committing to just five minutes of your most important task early in the day.

**Tactical advice:**
- Identify your 'one thing' the night before.
- Use the 'five-minute rule' to lower the mental hurdle of starting a difficult task.

*Timestamp: 01:15:43*


## Annie Pearl
*Annie Pearl*

> "Something we've done over the last year is really kind of moved to a model of talking about dates and promising and committing to dates that are within our control. And so, if you think about the product development life cycle, we can commit to a discovery effort... we've gotten a lot better at making the commitments around the work that's right in front of us versus making a commitment around a project six months out when we haven't even done enough discovery."

**Insight:** Commit to dates only for the immediate phase of work (discovery or solutioning) rather than long-term delivery dates for un-scoped projects.

**Tactical advice:**
- Break the lifecycle into Discovery, Solutioning, Build, and Launch.
- Only provide engineering delivery dates once the solutioning phase is complete and estimation is accurate.

*Timestamp: 00:36:30*


## Aparna Chennapragada
*Aparna Chennapragada*

> "What I'm seeing is that the time to first demo is much shorter, but the time to a full deployment is going to take longer. So I think that there's going to be an uneven cadence. So typically, I think there was much more of a you've been this thing, you take a few weeks and then you can iterate and so on. But that inner loop of prototyping and iterating and getting even user research through AI conversations, all of that gets shortened. But I think the bar for scale, therefore becomes much high."

**Insight:** AI development creates an uneven cadence where initial prototypes happen rapidly, but reaching production-grade scale and reliability takes significantly longer than traditional software.

**Tactical advice:**
- Plan for a shortened 'inner loop' for prototyping and discovery
- Allocate significant time for the 'outer loop' of scaling and deployment
- Manage stakeholder expectations regarding the gap between a successful demo and a shippable product

*Timestamp: 00:24:04*


## Brian Chesky
*Brian Chesky*

> "I had a head program manager that would score all the projects. Either they're green, yellow, or red. Meaning they're on track or not on track to ship... I use the reviews of the work every single week. And the reason there's not a lot of bureaucracy... is I'd review the work and if something wasn't happening, then I would stop the meeting and say, 'Why isn't this happening?'"

**Insight:** Use high-status program management and frequent executive reviews to maintain shipping velocity and identify bottlenecks.

**Tactical advice:**
- Elevate program management to a high-status role
- Use a simple RAG (Red, Amber, Green) status for project tracking
- Review work weekly to identify and unblock individual engineers

*Timestamp: 00:27:11*


## Dylan Field
*Dylan Field 2.0*

> "If timelines are maybe not well reasoned through from first principles and perhaps there's padding that has been well intentionally added by different folks, you have to understand fully, okay, what are the assumptions of how long things will actually take and what is a padding? Then, really work through that with the team."

**Insight:** Challenge timeline estimates by digging into the underlying assumptions and identifying unnecessary padding.

**Tactical advice:**
- Ask 'why' to uncover hidden constraints or unnecessary padding in estimates
- Work through timeline assumptions from first principles with the team

*Timestamp: 00:10:27*


## Eli Schwartz
*Eli Schwartz*

> "When you're building out an SEO effort, and I'm going to keep going back to this, it's a product. So you're building out a product and you're creating milestones... Now, if you start missing all those milestones... you can point very specifically to all those milestones that were missed."

**Insight:** SEO projects should be managed with product milestones to ensure accountability and track progress before final results are visible.

**Tactical advice:**
- Set monthly milestones for ideation, PRD creation, engineering sprints, and shipping
- Use 'pages indexed' as an early milestone to validate that the technical build is working

*Timestamp: 00:52:28*


## Jackson Shuttleworth
*Jackson Shuttleworth*

> "There's heavy Jira automation... making sure that you have really good process around how are you going to run so many experiments... We're planning months out, as we think about these feature iterations, even small ones, feature iterations, because when you lose cycles, not pushing on a feature, it's just sort of lost opportunity."

**Insight:** High-velocity experimentation requires rigorous process and automated project management to avoid 'lost cycles.'

**Tactical advice:**
- Use Jira automation to manage experiment pipelines.
- Plan design and engineering bandwidth months in advance to ensure continuous iteration.

*Timestamp: 01:08:41*


## Jason Fried
*Jason Fried*

> "We have these things in Basecamp called hill charts. And things that are on, that's actually work... A project's more like a hill. It's not like a linear line. If you're on the left side of the hill, it means you're still pushing this thing up the hill. You're still trying to figure out how to do this. But once work gets to the top, it's downhill from there. It's just pure execution and we know how to nail it."

**Insight:** Track project progress using 'hill charts' to distinguish between the uncertainty of discovery and the certainty of execution.

**Tactical advice:**
- Visualize work as a hill: the left side is 'figuring it out' and the right side is 'execution'
- Identify projects stuck on the 'uphill' side as high-risk for missing deadlines
- Focus management attention on moving items from the left side of the hill to the top

*Timestamp: 00:37:17*


## Laura Modi
*Laura Modi*

> "Your job is not just to keep people going on momentum. Your job is to make momentum. And sometimes that momentum has to be manufactured. And that has been one of my biggest lessons on just how, as leaders and people starting companies, how do you force yourself? And sometimes when it's early on, you're actually just doing it to yourself, creating manufactured deadlines and launch dates."

**Insight:** Leaders must often create arbitrary deadlines to maintain organizational velocity.

**Tactical advice:**
- Set 'manufactured' deadlines and launch dates to force progress.
- Use arbitrary milestones to prevent the team from over-perfecting and missing opportunities.

*Timestamp: 00:52:56*


## Nan Yu
*Nan Yu*

> "The only way to make deadlines real is to take them so seriously that they are basically like a P0 problem, and everything else has to not matter in comparison to the deadline because that's the only way you're going to be able to signal to the team and also to all the stakeholders that you're actually taking it seriously."

**Insight:** Deadlines only work if they are treated as the highest priority (P0) where nothing else matters in comparison.

**Tactical advice:**
- Don't have too many deadlines; only use them for critical external events.
- Protect the team from all other distractions once a deadline is set.

*Timestamp: 01:09:38*

---

> "We do almost no estimating in order to hit deadlines. What we do is we ship as early as we can. The thing we talked about earlier where if by the time that 10% of the time has elapsed, you have a working thing, you can now spend the rest of the time deciding whether or not you want to do another iteration or you want to polish that thing."

**Insight:** Hit deadlines by shipping a functional version early and using the remaining time for iterations rather than relying on upfront estimation.

**Tactical advice:**
- Focus on getting to a 'yes or no' shippable state as quickly as possible.
- Commit to the process of fast iteration from the start of the project.

*Timestamp: 01:13:18*


## Nir Eyal
*Nir Eyal*

> "tasks take people three times longer to finish than they estimate. Why does that happen? Because when you say, 'Okay, here's that thing on the to-do list. I'm going to work on that and see how long it takes me to get it done.' So, you work on it for five minutes and then you get an email and then you get a notification... you never actually track how long that thing took you to finish"

**Insight:** The planning fallacy occurs because we don't account for distractions; accurate timelines require measuring focused work time.

**Tactical advice:**
- Measure productivity by whether you did what you said you would do for as long as you said you would without distraction.
- Use time-boxing to create a feedback loop on how long tasks actually take.
- Switch from a to-do list (output-focused) to a calendar (input-focused) to understand constraints.

*Timestamp: 00:32:53*


## Seth Godin
*Seth Godin*

> "The thing about projects is when you run out of time and you run out of money, the project is over. Don't run out of time, don't run out of money. Good intentions are no reason for an extension. The professional doesn't ask for an extension because the professional understands that things you didn't expect are going to happen."

**Insight:** Professionalism in product management means accounting for the unexpected and shipping within the original constraints of time and budget.

**Tactical advice:**
- Treat deadlines and budgets as hard constraints that define the end of the project.
- Build buffers into plans to handle inevitable unexpected events without asking for extensions.

*Timestamp: 14:49*


## Timothy Davis
*Timothy Davis*

> "We have this calculator that we look at that says, 'How much time are you spending in meetings?'... All right, next quarter, it's red again. All right, now maybe we need to start having the conversation of, what this new hire will take over."

**Insight:** Use a quantitative capacity calculator to justify new hires only when team members are consistently 'in the red' after optimizing their schedules.

**Tactical advice:**
- Track meeting time, PTO, and optimization tasks against the total number of days in a quarter
- Cut non-essential meetings or project involvements before approving new headcount
- Wait for two consecutive quarters of 'red' capacity before initiating a hire

*Timestamp: 01:16:59*


