---
name: managing-up
description: Help users work effectively with their manager and executives. Use when someone is struggling with their manager relationship, needs to influence leadership, wants to get better at executive communication, or is trying to build trust with their boss.
---

# Managing Up

Help the user work effectively with their manager and executives using strategies from 35 product leaders.

## How to Help

When the user asks for help managing up:

1. **Understand the relationship** - Ask about their manager's style, what they care about, and where the friction or challenge is
2. **Diagnose the gap** - Determine if this is a communication issue, alignment issue, trust issue, or visibility issue
3. **Apply the right approach** - Help them choose between proactive updates, reframing conversations, building trust through wins, or direct feedback conversations
4. **Build sustainable habits** - Guide them toward ongoing practices rather than one-time fixes

## Core Principles

### Your manager is a resource to leverage, not an obstacle
Boz: "The advice I give more frequently than any other is for people to more directly leverage their leaders." Your primary job is to achieve results. Your manager has tools and authority to clear paths. Ask for help to bulldoze blockers rather than trying to solve everything yourself.

### Proactively communicate before they have to ask
Casey Winters: "People just way under communicate upward. Then they complain that executives are out of touch when they aren't telling executives what they need to know." Send weekly "state of" emails with priorities, blockers, and thoughts. Frame updates as "no response required" to keep leaders informed without creating burden.

### Understand two levels up
Fareed Mosavat: "You should understand your boss's priorities and your boss's boss's priorities. Eventually, that means you have to know what the board is thinking." Build a mental model of how your work creates leverage in the larger system. Tailor communication to address senior leadership's specific concerns.

### Bring recommendations, not just problems
Wes Kao: "When you ask 'Hey manager, what should we do?' you're putting a lot of cognitive load on them. Instead say 'Hey manager, here's what I think we should do.'" Present a point of view even if it's just an initial hunch. Provide insights and takeaways, not just raw data.

### Use structured update formats
Boz: "We used HPM - Highlight, People, Me. Every manager at Facebook would send this to their manager." Use consistent formats. Ask your manager: "How do you like to get information about me?" Consider weekly emails with priorities, blockers, and general thoughts.

### Position yourself as an ally who reduces burden
Ethan Evans: "Management can be a lonely job. Having an ally is a huge weight off people's shoulders." Recognize managers are overwhelmed. Move from asking "How can I help?" to suggesting specific solutions. Keep them in the loop by proactively fixing problems before they ask.

### Start with Chapter 1 when talking to execs
Casey Winters: "You have to start with chapter one, which is what part of the company strategy are you working on? What metrics are you trying to improve? What assumptions are you making?" Find the last point that's obvious to the audience and build from there. Don't dive into "Chapter 6" details without the strategic context.

### Use concrete artifacts, not abstract ideas
Dylan Field: "The more concrete an artifact is or the more you can debate something, the better. I ask for examples a lot." Present designs and docs rather than abstract ideas. If you lack data for a follow-up question, pause to find the answer rather than guessing.

### Run experiments to challenge strong opinions
Itamar Gilad: "If you run a secret experiment and come back with data, either they get extremely mad at you... or more commonly, they're pleasantly surprised." Use evidence to flip a leader's perspective rather than engaging in a battle of opinions.

### Understand the spirit, then offer better options
Jiaona Zhang: "It's understanding the spirit of what they're trying to achieve. Being able to go back with 'I understand the spirit, but here's a better way to achieve it.'" Align on the underlying goal first. Present automated or scalable alternatives rather than just saying no.

### Use the U-curve for founder involvement
Noah Weiss: "High involvement at the start for strategy and at the end for quality, with autonomy in the middle." Involve founders early for strategic buy-in on goals. Bring them back at the end to ensure the product meets quality standards.

### Say what you'll do, say you're doing it, say you did it
Peter Deng: "Say you're going to do the thing, say that you're doing the thing, and then say that you did it." This repetitive communication ensures alignment and provides opportunities for course correction.

## Questions to Help Users

- "What does your manager care most about right now? What's keeping them up at night?"
- "How does your manager prefer to receive information - email, Slack, meetings?"
- "Do they know what you're working on this week without having to ask?"
- "When you bring problems to them, are you also bringing recommendations?"
- "What does success look like for your team from your manager's perspective?"
- "Have you asked your manager directly how they'd like you to communicate?"

## Common Mistakes to Flag

- **Under-communicating** - If your manager has to ask what's going on, you're not communicating enough. Proactive updates build trust
- **Bringing problems without recommendations** - This puts cognitive load on your manager. Always come with a point of view
- **Starting with details, not strategy** - Executives need context. Start with "Chapter 1" (strategy) before "Chapter 6" (details)
- **Trying to solve everything alone** - Your manager has tools and authority you don't. Leverage them to clear blockers
- **Waiting to be managed** - The most senior people got there by being great at managing up. It's a proactive skill, not resentment

## Deep Dive

For all 50 insights from 35 guests, see `references/guest-insights.md`

## Related Skills

- Running Effective 1:1s
- Having Difficult Conversations
- Stakeholder Alignment
- Written Communication
