# Managing Up - All Guest Insights

*35 guests, 50 mentions*

---

## Alex Komoroske
*Alex Komoroske*

> "The underlying dynamic that must be true in any organization on a fundamental basis is you can't make your boss look dumb because if you do, they're the person who decides, 'Oh, this person's not performing,' or whatever. And that one little asymmetry, that one little fact... is what leads to the systemic compounding thing where you get these really weird dysfunctional emergent things that everybody hates."

**Insight:** Organizational dysfunction often stems from the simple power asymmetry where subordinates feel they cannot challenge a leader's public narrative without personal risk.

**Tactical advice:**
- Acknowledge 'organizational kayfabe'—the things everyone pretends are true—to navigate the system without being 'knocked out of the game.'
- Find ways to introduce disconfirming evidence that doesn't feel like an existential threat to leadership.

*Timestamp: 00:29:12*


## Ami Vora
*Ami Vora*

> "With Max, I also wrote a parallel document of hot takes. So once a quarter or so for the first year, I'd write a document that was just like, hey, for sake of provocation, if we wanted to fundamentally change a few things, here's ideas on what we could fundamentally change."

**Insight:** Build a high-trust relationship with a CEO by proactively sharing provocative strategic observations.

**Tactical advice:**
- During onboarding, write a list of themes and observations to build credibility.
- Create a 'hot takes' document to spark discussion on fundamental changes with the executive team.

*Timestamp: 01:09:09*


## Anneka Gupta
*Anneka Gupta*

> "As having a founder that can effectively operate in founder mode means that I can go and have a conversation with the CEO and say, "Hey, look, we have this huge opportunity and these are the things that aren't working, and I need your help to help figure out how we can move the needle more substantially in the direction that we need to go.""

**Insight:** A product leader can leverage a founder's unique power as a resource to unblock major initiatives and drive organizational change.

**Tactical advice:**
- Activate the CEO as an ally to push initiatives that require high-level power to move the needle.
- When a founder pushes a 'pet project,' identify the underlying objective and suggest alternative options that meet that goal more effectively.

*Timestamp: 00:11:23*


## Bangaly Kaba
*Bangaly Kaba*

> "A lot of times I think there is a big disconnect between an IC focusing on their discrete area and try to optimize for local maxima, versus understanding, okay, my manager's thinking about these things and this is how I fit in, and understanding maybe they have a gap to understanding why your area is important."

**Insight:** Effective managing up requires understanding your manager's broader objectives and showing how your work supports those goals.

**Tactical advice:**
- Identify what your manager is currently optimizing for and find synergies with your own remit.
- Take on adjacent tasks that are on your manager's plate to alleviate their burden and increase your scope.

*Timestamp: 00:18:28*


## Boz
*Boz*

> "The advice I find I have to give more frequently than any other in my career, as a manager, a board member, an advisor and a friend, is for people to more directly leverage their leaders."

**Insight:** Your primary job is to achieve results, and your manager is a resource with tools and authority that can clear paths and accelerate your work.

**Tactical advice:**
- Ask for help to bulldoze blockers rather than trying to solve everything yourself.
- Frame updates as 'no response required' to keep leaders informed without creating a burden.
- Provide a 'heartbeat' or 'ping' to your manager so they have a mental model of your progress.

*Timestamp: 00:13:40*

---

> "We actually used to have a format for that we called HPMs. Highlight, people, me. And every manager at Facebook from like 2008 to like 2014 would send to their manager, or even their leadership group."

**Insight:** A structured, consistent update format helps leaders quickly digest status, team health, and personal sentiment.

**Tactical advice:**
- Use the HPM (Highlight, People, Me) framework for weekly updates.
- Ask your manager directly: 'How do you like to get information about me?'

*Timestamp: 00:20:02*

---

> "Mark's voracious for all information and all points of view... you'll give him feedback, he listens... over the course of the next week or two, you'll just see shifts."

**Insight:** When managing highly effective leaders, provide feedback and allow them time to 're-compile' their worldview with the new data.

**Tactical advice:**
- Take the long view when giving feedback to senior leaders; they may pressure-test your input with others before acting.
- Be direct with concerns, but deliver them with a belief that the situation can be improved.

*Timestamp: 00:45:08*


## Bret Taylor
*Bret Taylor*

> "I probably credit Sheryl Sandberg for really changing the way I approach new jobs... She pulled me into a room and gave me talking to."

**Insight:** Successful career growth requires being receptive to direct, high-stakes feedback from executives and adapting your role to the company's needs.

**Tactical advice:**
- Reflect on whether you are doing what you 'like' or what is most impactful for the organization

*Timestamp: 00:15:09*


## Casey Winters
*Casey Winters*

> "I find that in general people just way under communicate upward inside of companies. And then they'll complain that executives are out of touch when they aren't telling executives what the executives need to know."

**Insight:** Executives often appear out of touch because teams fail to proactively communicate the context and trade-offs necessary for informed leadership.

**Tactical advice:**
- Escalate issues early so leaders can help change the circumstances rather than just dealing with them
- Communicate explicit trade-offs to ensure leaders can evaluate results with the proper context

*Timestamp: 08:14*

---

> "One of the ways I try to frame it to my team is if you're not an executive, whatever you're working on, you're basically writing and telling a story. And when you talk to an exec about that story, you have to start with chapter one, which is what part of the company strategy are you working on? What metrics are you trying to improve? What assumptions are you making that are guiding what you're building?"

**Insight:** Effective upward communication requires grounding the narrative in high-level strategy (Chapter 1) before diving into the specific work (Chapter 6).

**Tactical advice:**
- Start presentations with the company strategy and metrics before discussing specific features
- Find the last point in your story that is completely obvious to the audience and build from there

*Timestamp: 09:14*

---

> "Something I commonly say is that executive communication is actually executives communication. You're communicating with individual executives that all have different styles and different concerns about the business or about the particular problem you're working on."

**Insight:** Upward communication must be tailored to the specific concerns and styles of individual executives rather than treated as a generic audience.

**Tactical advice:**
- Anticipate the specific questions a CFO vs. a CEO will ask and weave answers into the early part of the story
- Assume executive questions are a desire to learn rather than a test of your knowledge

*Timestamp: 13:18*


## Christian Idiodi
*Christian Idiodi*

> "The most powerful way I have found to get trust with many people is to have them accountable for an outcome of mine, which is to know. So if I wanted to accelerate trust with Lenny, I will ask Lenny to teach me."

**Insight:** Build trust with powerful stakeholders by asking them to teach you, which makes them psychologically invested in your success and competence.

**Tactical advice:**
- Identify the most influential or 'loudest' person in the organization and ask them to mentor you.
- Volunteer to 'intern' or shadow a leader to learn what drives their influence.
- By having a leader teach you, you effectively extend their internal trust to yourself.

*Timestamp: 00:55:44*


## Chip Conley
*Chip Conley*

> "Brian assumed everybody else was going to work at the same pace and duration... His point of view is like, 'Hey, we're having a meeting in the office tonight at 10 o'clock. Be there.'"

**Insight:** Founders often assume employees share their extreme work pace, requiring boundaries and clear communication.

**Tactical advice:**
- Recognize when a founder's workaholism is one-dimensional
- Be prepared to push back on unreasonable meeting times if they don't align with your career stage

*Timestamp: 00:13:42*

---

> "I was mentoring Brian on leadership, but he was also my boss... It required me to have a certain amount of humility as well as to be reporting to a guy 21 years younger than me, Brian."

**Insight:** Managing up effectively requires balancing your own expertise with humility when reporting to a younger or less experienced leader.

**Tactical advice:**
- Don't pretend to know things you don't know
- Show respect to earn it in return
- Adopt a 'wise and curious' mindset

*Timestamp: 00:07:42*

---

> "I would say, 'Lenny, let's do a little pep talk, you and me before the meeting.' I want you to start the meeting with the following as you present and Brian's in the room. 'Brian, let's talk about what we're trying to accomplish here. Let's get really clear... on what both, what's the intention of this iteration that we're doing on the product? What defines success, and what do I want to get accomplished in this meeting?'"

**Insight:** Start meetings with high-intensity founders by explicitly aligning on intentions and success metrics to prevent the session from going off-track.

**Tactical advice:**
- Set alignment on the front end of every meeting
- Define what success looks like for the specific meeting
- Use the agreed-upon goals to redirect the conversation if the founder becomes 'combustible'

*Timestamp: 00:18:53*

---

> "I always wanted to really limit the deck as much as possible, because I didn't know where the meeting was going to go. I wanted the decks helpful at the start, at the very start, to just set principles, set goals."

**Insight:** When dealing with unpredictable founders, use minimal slide decks to maintain flexibility in the conversation.

**Tactical advice:**
- Limit the number of slides in your presentation
- Use decks primarily for setting principles and goals at the start

*Timestamp: 00:20:27*


## Christopher Miller
*Christopher Miller*

> "I think I was just willing to take some risks and really push for the things that I believed made sense even though maybe based on the titles that I had at the time, I wasn't sort of inherently given a seat at the table and really pushed my away into some of these conversations and then was eventually invited to them."

**Insight:** Successful product leaders often gain influence by proactively contributing to high-level strategy discussions before they are formally invited.

**Tactical advice:**
- Push for a seat at the table by having a well-formed perspective on business-level problems
- Widen your aperture beyond immediate execution to understand how different parts of the business connect

*Timestamp: 00:06:57*

---

> "we ran into the COO at the time and out of the blue I think he had asked us what we thought about pricing and packaging... we ended up kind of pitching in the midst of pints being sort of handed every which way you could turn this vision for a completely different way we might approach pricing and packaging, and he was pretty intrigued and he said, 'Why don't you come to the next executive meeting and pitch us on it?'"

**Insight:** Serendipitous encounters with executives are opportunities to pitch forward-thinking ideas if you have already done the pre-work.

**Tactical advice:**
- Have a 'ready-to-go' pitch for major business levers like pricing and packaging
- Use informal settings to test contrarian ideas with leadership

*Timestamp: 00:09:33*


## Claire Vo
*Claire Vo*

> "I sat for about a half a day and I thought, I think I can help here, drew out an org chart, put my name on the top, walked into my boss's office and said, 'This is one potential solve of your marketing organization question, is we'll bring product and marketing growth together. I can be in this position. Here's how I'd change the management structure underneath this.'"

**Insight:** Proactively solve leadership's structural gaps by proposing yourself as the solution with a fully formed plan.

**Tactical advice:**
- Draw out a proposed org chart to solve a leadership gap
- Write your own job description for the role you want to step into
- Focus on how the new structure provides leverage to your manager

*Timestamp: 00:06:54*


## Ethan Evans
*Ethan Evans 2.0*

> "Management can be a lonely job, because you feel like you're responsible for everything. So having an ally, it's just a huge weight off people's shoulders. And I think a lot about social engineering. The social engineering's here is just the simple, 'You help me, I'll help you.'"

**Insight:** Effective managing up involves positioning yourself as an ally who alleviates the manager's burden through reciprocal help.

**Tactical advice:**
- Recognize that managers are often overwhelmed and appreciate proactive support
- Move from asking 'How can I help?' to suggesting specific solutions as you gain seniority
- Keep your leader in the loop by proactively identifying and fixing problems before they ask

*Timestamp: 00:17:31*


## Fareed Mosavat
*Fareed Mosavat*

> "I call this going two stack levels up, two stack levels down in terms of your curiosity and what you understand... you should understand your boss's priorities and your boss's boss's priorities. Eventually, that means you have to know what the board is thinking."

**Insight:** Effective management and influence require understanding the strategic priorities and mental models of leaders two levels above your current role.

**Tactical advice:**
- Ask your manager directly about their highest priorities and their manager's priorities
- Build a mental model of how the entire company works and how your work creates leverage within that system
- Tailor your communication to address the specific concerns and goals of senior leadership

*Timestamp: 00:28:22*


## Itamar Gilad
*Itamar Gilad*

> "If you come with data, if you run a secret experiment and you come back and you show them you usually get one of two results. Either they get extremely mad at you... But the more common case is they're pleasantly surprised and that's what happened with Steve Jobs, as well."

**Insight:** Presenting hard evidence from small-scale experiments is the most effective way to challenge the opinions of strong-willed founders or executives.

**Tactical advice:**
- Run 'secret' or small-scale experiments to gather data before challenging a senior leader's opinion
- Use evidence to flip a leader's perspective rather than engaging in a battle of opinions

*Timestamp: 00:18:33*


## Jackie Bavaro
*Jackie Bavaro*

> "After a little bit of that, I was like, 'It might be easier if I just go, I might be able save you some time and some energy if I just joined you.' And it was a way that I took myself into this higher level meeting, framing it as something that was going to help out my boss. And it did. It wasn't dishonest, but it was a pretty effective way of advocating to get into this meeting."

**Insight:** To gain access to high-level decision-making forums, frame your participation as a way to reduce your manager's workload.

**Tactical advice:**
- Offer to attend meetings to capture action items or answer specific questions for your manager
- Frame requests for visibility as 'saving the manager time'

*Timestamp: 13:01*


## Jason Shah
*Jason Shah*

> "It shifted the pushback of like, 'We can't build this thing, it's too many features, we don't have enough time, we don't have enough resources' to, 'Oh, we all want a really elegant, really smooth, slick experience for our customers. How do we do that? What's a trip design or a new concept that is actually going to elevate things?'... It wasn't about saying no. It was about understanding what we're all actually sharing as a goal which was a great simple customer experience and then actually building that."

**Insight:** To successfully influence a founder or CEO, reframe your constraints as a way to better achieve their high-level vision.

**Tactical advice:**
- Identify the specific 'big idea' or 'end state' the leader is excited about (e.g., 'winning' or 'magical experience').
- Pitch your scope changes or alternative plans as the superior way to reach that specific end state.

*Timestamp: 00:40:26*


## Jerry Colonna
*Jerry Colonna*

> "One of the things to ask oneself is what draws me to this position in the first place? How have I been complicit, not responsible in creating the conditions I say I don't want. How have I benefited from the dysfunction that exists in this organization?"

**Insight:** When managing a difficult relationship with a superior, you must examine why you are drawn to that dynamic and how you might be enabling it.

**Tactical advice:**
- Identify if a dysfunctional work environment feels 'familiar' based on past personal experiences.
- Ask yourself how you might be benefiting from the current dysfunction (e.g., avoiding certain responsibilities).

*Timestamp: 01:16:05*


## Jeremy Henrickson
*Jeremy Henrickson*

> "You have to find a way to work with those [manager's idiosyncrasies]. And I think that adaptability, like I'm just sort of, I like being a moldable puzzle piece where I can just fit in."

**Insight:** Success with strong-willed founders requires high adaptability and a foundation of mutual respect.

**Tactical advice:**
- Identify where the founder cares most and where you can add the most value
- Build a foundation of respect to enable healthy debate on product decisions

*Timestamp: 01:00:47*


## Jiaona Zhang
*Jiaona Zhang*

> "it's understanding the spirit of what they're trying to achieve. Being able to go back with, 'Hey, I understand the spirit. The spirit is that we're trying to get people who previously didn't consider Airbnb before to come and use Airbnb, but the right way to do it is not this very time-intensive, cost-intensive way to inspect all these homes. The way to do it is to be much more granular in what we ask people when they upload their home and more checks in that. And that could be automated and through technology as opposed to through humans.' It's coming back with actual options."

**Insight:** To effectively push back on a founder's idea, align on the underlying goal and present alternative, more scalable solutions backed by data.

**Tactical advice:**
- Understand and acknowledge the 'spirit' of what the leader is trying to accomplish
- Present better options with data and strategic thinking rather than just saying 'no'
- Propose automated or scalable alternatives to manual, high-cost solutions

*Timestamp: 00:15:37*


## Julie Zhuo
*Julie Zhuo 2.0*

> "If you understand your manager's job, which is how to get better outcomes from the team, and also you understand what exactly would your manager consider success for the team, it also makes it easier for you to then be like, 'Oh, well if I do this project, then that clearly seems like it's a very direct path to creating value for the team.'"

**Insight:** Effective managing up requires understanding your manager's definition of success and aligning your work to those outcomes.

**Tactical advice:**
- Ask your manager: 'What do you consider success for the team?'
- Share your own 'hopes and dreams' with your manager to turn the relationship into a collaboration.

*Timestamp: 00:54:39*


## Kenneth Berger
*Kenneth Berger*

> "To me, it really is about the relationship with the CEO or with the founders because that's the root of a lot of the issues that come out of that scenario... Imagine that they're terrified all the time, and see if that makes their behavior more clear."

**Insight:** Understanding the inherent fear and pressure founders face can help reports interpret and navigate their behavior more effectively.

**Tactical advice:**
- Empathize with the founder's sense of high stakes and existential threat
- Prioritize building a healthy, transparent relationship with the founder above all else

*Timestamp: 00:58:05*


## Keith Coleman & Jay Baxter
*Keith Coleman & Jay Baxter*

> "One key attribute is there's one clear driver of the project, who's effectively a founder... and also there's one clear decision-maker that they go to. That was true back when we started and it is true now. If we need something or have a question about something, I talk to Elon."

**Insight:** To move fast within a large organization, establish a direct line to a single senior executive who can make final decisions.

**Tactical advice:**
- Identify one clear senior decision-maker to act as the project's primary stakeholder
- Maintain a direct communication loop with that stakeholder to bypass middle-management layers

*Timestamp: 00:42:43*


## Melissa Perri
*Melissa*

> "Where the gaps come between that and becoming an executive is interfacing with the board, understanding the financials super deeply so that you can create revenue projections off of what your roadmaps and your product's strategy is going to be."

**Insight:** Executive-level product leadership requires a deep understanding of financials and the ability to navigate relationships with the board and CFO.

**Tactical advice:**
- Learn to project revenue outcomes based on planned product initiatives to gain credibility with the board.
- Work closely with the CRO and CFO to align product strategy with business growth targets.

*Timestamp: 15:03*


## Nir Eyal
*Nir Eyal*

> "You print out your calendar or you show it to them on your screen, and you say, 'Hey boss, I need 10 minutes with you, Monday morning. Is that okay? Can I get 10 minutes with you?' And now, what you're going to do is you're going to show them your time box calendar for your working hours. You're going to say, 'Okay, boss, you see here's my time for email. Here's my time for that meeting you asked me to go to. Here's time for that big project I'm working on. Now, you see this other piece of paper? Okay, you see this other list here? This is a list of things you've asked me to do that I'm having trouble fitting into my calendar.'"

**Insight:** Use a visual time-boxed calendar to facilitate a prioritization conversation with your manager instead of simply saying 'no' to new tasks.

**Tactical advice:**
- Perform 'schedule syncing' by showing your manager your time-boxed calendar.
- Ask your manager to help prioritize tasks that don't fit into the current schedule.
- Avoid the advice of just saying 'no'; instead, ask for help with trade-offs.

*Timestamp: 01:06:02*


## Noah Weiss
*Noah Weiss*

> "The first is, I think as much as possible... is getting to the point where you have alignment on the principles for what it means to build a great product of that company. Not just about if the intuition and tasting gut, but how do you distill that to principles that become the language of the company so that everybody else can start thinking through a similar frame or similar lens when you're designing a product."

**Insight:** Align with product-minded founders by codifying their intuition into shared principles that the whole team can use as a common language.

**Tactical advice:**
- Distill founder intuition into written principles.
- Use these principles to avoid 'Goldilocks' reviews where teams guess what the founder wants.

*Timestamp: 00:12:52*

---

> "I think when to involve the founder CEO in a project is really important. The short version I think that works the best is almost like a U-curve where the X-axis is time and the Y-axis is level of involvement. I think you want to get the founder CEO really involved early on, especially if it's a big new project, to make sure that there's strategic buy-in... Then I think at the very end you want them to really be bought in that did you build something that's up to the quality... of the company?"

**Insight:** Manage executive involvement using a 'U-curve'—high involvement at the start for strategy and at the end for quality/polish, with autonomy in the middle.

**Tactical advice:**
- Involve founders early for strategic buy-in on goals and anti-goals.
- Bring founders back at the end to 'taste the soup' and ensure the product meets the brand's quality bar.

*Timestamp: 00:14:08*


## Noam Lovinsky
*Noam Lovinsky*

> "I went to Salar and said, 'Hey, I think I should actually report to Hunter. I think this would work better if we kind of combined the organizations this way and then we divided and conquered this way.' ... no one has ever come to me in my career and said, 'I would like you to layer me in this other person.' But in that moment I was just like, 'This is how I will do better work. This is how I will get better support.'"

**Insight:** Proactively suggest organizational changes, including being 'layered' under a different manager, if it provides better support and alignment for your work.

**Tactical advice:**
- Identify which manager's style and scope best support your current growth needs
- Propose reporting structure changes that optimize for team productivity over personal title

*Timestamp: 00:13:41*


## Raaz Herzberg
*Raaz Herzberg*

> "I think CMO is a very, very hard role. And also, I think it's a role that is very hard to do without a lot of trust, and without a deep connection to the founding team. Everything you do in marketing is very visible, and you're kind of touching something that matters so deeply to the founding team."

**Insight:** High-stakes leadership roles require a foundation of deep trust with founders because marketing decisions are highly visible and easily scrutinized.

**Tactical advice:**
- Build trust by demonstrating a deep understanding of the product and the market before attempting radical brand changes.

*Timestamp: 00:34:16*


## Ravi Mehta
*Ravi Mehta*

> "I think oftentimes people refrain from giving feedback when they feel like that feedback is going to be intrusive. So just inviting your manager to say, 'Look, I'm really looking to level up. Please give me feedback whenever you see something. You can give it to me in real time. Don't worry about wordsmithing it.'"

**Insight:** Proactively giving your manager 'permission' to be blunt reduces their social friction in providing high-volume feedback.

**Tactical advice:**
- Explicitly ask for real-time, unpolished feedback to increase the quantity of insights you receive.
- Reward your manager for giving feedback by responding enthusiastically, even if the feedback is difficult to hear.

*Timestamp: 01:05:06*

---

> "As someone who's working with a manager, there's kind of two things that you're constantly solving for. One is the degree to which you're aligned with your manager, and the second is the degree to which your manager has confidence in you."

**Insight:** The ability to deviate from a manager's preferred direction depends on the 'currency' of their confidence in your judgment.

**Tactical advice:**
- If you lack alignment, focus on building confidence through small wins to earn the right to take a different path.
- Map your relationship on a 2x2 of Alignment vs. Confidence to understand your current influence.

*Timestamp: 01:11:22*


## Sriram and Aarthi
*Sriram and Aarthi*

> "He would tell you what the rules of engagement were for every meeting... He'd be like, 'Look, I'm going to give you a spectrum of A, how much I care about this topic. Everything from I don't care... all the way to I'm the founder, I'm the CEO, just do this.'"

**Insight:** Effective leaders clarify their level of involvement and the 'rules of engagement' for every review meeting.

**Tactical advice:**
- Define the spectrum of your interest in a topic (FYI vs. Opinionated vs. Decision-maker).
- Articulate the logic tree behind your opinions so others can attempt to prove you wrong.

*Timestamp: 00:57:43*


## Shweta Shriva
*Shweta Shriva*

> "Making your ambitions known to your manager, to your leader, is a good thing that you should. And so, when the right opportunity comes, at least your leader or manager is aware that, hey, this person wanted to work on something more challenging, so maybe I put her on that project."

**Insight:** Proactively communicating your career ambitions allows leadership to align your growth with upcoming business opportunities.

**Tactical advice:**
- Explicitly state your desire for more challenging or high-visibility work to your manager.

*Timestamp: 34:03*


## Tom Conrad
*Tom Conrad*

> "Maybe I should have beat the drum a little harder about just how unlikely it was that we were going to land the kind of distribution in month one that the model sort of required. If I had to go back and do it again, I think I would spend maybe more time investing and illuminating that aspect of the digital universe."

**Insight:** Product leaders must aggressively challenge unrealistic leadership assumptions with data, especially regarding distribution and market reach.

**Tactical advice:**
- Use historical industry data to ground executive expectations
- Highlight the improbability of 'best-case' scenarios in distribution models

*Timestamp: 00:30:54*

---

> "I take the job full knowing that it's going to be wildly different than Pandora... in the context of Snapchat, at best, I was going to be Evan's right hand, a person that principally executed his vision."

**Insight:** When working for a visionary founder, the role of a product leader often shifts from defining vision to high-fidelity execution of the founder's direction.

**Tactical advice:**
- Clarify whether the role is to define strategy or to be an 'execution partner' to the founder
- Adapt your leadership style to complement a founder's specific strengths and involvement level

*Timestamp: 00:59:00*


## Wes Kao
*Wes Kao*

> "I think that most people assume that their boss has to manage them and they feel a little bit resentful that, why should I manage my boss? They're getting paid more. They are my manager. They have more responsibility. And you can continue to think that way and your career might be fine, but if you embrace that if you manage your boss, they're going to appreciate you much more, you're going to get more opportunities, you're going to have more trust with them, there's all these great things that happen when you decide to manage up."

**Insight:** Managing your manager is a proactive career strategy that builds trust and opens up more opportunities than waiting to be managed.

**Tactical advice:**
- Shift your mindset from resentment to proactive partnership with your manager.
- Focus on building trust by taking responsibilities off your manager's plate.

*Timestamp: 00:00:00*

---

> "the most senior people are best at managing up. This is why they got promoted in the first place because they were great at managing up to their bosses to understand what was worrying their bosses, what was keeping them up at night so that they could take that off their plate. They're great at keeping their bosses in the loop on what's happening so their bosses, aren't constantly having to ask and pepper them with questions every day"

**Insight:** Seniority is often a result of effective managing up, specifically by identifying and solving the manager's primary concerns.

**Tactical advice:**
- Identify what is 'keeping your boss up at night' and proactively address those issues.
- Communicate status updates before your manager has to ask for them.

*Timestamp: 00:32:29*

---

> "proactively giving the right amount of context for your manager to be able to weigh in on what you're doing and to be able to give feedback, I think that's super, super important. And then thinking about the right level of context to give them, is this a reversible decision or is this one that is irreversible or difficult to reverse or expensive to reverse?"

**Insight:** Effective managing up requires providing the appropriate level of context based on the risk and reversibility of the decision.

**Tactical advice:**
- Categorize decisions as reversible or irreversible to determine how much context to provide.
- Share your rationale and thought process so the manager can provide targeted feedback.

*Timestamp: 00:33:32*

---

> "I sent my manager a state of Lenny email every week, just titled the state of Lenny. And it had basically three sections, my priorities currently, blockers that I need their help with, and maybe that was the first thing that I put up just to make sure that they saw that, and then just things on my mind currently that week."

**Insight:** A structured weekly update email ensures alignment on priorities and surfaces blockers without requiring a meeting.

**Tactical advice:**
- Send a weekly 'state of' email to your manager.
- Include three sections: current priorities, blockers needing help, and general thoughts.

*Timestamp: 00:34:44*

---

> "When you just ask your manager, 'Hey manager, what should we do?' You're putting a lot of cognitive load on your manager to need to think about the problem, think about potential solutions, craft the solution, and then tell you what to do. Whereas if you instead said, 'Hey manager, here's what I think we should do.'"

**Insight:** Effective managing up involves bringing recommendations and points of view rather than just problems.

**Tactical advice:**
- Present a point of view (POV) even if it's just an initial hunch
- Provide insights and takeaways when sharing reports rather than just raw data

*Timestamp: 01:01:54*


## Yuhki Yamashata
*Yuhki Yamashata*

> "Dylan is very based on intuition and instinct... part of my job is to build out that logic streak for him of how did you arrive at that conclusion so that people can understand that at scale, in a way. But he's very much about that. Or I think there's a way which, sometimes, it's a product manager, you want to lay out a problem and say, okay, we're going to first focus on this problem, and then [inaudible 00:29:21] these three approaches. We're going to take this approach and have a review at every step along the way. But for Dylan, I think, it's very hard for him to really fully get bought into it until he sees the end implementation to viscerally feel if this is a good solution or not."

**Insight:** When working with an intuition-led founder, the CPO's role is to provide the logical framework and 'logic streak' that translates that intuition into scalable strategy.

**Tactical advice:**
- Build a 'logic streak' to support or explain a leader's intuition
- Provide high-fidelity end-state visualizations for leaders who need to 'see it to feel it'
- Contain 'founder madness' by creating structured channels for their ad-hoc feedback

*Timestamp: 00:29:09*


## Dylan Field
*Dylan Field*

> "I think the more concrete an artifact is or the more you can debate something, the better. I ask for examples a lot, I try to ask follow up questions about things and make sure I fully understand it. And I think where I get stuck sometimes is if I ask follow up questions and we don't have answers yet, and then my response might be, 'Let's go find the answer to these questions and then let's go back to this conversation', if I think it's something that's really important."

**Insight:** When influencing leadership, use concrete artifacts and be prepared to answer deep follow-up questions based on first principles.

**Tactical advice:**
- Present concrete artifacts (designs, docs) rather than abstract ideas to facilitate better debate
- If you lack data for a leader's follow-up question, pause the conversation to find the answer rather than guessing
- Argue from first principles to build trust in your decision-making process

*Timestamp: 15:05*


## Peter Deng
*Peter Deng*

> "Say you're going to do the thing, say that you're doing the thing, and then say that you did it... it's a great time to reaffirm you're doing or invite the conversation that this is no longer the thing to do."

**Insight:** Use repetitive communication to ensure alignment with leadership and provide opportunities for course correction.

**Tactical advice:**
- Explicitly state intentions before starting a project to calibrate with managers
- Provide updates during the process to allow for mid-stream feedback
- Close the loop by confirming completion to ensure impact is recognized

*Timestamp: 01:19:30*


