---
name: measuring-product-market-fit
description: Help users assess and achieve product-market fit. Use when someone is trying to determine if they have PMF, measuring user engagement and retention, running the Sean Ellis survey, or figuring out if they should scale or keep iterating.
---

# Measuring Product-Market Fit

Help the user assess and achieve product-market fit using frameworks from 46 product leaders.

## How to Help

When the user asks about product-market fit:

1. **Understand their stage** - Ask how many customers they have, what their retention looks like, and what signals they're seeing (or not seeing)
2. **Diagnose the situation** - Determine if they're confusing vanity metrics with PMF, if they have PMF in a specific segment, or if they're clearly pre-PMF
3. **Apply the right framework** - Help them use the Sean Ellis survey, retention curves, or reference customer counts depending on their situation
4. **Guide next steps** - Help them decide whether to scale or continue iterating based on the evidence

## Core Principles

### Use the Sean Ellis "disappointment" survey
Sean Ellis: "How would you feel if you could no longer use this product? Very disappointed, somewhat disappointed, or not disappointed. If 40% say 'very disappointed,' you're on the right track." This is a leading indicator of PMF before long-term retention data is available. Focus on the "very disappointed" segment as your core value indicator.

### Retention is the ultimate metric
Uri Levine: "Product market fit has one metric. Retention. If you create value, they will come back. If they're not coming back, you're not creating value." Look for retention curves that flatten over time rather than decaying to zero. The "smile curve" - where engagement increases over time - is the strongest signal.

### PMF is obvious when you have it
Matt MacInnis: "Product market fit is something where you absolutely know it when you see it. Therefore if you don't absolutely know it, you don't have it." If there's doubt, you likely don't have it. Look for the market pulling the product out of your hands.

### PMF is not static - it can be lost
Casey Winters: "Protecting what you've built is increasingly important once you build scale. You might fall out of product market fit in a year or five years if you're not continually making your product better." Markets shift, competitors improve, and user expectations rise.

### Reference customers validate PMF
Christian Idiodi: "The holy grail is really a reference customer - somebody who loves it enough to tell people about it. I want 6-8 references for B2B, 15-25 for B2C as an indication of PMF." Don't launch publicly until you have secured the target number of references from early users.

### PMF exists in segments, not universally
Karri Saarinen: "The way we think about it is, 'Do we have the fit in specific segments?' and how strong that fit is." Find PMF in one segment first (e.g., early-stage startups) before expanding. Double down where you see natural pull.

### PMF requires distribution, not just retention
Casey Winters: "If you have a product that retains well and you can't find more users for it, I don't think that's product market fit." True PMF requires both a retaining product AND a scalable, built-in distribution mechanism.

### PMF is multi-stage, not binary
Todd Jackson: "There's essentially four levels: nascent, developing, strong, extreme." Level 1 (3-5 customers), Level 2 (5-25 customers), Level 3 (25-100 customers), Level 4 (100+ customers). Sequence focus: satisfaction at Level 1, demand at Level 2, efficiency at Level 3.

### Look for customer "pull"
Raaz Herzberg: "We felt the questions change - 'How are you pricing this? When can we start a POV?' That's real intent." True pull is characterized by customers driving next steps, not just saying "this is interesting."

### A lack of outrage during outages = no PMF
Jeff Weinstein: "During those 20 minutes our customers weren't furious. That was the signal we did not have product market fit." If your product goes down and nobody notices or complains, you haven't solved a mission-critical problem.

## Questions to Help Users

- "If users couldn't use your product anymore, what percentage would be 'very disappointed'?"
- "What does your retention curve look like at day 7, 30, and 90?"
- "Do you have customers willing to be references and tell others about you?"
- "Is the market pulling the product from you, or are you pushing it on them?"
- "Are customers driving next steps (asking about pricing, timelines) or just being politely interested?"
- "What specific segment do you have the strongest fit in?"

## Common Mistakes to Flag

- **Confusing launch spikes with PMF** - Product Hunt success or press coverage doesn't mean you have PMF. Look for sustained organic growth
- **Ignoring retention data** - If users aren't coming back, you don't have PMF regardless of how many you acquire
- **Scaling too early** - Paid growth before PMF just burns cash and can damage your brand
- **Conflating TAM with PMF** - A large market opportunity doesn't mean you've achieved fit within it
- **Listening to "somewhat disappointed" users** - Focus on what makes "very disappointed" users love you, not what would make lukewarm users slightly happier

## Deep Dive

For all 64 insights from 46 guests, see `references/guest-insights.md`

## Related Skills

- Designing Growth Loops
- Retention & Engagement
- Conducting User Interviews
- Startup Pivoting
