# Measuring Product-Market Fit - All Guest Insights

*46 guests, 64 mentions*

---

## Adam Grenier
*Adam Grenier*

> "One of the biggest pieces of advice I'm giving to people that are like, "How should we adjust our marketing with the economic changes and things like that?" I was like, "Start by assuming you no longer have product market fit, because you had product market fit in a different market." It's a different market now, so you have to start over."

**Insight:** Product-market fit is not static; changes in the external economic environment can effectively reset your PMF even if the product remains the same.

**Tactical advice:**
- Assume you no longer have PMF when the market shifts significantly
- Re-evaluate your customer base rather than just looking for new acquisition channels

*Timestamp: 00:00:00*

---

> "It's probably the biggest flag that I see with a lot of companies that claim to have product market fit, which is your TAM and your product market fit are not using the same definition."

**Insight:** A common mistake is conflating a large Total Addressable Market (TAM) with actual product-market fit within that market.

**Tactical advice:**
- Ensure your definition of PMF aligns with the actual audience you are targeting within your TAM
- Map out what you need to see from early adopters to gain confidence in broader PMF

*Timestamp: 00:39:07*


## Ben Williams
*Ben Williams*

> "Starting with that narrow focus and building around community engagement... was important because of this kind of depth verse breadth approach and that depth-first approach that Snyk took was important to be able to effectively validate the solution on the path to product market fit."

**Insight:** Finding product-market fit often requires a 'depth-first' approach, focusing on a narrow persona and use case before expanding.

**Tactical advice:**
- Focus on a single persona and context (e.g., Node.js developers) to validate the solution
- Avoid going too wide too early to ensure the product nails the initial use case

*Timestamp: 00:17:14*


## Benjamin Lauzier
*Benjamin Lauzier*

> "If you don't have product market fit, and if you don't have a good enough growth strategy for at least one side of your marketplace, just forget about all this marketplace stuff. Focus on this core exchange of value, go deep with one side of the marketplace and see if you can rely on some crutch, some hack for the other side for time being."

**Insight:** Pre-product-market fit marketplaces should ignore complex marketplace dynamics and focus entirely on the core exchange of value and a growth strategy for one side.

**Tactical advice:**
- Focus on the 'hardest side' of the marketplace first (usually supply).
- Use hacks or 'crutches' (like Craigslist) to jumpstart the easier side while proving the core value proposition.

*Timestamp: 00:08:46*

---

> "The metric that I like the most is a predictor of liquidity. So your liquidity might be, it's typically a measure of demand utilization... how many of those searches with intent actually turn into a transaction. So, it's your field rate of your intentful demand typically, and that's really indicative of the net output of your marketplace."

**Insight:** Liquidity is best measured by the 'fill rate' of intentful demand, which represents the efficiency of the marketplace's matching engine.

**Tactical advice:**
- Identify 'intentful' users (e.g., those searching with specific dates or locations).
- Track the conversion rate from intent to transaction as the primary output metric.

*Timestamp: 00:18:26*

---

> "It's what I call a market health metric, and this is basically think of your proxy that is the best predictor of your liquidity... For Lyft and for Uber, it was ETAs. So, we knew that if the closest driver was at least two minutes away from you or closer, then we had hit a ceiling, you were more than X person likely to convert and book a ride."

**Insight:** A 'market health metric' is a leading indicator that predicts conversion and plateaus when the marketplace is healthy.

**Tactical advice:**
- Find the threshold where conversion rates plateau (e.g., a specific ETA or price point).
- Use this threshold as an actionable target for supply teams to work against.

*Timestamp: 00:19:19*

---

> "I like the classic if we were to take this product away, what percentage of users would be significantly disappointed or have no other solution? ... consider that you have two product market fits essentially. You want to make sure that you have a compelling enough value proposition on both sides of the marketplace."

**Insight:** Marketplaces require two distinct product-market fits, which can be measured using the Sean Ellis 'disappointment' survey for both supply and demand.

**Tactical advice:**
- Survey both sides of the marketplace independently to ensure the value proposition holds for both.
- Watch for cases where you have PMF on the demand side but the margins or experience aren't compelling enough for suppliers.

*Timestamp: 00:21:55*


## Brian Balfour
*Brian Balfour*

> "The data that Deedy published clearly show that both the retention curves... level off at significant portions higher than all the other platforms... They have the very elusive smile curve... It's an early indicator that that platform is on a trajectory to hit escape velocity."

**Insight:** Retention curves, specifically the 'smile curve,' are the most reliable indicators of a platform's long-term dominance and product-market fit.

**Tactical advice:**
- Prioritize retention and engagement depth over vanity metrics like signups.
- Look for 'smile curves' where usage increases over time due to network effects or data moats.

*Timestamp: 00:32:00*


## Casey Winters
*Casey Winters*

> "Protecting what you've built actually is increasingly important once you build scale... if you're not continually pushing to make your product better... you're eventually not necessarily tomorrow, but maybe in a year, maybe in five years, you might find yourself fall out of product market fit entirely."

**Insight:** Product-market fit is a moving target that can be lost if a company fails to keep pace with rising user expectations and competitive improvements.

**Tactical advice:**
- Frame technical maintenance as 'protecting the gains' to justify investment to leadership
- Continuously iterate on the core product to prevent falling behind the market's evolving baseline

*Timestamp: 28:48*

---

> "Founders are starting to intuit what I've written about a bit as well as you, which is that scalable acquisition or what we call an acquisition loop is a requirement for product market fit. Like if you got a product that retains well and you can't find more users for it, I don't think that's product market fit."

**Insight:** True product-market fit requires both a retaining product and a scalable, built-in distribution mechanism.

**Tactical advice:**
- Think about building growth loops into the product before reaching PMF to ensure distribution is ready for scale

*Timestamp: 49:12*


## Christian Idiodi
*Christian Idiodi*

> "The holy grail of product walk is really a reference customer. This is somebody that has used your solution or your product, loves it enough to tell people about it... I want six to eight references, for B2C, I want maybe 15 to 25 references as an indication that we've achieved product market fit."

**Insight:** Product-market fit is validated when a specific threshold of customers is willing to put their reputation on the line as a reference for your product.

**Tactical advice:**
- Target 6-8 reference customers for B2B products.
- Target 15-25 reference customers for B2C products.
- Do not launch publicly until you have secured the target number of 5-star references from early users.

*Timestamp: 00:17:35*

---

> "Product market fit is when you iterate it in this discovery, you've discovered and delivered something so meaningful that these customers that are your target customers, are willing to put their reputation on the line and be a reference."

**Insight:** PMF is the result of iterating discovery until target customers are willing to provide public testimonials.

**Tactical advice:**
- Use the 'reference' request as a litmus test for value: if a user won't give a review, find out the specific hesitation to uncover deeper discovery insights.
- Iterate on the product until the customer says it is the 'best in the world' for their specific problem.

*Timestamp: 00:28:37*


## Chris Hutchins
*Chris Hutchins*

> "Andy, he's legendary. If anyone listening to this, wants to learn about product market fit, Andy is your guy. I believe he coined the term, he teaches the class at Stanford. And the lesson was really find something people are reaching over the table want, and make sure you have that validation."

**Insight:** Product-market fit is identified when customers are so eager for a solution that they are effectively 'reaching over the table' to get it.

**Tactical advice:**
- Look for validation where users demand the product immediately
- Measure exponential organic growth as the primary indicator of PMF

*Timestamp: 00:09:29*


## Christopher Lochhead
*Christopher Lochhead*

> "What product market fit has come to mean is... 'achieved product market fit.' ... categories make products not the other way around. What you want is you want to design a market category for your product, not fit your product into a market category."

**Insight:** Product-market fit is often a 'better trap' that leads to competing for small market shares rather than dominating a new space.

**Tactical advice:**
- Design the market for the product instead of trying to fit the product into an existing market.

*Timestamp: 01:11:01*


## Claire Butler
*Claire Butler*

> "You can't optimize your way to product market fit. I don't care at the early stages if something's optimized by 5% from an email. That doesn't fundamentally tell me if something's working or not, so I think metrics are really hard and signal is actually way more important."

**Insight:** In the early stages, qualitative signal and user passion are more important than small percentage optimizations of metrics.

**Tactical advice:**
- Prioritize finding a few users who love the product over optimizing conversion funnels
- Focus on anecdotal evidence and deep user engagement as primary signals of fit

*Timestamp: 00:23:40*


## Dan Hockenmaier
*Dan Hockenmaier*

> "Even if you have a very few customers, if your cohorts look really good, they're retaining or even kind of like the classic smiling curve where you see more in engagement later in the life cycle than you do earlier, that's the thing that gives the company conviction to invest resources against it."

**Insight:** A 'smiling' retention curve, where engagement increases over time, is the strongest indicator of product-market fit and a signal to scale.

**Tactical advice:**
- Look for 'smiling' engagement curves in early cohorts to justify aggressive resource investment

*Timestamp: 00:46:20*


## Dalton Caldwell
*Dalton Caldwell*

> "I think you build conviction and you have this network effect virtual cycle where you get work conviction. The more customers reflect back to you and data reflects back to you that you're on the right track."

**Insight:** Conviction in product-market fit is a lagging indicator that builds through a virtuous cycle of customer feedback and data reflection.

**Tactical advice:**
- Monitor if customer feedback is consistently reflecting that you are on the right track
- Use increasing internal conviction as a proxy for moving toward PMF

*Timestamp: 00:51:12*


## Elena Verna
*Elena Verna 4.0*

> "product market fit as a concept is no longer what it used to be, and how every company basically has to recapture product market fit every three months."

**Insight:** In the AI era, PMF is not a static milestone but a 'treadmill' that must be constantly maintained due to rapid technological shifts.

**Tactical advice:**
- Re-evaluate product-market fit every 90 days to account for new LLM model releases and changing consumer expectations.

*Timestamp: 00:02:13*

---

> "The interesting piece here of how I relate to it, we still have the core users. And by the way, those core users are mostly pioneers right now that are excited by the capabilities. Then there's latent majority that is filled with adjacent users. And the issue right now... is that we're constantly focusing on recapturing the pioneers. We don't have time to go after adjacent users."

**Insight:** The rapid pace of AI forces companies to focus on retaining 'pioneers' (early adopters), potentially delaying expansion to the 'latent majority' (adjacent users).

**Tactical advice:**
- Be aware of the risk of alienating the 'latent majority' by over-indexing on high-end technical capabilities for pioneers.

*Timestamp: 01:07:39*


## Grant Lee
*Grant Lee*

> "We launched on Product Hunt, and felt really good. We had what we felt like was a great launch, ended up winning product of the day, product of the week, product of the month. And it was like, wow, I think we have something here. And then we'd look at signups, and you'd get that initial spike in signups, and then they sort of flatten out. We were still getting new users every day, but it was clear we didn't have strong word of mouth. There wasn't strong organic virality."

**Insight:** Vanity metrics like 'Product of the Day' can mask a lack of true product-market fit if organic word-of-mouth isn't building momentum.

**Tactical advice:**
- Distinguish between vanity launch spikes and a core growth engine.
- Be your own worst critic and look for 'pull' from the market where the product grows without marketing spend.

*Timestamp: 00:10:02*


## Gustaf Alstromer
*Gustaf Alstromer*

> "If I drill down what makes companies fail, it's quite simple. It's just like they don't talk to users, which means they don't find product market fit. And if they don't find product market fit, nothing else really matters."

**Insight:** Product-market fit is the only metric that matters in the early stages, and it is achieved solely through user conversation.

**Tactical advice:**
- Prioritize talking to customers over all other activities until PMF is found

*Timestamp: 00:00:00*

---

> "We have to remind everyone on the first day in YC, 'None of you have product market fit because you probably don't,' right? Almost nobody has. Because people confuse this external validation with the thing that matters the most, which is talking to customers and learning what matters."

**Insight:** Founders often mistake fundraising success or investor praise for actual product-market fit.

**Tactical advice:**
- Distinguish between external validation (investors, press) and customer validation (usage, feedback)

*Timestamp: 00:26:41*


## Ivan Zhao
*Ivan Zhao*

> "It never hit us as a binary state. Just like, 'Oh, good. We have people who care about this thing we make now.'... It's a very gradual ramp. Maybe that's why early days when it's really the lost eras, it doesn't feel too low because it just... Even for Notion today, it feels like it's so small in terms of where it could be."

**Insight:** Product-market fit is often a gradual ramp of increasing resonance rather than a single 'eureka' moment.

**Tactical advice:**
- Look for external signals like unsolicited investor interest or community-created economies as indicators of PMF.
- Focus on whether you are building the thing in your head better than you did last week rather than chasing binary milestones.

*Timestamp: 00:25:20*


## Jake Knapp + John Zeratsky
*Jake Knapp + John Zeratsky*

> "For over a decade, John and I have been, in quotes, designing time as part of our work with startups, helping them find or expand product market fit. So, we developed a design sprint at Google Ventures, which the Sprint book is about. And now, we run this venture fund of our own called Character. And we run these highly-structured sprints with companies."

**Insight:** Design sprints are a structured way to help startups find or expand product-market fit by controlling the workday defaults.

**Tactical advice:**
- Use highly-structured sprints to achieve big goals in short periods.
- Change the defaults of how the workday happens to focus on PMF.

*Timestamp: 00:07:01*

---

> "We help teams find and expand product market fit with Sprint. It's a tool for doing that and it uses a lot of these principles we talked about with Make Time to change the defaults, but not just the defaults of the way an individual works, but the ways teams work, the way people make decisions, the way we evaluate what's a good idea, a good strategy and worth pursuing based not on just a hunch or a guest, but based on something we can actually see with customer reactions."

**Insight:** Sprints facilitate PMF by moving from hunches to evaluating real customer reactions through prototypes.

**Tactical advice:**
- Evaluate strategies based on customer reactions rather than internal hunches.
- Use prototypes to test hypotheses quickly.

*Timestamp: 01:29:07*


## Jeff Weinstein
*Jeff Weinstein*

> "I missed a huge moment that I should have pounced on, which is that during those 20 minutes, our customers weren't furious. They weren't emailing us like crazy... I didn't realize at the time that was the signal that we did not have product market fit."

**Insight:** A lack of customer outrage during a service outage is a strong indicator that your product is not solving a mission-critical problem.

**Tactical advice:**
- Monitor customer reaction intensity during outages as a proxy for PMF.

*Timestamp: 00:18:11*

---

> "I just set a rule, which is, 'We discount all of that feedback from our friends to zero.' That is not of interest to us... We are only interested in Sarah, our target customer, and can we get her to solve whatever the problem is as quickly as possible."

**Insight:** Feedback from friends or non-paying users is often polite noise that distracts from the needs of the actual target customer.

**Tactical advice:**
- Explicitly ignore feedback from friends or people who aren't your specific target persona.

*Timestamp: 00:37:00*


## Jen Abel
*Jen Abel*

> "I think product market fit when you start with the market first, it's accelerated. ... Starting with a product is a hell of a lot riskier."

**Insight:** Starting with a deep understanding of a market problem accelerates the path to PMF, whereas starting with a technical insight is riskier but potentially has higher upside.

**Tactical advice:**
- Identify if you are solving a 'growing and widening' problem to ensure it is a priority for the market.

*Timestamp: 00:22:00*


## Jonathan Becker
*Jonathan Becker*

> "Product market fit. If you know that your business sells into audiences. Let's say you are a social media influencer or you had a really strong email marketing game, or organically your content surfaces within Google search results... If other things work, it is highly likely that paid acquisition will work."

**Insight:** Paid growth should only be scaled once product-market fit has been validated through other organic or direct channels.

**Tactical advice:**
- Verify PMF through organic search, email, or direct mail before investing heavily in performance marketing

*Timestamp: 00:21:18*


## Julia Schottenstein
*Julia Schottenstein*

> "It's can they not stop talking about it and that's the chatter about a product, they want to share it with their teammates or to other people at different companies. That just top of mind love and wanting to share what they've found with others is really a great sign that you're onto something."

**Insight:** Product-market fit is signaled by organic 'chatter' and a user's proactive desire to evangelize the product to peers.

**Tactical advice:**
- Look for users who treat the product as an identity rather than just a tool.
- Monitor if users are sharing the product with teammates or peers at other companies without being prompted.

*Timestamp: 00:11:36*


## Karri Saarinen
*Karri Saarinen*

> "For us, the way we think about is, 'Do we have the fit in the specific segments?' And how strong that fit is. In the company's journey, the first year, we just focused on, 'Can we get the fit...' In the first two years, we focused on, 'Can we get the fit in the early stage startup segment?'"

**Insight:** Product-market fit is not binary; it is a spectrum that should be measured and achieved segment by segment.

**Tactical advice:**
- Identify a specific market segment (e.g., early-stage startups) and aim to become the 'default' tool for them first.
- Double down on segments where you see natural pull rather than trying to capture the whole market at once.

*Timestamp: 01:18:28*


## Luc Levesque
*Luc Levesque*

> "Generally speaking, I would say you don't want to focus too much on growth until you have product market fit. So make sure you have a product that users love that's either showing strong signs of retention or has some good loop that you can see that you can start thinking about growth."

**Insight:** Scaling growth before achieving product-market fit can damage a brand by exposing a subpar experience to too many users.

**Tactical advice:**
- Verify strong retention signs before investing heavily in growth advisors or teams
- If testing growth early, isolate experiments to small, 'off-the-grid' markets to contain potential brand damage

*Timestamp: 00:19:08*


## Manik Gupta
*Manik Gupta*

> "Building consumer products is very hard. I think people think it's easy, because each of us is a consumer... But man, it's hard. It takes a long time to get things right. Because you're essentially trying to get so many things right when you're building a successful consumer product. You have to be able to reach out to a vast, heterogeneous set of users who have different needs, who have different perspectives. The go to market is always very interesting, because you can't force people to use your product. People have to choose you, you don't choose them."

**Insight:** Consumer product-market fit is exceptionally difficult because it requires creating enough organic 'pull' to satisfy a diverse audience that cannot be forced into adoption.

**Tactical advice:**
- Expect consumer PMF to take significantly longer than other product types due to the complexity of user choice.
- Focus on driving 'real love' and virality rather than just functional utility.

*Timestamp: 00:21:47*


## Marty Cagan
*Marty Cagan 2.0*

> "A lot of the CEOs and CFOs I talk to, they resonate best when I frame it as it's about time to money more than time to market. We know how to do time to market. If you insist on time to market, we know how to do that. The techniques are well-known. The harder part is time to money and I know that's what they care about and that's what a product team really does."

**Insight:** Real product success is measured by 'time to money' (outcomes and value) rather than just 'time to market' (shipping speed).

**Tactical advice:**
- Focus on outcomes that drive business value rather than just shipping features on a schedule.
- Use 'time to money' as a metric to align with executive leadership.

*Timestamp: 00:21:01*


## Matt MacInnis
*Matt MacInnis*

> "Product market fit is a sort of thing where you absolutely know it when you see it, and therefore if you don't absolutely know it, you don't have it."

**Insight:** PMF is binary and obvious; if there is any doubt about whether you have it, you likely don't.

**Tactical advice:**
- Be brutally honest about whether the market is pulling the product out of your hands.
- Avoid the 'never quit' trap if you've pivoted multiple times without seeing explosive growth.

*Timestamp: 00:43:17*

---

> "The market's either going to latch onto your product and run with it or it's not. Do not ship the product, find a lack of success, and then try to market your way through that, because the binding receptors likely don't exist."

**Insight:** The market is immutable; you cannot market your way into PMF if the underlying 'receptors' for your 'drug' (product) aren't there.

**Tactical advice:**
- View a startup as an experiment to see if binding receptors exist in the market.
- Stop trying to 'convince' the market to want a product that isn't naturally latching.

*Timestamp: 00:54:13*


## Maya Prohovnik
*Maya Prohovnik*

> "We had this feeling... that it just wasn't ever going to be big enough. And so we had this really interesting moment where the users were all telling us, there's no problem. We love this product. They were using it every day, they were coming back... and we were just like, this just isn't going to get us to where we need to be, our original goal had been we wanted to democratize audio."

**Insight:** Product-market fit should be measured against the ultimate mission and scale potential, not just current user satisfaction.

**Tactical advice:**
- Look beyond retention metrics to evaluate if the product can reach the target '80%' of the market
- Be willing to pivot even if current users are happy if the growth ceiling is too low for the business goals

*Timestamp: 00:21:50*


## Merci Grace
*Merci Grace*

> "We had a activation metric that we got to through some initial regression analysis, and then we tested the hypotheses that we developed from that regression analysis and made it into the product. And so for us it was three people, real human beings, not bots, and 50 messages, real messages."

**Insight:** Activation metrics should be derived from data analysis and represent the minimum threshold where the product's core value is realized.

**Tactical advice:**
- Use regression analysis to identify the specific user actions that correlate with long-term retention.
- Define activation by human-to-human interaction rather than bot-driven activity.

*Timestamp: 20:02*


## Mike Maples Jr
*Mike Maples Jr*

> "In the early days of product market fit, I like to say we want to answer a very simple but profound question. What can we uniquely offer that people are desperate for?"

**Insight:** Product-market fit is found at the intersection of a unique offering and extreme customer desperation.

**Tactical advice:**
- Identify 'desperate' customers who will tolerate an imperfect early product
- If you don't have PMF, evaluate if the insight is wrong, the implementation is wrong, or you're talking to the wrong customer

*Timestamp: 00:43:10*


## Nabeel S. Qureshi
*Nabeel S. Qureshi*

> "When you take something to a customer, ask them to pay you a lot of money and if they don't, then find a new problem. Don't wait three weeks, which is what every founding team typically does because you don't have that kind of time."

**Insight:** High-ticket price testing is the ultimate validation of whether you are solving a 'burning' problem.

**Tactical advice:**
- Ask for significant payment early in the sales process to gauge true necessity.
- Be willing to pivot immediately if a customer won't pay for the current solution.

*Timestamp: 01:17:22*


## Nikhyl Singhal
*Nikhyl Singhal*

> "For me, it's always around this pull that sort of how much work do you have to do to basically generate pull?... I think that this sucking pull kind of concept feels like the most appropriate way to define it as opposed to the sort of unit economics of acquisition and time to pay back."

**Insight:** Product-market fit is best identified by a natural 'sucking sound' or market pull rather than forced growth through capital and marketing.

**Tactical advice:**
- Measure how much organic 'pull' exists versus how much effort is required to acquire users
- Ask if the company is scaling a product people love or still trying to find that 'sucking sound'

*Timestamp: 00:20:36*


## Nikita Bier
*Nikita Bier*

> "If your product's working, you'll know. And if there's any uncertainty, it's not working. And it really is a binary when it comes to consumer products."

**Insight:** Product-market fit in consumer apps is usually obvious and undeniable rather than a subtle metric.

**Tactical advice:**
- Look for 'pull' from the market where users are fighting to get in
- Monitor hourly active users (HAU) rather than just DAU for high-engagement products

*Timestamp: 00:36:06*


## Nilan Peiris
*Nilan Peiris*

> "When we overlay the referral data over the NPS survey data, we saw something really interesting. There's very low invite rates at one to six, and not just invite, conversion rates of users that joined for invites. But when we've got people from sixes to this seven and eight group, they doubled the number of people they told. Eight to nine, they doubled again, and nine to 10, they doubled again."

**Insight:** NPS scores have a non-linear impact on growth; moving a user from an 8 to a 9 can double their likelihood to refer others.

**Tactical advice:**
- Overlay referral and invite data on top of NPS survey results to identify the 'evangelical' threshold
- Focus product efforts on moving users from 'neutral' (7-8) to 'promoter' (9-10) to exponentially increase the viral coefficient
- Use NPS as a proxy for the viral coefficient of the customer base

*Timestamp: 00:11:13*


## Pete Kazanjy
*Pete Kazanjy*

> "Take 50 at-bats, take 100 at-bats, and now that you know that you reliably, for every cohort of ten first meetings, what's known in sales land as opportunities, for every cohort of 10 that you engage, are you closing 1, are you closing 1.5, are you closing 2, or are you closing 2.5, if you're in there?"

**Insight:** In B2B, product-market fit is evidenced by a repeatable conversion rate from first meetings to closed deals across cohorts.

**Tactical advice:**
- Track conversion rates by cohort of 10 meetings
- Look for a 15-25% conversion rate as a signal of repeatability

*Timestamp: 00:16:08*


## Raaz Herzberg
*Raaz Herzberg*

> "We really felt the type of questions change, right? Silly. The call sounded like, again, "How are you pricing this, or when can we start doing a POV?" I think naturally, as human beings, you have a bias to look for affirmation, versus a bias for what you don't want to hear."

**Insight:** Product-market fit is signaled by a shift from polite interest to urgent, tactical questions about pricing and implementation.

**Tactical advice:**
- Look for questions about pricing and POV (Proof of Value) timelines as signs of real intent.
- Beware of 'interesting' as a feedback—it often masks a lack of understanding or need.
- Actively fight the bias for seeking affirmation and instead look for deep enthusiasm.

*Timestamp: 00:07:01*

---

> "It's almost like you need to see them pushing for the next step is what I'm hearing is, "Let's do a POV, what's the next step to do this? I want to connect you to this person, to talk further about this," versus just, "Oh yeah, this is awesome. Thank you.""

**Insight:** True pull is characterized by the customer driving the next steps of the engagement.

**Tactical advice:**
- Measure 'pull' by how quickly and eagerly customers complete technical hurdles or questionnaires.

*Timestamp: 00:14:23*


## Rahul Vohra
*Rahul Vohra*

> "The trick here is not to act too much on the feedback that the very disappointed people are giving you, because they already love your product... But to focus on the segment of the somewhat disappointed people, they kind of love your product, but something, and I would wager something small, is holding them back."

**Insight:** Use the Sean Ellis test to identify 'somewhat disappointed' users whose needs align with your core value proposition to systematically increase PMF.

**Tactical advice:**
- Ask users: 'How would you feel if you could no longer use this product?'
- Focus roadmap efforts on the 'somewhat disappointed' group that values your core benefit.
- Politely disregard feedback from users who don't value your core benefit, even if they are vocal.

*Timestamp: 00:56:30*


## Robby Stein
*Robby Stein*

> "You might look at something like a J-curve. This is the retention, the percentage of people still using the product day seven, day 30, day 90, and does it flatten or do people just drip out of there?"

**Insight:** Product-market fit is evidenced by a retention curve that flattens over time rather than decaying to zero.

**Tactical advice:**
- Monitor the 'J-curve' of retention at day 7, 30, and 90 to see if the product is net useful.
- Scrutinize whether the product is good enough that people talk about it and drive organic growth.

*Timestamp: 00:28:15*


## Sarah Tavel
*Sarah Tavel*

> "I don't like NPS for this... I like Sean Ellis's question of how disappointed would you be if this product disappeared? And I think it's if you have at least 40% of people respond that they'd be very disappointed, then you're on the right track."

**Insight:** The Sean Ellis survey is a more reliable indicator of product-market fit than NPS for early-stage startups.

**Tactical advice:**
- Survey users on how disappointed they would be if the product vanished
- Aim for a 40% 'very disappointed' threshold

*Timestamp: 00:57:39*

---

> "Customers don't care how big you are, they don't care how many transactions you've accumulated. What they care about is when they have a transaction with you, how happy do you make them? How much better is the experience that you provide than any other substitute that they could use? ... I call it happy GMV."

**Insight:** Product-market fit in marketplaces is measured by 'Happy GMV'—transactions that result in high retention and satisfaction.

**Tactical advice:**
- Track the percentage of transactions that lead to a repeat purchase
- Focus on the 'happy path' of the user experience rather than aggregate volume

*Timestamp: 00:51:11*


## Sean Ellis
*Sean Ellis*

> "The question is, how would you feel if you could no longer use this product? And I give them the choice, very disappointed, somewhat disappointed, or even not disappointed or not applicable, I've already stopped using the product. And what I'm trying to find are those people who say, 'I would be very disappointed if I could no longer use this product,' then that's a really powerful vein to dig into"

**Insight:** The 'Sean Ellis Test' identifies 'must-have' status as a leading indicator of product-market fit.

**Tactical advice:**
- Ask users how they would feel if they could no longer use the product.
- Focus on the 'very disappointed' segment as your core value indicator.

*Timestamp: 00:03:19*

---

> "I would say it's a leading indicator of product market fit. The lightning indicator is, do they actually keep using it? So probably retention cohorts are more accurate, but the problem is... how long do you have to look at a retention cohort before you know that you've actually long-term retained someone?"

**Insight:** Surveys provide immediate signal on PMF before long-term retention data is available.

**Tactical advice:**
- Use the 40% 'very disappointed' threshold as a target before aggressively scaling growth.
- Validate survey results against actual retention cohorts once data is available.

*Timestamp: 00:06:40*

---

> "Just ignore the people who say they'd be somewhat disappointed. They're telling you it's a nice to have. If you start paying attention to what your somewhat disappointed users are telling you and then you start tweaking onboarding and product based on their feedback, maybe you're going to dilute it for your must have users."

**Insight:** Focusing on 'somewhat disappointed' users can lead to product dilution; instead, find the subset of them who value the same core benefit as your 'must-have' users.

**Tactical advice:**
- Identify the primary benefit cited by 'must-have' users.
- Look at 'somewhat disappointed' users who value that same benefit and identify what specific features they are missing to move them to 'must-have' status.

*Timestamp: 00:40:43*


## Shweta Shriva
*Shweta Shriva*

> "We're tracking the commercial metrics in terms of the trips per week, the daily or weekly active users and all the funnel metrics that you can think of. Also, the operational metrics, the cost, right? Well, how much is the thing costing us to operate?"

**Insight:** Measuring PMF in service-heavy industries requires balancing usage growth with operational unit economics.

**Tactical advice:**
- Track trips per week and active users alongside operational costs to measure business viability.

*Timestamp: 16:46*


## Tanguy Crusson
*Tanguy Crusson*

> "Before we brought a single line of code, put an ad inside a Jira newsletter going, 'Hey, we've got this thing for product managers coming up.' And then we had a website that before we had any line of code written that said, 'Hey, product managers, your job is hard. We want to help, put your name here if you want to join us on the journey,' that kind of thing. And that's when we saw, I think it was in two weeks, we got more than 3000 signups to that waitlist."

**Insight:** Validate market demand using newsletters and landing pages before writing any code.

**Tactical advice:**
- Use existing distribution channels (like newsletters) to test interest in new concepts
- Create a simple waitlist landing page to quantify demand before development

*Timestamp: 00:27:15*


## Todd Jackson
*Todd Jackson*

> "There's essentially four levels of product-market fit: nascent, developing, strong, extreme."

**Insight:** Product-market fit is a multi-stage journey (Nascent, Developing, Strong, Extreme) rather than a binary state, defined by the intersection of demand, satisfaction, and efficiency.

**Tactical advice:**
- Identify your current level based on customer count: Level 1 (3-5 customers), Level 2 (5-25 customers), Level 3 (25-100 customers), Level 4 (100+ customers).
- Sequence your focus: prioritize customer satisfaction at Level 1, demand at Level 2, and efficiency at Level 3.

*Timestamp: 00:00:22*

---

> "Extreme product-market fit is a state of widespread demand for a product that satisfies a critical need and crucially can be delivered repeatably and efficiently to each customer."

**Insight:** True product-market fit requires not just demand and satisfaction, but also an efficient economic model where the marginal customer becomes easier to acquire over time.

**Tactical advice:**
- Monitor the 'marginal customer'—if the next customer is getting harder to acquire rather than easier, your PMF is not strengthening.
- Track efficiency metrics like burn multiple and gross margin only once you reach Level 3 (Strong PMF).

*Timestamp: 00:17:30*


## Uri Levine
*Uri Levine*

> "Product market fit have one metric. One metric. That's it. Retention. That's really simple. If you create value, they will come back. If they're not coming back, that means that you are not creating value."

**Insight:** Retention is the only definitive metric for product-market fit because it proves the product provides recurring value.

**Tactical advice:**
- Monitor retention as the primary indicator of PMF.
- Look for 3-month retention rates of 30-50% for high-frequency products.

*Timestamp: 00:20:14*

---

> "And we are going back to basic, product market fit is very simple. That means that you create value to your customers, this is what it is. And you never heard of a company that did not figure out product market fit. They simply died, that's it. And by the way, product market fit in general have only one metric, only one metric, retention. Look, it's really simple, if you create value, they will come back, that's it. If they are not coming back, that means that you are not creating value."

**Insight:** Product-market fit is defined by customer value creation, which is best measured through a single metric: retention.

**Tactical advice:**
- Use retention as the primary indicator of whether your product is creating value.
- Recognize that if users are not returning, you have not yet achieved product-market fit.

*Timestamp: 00:11:43*


## Hila Qu
*Hila Qu*

> "We did a correlation analysis to understand, hey, those are the 10 high value actions we believe we want to look at. If a new user did this action, what's the maybe 30 day conversion rate and... 90 day conversion rate. What's the 30 day retention rate? Because we look at both."

**Insight:** Identifying the core value of a product involves correlating specific user actions with long-term retention and conversion.

**Tactical advice:**
- List potential high-value actions and run correlation analysis against retention
- Compare the conversion lift of different user actions against the average

*Timestamp: 00:41:40*


## Nickey Skarstad
*Nickey Skarstad*

> "I joined that team when the product had just launched. So they had done sort of their early thinking, the existential thinking. Had a brand new product in market, and then I joined the team. And so I was the first boots on the ground product manager, and really helped that team figure out how do we get product market fit?"

**Insight:** Early-stage PMs must bridge the gap between 'existential thinking' and practical market validation to find product-market fit.

**Tactical advice:**
- Focus on digital experience and live event experience simultaneously for service-based marketplaces

*Timestamp: 00:06:18*


## Timothy Davis
*Timothy Davis*

> "The biggest issue wasn't necessarily that users weren't interested in our product and weren't purchasing it, it was because we didn't have a product market fit mainly from an operation standpoint... I wouldn't recommend it [investing in paid pre-PMF]. All you're going to do is really annoy the users."

**Insight:** Paid marketing should be avoided until the product is operationally ready to convert users to prevent long-term brand damage.

**Tactical advice:**
- Verify operational readiness, such as local currency support, before running ads in new regions
- Hold off on 'signs of life' tests if the conversion path is broken to avoid creating a negative first impression

*Timestamp: 00:31:33*


## Tamar Yehoshua
*Tamar Yehoshua*

> "What I've seen is when a company isn't well run like IT isn't working, marketing is broken, there are not enough people in HR, there's a lot of turnover. All of these things I've seen that they're not correlated to the company being successful... the numbers are amazing. They're growing like crazy."

**Insight:** Strong product-market fit can overcome internal operational chaos and poor management.

**Tactical advice:**
- Distinguish between 'broken' internal processes and the core success of the product in the market.

*Timestamp: 00:11:45*

---

> "We always talk about product market fit. Nobody really knows what product market fit is. Everybody has a different explanation, but it means people want to use your product. That they're clamoring for it. So you've built something that people value and that people value and that solves a problem for them, but that's also not good enough. You need to build a great product, but you also have to have distribution and you need to have a sales team that works."

**Insight:** PMF is the foundation of a company, but it must be paired with distribution and sales to scale.

**Tactical advice:**
- Look for signs that customers are 'clamoring' for the product as a primary indicator of PMF.

*Timestamp: 00:12:51*


