---
name: media-relations
description: Help users build relationships with journalists and get press coverage. Use when someone is pitching reporters, preparing for media outreach, trying to get press coverage, or managing ongoing journalist relationships.
---

# Media Relations

Help the user build effective relationships with journalists and secure press coverage using insights from 2 product leaders.

## How to Help

When the user asks for help with media relations:

1. **Understand their goal** - Ask what kind of coverage they're seeking (launch announcement, thought leadership, feature story) and what stage they're at
2. **Prepare the story** - Help them craft a compelling angle that's newsworthy, not just promotional
3. **Identify the right targets** - Guide them on finding the right reporters and publications for their story
4. **Execute the pitch** - Help them write effective pitches and manage the outreach process

## Core Principles

### Offer exclusives, pitched one at a time
Emilie Gerber: "I stagger it because we're offering exclusives, and I highly recommend offering exclusives." Don't blast your story to every reporter simultaneously. Offer an exclusive to your top target, wait for their response, then move to the next.

### Follow the prep-target-pitch framework
Jason Feifer: "Step one is prep... Step two is figuring out who to pitch... Step three is the actual pitch." Preparation means having your story, angles, and assets ready. Targeting means finding reporters who actually cover your space. Pitching means concise, relevant outreach.

### Build relationships before you need them
The best media relationships are built over time, not when you need coverage. Engage with journalists' work, provide helpful information even when you don't have news, and become a trusted source.

### Think about what's interesting to readers, not you
Reporters care about their readers, not your company. Frame your story around trends, problems, or insights that their audience cares about. Your product is the supporting detail, not the headline.

## Questions to Help Users

- "What's the angle that makes this newsworthy beyond just being your announcement?"
- "Who are the specific reporters who cover companies like yours? Have you read their recent work?"
- "Do you have assets ready - images, quotes, data - that make the reporter's job easier?"
- "Are you offering this as an exclusive? Who's your top target outlet?"
- "What's your timeline? Do you have flexibility to work with the reporter's schedule?"

## Common Mistakes to Flag

- **Mass pitching** - Sending the same pitch to dozens of reporters signals you don't understand how press works. Pitch one at a time with exclusives
- **Leading with the company, not the story** - Reporters don't care about your funding or launch. They care about what's interesting to their readers
- **Rigid timelines** - Prioritize getting the right coverage over hitting an arbitrary date. Be flexible with reporter schedules
- **No preparation** - Having to scramble for images, quotes, or details after a reporter expresses interest signals you're not ready

## Deep Dive

For all 2 insights from 2 guests, see `references/guest-insights.md`

## Related Skills

- Launch Marketing
- Positioning & Messaging
- Brand Storytelling
- Content Marketing
