---
name: negotiating-offers
description: Help users negotiate job offers and compensation. Use when someone is negotiating salary, equity, or other terms of a job offer, preparing for a compensation conversation, or asking how to ask for more money.
---

# Negotiating Offers

Help the user negotiate job offers and compensation using strategies from 3 product leaders.

## How to Help

When the user asks for help negotiating an offer:

1. **Understand their situation** - Ask about the offer details, what they're hoping for, and what leverage or alternatives they have
2. **Reframe beyond salary** - Help them think about what they need to succeed in the role, not just personal compensation
3. **Prepare the approach** - Guide them on the right language, timing, and framing for the negotiation
4. **Coach on execution** - Help them practice the actual conversation and anticipate responses

## Core Principles

### Negotiate for success factors before compensation
Phyl Terry: "Before we talk about money, I want to think about the things that will set me up to succeed. There's $10 million of tech debt here - are we on board that this will be priority one?" Identify critical blockers (tech debt, headcount, budget) during the interview process and ask for specific authority to fix them as part of the offer negotiation.

### Use collaborative language - "Are you open to...?"
Phyl Terry: "87% of the time when you ask for more money, you get it. Say 'Are you open to $X? That's what I was hoping for. Is that something we can talk about?'" Conduct the negotiation live (phone or in-person) with the hiring manager if possible. Use "Are you open to...?" to keep the conversation collaborative and lower-risk.

### Understand what you're really optimizing for
Bob Moesta: "Compensation is often a surrogate for other needs like respect or learning. I can pay people less if I give them better experiences." Before negotiating aggressively on salary, identify if you're really seeking money or something else (learning, autonomy, respect, growth). Sometimes the right move is to accept less money for better experience.

### Consider alternative arrangements
Paul Millerd: "A big move is turning your current job into a contract job - employers are more open than people think. Say 'I want to work three days a week as a contractor. Are you open to this?'" If flexibility matters more than maximizing salary, propose specific alternative arrangements. Frame the reduced risk for the employer as a benefit.

## Questions to Help Users

- "What's the full offer - base, equity, bonus, and other terms?"
- "What do you actually need to succeed in this role that you might not get by default?"
- "Is salary the thing you really care about, or is it a proxy for something else?"
- "What's your alternative if this negotiation doesn't work out? Do you have other offers?"
- "Have you done the live conversation yet, or is it still over email?"
- "What specific number or terms are you hoping to get to?"

## Common Mistakes to Flag

- **Only negotiating salary** - The resources, authority, and support you need to succeed are often more valuable than a few thousand in comp
- **Negotiating only over email** - Live conversations build relationship and are more effective. Request a call with the hiring manager
- **Using adversarial language** - "Are you open to...?" is more effective than demands or ultimatums
- **Not asking at all** - Most of the time when you ask for more, you get it. The risk of asking is lower than most people think
- **Optimizing for the wrong thing** - Make sure you know if you really want more money or if salary is a proxy for respect, growth, or autonomy

## Deep Dive

For all 4 insights from 3 guests, see `references/guest-insights.md`

## Related Skills

- Building a Promotion Case
- Finding Mentors & Sponsors
- Career Transitions
- Having Difficult Conversations
