---
name: onboarding-new-hires
description: Help users onboard new team members effectively. Use when someone is planning onboarding for a new hire, starting a new job themselves, designing a first-90-days plan, or trying to ramp up new employees faster.
---

# Onboarding New Hires

Help the user onboard new team members effectively using approaches from 14 product leaders.

## How to Help

When the user asks for help with onboarding:

1. **Understand the context** - Ask if they're onboarding someone or being onboarded, the seniority level, and whether it's a new role or backfill
2. **Design the structure** - Help them create a 30-60-90 day plan with clear milestones and success criteria
3. **Prioritize belonging and learning** - Ensure the plan includes social integration, not just tasks
4. **Engineer early wins** - Identify opportunities for the new hire to demonstrate value quickly

## Core Principles

### Listen first, act later - diagnose before you treat
Deb Liu: "The first 90 days are focused on listening and learning first, then doing. Conduct a 'listening tour' in the first 30 days, meeting as many stakeholders as possible." Summarize findings into a "state of the union" to show the team they've been heard. Align on vision in days 30-60, move to full execution by day 90.

### Define success at 90 days, 1 year, and 2 years
Lauren Ipsen: "The 90-day plan is overused but necessary, and that's just the tip of the iceberg. What should this person be doing a year from now? Two years from now?" Define what "crushing it" looks like at each milestone before starting the search.

### Create immediate belonging through pairing
Heidi Helfand: "Help them feel a sense of belonging by not having their first day be them sitting alone. Have someone be a 'first pair.'" Ensure new hires are not working alone on day one. Assign a buddy to work with them immediately. Encourage sharing personal stories to build connection.

### Teach golden rituals by the first Friday
Shishir Mehrotra: "Great companies have a very small list of golden rituals. Every employee knows them by their first Friday." Include core company rituals in the onboarding curriculum. These rituals should be named, known, and templated.

### Engineer early wins for visibility
Melissa Tan: "How do I help them secure early wins? I'll suggest 'You should do this presentation - it's a great way to get visibility early.'" Identify low-hanging fruit projects for new hires. Create opportunities for them to present to leadership in their first weeks.

### Document your philosophy publicly
Brandon Chu: "People joining my team already knew how I thought because they'd Google me. It passively onboarded a lot of the PMs." Write about your management and product philosophy. New hires can ramp up before their first day.

### Have a "relationship design" conversation
Kenneth Berger: "For maybe your first 10-20 employees, have a relationship design conversation when they're hired." Collaboratively figure out the best way to work together given specific roles and personalities. This prevents friction and "out of integrity" behavior later.

### Don't overpromise during hiring
Molly Graham: "Do not promise things you can't control. Be honest about the ambiguity and chaos of a scaling environment." Avoid promising stability, specific titles, or career paths you can't guarantee. Overpromises become "letter bombs" that demoralize high performers when they explode.

### Accelerate ownership with clear cadences
Timothy Davis: "I want to try and make onboarding 30-45 days by giving them responsibility early. Here's everything we did, here's your responsibilities, go." Use an ops cadence spreadsheet to define task frequency. Assign campaign or project ownership within the first few weeks.

### Use AI for low-friction knowledge access
Scott Wu: "New engineers can ask Devin questions about the codebase. It's nice to be able to ask without social pressure." AI tools can help new hires explore internal systems and ask "dumb questions" without feeling judged.

## Questions to Help Users

- "What does success look like at 30, 60, and 90 days for this person?"
- "Who is their 'first pair' or buddy on day one?"
- "What are the company's golden rituals they need to know by their first Friday?"
- "What early win can we engineer to give them visibility and credibility?"
- "Have you documented your philosophy anywhere they can read before starting?"
- "What did you promise them during hiring that you need to deliver on?"

## Common Mistakes to Flag

- **No structured 90-day plan** - New hires need clear milestones. "Figure it out" is not onboarding
- **Leaving them alone on day one** - Isolation kills belonging. Assign a pair from the start
- **All tasks, no relationships** - Onboarding is social, not just functional. Prioritize introductions and connection
- **Delayed ownership** - Don't wait months to give responsibility. Find ways to assign ownership in weeks
- **Over-promising during hiring** - Be honest about chaos and ambiguity. Broken promises demoralize

## Deep Dive

For all 14 insights from 14 guests, see `references/guest-insights.md`

## Related Skills

- Writing Job Descriptions
- Conducting Interviews
- Building Team Culture
- Running Effective 1:1s
