# Onboarding New Hires - All Guest Insights

*14 guests, 14 mentions*

---

## Brandon Chu
*Brandon Chu*

> "one amazing, and just the context, I'm really old at Shopify now... people that would join my team already knew how I thought. It was pretty onboarded a lot of the PMs that would join my team because obviously, they're going to look for who their leads is and Google that a bit"

**Insight:** Publicly documenting your philosophy and mental models acts as a passive onboarding system for future hires.

**Tactical advice:**
- Write about your management and product philosophy to help new hires ramp up before their first day

*Timestamp: 31:49*


## Deb Liu
*Deb Liu*

> "I created, it's actually when I joined Ancestry... I decided I was going to adapt all of those things into a summary and then I was going to try it real time in my blog... it's focused on listening and learning first and then doing. So that's the crux of it, which is in those 90-days it's like you got to get used to the environment. You want to have some impact at the start. You want to have a couple quick wins, but you want to understand the lay of the land and you want to listen."

**Insight:** A successful onboarding follows a 'diagnose before you treat' philosophy, prioritizing listening and cultural alignment before major execution.

**Tactical advice:**
- Conduct a 'listening tour' in the first 30 days, meeting as many stakeholders as possible
- Summarize findings into a 'state of the union' to show the team they have been heard
- Align on vision in the second 30 days and move to full execution by day 90

*Timestamp: 00:51:18*


## Heidi Helfand
*Heidi Helfand*

> "So the tip with one by one is when someone joins, help them feel a sense of belonging, and you can do that through not having their first day be them sitting over there alone. You could have someone have a first pair."

**Insight:** Successful onboarding prioritizes immediate social integration and belonging through collaborative work like pairing.

**Tactical advice:**
- Ensure new hires are not left to work alone on their first day
- Assign a 'first pair' partner to work with the new hire immediately
- Encourage new hires to share their personal stories to increase retention and connection

*Timestamp: 00:35:12*


## Kenneth Berger
*Kenneth Berger*

> "I recommend to a lot of founders for maybe their first 10 or 15, or 20 employees of just have a relationship design conversation with each of them when they're first hired."

**Insight:** Early alignment on working styles and expectations prevents future friction and 'out of integrity' behavior.

**Tactical advice:**
- Conduct a 'relationship design' conversation during the first few weeks
- Collaboratively figure out the best way to work together given the specific roles and personalities involved

*Timestamp: 01:00:13*


## Lauren Ipsen
*Lauren Ipsen*

> "The 90 day plan is something that's overused but so necessary, and that's just the tip of the iceberg. So that component and then, okay, a year from now, what should this person be doing? Two years from now?"

**Insight:** A concrete 90-day plan is essential for defining immediate success and long-term trajectory for senior hires.

**Tactical advice:**
- Define what 'crushing it' looks like at the 90-day, 1-year, and 2-year marks before starting the search.

*Timestamp: 00:15:24*


## Melissa Tan
*Melissa Tan*

> "How do I ramp them up as quickly as possible... make sure it's clear what success looks like in their first 90 days? And then how do I help them secure early wins essentially? So I often will suggest, 'Hey, you should do this presentation. It's a great way to get visibility early in your journey here.'"

**Insight:** Effective onboarding focuses on defining clear 90-day success metrics and engineering early 'wins' to build the new hire's internal credibility.

**Tactical advice:**
- Define specific success criteria for the first 90 days
- Identify 'low-hanging fruit' projects for the new hire to tackle immediately
- Create opportunities for new hires to present their work to leadership early on

*Timestamp: 00:40:32*


## Mike Krieger
*Mike Krieger*

> "I actually hadn't joined a company since my first internship in college basically. And I was like, 'Oh, how do I onboard myself? How do I get myself up to speed? How do I balance making sweeping changes versus understanding what's not broken about it overall?'"

**Insight:** Executive onboarding requires a delicate balance between observing existing culture and implementing necessary strategic changes.

**Tactical advice:**
- Focus on identifying 'founder-type' engineers who can drive high-impact projects independently.
- Avoid over-indexing on headcount early; instead, find key senior leaders who can shape product strategy.

*Timestamp: 00:34:22*


## Molly Graham
*Molly Graham*

> "Do not promise things that you can't control... being honest and upfront about who you are as a company, about what you're able to promise, all of that is actually... it's very hard work but it's so important."

**Insight:** Over-promising stability or specific career paths during hiring/onboarding creates 'letter bombs' that demoralize high performers when they inevitably explode.

**Tactical advice:**
- Avoid promising things like stability, specific titles, or never hiring over someone.
- Be honest about the ambiguity and chaos of a scaling environment during the recruitment process.

*Timestamp: 01:00:31*


## Nikita Miller
*Nikita Miller*

> "I think that in-person onboarding for new folks is really important for everyone. For any new person to an organization, I think how we work culturally, having a contact that you can reach out to, all of that I think is really crucial."

**Insight:** Even in remote-first companies, the first week of onboarding should ideally happen in person to build cultural context.

**Tactical advice:**
- Aim for one week of in-person onboarding for new hires
- Ensure new hires have a specific cultural contact or 'buddy' to reach out to

*Timestamp: 48:04*


## Roger Martin
*Roger Martin*

> "You have to have a different way of recruiting, a different way of onboarding, a different way of career development. And if you do all of those things, you end up with a 10% turnover rate, so that your people are there 10 years on average, and you can then get them trained up to deliver that kind of service."

**Insight:** Strategic differentiation often requires specialized onboarding and retention systems that differ significantly from industry norms.

**Tactical advice:**
- Align onboarding and training specifically to the 'how to win' choice (e.g., specialized service).
- Focus on reducing turnover to build the long-term expertise required for a differentiated brand.

*Timestamp: 00:56:26*


## Shishir Mehrotra
*Shishir Mehrotra*

> "Great companies has a very small list of golden rituals. And there are three rules of golden rituals. Number one, they're named. Number two, every employee knows them by their first Friday and, number three, they're templated."

**Insight:** Successful onboarding ensures new hires can identify and participate in core company rituals within their first week.

**Tactical advice:**
- Ensure every new hire knows the company's 'golden rituals' by their first Friday.
- Include core rituals in the new hire onboarding curriculum.

*Timestamp: 00:26:35*


## Tomer Cohen
*Tomer Cohen 2.0*

> "Starting January, we're going to start having our APB program and they're going to come into LinkedIn. We're going to teach them how to code, design and PM at LinkedIn. They're going to go through a pretty rigorous training process, and then they're going to join those pods."

**Insight:** The next generation of product talent should be onboarded as 'Full Stack Builders' who are cross-trained in engineering, design, and product management from day one.

**Tactical advice:**
- Replace traditional APM programs with 'Associate Product Builder' tracks
- Provide rigorous cross-functional training in coding, design, and PM skills for new hires

*Timestamp: 00:36:14*


## Scott Wu
*Scott Wu*

> "One of the fun use cases that we've seen actually with folks is they'll often actually get Devin's help to onboard new engineers on the team. When you're new and you're joining, there's obviously a lot of questions that you have about the code base... It's nice to just be able to ask Devin and to go through Devin's wiki and to understand these internal representations."

**Insight:** AI agents can serve as a low-friction knowledge base for new hires, allowing them to ask 'dumb' questions without social pressure.

**Tactical advice:**
- Use AI to index the codebase and create an interactive wiki for new engineers
- Encourage new hires to use AI tools to explore internal representations and system architecture during their first weeks

*Timestamp: 00:44:15*


## Timothy Davis
*Timothy Davis*

> "I want to try and make that 45 days, if not 30... giving them responsibility early on for something... 'Here's everything we did last additions. This is the results. These are your responsibilities, these are the expectations. Go.'"

**Insight:** Accelerate the onboarding process by providing clear operational cadences and assigning high-stakes ownership immediately.

**Tactical advice:**
- Use an 'ops cadence' spreadsheet to define exactly how often tasks (weekly, bi-weekly, monthly) should be performed
- Assign a specific campaign or project ownership within the first few weeks to drive immediate impact
- Conduct 'over-the-shoulder' screen-sharing sessions to demonstrate efficient workflows

*Timestamp: 01:21:14*


