---
name: organizational-design
description: Help users design effective organizational structures. Use when someone is thinking about team structure, deciding between functional vs. divisional models, planning a reorg, or figuring out how to structure product teams.
---

# Organizational Design

Help the user design effective organizational structures using frameworks from 2 product leaders.

## How to Help

When the user asks for help with organizational design:

1. **Understand their context** - Ask about their current structure, company stage, what problem they're trying to solve, and what trade-offs they're willing to make
2. **Identify the core trade-off** - Help them see the spectrum between centralized (Apple-style) and decentralized (Amazon-style) models
3. **Evaluate options** - Walk through the implications of different structures for speed, coherence, and cross-team dependencies
4. **Guide implementation** - Help them think through how to transition to a new structure

## Core Principles

### The fundamental trade-off: speed vs. coherence
Gustav Soderström: "On one spectrum, you have Amazon - minimize dependencies so you can run in parallel. On the other, you have Apple - centrally organized close to a single individual." Amazon optimizes for speed through autonomous teams with minimal dependencies. Apple optimizes for coherent user experience through central coordination. Neither is universally better - choose based on what matters most for your product.

### Functional models can restore startup speed
Brian Chesky: "We went to a functional model. We went back to a startup." Airbnb eliminated divisional structures and management layers that separated leaders from the work. Functional models concentrate expertise and reduce the "telephone game" between executives and ICs.

### Eliminate managers who don't know the work
Brian Chesky's restructuring removed "people managers" who couldn't do the work themselves. Leaders should have enough context to make decisions, not just manage reports. If a manager can't review the actual output, the structure is broken.

### Structure follows strategy
The right org structure depends on what you're optimizing for. If you need rapid, parallel execution on independent initiatives: decentralize. If you need a tightly integrated product experience: centralize.

## Questions to Help Users

- "What problem are you trying to solve with this restructuring?"
- "Do you optimize more for speed of independent teams, or coherence across the product?"
- "How many layers are between your executives and the people doing the work?"
- "Can your managers actually review and understand the output of their teams?"
- "What are the biggest coordination failures you're experiencing today?"

## Common Mistakes to Flag

- **Reorging without a clear problem** - Structure changes are disruptive. Be clear about what specific problem you're solving
- **Copying another company's structure** - Amazon's structure works for Amazon's strategy. Make sure you're choosing based on your needs, not prestige
- **Too many management layers** - Every layer adds latency and information loss. Minimize distance between decision-makers and work
- **Managers who can't do the work** - If leaders don't understand the output, they can't make good decisions about it

## Deep Dive

For all 2 insights from 2 guests, see `references/guest-insights.md`

## Related Skills

- Building Team Culture
- Organizational Transformation
- Managing Up
- Delegating Work
