---
name: partnership-bd
description: Help users build strategic partnerships and business development deals. Use when someone is pursuing a partnership, negotiating a BD deal, working with platforms like Google or Facebook, or trying to build distribution through partners.
---

# Partnership & BD

Help the user build strategic partnerships and business development deals using insights from 9 product leaders.

## How to Help

When the user asks for help with partnerships or BD:

1. **Understand the opportunity** - Ask about the potential partner, what each side wants, and what the ideal outcome looks like
2. **Assess network vs. merit dynamics** - Determine if success depends on relationships or product quality, and plan accordingly
3. **Design the approach** - Help them craft a pitch that shows mutual benefit, not just their own needs
4. **Navigate the negotiation** - Guide them on timing, leverage, and when to say no

## Core Principles

### Partnerships are network-dependent in some industries
Ayo Omojola: "Very often the way to make things happen is network-dependent, not necessarily about the merit of the thing itself. There are companies that exist because the founders know the CEO of every major payer." In industries like healthcare, finance, or enterprise, relationships matter more than product. Determine if your business is network-dependent early.

### Position yourself as a case study for the platform
Adam Grenier: "Let me into your alpha, because I have five years of experience buying mobile ads. If you get us to work, we're a killer case study for a category you want to grow." When partnering with major platforms, show how your success helps them prove their business model. Offer to be an alpha tester for new features.

### Build scalable platforms, not bespoke deals
Keith Yandell: "We'll build you a product so you won't need to ask us every time. Then you'll know the parameters in which you can negotiate." Effective BD teams work with Product to create self-serve platforms for partners rather than negotiating one-off integrations. This increases velocity and reduces engineering load.

### Strategic patience leads to better deals
Jason Droege: "McDonald's approached us and I said 'No.' I pushed them off for four or five months. It ended up being a net benefit because we got a great deal." Don't rush into partnerships just because of the partner's size. Initial resistance can lead to better terms or exclusivity.

### Channel partners won't sell like founders
Jen Abel: "The problem with channel partnerships is there are a hundred of you on the list and you're expecting them to sell on your behalf. They're not visionaries, they're consultants." Don't expect Accenture or Deloitte to evangelize your product. They lack the founder's vision-casting ability.

### Use corp dev to find internal sponsors
Julia Schottenstein: "Use that corp dev team to your advantage. Take that meeting, say you're not interested in acquisition yet, but push them for an introduction to someone who could sponsor the deal - usually someone in Product or a GM." Corp dev teams are gateways to internal sponsors even if you're not looking to sell.

### Find partners at the moment of need
Meltem Kuran: "VCs ask portfolio companies 'What platform do you trust for hiring?' So people go to their VCs for that kind of question." The best partners are those your target audience already consults at the exact moment the problem arises.

### Treat partnerships as iterated prisoner's dilemma
Tobi Lutke: "Being a good partner is like a corporate marshmallow test companies tend to fail. The correct way to play iterated prisoner's dilemma is coordinate for both sides - it's way more valuable over long periods." Resist pulling future profits forward at the expense of a partner. Long-term coordination always beats short-term defection.

### Test with manual operations before building
Keith Yandell: "We should have tested this at one hotel with hacky operations before asking for product resources." Validate partnership hypotheses with manual operations before committing engineering time. Dream big, start small.

## Questions to Help Users

- "What does the partner want from this deal? What's in it for them?"
- "Is this industry network-dependent, or will product merit win?"
- "Can you position yourself as a case study for something they want to prove?"
- "What's your leverage? Can you afford to say no?"
- "Are you building toward a scalable platform or negotiating a one-off deal?"
- "Who inside the partner organization can sponsor this internally?"

## Common Mistakes to Flag

- **Expecting partners to sell for you** - Channel partners and consultants won't evangelize like founders. Don't outsource vision-casting
- **Rushing into big-name partnerships** - Strategic patience often leads to better deal terms. Don't let FOMO drive bad deals
- **Building before validating** - Test partnership ideas with manual operations before committing engineering resources
- **Ignoring network dynamics** - In some industries, relationships matter more than product. Know which game you're playing
- **Short-term defection** - Pulling profits forward at a partner's expense destroys long-term value. Play the long game

## Deep Dive

For all 11 insights from 9 guests, see `references/guest-insights.md`

## Related Skills

- Founder Sales
- Enterprise Sales
- Building Sales Team
- Negotiating Offers
