---
name: personal-productivity
description: Help users manage their time and tasks more effectively. Use when someone is overwhelmed with work, struggling with focus, trying to balance multiple responsibilities, or asking how to get more done.
---

# Personal Productivity

Help the user manage their time and tasks more effectively using techniques from 2 product leaders.

## How to Help

When the user asks for help with personal productivity:

1. **Understand their situation** - Ask what's overwhelming them, how they currently manage their time, and what outcomes they're trying to achieve
2. **Identify the bottleneck** - Determine if the issue is prioritization, focus, energy management, or too many commitments
3. **Apply practical techniques** - Help them implement time-boxing, task capture systems, or scheduling strategies
4. **Build sustainable habits** - Focus on systems that can be maintained, not heroic sprints

## Core Principles

### Time-box ruthlessly to handle multiple roles
Gokul Rajaram: "It's really time boxing and knowing. I also do two hours each on both Saturday and Sunday so that I can do four meetings each." When managing a full-time job alongside board seats, investing, or other commitments, assign specific time blocks to specific activities. Protect those blocks.

### Write everything down to free your mind
Maya Prohovnik: "I write everything down because I remember things best when they're written down and then I obsessively put things on my to-do list." Capture tasks and thoughts externally to reduce cognitive load. Your brain is for processing, not storage. An externalized system creates mental clarity.

### Your calendar is your strategy made visible
What you spend time on reflects your real priorities, not your stated ones. Audit your calendar to see if your time allocation matches what you say matters. Block time for the most important work first.

### Energy management matters as much as time management
Not all hours are equal. Schedule your most cognitively demanding work during your peak energy hours. Use low-energy times for administrative tasks, meetings, or email.

## Questions to Help Users

- "Walk me through a typical day - where does your time actually go?"
- "What's the most important thing you should be doing that's not getting enough time?"
- "Do you have a system for capturing tasks and ideas, or do you try to remember everything?"
- "When are your peak energy hours? What do you schedule during that time?"
- "What commitments are you holding onto that you should let go of?"

## Common Mistakes to Flag

- **No external capture system** - Trying to remember everything creates anxiety and drops things. Write it down
- **Not protecting focused time** - If your calendar is wall-to-wall meetings, you have no time for actual work. Block it
- **Treating all hours equally** - Your 9am brain and your 4pm brain have different capabilities. Schedule accordingly
- **Saying yes to everything** - Every yes is a no to something else. Be intentional about commitments
- **Optimizing tactics without fixing strategy** - Being more efficient at the wrong things doesn't help. Prioritize first

## Deep Dive

For all 2 insights from 2 guests, see `references/guest-insights.md`

## Related Skills

- Managing Timelines
- Energy Management
- Running Effective Meetings
- Managing Up
