---
name: planning-under-uncertainty
description: Help users plan products and strategy when outcomes are unpredictable. Use when someone is dealing with ambiguous timelines, building in fast-moving markets, planning AI/ML projects, or asking how to make commitments when they don't know what will happen.
---

# Planning Under Uncertainty

Help the user navigate product planning when the future is unclear using adaptive planning frameworks from 44 product leaders.

## How to Help

When the user asks for help with planning under uncertainty:

1. **Understand the uncertainty type** - Ask what's driving the ambiguity: technical unknowns, market volatility, AI/ML unpredictability, or organizational change
2. **Assess planning horizon** - Determine if they need short-term execution tactics or long-term strategic flexibility
3. **Match framework to context** - Recommend appropriate planning approaches based on their uncertainty profile
4. **Build in adaptation mechanisms** - Help them create checkpoints and decision criteria for pivoting

## Core Principles

### Embrace optionality over prediction
Amjad Masad: "Being agile, not being stuck with roadmaps, being able to just say, oh, we're just going to switch priorities right away, is going to be super important." In rapidly changing environments like AI, maintain flexibility to pivot when new capabilities emerge rather than committing to rigid long-term plans.

### Build buffers for chaos
Upasna Gautam: "Any time we're planning we build in buffers for all of that chaos that's happening on a daily basis." In chaotic environments, planning must include explicit time buffers and contingency plans ranging from days to months depending on scope.

### Use data as compass, not GPS
Shaun Clowes: "Data is more like a compass than a GPS. If you look at data as a way of giving you the answer, you're always wrong." Use data to validate or invalidate intuition rather than waiting for it to tell you exactly what to do.

### Value learning over winning
Ramesh Johari: "Experimentation was never historically in science about winners and losers... Experimentation is always very hypothesis driven. It's about, what are you learning?" A healthy experimentation culture values learning from "failed" risky bets more than safe, incremental "wins."

### Develop reproducible testing processes
Nikita Bier: "Develop a reproducible testing process, and that will actually influence the probability of your success more than anything." Success in uncertain markets is driven by the quality and speed of the testing process rather than the initial idea.

### Diagnose before acting in crisis
Alex Hardimen: "There's this incredible humility that was needed to really understand and first diagnose what was actually happening on the platform." Managing through a crisis requires "wartime" humility to accurately diagnose problems before attempting solutions.

### Create decision triggers, not fixed plans
Eric Ries: "Give yourself a fixed period of time to take some decisive action and see if it feels better." Build checkpoints into plans where you'll reassess based on what you've learned, not just calendar dates.

### Distinguish reversible from irreversible decisions
Claire Hughes Johnson: "Type one, type two decisions. Is it high impact? Is it irreversible? Is it not?" Spend more time on one-way doors and move quickly on reversible decisions that can be adjusted later.

## Questions to Help Users

- "What would need to be true for your current plan to work? Which of those assumptions are you least confident about?"
- "If this takes twice as long as expected, what would you do differently? What if it takes half as long?"
- "What's the smallest thing you could ship to learn whether your core hypothesis is correct?"
- "Is this a one-way door or a two-way door decision?"
- "What signals would tell you to pivot or kill this initiative?"
- "How much buffer have you built in for unexpected chaos?"

## Common Mistakes to Flag

- **Over-planning** - Creating detailed long-term roadmaps that create false confidence and resist necessary pivots
- **Analysis paralysis** - Waiting for perfect information instead of making decisions with 70% confidence
- **Ignoring leading indicators** - Not tracking intermediate signals that could tell you earlier if you're on track
- **Judging experiments by outcomes alone** - Not valuing the learning from "failed" experiments that tested important hypotheses
- **Planning theater** - Spending excessive time on documents and processes that don't reduce actual uncertainty

## Deep Dive

For all 52 insights from 44 guests, see `references/guest-insights.md`

## Related Skills

- prioritizing-roadmap
- running-decision-processes
- scoping-cutting
- problem-definition
