---
name: platform-strategy
description: Help users design and execute platform business strategies. Use when someone is building a marketplace, creating an ecosystem, deciding on API strategy, thinking about multi-sided network effects, or building developer platforms.
---

# Platform Strategy

Help the user design and execute platform business strategies using frameworks from 24 product leaders who have built and scaled platforms.

## How to Help

When the user asks for help with platform strategy:

1. **Understand the platform type** - Clarify whether they're building a marketplace, API platform, ecosystem, or developer platform
2. **Identify the network effects** - Help them understand which sides of the platform create value for each other
3. **Assess the lifecycle stage** - Determine if they're in the moat-building, opening, or closing phase
4. **Design for trust and governance** - Help them think through the rules that will govern platform participants

## Core Principles

### Treat internal platforms as products
Camille Fournier: "Platform engineering is not just maintaining cloud infrastructure... platforms are products, ultimately. You should be thinking about how do I create coherent offerings that make this company more productive?" Internal platforms need dedicated product management and focus on user (developer) productivity, not just technical elegance.

### Understand the four-stage platform lifecycle
Brian Balfour: "The four steps are essentially, one is I call a Step Zero. It's the conditions of the market have been met. Step One is about a moat, Step Two is about a platform opening, and Step Three is about the platform closing for control and monetization." Platforms follow a predictable lifecycle from market consensus to closing for monetization.

### Reduce cognitive load through clear interfaces
Jeremy Henrickson: "The more you can bake into a clear platform, it reduces the decision-making complexity for everyone who's working on the domain part of the problem." A well-defined platform with clear interfaces simplifies product development by reducing the cognitive load on individual teams.

### Find compounding dynamics
Alex Komoroske: "Anything that is shaped like an ecosystem that has some kind of network effect... you have to know what you're looking for and find the dynamics of a thing that if it worked would work at an accelerating rate." Platform success comes from identifying "gardening" opportunities - projects with inherent compounding loops that grow on their own.

### Build systems, not features
Aparna Chennapragada: "The way I think about how we are positioned and what we do with GitHub is... So it's a system, not just a product or a set of features." Long-term platform defensibility comes from building a comprehensive system and repository of context rather than just a single feature or tool.

### Invest incrementally based on signals
Alex Komoroske: "Invest incrementally in ecosystem projects only as you receive signals of utility and adoption." Don't bet big on platform initiatives until you have evidence of demand and usage patterns.

## Questions to Help Users

- "Which side of your platform is harder to acquire? That's probably where you should focus first."
- "What value does your platform provide to a user with zero other participants?"
- "What stage of the platform lifecycle are you in - building the moat, opening, or closing?"
- "How will you prevent the supply side from being commoditized or going around you?"
- "What compounding dynamics exist in your platform that accelerate as it grows?"
- "What governance rules will you enforce, and how will you handle disputes?"

## Common Mistakes to Flag

- **Building platforms in a vacuum** - Not iterating based on actual product and developer needs
- **Treating all participants equally** - Not recognizing that power users and high-quality suppliers deserve different treatment
- **Skipping the moat phase** - Opening a platform before establishing defensibility
- **Feature thinking over systems thinking** - Building point solutions instead of comprehensive systems with context
- **Over-investing before signals** - Betting big on platform initiatives without evidence of utility and adoption

## Deep Dive

For all 28 insights from 24 guests, see `references/guest-insights.md`

## Related Skills

- platform-infrastructure
- retention-engagement
- pricing-strategy
