---
name: positioning-messaging
description: Help users craft product positioning and messaging. Use when someone is launching a product, differentiating from competitors, writing marketing copy, struggling to explain what their product does, or working on value propositions and taglines.
---

# Positioning & Messaging

Help the user craft compelling product positioning and messaging using frameworks from 58 product leaders and marketers.

## How to Help

When the user asks for help with positioning and messaging:

1. **Understand the target audience** - Ask who specifically they're trying to reach and what those people care about
2. **Identify the competitive frame** - Determine what alternatives customers are comparing them against
3. **Find the differentiated value** - Help them articulate what's uniquely true and valuable about their offering
4. **Test message resonance** - Guide them toward language that reflects how customers describe their own problems

## Core Principles

### Positioning dictates everything
Arielle Jackson: "I really believe that positioning dictates so much of your marketing and should always be the first thing you do. I had a student in my last class... He goes, I'll never write a line of code without doing positioning first." Positioning is the foundational element of marketing that should precede product development and all other marketing activities.

### Weak positioning creates pipeline friction
April Dunford: "Weak positioning hurts you in the early stages of pipeline in that people don't really get what you are, so they're not responding to your marketing the way they should. And you'll get this sluggishness in the middle of your pipeline." Monitor for customers asking sales reps to "back up and start over" during pitches - this signals positioning problems.

### Communication is defined by the receiver
Gina Gotthilf: "Communication isn't about being able to convey a message, it's about being able to convey a message in a way that the listener receives it, and understands it, and remembers it." Effective communication is defined by the listener's ability to understand and remember the message, not just the act of sending it.

### Use pattern matching for press
Emilie Gerber: "You can get so in the weeds with your own messaging that you want to set up this massive problem statement... but if you're very straightforward and you're pattern matching, it's generally actually going to work." Straightforward pattern matching is more effective for press than complex problem statements or trend stories.

### Brand sets expectations
Jessica Hische: "The cover of the book should tell people what to expect from the thing that they're about to engage with." A brand's visual identity should serve as a symbiotic preview that sets the correct expectations and tone for the product experience.

### Start with the struggling moment
Bob Moesta: "A struggling moment causes demand. And you start to realize that in some cases that struggling moment exists and can exist for a long time and nobody solved it." Great positioning starts with understanding the specific context where users feel stuck, not with product features.

### Differentiation requires sacrifice
April Dunford: "You can't be everything to everyone." True positioning requires explicitly deciding who you're NOT for and what you're NOT offering.

## Questions to Help Users

- "When a customer switches to your product, what are they switching FROM? What were they doing before?"
- "If your product disappeared tomorrow, what would your best customers miss most?"
- "What do your happiest customers say when they recommend you to a friend?"
- "Who is specifically NOT a good fit for your product, and why?"
- "What competitive alternative are you explicitly positioning against?"
- "Can everyone in your company describe what you do consistently?"

## Common Mistakes to Flag

- **Feature-first messaging** - Leading with what the product does rather than what customers achieve
- **Positioning by adjectives** - Using words like "powerful" or "easy-to-use" that every competitor also claims
- **Trying to appeal to everyone** - Refusing to narrow the target audience for fear of missing opportunities
- **Complex problem statements** - Over-explaining the problem instead of using straightforward pattern matching
- **Company-centric language** - Using internal jargon or product names that mean nothing to prospects

## Deep Dive

For all 106 insights from 58 guests, see `references/guest-insights.md`

## Related Skills

- problem-definition
- product-taste-intuition
- pricing-strategy
