# Positioning & Messaging - All Guest Insights

*58 guests, 106 mentions*

---

## Adam Grenier
*Adam Grenier*

> "The other one that I think is less known or talked about is the gift of details. So, in a scene, if you give somebody really specific details about something, it gives so much more meat to be able to work off of... if I say, 'We create content that is both education and entertainment to solve people's deep curiosities in the way that maybe a biography would.' That just opens up the exact problem that you're trying to solve."

**Insight:** Using hyper-specific details in messaging helps define the problem space and differentiates the product more effectively than broad descriptions.

**Tactical advice:**
- Use specific analogies (like 'biographies') to anchor the value proposition
- Provide 'meat' in descriptions to help customers understand the exact problem being solved

*Timestamp: 00:07:59*


## Andy Raskin
*Andy Raskin_*

> "The traditional structure, the way I learned how to pitch in business school, I think the way most people did is what I call the arrogant doctor. So you have a problem, a pain, I have a solution, a treatment, and I'm going to tell you why it's better than all the other treatment."

**Insight:** Traditional problem-solution positioning often leads to 'bragging' rather than engagement.

**Tactical advice:**
- Avoid the 'arrogant doctor' pitch structure of problem/solution/betterment.

*Timestamp: 00:08:54*

---

> "Every movie starts with some kind of shift in the world, and I call this shift the shift from the old game to a new game. The archetypal example of this, I think in the business world, is what Benioff did with Salesforce. So he comes in and he says, 'Hey, software is over and there's this new world called the cloud, a new game, new rules.'"

**Insight:** Effective positioning frames the product as a response to a fundamental shift in the market paradigm.

**Tactical advice:**
- Define the shift from an 'old game' to a 'new game' with new rules.
- Name the old game and the new game concisely (e.g., 'Software' vs. 'Cloud').

*Timestamp: 00:00:00*

---

> "What's really, I think key is naming it, naming that old game... This very, very concise naming is really key. And it's hard because in making it compact you're losing completeness... we're always kind of overstating it in a way, but it's not a problem."

**Insight:** Concise, even if slightly hyperbolic, naming of market shifts is more effective than exhaustive bullet points.

**Tactical advice:**
- Name the shift using simple contrasts (e.g., 'Transactions' to 'Subscriptions' or 'Opinions' to 'Reality').

*Timestamp: 00:19:42*


## Anuj Rathi
*Anuj Rathi*

> "How do I actually now empathize with this lazy, selfish, and vain customer, and build my product in a way so that I can make this appear on your site like this is the thing that you have to use, the way you write your copy, the way you build your onboarding, the way you do your first warm welcome?"

**Insight:** Effective positioning requires empathizing with the 'lazy, vain, and selfish' nature of new users who have existing habits and limited attention.

**Tactical advice:**
- Connect marketing messages directly to the product onboarding experience to ensure a seamless narrative journey.
- Focus on one primary value proposition for new users rather than overwhelming them with the full suite of product features.
- Think like a 'full-stack influencer' who must persuade both internal teams and external users.

*Timestamp: 00:16:37*


## April Dunford
*April Dunford*

> "Weak positioning hurts you in the early stages of pipeline in that people don't really get what you are, so they're not responding to your marketing the way they should. And you'll get this sluggishness in the middle of your pipeline, particularly if you have sales people. The light doesn't come on until they've had three calls with the sales rep and then the light comes on."

**Insight:** Weak positioning creates friction throughout the entire sales funnel, from initial marketing response to sales cycle length.

**Tactical advice:**
- Monitor for 'sluggishness' in the middle of the sales pipeline
- Listen for customers asking sales reps to 'back up and start over' during pitches

*Timestamp: 00:08:47*

---

> "positioning defines how your product is the best in the world, delivering some value that a well-defined set of companies care a lot about. So put another way, it encompasses a lot of things, it defines what are the alternatives to what you do? How are you different? What value can you deliver that no other product on the market can?"

**Insight:** Positioning is the strategic definition of a product's unique value within a specific market context against specific alternatives.

**Tactical advice:**
- Define the specific alternatives customers use today
- Identify the unique value only your product can deliver
- Determine which specific companies care most about that unique value

*Timestamp: 00:11:30*

---

> "I actually think it's better in the early days of a product to keep the positioning a little bit loose and allow the market to pull you maybe in a direction that you didn't think it was going to."

**Insight:** Early-stage startups should maintain flexible positioning to allow for market discovery and unexpected use cases.

**Tactical advice:**
- Treat early positioning as a 'thesis' rather than a fixed fact
- Use broader category terms initially to see which customer segments show the strongest pull

*Timestamp: 00:47:23*

---

> "I need to understand that deeply in order to build my whole go-to market strategy, in order to have marketing campaigns that resonate with those kinds of companies, in order to make a list, if my sales are doing outbound, or if I'm doing target account selling, or ABM, how do I make that list of who I'm going after, that kind of stuff."

**Insight:** Deep market segmentation based on product value is the foundation for all outbound and account-based marketing efforts.

**Tactical advice:**
- Segment the market based on characteristics that make customers care about your specific value
- Use these segments to build actionable outbound sales lists

*Timestamp: 00:53:35*

---

> "The pitch structure has two big pieces. So the first is the setup. The setup piece is not about us, it's about the market, our point of view on the market. The second bit is all about our differentiated value. So why pick us over the other guys?"

**Insight:** An effective sales pitch should be structured as a narrative that first aligns the customer with a specific market worldview before introducing the product's unique value.

**Tactical advice:**
- Start with an insight into the market or the 'problem inside the problem'.
- Discuss the pluses and minuses of alternative solutions to paint a picture of the entire market.
- Define a 'perfect world' solution that the customer agrees would solve their problem.

*Timestamp: 00:12:33*

---

> "Differentiated value is the answer to the question why pick us over the other alternatives? And so the way we get at that in positioning is we start with putting a stake in the ground of who do we actually compete with?"

**Insight:** Differentiated value is derived by identifying what a customer would do if your product didn't exist and then determining the unique capabilities you offer that provide specific value.

**Tactical advice:**
- Identify competitive alternatives, including status quo like spreadsheets or manual labor.
- List features or capabilities that are unique to your product compared to those alternatives.
- Ask 'so what?' for each feature to uncover the actual value delivered to the customer.

*Timestamp: 00:39:20*


## Arielle Jackson
*Arielle Jackson*

> "I really believe that positioning dictates so much of your marketing and should always be the first thing you do. I had a student in my last class... He goes, I'll never write a line of code without doing positioning first."

**Insight:** Positioning is the foundational element of marketing that should precede product development and all other marketing activities.

**Tactical advice:**
- Perform positioning exercises before writing code or launching products
- Ensure all employees and customers describe the company consistently

*Timestamp: 00:19:22*

---

> "Positioning is the space that you occupy in your target customer's mind and everything you can do to influence how they describe your product. You have a positioning problem if I ask 10 of your customers or 10 of your employees what the company does or what the product does. And I get multiple answers."

**Insight:** Effective positioning ensures a unified understanding of the product's role across all stakeholders.

**Tactical advice:**
- Interview 10 people (execs, customer-facing staff, and customers) to check for consistency
- Distill the company's value proposition into a single sentence

*Timestamp: 00:51:23*

---

> "That statement is for target audience who there's a statement of need or opportunity. And then you say our product name is a category that has a benefit, unlike the old thing they were doing, our product works this other way."

**Insight:** A structured 'four-statement' framework helps define the target audience, the problem, the category, and the unique differentiator.

**Tactical advice:**
- Identify the target audience and their specific statement of need
- Define the product category and the primary benefit
- Contrast the product against the 'old way' of doing things

*Timestamp: 00:57:20*

---

> "The bar test... you pretend to be someone in your target, having drinks with someone else in your target at a bar and you have to be able to say, hey, I just started using product name. It's this really great category, that benefit. And the other person goes, hm, tell me more or that's cool, what do you mean?"

**Insight:** The 'bar test' ensures that positioning and messaging use natural, human language rather than corporate jargon.

**Tactical advice:**
- Role-play a conversation between two target customers at a bar
- Avoid words like 'leverages' or 'empowers' in favor of descriptive, conversational verbs

*Timestamp: 01:00:28*


## Barbra Gago
*Barbra Gago*

> "When you're building a category, you need to make sure that there is a category that's validated by analysts and directory sites and things like that. But also, you want to have a lot of traction in terms of thought leadership like why is this the category? What are the unique value propositions of this particular thing? What are the pain points it solves?"

**Insight:** Category creation requires a blend of external validation from analysts and internal thought leadership that defines unique value and solves specific pain points.

**Tactical advice:**
- Validate the category through analysts and directory sites
- Develop thought leadership explaining why the category exists
- Define unique value propositions and specific pain points solved

*Timestamp: 00:00*

---

> "The main thing which we've talked a little bit about already is really understanding your customers and their pain points and how they talk about things. All of my best marketing and positioning literally comes from having a million conversations with customers and listening to how they solve problems and how our system helps them solve problems and what they're doing and how they talk about stuff."

**Insight:** Effective positioning is derived directly from the language and problem-solving methods used by customers in real conversations.

**Tactical advice:**
- Conduct extensive customer conversations to hear their specific language
- Listen for how customers describe their pain points and solutions
- Use customer-derived language to shape marketing and positioning

*Timestamp: 21:36*


## Brian Chesky
*Brian Chesky*

> "The basic idea is this. You can't build a product unless you know how to talk about the product. You can't be an expert in making the product unless you're also an expert in the market of it."

**Insight:** Product development and product marketing are inseparable; builders must understand how to communicate the value to the market.

**Tactical advice:**
- Combine inbound product development with outbound product marketing
- Ensure product experts are also market experts

*Timestamp: 00:07:42*


## Camille Ricketts
*Camille Ricketts*

> "I think the best first step for any positioning exercise is to think who are our best fit customers? And it's not necessarily who we wish they would be, but it's actually the hard cold reality of who they actually are. Where it's like these are the people that seem to be really getting it. They're paying us more, they're talking about it just organically."

**Insight:** Positioning should be based on the 'hard cold reality' of who your best-fit customers actually are, not who you wish they were.

**Tactical advice:**
- Identify customers who are already paying more and talking about the product organically
- Base positioning on the attributes of these high-value, organic advocates

*Timestamp: 00:38:10*


## Christine Itwaru
*Christine Itwaru*

> "Product marketing positions help the revenue team sell their lead gen for all of the outbound and the campaigns that they're running... For us, it's about educating and it's about helping our internal folks, our internal revenue team understand, 'What is the added value? How do you now do this thing?'"

**Insight:** Product operations focuses on internal education and functional understanding, while product marketing focuses on external positioning and sales enablement.

**Tactical advice:**
- Distinguish between 'selling' (PMM) and 'educating' (Product Ops) when preparing internal teams for new features

*Timestamp: 00:46:13*


## Christopher Lochhead
*Christopher Lochhead*

> "Languaging, which is the strategic use of language to change thinking. And a mistake that a lot of entrepreneurs make is they use old language to describe their new thing."

**Insight:** Strategic language is required to shift consumer thinking and create a demarcation point from the past.

**Tactical advice:**
- Create new terminology to describe your category (e.g., 'Vertical Railway' for elevators).
- Avoid using old language to describe innovative products.

*Timestamp: 00:49:09*

---

> "The company that creates the languaging for the category wins. ... New languaging creates new thinking, and a demarcation point in language creates a demarcation point in thinking, which can create a demarcation point in perceived value."

**Insight:** Owning the vocabulary of a category allows a company to control the perception of value.

**Tactical advice:**
- Introduce new terms like 'LLM' or 'Training Data' to define the conversation in your space.

*Timestamp: 00:56:39*

---

> "Positioning in the modern context is for losers. That is to say people who are fighting over the 24%. ... Positioning has become sort of category design for the cowards. It's like, 'Well, I know that we could really be as radical as to create our own space, so let's just see if we can carve off our little niche over here.'"

**Insight:** Traditional positioning often focuses on competing within an existing category rather than creating a new one.

**Tactical advice:**
- Avoid positioning against competitors; instead, position your category against the status quo.

*Timestamp: 01:18:15*


## Claire Butler
*Claire Butler*

> "I see that they were actually had some branding and positioning and things that the products, Figma, was going to be named Summit, that was the name... I had an immediate reaction of like, "We cannot make this thing Summit. That's not going to work. We can't have two brands. Summit's not ownable, we can't build equity and multiple things. That's just never going to work.""

**Insight:** Choose a brand name that is ownable and allows for long-term equity building rather than splitting focus across multiple sub-brands.

**Tactical advice:**
- Avoid generic names that cannot be easily owned in the market
- Consolidate brand equity into a single, ownable name early on

*Timestamp: 00:04:50*

---

> "I remember there was more than one day where we locked ourselves in a conference room and I made Dylan and show at the time have this positioning up on the big screen and made them agree on it word for word."

**Insight:** Forcing alignment on specific messaging word-for-word is a necessary exercise for early-stage clarity.

**Tactical advice:**
- Conduct intensive, word-for-word positioning reviews with founders

*Timestamp: 00:08:36*

---

> "I think one of the things I learned right away, very quickly was that designers don't want to hear from marketers. They don't want to be marketed to and they have an extremely high bullshit meter. You use a word like efficiency, collaboration, all of those buzzwords, and they're just like, "I don't want to hear this.""

**Insight:** Technical audiences respond better to technical features and craft-based language than traditional marketing buzzwords.

**Tactical advice:**
- Avoid fluff words like 'efficiency' or 'collaboration' when targeting practitioners
- Focus messaging on technical features and how they improve the user's workflow

*Timestamp: 00:32:14*


## Crystal W
*Crystal W*

> "If your product does something that's not super familiar, you have to tie it to something that is. So I talked about using drivers to sell GoPay. Before that, one thing that we did was to actually take someone's virtual account number and put it onto a picture of a credit card. You know what a credit card is, that's familiar to you."

**Insight:** Bridge the gap for novel products by using visual metaphors and copy that align with familiar mental models.

**Tactical advice:**
- Use visual cues (like a credit card image) to explain digital-only concepts
- Focus copy on the user's pain point rather than the technical solution

*Timestamp: 00:37:15*


## David Placek
*David Placek*

> "Your brand name, nothing's going to be used more often or for longer than that name. Design will change, messaging will change, products will change, but that name is there."

**Insight:** A brand name is the most permanent and frequently used element of a company's identity.

**Tactical advice:**
- Prioritize the name as a long-term asset that outlasts design and product iterations

*Timestamp: 00:00:00*

---

> "Even before you launch this brand, why not start with an advantage in the marketplace? And you won't get an advantage if you're descriptive. If you are Cloud Pro and there's 10 other cloud services, you're not going to stand out in the marketplace."

**Insight:** Distinctive names provide an asymmetric advantage by standing out from descriptive competitors.

**Tactical advice:**
- Avoid descriptive names that blend into the category
- Aim for distinctiveness to create 'cumulative advantage' over time

*Timestamp: 00:16:09*

---

> "You don't want to make a statement here. You want to start a story. And Azure is going to behave differently in the marketplace than Cloud Pro, which is I think one of the names that we presented to them on the other site at their request."

**Insight:** A great name should initiate a narrative rather than just describing a function.

**Tactical advice:**
- Choose names that evoke a story or experience rather than just stating what the product does

*Timestamp: 00:13:27*


## Elena Verna
*Elena Verna 2.0*

> "Individual is not solving for data-driven culture. Individual is just solving for data insights for them. Company's solving for data-driven culture... Sales can tell that story. Sales can bridge that gap, and then you can increase the perceived value in order to bridge the gap to that $15,000, 20, hundred-thousand dollar contract."

**Insight:** Enterprise sales requires shifting the narrative from individual utility to organizational transformation.

**Tactical advice:**
- Identify the enterprise-level value prop (e.g., 'increased innovation' vs. 'making a whiteboard')
- Bridge the gap between what the product shows and what the organization benefits from

*Timestamp: 00:11:25*

---

> "Never ever once have I seen a rebrand or redesign, especially of UK marketing site produce good performance results. New CMO comes in designing their website or designing the brand as if it was reflection of their personal taste, and oftentimes it's promised with our acquisition is going to go up and it never materializes into anything meaningful."

**Insight:** Rebrands and homepage redesigns typically result in a short-term performance hit and should be viewed as long-term strategic shifts rather than immediate growth drivers.

**Tactical advice:**
- Forecast and model for a performance hit immediately following a rebrand launch.
- Bake in three to six months of optimization work after a redesign to return to previous performance levels.
- Avoid promising increased acquisition as a direct result of a visual rebrand.

*Timestamp: 00:19:23*


## Emilie Gerber
*Emilie Gerber*

> "You can get so in the weeds with your own messaging that you want to set up this massive problem statement, you want to make it a huge trend story, but if you're very straightforward and you're pattern matching, it's generally actually going to work."

**Insight:** Straightforward pattern matching is more effective for press than complex problem statements or trend stories.

**Tactical advice:**
- Be direct and concise in messaging
- Use pattern matching to help reporters understand the story quickly

*Timestamp: 00:00:32*

---

> "I'll put company taking on whatever Salesforce with X approach. It's so successful because instantly it gives the reporter a frame of reference. And so it gives the reporter, oh, I know what Salesforce does, so I can understand how this solution would be better."

**Insight:** Referencing a well-known incumbent provides reporters with an immediate frame of reference for your product.

**Tactical advice:**
- Use 'Company X taking on [Incumbent] with [Approach]' in subject lines
- Frame the product as a better version of a household name

*Timestamp: 00:41:24*

---

> "A lot of companies want to position themselves as category creators, and I actually hate that. It doesn't work. It doesn't land with press, and most of the time it's not totally true... for PR, it's just not a useful tactic."

**Insight:** Category creation is generally an ineffective positioning tactic for PR compared to direct comparisons.

**Tactical advice:**
- Avoid 'category creator' jargon in press pitches
- Focus on how you are better than existing solutions rather than being the 'first' of a new category

*Timestamp: 00:41:24*

---

> "The more that you can reiterate over and over again how you want the article to be, I think the more likely that it'll land in the reporter's head and make sure that the reporter really understands what you're building and what your goals are."

**Insight:** Repetition of core messages during briefings increases the likelihood of those messages appearing in the final story.

**Tactical advice:**
- Nail core messages before talking to reporters
- Reiterate the desired angle multiple times during the interview

*Timestamp: 00:27:20*


## Eli Schwartz
*Eli Schwartz*

> "Product people need to think about how do we position this to the user that is not going to find out about this from a social channel, that's not going to be attracted by an ad? This is a user that's doing their own self-discovery journey."

**Insight:** SEO should be viewed as a product positioning challenge for users on a self-discovery journey rather than just a marketing tactic.

**Tactical advice:**
- Identify the specific self-discovery journey a user takes when they aren't coming from social or ads
- Position the product as a solution to the specific problem the user is searching for in the mid-funnel

*Timestamp: 00:00:19*

---

> "We discovered that Tinder is a loneliness-solving problem, loneliness-solving solution... we built out is if you look for online dating in many cities around the world... you're going to find a Tinder page, which gives some examples of places you can go on a date. And more than that, it gives you Tinder as a solution to solve the loneliness problem you have."

**Insight:** Effective SEO positioning involves identifying the underlying emotional or functional problem the product solves (e.g., loneliness) rather than just the category (e.g., dating).

**Tactical advice:**
- Use user research to find the 'problem-solving' angle of your product
- Create local or programmatic pages that showcase the product as a solution to that specific problem

*Timestamp: 00:28:17*


## Emily Kramer
*Emily Kramer*

> "Forget the product marketing content partner, demand and growth, forget all of it, and just think of marketing as you need a fuel and you need an engine. And goal is like all the things that you're creating. I mean this should be obvious, but it's the content, it's the word, it's the design in some regard. All the things that you're making, all the things that are going to add value. An engine is how you get it out to the right people."

**Insight:** Marketing should be viewed as a combination of 'fuel' (content and messaging) and 'engine' (distribution and operations).

**Tactical advice:**
- Identify whether your current bottleneck is 'fuel' (nothing valuable to say) or 'engine' (no way to distribute the message).
- Ensure you have fuel (positioning/content) before building a complex distribution engine.

*Timestamp: 00:00:00*

---

> "The company that you're working on, what's the product? Why is it better? Who is it for? It's the most basic positioning question you can ask, but a lot of people can't answer it. So that's a good one. And also if you're writing positioning at your company or if you're on marketing your company and you can't tell me what the product is, why it's better, who it's for, go figure that out if that's what the home page of your website should cover."

**Insight:** Core positioning must answer three questions: What is it, why is it better, and who is it for?

**Tactical advice:**
- Audit your homepage to ensure it clearly answers the three core positioning questions.
- Use these three questions as a litmus test when interviewing marketing candidates.

*Timestamp: 01:04:49*


## Geoffrey Moore
*Geoffrey Moore*

> "You want to have a target segment that is big enough to matter, small enough to lead and a good fit with your crown jewels."

**Insight:** The ideal initial target market for a disruptive product must be large enough to sustain growth but small enough to dominate quickly.

**Tactical advice:**
- Define segments by geography, industry, and profession to ensure peers talk to each other.
- Aim for 30-50% market share in your initial 'pond' within two years.

*Timestamp: 00:19:55*

---

> "We are the technology leaders who have specialized and committed to solve this problem. And by the way, we have huge respect for your incumbent vendor. We're not asking you to kick them out. They just can't solve this problem. We also have respect for our peers, but frankly, they wouldn't know your problem if they wouldn't recognize it in a lineup."

**Insight:** Effective positioning for pragmatists emphasizes domain specialization over general technology superiority.

**Tactical advice:**
- Acknowledge incumbent vendors rather than trying to replace them entirely.
- Differentiate from technology peers by highlighting your specific commitment to the customer's niche problem.

*Timestamp: 01:09:56*


## Gia Laudi
*Gia Laudi*

> "Generally, the lowest hanging fruit outcome is realigning around better positioning and messaging. And identifying more resonant positioning and messaging that speaks to that context that I was talking about before, before people discover that you even exist, have that moment where they're like, 'Oh my god, this has to change. This sucks,' ties that in, ties in what they care about and what is valuable about your product and then also that desired outcome."

**Insight:** High-impact positioning connects the customer's 'struggle' context (before they find you) to the specific desired outcome your product enables.

**Tactical advice:**
- Identify the 'struggle' context customers experience before discovering your product
- Align messaging with the customer's desired outcome rather than just product features

*Timestamp: 00:09:15*

---

> "You want to reflect them back to them. That is what is going to show them that you understand the problem that they have and that your product has exactly what it is that they need. The hierarchy of messaging is really important as well... you want to reflect back what they said they care about, not what you think is the coolest thing about your product."

**Insight:** Effective messaging uses the customer's own language to prove you understand their problem and prioritizes what they value most.

**Tactical advice:**
- Use 'voice of customer' research to mirror the language customers use
- Establish a messaging hierarchy based on what customers rank as most valuable
- Create a messaging guide (5-7 pages) to serve as guardrails for all collateral

*Timestamp: 00:51:50*


## Gina Gotthilf
*Gina Gotthilf*

> "Communication is constantly underrated. And communication isn't about being able to convey a message, it's about being able to convey a message in a way that the listener receives it, and understands it, and remembers it. And that's really hard to do."

**Insight:** Effective communication is defined by the listener's ability to understand and remember the message, not just the act of sending it.

**Tactical advice:**
- Focus on making the message resonant and memorable for the specific listener.

*Timestamp: 00:00:00*

---

> "There is always a quirk, like it's unexpected. The way we talk to you is a little bit funny. It doesn't take ourselves too, seriously and it makes the person receiving this message feel something. Again, it's about how you make people feel. And you feel like either you giggle, or you're like, wait what? They just did what? And using that to your benefit."

**Insight:** Using an unexpected or humorous voice creates an emotional connection that makes a brand more memorable.

**Tactical advice:**
- Incorporate 'quirks' or unexpected elements into brand communication to provoke an emotional response.
- Don't take the brand too seriously to make it more relatable.

*Timestamp: 00:00:25*

---

> "First, the core copy, the message and button need to be above the fold. Or, if you're not going to keep the button above the fold, which I still recommend, but if you're not going to do that for whatever reason, then you need to have a very clear indicator that there's something to scroll towards on your page. The second thing, applies to both desktop and mobile, is people skim... So you have to approach a landing page with that perspective in as much as possible. And so for me, what makes something particularly skimmable is first restricting copy a lot. And even copy that seems short is probably not short enough. Second, so people normally like to have a title, some sort of subtitle, and then an image and a button... Having the title and the button speak to each other is really cool. Because if people only read the title and the button, they got it."

**Insight:** Landing pages must be optimized for skimmability and mobile viewing, ensuring the core message and call-to-action are immediately obvious.

**Tactical advice:**
- Keep core copy and buttons above the fold.
- Restrict copy length aggressively to accommodate skimmers.
- Ensure the title and the button text 'speak to each other' so the value prop is clear even if nothing else is read.
- Use clear visual indicators if content requires scrolling.

*Timestamp: 00:20:44*

---

> "I love copywriting, and I believe that communication is constantly underrated, and communication isn't about being able to convey a message. It's about being able to convey a message in a way that the listener receives it and understands it and remembers it. And that's really hard to do. And one of the things I've helped employ at Duolingo that I think is still there today... is a unique voice and what that means is exactly what you said, Lenny, not just another language learning app where we give you instructions and you follow directions. There is always a quirk. It's unexpected."

**Insight:** A unique brand voice differentiates a product from generic competitors and aids in message retention.

**Tactical advice:**
- Develop a 'unique voice' that avoids industry clichés.
- Audit copy to ensure it couldn't have been written by any other company.

*Timestamp: 00:49:17*

---

> "We constantly looked at every copy we wrote and asked, 'Could this have been written by other companies? Could this have been any other company or is it Duolingo? What makes this Duolingo?'... It helps figuring out, exactly what does that voice, what does it sound like? What are some words that it tends to use? Why yes, why not? What's too much, what's too little?"

**Insight:** Maintaining a consistent brand voice requires rigorous internal standards and a clear definition of the brand's personality.

**Tactical advice:**
- Create a voice guide defining specific words, tones, and boundaries ('what's too much, what's too little').
- Test every piece of copy against the brand's unique identity.

*Timestamp: 00:52:09*


## Grant Lee
*Grant Lee*

> "When I think about something that could be scalable, it's almost like you can take the ingredients of a brand and replicate it a ton, this DNA is something where you can imagine creating tons of content around and all feeling pretty cohesive. And I think that needs to be done by design. You're really being thoughtful about every single element. Like what is the art direction you want to go with? What is the voice and tone? Such that as you're creating thousands of pieces of copy, it all feels pretty cohesive."

**Insight:** A scalable brand requires a well-defined 'DNA'—including art direction and tone—that allows for the mass production of cohesive content.

**Tactical advice:**
- Invest in a rebrand when the existing brand limits your ability to scale creative content.
- Ensure 'symmetric messaging' where the ad, landing page, and product experience all feel cohesive.

*Timestamp: 00:39:12*


## Hamilton Helmer
*Hamilton Helmer*

> "Almost every startup that you want to deal with starts with counter positioning because remember what product market fit is primarily is a substitution. You are coming up with a way to satisfy a more or less existing need in a novel way that creates more value."

**Insight:** Counter-positioning is the most common entry point for startups, leveraging a new business model that incumbents cannot easily mimic without damaging their existing business.

**Tactical advice:**
- Identify how your product satisfies an existing need in a way that creates a 'collateral damage' dilemma for incumbents who might try to copy you.

*Timestamp: 00:18:13*


## Ivan Zhao
*Ivan Zhao*

> "Only hardcore Lego fans care about Lego bricks. Most people care about Lego boxes. And they actually want the Lego box to be ready-made. When you unpack the box, the set is there for you, right? That's what we're learning a lot, especially move up market. There's this term that took me a while to learn. It's called solutions. You need to be a solution for enterprise customer."

**Insight:** Horizontal tools must be positioned as 'solutions' (Lego boxes) for specific enterprise needs rather than just 'primitives' (Lego bricks).

**Tactical advice:**
- Package modular features into 'solutions' that sit on a specific P&L for enterprise buyers.
- Create pre-made templates or 'sets' to reduce the cognitive load for non-power users.

*Timestamp: 00:51:56*


## Jackson Shuttleworth
*Jackson Shuttleworth*

> "We've actually set up really good infrastructure for copy testing. We used to say continue, our standard CTA is continue, and we changed that to commit to my goal, and it was a massive win."

**Insight:** Small changes in micro-copy can significantly alter user intentionality and retention.

**Tactical advice:**
- Test high-intent CTAs (e.g., 'Commit to my goal') against generic ones (e.g., 'Continue').
- Invest in infrastructure that allows for rapid, low-cost copy experimentation.

*Timestamp: 00:00:30*


## Jake Knapp + John Zeratsky
*Jake Knapp + John Zeratsky 2.0*

> "It's crucial then that a product has a clear promise that it makes, and that promise is radically differentiated from the alternatives and that that promise is strong enough that you'll try it and then that the product delivers on that promise."

**Insight:** Effective positioning is built on a 'promise' that is both radically different from alternatives and highly motivating to the customer.

**Tactical advice:**
- Focus on the promise made to the customer rather than just technical features.
- Ensure the promise is strong enough to overcome the customer's natural defense against trying new things.

*Timestamp: 00:30:10*

---

> "We talk about classic differentiators, fast to slow, smart to not so smart to borrow from the iPhone slide, easy to use to hard to use, and so on."

**Insight:** Starting with 'classic' differentiators helps teams warm up before identifying more nuanced, custom ways to stand out.

**Tactical advice:**
- Score the product against competitors on classic scales: fast/slow, smart/not-smart, easy/hard, free/expensive, focused/one-size-fits-all, simple/complicated, integrated/siloed.

*Timestamp: 00:31:44*


## Jason Feifer
*Jason Feifer*

> "The editor, the writer, I'll just say it as plainly as possible. They don't care about you. They don't care about you. They care about their reader or their listener or their viewer. That's who they care about. That's who they're serving, and if you can be of use to them in sharing the kinds of information that they are looking to serve their audience, then you can get what you want."

**Insight:** Effective messaging for press requires shifting the focus from your own needs to the needs of the publication's specific audience.

**Tactical advice:**
- Research a publication's mission before pitching to ensure your story fits their specific editorial lens.
- Avoid treating journalists as service providers; instead, position yourself as a resource for their readers.

*Timestamp: 00:00:00*

---

> "If he is selling hot dogs in Washington, DC, then I understand what press is for him. Press is to drive hotdog sales. That's what he wants to do. Entrepreneur is not going to do that for him. Full stop. Why? Because Entrepreneur reaches a national to international audience... What he needs to do is think, 'Okay, my goal, get more people to buy hot dogs. Where am I? I'll in Washington, DC. How can I reach people who are interested in food in my market?'"

**Insight:** Messaging must be targeted to publications whose audience geographic and topical reach aligns with your business goals.

**Tactical advice:**
- Match the scale of the publication (local vs. national) to the scale of your target customer base.
- Look at where your competitors have been featured to identify the right audiences to target.

*Timestamp: 00:11:52*


## Jen Abel
*Jen Abel 2.0*

> "You need to vision cast, you need to sell to a gap, don't sell to a problem. There's a very big difference between problem selling and gap selling. Problem selling is highly specific, more technical than not, and it's the way that every salesperson is going to go about it, find the problem and anchor to it. When you're selling to a leader, you need to be vision casting and you need to be selling an opportunity which is they are here, here's where we can take you."

**Insight:** Effective enterprise positioning focuses on 'gap selling'—the distance between the current state and a future opportunity—rather than just solving technical problems.

**Tactical advice:**
- Sell the 'opportunity' and the 'future version' of the customer (Mario on blast) rather than just the tool (the mushroom).
- Avoid scripts that focus solely on pain points, as they can feel overly 'salesy' to executives.

*Timestamp: 00:11:01*

---

> "As soon as you become a comparison, as soon as you become one of three that they're testing out, you've already sort of lost. It's all about differentiation. Here's what you will be able to do tomorrow because of how we're going to serve you today."

**Insight:** Winning in the enterprise requires radical differentiation to avoid being commoditized in a three-way vendor comparison.

**Tactical advice:**
- Own the framing of the problem so that you are not easily compared to incumbents.
- Focus messaging on what the client can achieve 'tomorrow' rather than just current features.

*Timestamp: 00:00:34*


## Jessica Hische
*Jessica Hische*

> "I think the logo and the brand assets can generate a lot of both internal and external excitement and just tell people what to expect from the thing that they're about to engage with. Some people say don't judge a book by its cover. I'm the opposite, where any book... The cover of the book should be giving you incredible insight into what is on the interior of the book and setting the tone and setting the vibe so that when you open the book and read the book, it's a symbiotic thing where you're like, 'Oh, I understand what I was getting into.'"

**Insight:** A brand's visual identity should serve as a symbiotic preview that sets the correct expectations and tone for the product experience.

**Tactical advice:**
- Ensure the brand assets generate internal team excitement as well as external customer interest.
- Use the 'cover' of the product to provide immediate insight into the 'interior' value.

*Timestamp: 00:06:32*

---

> "If you invest super heavily on the whole brand vision from the jump, sometimes it's like throwing away money if you have to pivot. What I love about the work that I do is that I understand that a lot of people have to just have something to put on decks and have something to put on a holding page or whatever, and internal teams are totally capable of doing that early work. But then if it does become successful, you don't want to get locked into whatever it is that you had to throw together before an investor meeting or something."

**Insight:** Early-stage startups should avoid over-investing in brand vision until the product direction is stable, but should plan for a professional refresh once successful.

**Tactical advice:**
- Use internal teams for early 'placeholder' branding during the pivot-heavy phase.
- Wait until the company is successful or stable before committing to a massive brand exploration.

*Timestamp: 00:08:24*

---

> "One of the reasons why I tell people why having a custom logo or custom typography can really matter is that if you're using something that's available to everyone, the chances of someone else coming in and copying you are very easy and high. You might be one of these lucky companies that just out the gate is outrageously successful, but with success comes people climbing up behind you trying to copy your success. If that success is very easily copyable and people will try to trick your customers into coming their way by repeating the things that you're doing, including the branding, one way to avoid that is by doing something that's more customized when it comes to the logo and brand."

**Insight:** Custom typography and logos act as a defensive moat against competitors attempting to mimic a successful brand's identity.

**Tactical advice:**
- Invest in custom design to prevent competitors from easily tricking customers with similar 'off-the-shelf' branding.
- Consider a refresh when you are about to physically invest money in swag, conferences, or large-scale rollouts.

*Timestamp: 00:11:03*

---

> "When you think about logos and things like that, you want it to be something that, at a super fast glance, people can read it right away. That doesn't mean that everything has to be simple, but it just means that everything has to be incredibly legible, especially when you're starting a new company or you have a less recognizable brand."

**Insight:** For new or less recognizable brands, legibility is more important than abstract simplicity to ensure immediate recognition.

**Tactical advice:**
- Test logos for 'misreads' or unintended words (e.g., the Jeni's Ice Cream 'penis' misread example).
- Prioritize high legibility at a 'super fast glance' until the brand reaches household-name status.

*Timestamp: 00:17:18*


## Jonathan Becker
*Jonathan Becker*

> "I think about us beginning a conversation at the top of funnel creatively with an audience, having that conversation change as we say different things, and the audience that we're targeting ultimately graduates through different behaviors on our website from one to another, and then ultimately it resulting in an end to the conversation where they take an action."

**Insight:** Messaging should be treated as a continuous, evolving conversation that changes based on the user's stage in the funnel.

**Tactical advice:**
- Vary messaging between 'generating intent' at the top of the funnel and 'capturing intent' at the bottom
- Avoid using a single homogenous message across all targeting stages

*Timestamp: 00:35:56*


## Jonathan Lowenhar
*Jonathan Lowenhar*

> "What is our uncommon denominator from the enemies? So who are we competing against? Is it actual companies or is it status quo in some sort? What are they great at? What are we great at? What are we great at that they're not?"

**Insight:** Effective positioning requires identifying your 'uncommon denominator' against both direct competitors and the status quo.

**Tactical advice:**
- Identify the 'enemy' (competitors or the current way of doing things).
- Define what you are great at that the competition is not.
- Translate these differences into branding and marketing artifacts.

*Timestamp: 01:03:37*

---

> "All we're looking for in the beginning is a white-hot center of opportunity, a small population that is an enormous fan that's getting enormous impact. We can worry about adjacencies and expansion later."

**Insight:** Early-stage success comes from hyper-focusing on a small, highly-satisfied 'white-hot center' of customers.

**Tactical advice:**
- Identify your 'favorite' existing customer who raves about the product.
- Define the Ideal Customer Profile (ICP) based on that specific successful user.
- Establish 'kill criteria' to reject prospects that don't fit the ICP, even if they want to buy.

*Timestamp: 01:10:10*


## Kevin Aluwi
*Kevin Aluwi*

> "We were the first company of scale to have ads that don't take ourselves too seriously. We make fun of ourselves, we make fun of our cultural observations of Indonesia. And again, to just build this overall field that like, Hey, we get, we are part of the overall culture of Indonesia."

**Insight:** Effective messaging builds relatability by reflecting local cultural observations and maintaining a self-aware, non-corporate tone.

**Tactical advice:**
- Incorporate cultural observations into marketing copy to build local relatability
- Adopt a tone that doesn't take the company too seriously to differentiate from corporate competitors

*Timestamp: 00:20:42*


## Kevin Weil
*Kevin Weil*

> "I think being first helps... we like being the first to launch new capabilities... ChatGPT can be this one-stop-shop where all the things that you want to do are possible."

**Insight:** Market leadership in AI is driven by being the first to launch new capabilities and positioning the product as a universal tool.

**Tactical advice:**
- Prioritize speed to market for novel features to capture the consumer mindset
- Position the product as a 'catch-all' for diverse user needs

*Timestamp: 00:35:02*


## Kristen Berman
*Kristen Berman*

> "When you ask a question, you can insert an idea into someone's head, you can get them thinking about something different. And so, in a sign up flow, what would you want people to be thinking about? You probably want them to be thinking about the benefits that you offer."

**Insight:** Using interactive questions in a signup flow can prime users to think about product benefits, increasing their motivation to complete the process.

**Tactical advice:**
- Replace static carousels with multiple-choice questions that force users to engage with the product's value proposition.

*Timestamp: 12:22*


## Laura Schaffer
*Laura Schaffer*

> "Developers, almost two, one, do not look at your marketing website at all. They go straight to your signup flow... They're the IKEA buyers who when IKEA package comes, they're not opening up the instruction manual and reading in and then starting to go through, they're in there tearing open the bags."

**Insight:** For technical audiences, the product experience and documentation serve as the primary messaging and value proposition.

**Tactical advice:**
- Ensure the signup flow provides context that developers might have missed by skipping the marketing site
- Focus messaging on the 'proof of concept' rather than high-level marketing claims
- Address the developer's professional risk (reliability and reputation) directly in the product experience

*Timestamp: 01:07:15*


## Lulu Cheng Meservey
*Lulu Cheng Meservey*

> "I often say to find your audience's cultural erogenous zones. So what it means is people have things that they either care about or don't, and you're not going to change that. So it's a huge lift to try to change someone's worldview or their passions. It's a light lift to take the thing you want to talk about and just shape it into, to fit into their worldview or their passions."

**Insight:** Effective messaging bridges what you want to say with what the audience already cares about rather than trying to change their fundamental interests.

**Tactical advice:**
- Identify the 'cultural erogenous zones' or existing passions of your target audience.
- Create an 'API' or bridge that connects your product's value to those existing passions.
- Avoid trying to force an audience to care about something entirely new; shape your story to fit their worldview.

*Timestamp: 00:00:00*

---

> "You want to make it something that a second-grader could understand. You want to minimize the cognitive burden on the recipient. So it should be something where they're not having to expend any extra energy understanding the thing, where it immediately paints a picture."

**Insight:** High-impact messaging minimizes cognitive load by using simple language and vivid imagery that is instantly understood.

**Tactical advice:**
- Boil the company mission down to one sentence a second-grader could understand.
- Cleanse messaging of all cliches and common corporate parlance.
- Use analogies and imagery to make the message 80-90% more effective.

*Timestamp: 00:07:35*

---

> "The amount of pressure is the force divided by the surface area... if you decrease the surface area and don't try to appeal to everybody with everything. And you're targeting exactly whom you're talking to and you are sharpening your message to a point... then you're able to with the same amount of effort or expense or time, you're able to make more of an impact."

**Insight:** Startups should narrow their target audience to increase the 'pressure' and impact of their limited resources.

**Tactical advice:**
- Decrease the surface area of your marketing by hyper-targeting a specific group.
- Choose a 'tiny monopoly' or corner of the internet to dominate entirely before expanding.
- Avoid watering down messages to appeal to everyone, which results in a 'milk toast' brand that loses true fans.

*Timestamp: 00:31:29*


## Madhavan Ramanujam
*Madhavan Ramanujam*

> "What you build as a product person is features. What people actually get out of it is the benefits... If you pitch features, you're not talking value. And if you're not talking value, no one is going to get it."

**Insight:** Value communication must focus on the outcomes (benefits) rather than the technical components (features).

**Tactical advice:**
- Audit marketing pages to ensure they lead with benefits (e.g., 'Ability to sell photos online' vs. a list of technical specs)
- Use benefit-led taglines that emphasize the 'unfair advantage' provided to the customer

*Timestamp: 01:12:32*

---

> "Superhuman... came up with a $30 price point per month... the way they kind of told the story was that you pay a dollar a day for actually getting four hours of productivity back in the week, and then suddenly the pricing doesn't look too off. I mean, it's like the price for a latte in a week to actually get four hours back."

**Insight:** Effective positioning reframes the price in the context of the specific value or time saved for the user.

**Tactical advice:**
- Break down monthly costs into daily units to make them comparable to common expenses (e.g., a latte)
- Directly link the price to a specific unit of value (e.g., hours of productivity)

*Timestamp: 00:13:15*


## Marc Benioff
*Marc Benioff*

> "I'm running aggressive marketing against Microsoft because they have really a terrible product, Copilot, that I have to position against and market against."

**Insight:** Effective positioning often requires identifying a clear 'villain' or inferior alternative to highlight your own product's value.

**Tactical advice:**
- Directly challenge the efficacy of the market leader's product
- Use aggressive marketing to highlight specific technical failures of competitors

*Timestamp: 20:58*


## Matthew Dicks
*Matthew Dicks*

> "We're not going to match content to content. Instead, we're going to match theme, meaning or message... That snap when someone realizes, you were telling me about apples, but really you were telling me about tubes. That snap is so powerful."

**Insight:** Effective business messaging uses 'adjacency'—connecting a relatable personal story to a product's value proposition through shared themes.

**Tactical advice:**
- Identify the core theme or message of your product (e.g., 'giving people what they need').
- Find a personal story that illustrates that same theme in a different context.
- Connect the two at the end of the story to create a 'snap' of realization for the audience.

*Timestamp: 01:03:33*


## Meltem Kuran
*Meltem Kuran*

> "If your one-liner can also work for another business, please don't let that be your one-liner. Make it so that people actually understand what you do. Because right now there's a lot of statements out there like, 'we do the complex things so you can focus on what you do best', what does that mean? And you can give that to 90% of the B2B businesses out there and it would apply to them, which means it's not good enough."

**Insight:** Effective B2B messaging must be specific and unique to the product's actual function.

**Tactical advice:**
- Avoid generic value propositions that could apply to any competitor.
- Test messaging that explains the specific problem solved versus the general benefit.

*Timestamp: 00:28:06*

---

> "I'm not a huge fan of early awareness campaigns for B2B businesses specifically... the reason I don't like awareness early on is because to do a proper awareness campaign, it takes time... B2B businesses uniquely are started because there's a very real need and there's a lot of people that are ready to convert, first tap into the bottom of the funnel, and then go out and start speaking to the masses."

**Insight:** Early-stage B2B companies should prioritize high-intent, bottom-of-funnel channels over broad brand awareness.

**Tactical advice:**
- Focus on capturing existing demand before trying to create broad awareness.
- Wait until the product interface or brand is recognizable before investing in out-of-home or mass awareness ads.

*Timestamp: 00:32:36*


## Mike Maples Jr
*Mike Maples Jr*

> "The way startups win is by being radically different. A startup wins by avoiding the comparison trap entirely... that's what we mean by forcing a choice and not a comparison."

**Insight:** Effective positioning forces the customer to make a choice between the old way and a new category, rather than comparing features.

**Tactical advice:**
- Avoid being a '10 times better apple'; aim to be the 'world's first banana'
- Target customers who value the specific 'difference' of your product over its relative 'betterness'

*Timestamp: 00:12:53*

---

> "The great startups, they create movements not so much by criticizing the incumbent, but by showing the weakness in the strength of the incumbent. And then just saying to the customer, 'Hey, look, you decide...'"

**Insight:** Position against incumbents by identifying the 'weakness in their strength'—the inherent trade-offs of their successful business model.

**Tactical advice:**
- Identify the core strength of the incumbent (e.g., consistency in hotels)
- Frame that strength as a weakness for a specific segment (e.g., consistency means you don't 'live like a local')
- Let the customer choose based on that tension

*Timestamp: 01:11:31*


## Nikita Bier
*Nikita Bier*

> "We made the icon black with a flame, called it Gas and the invites rate jumped... boys didn't want to invite their friends to an app called Crush with a pink icon."

**Insight:** Visual branding and naming significantly impact viral growth by influencing the social comfort of sending invitations.

**Tactical advice:**
- Test different names and icons to see how they impact invitation rates across different demographics
- Ensure the brand identity aligns with the social dynamics of the target audience (e.g., making it 'masculine' enough for boys to share)

*Timestamp: 01:15:52*


## Nilan Peiris
*Nilan Peiris*

> "closing this delta between what you've done, and what's perceived to be done is what I call product marketing within the product. ... we're doing instant transfers, and customers wouldn't know it was instant. So when you get an instant transfer, there's like this wizzy animation at the end, and you kind of know the money's in the other person's account, ready to spend. And again, you see this big jump in referral rate when that happens, but people need to know it's happened."

**Insight:** In-product marketing is essential to ensure users perceive the full value of the features you have built, which directly drives referral rates.

**Tactical advice:**
- Use visualizations (like comparison graphs) to prove the value or savings the product provided
- Add 'delight' animations or clear notifications to highlight when a '10x' experience (like an instant transfer) has occurred
- Close the 'perception gap' by explicitly showing the user the benefit they just received

*Timestamp: 01:07:21*


## Paul Adams
*Paul Adams*

> "The way I describe product market fit is, you've got to build the right product for the right market... And so, the story is really important, as important. And actually, sometimes you'll see not great products... they got the story wrong."

**Insight:** Product-Market Fit is incomplete without 'Story Fit'—the ability to explain the product's value simply and effectively.

**Tactical advice:**
- Focus on the 'Story' as much as the 'Product' to ensure customers understand why you are better.

*Timestamp: 01:06:21*


## Pete Kazanjy
*Pete Kazanjy*

> "ICP stands for Ideal Customer Profile. Actually, it's important to think about there's two things in a B2B sales motion, there's the characteristics of the account, which is the company that's going to buy, and then there's the characteristics of the human and the personas that you're going to be interacting with."

**Insight:** Effective sales requires a crisp definition of both the target company (ICP) and the specific stakeholders (Personas).

**Tactical advice:**
- Define the minimum company size or technical requirements for your ICP
- Map out the different personas involved: the user, the technical gatekeeper, and the budget owner
- Tailor your messaging to the specific pain points of each persona

*Timestamp: 00:37:11*


## Raaz Herzberg
*Raaz Herzberg*

> "I wanted Wiz's brand to, again, my first motive, stand out. I wanted Wiz to have a very positive, optimistic type of brand. So I went all in on, "Scrap whatever we were doing before, which was dark, and go pink, go bright blue, always go optimistic, and focused on magic, not scaring people from the facts, but magic.""

**Insight:** Effective positioning in a crowded market often requires taking a visual and emotional stance that is the polar opposite of industry norms.

**Tactical advice:**
- Use 'themed' presence at industry events to break through the noise of traditional competitors.
- Differentiate by being optimistic in an industry (like security) that typically relies on fear.

*Timestamp: 00:38:48*

---

> "I keep going back to, I don't want us to forget that we are inside our own bubble. We go to work at Wiz every day... but reminding ourselves that customers don't live in that bubble, they're people in the world. Their life is not Wiz."

**Insight:** The 'Dummy Explanation' requires stripping away internal jargon and assuming zero prior knowledge from the audience.

**Tactical advice:**
- Avoid using internal product names or industry initials (like CSPM) in top-of-funnel messaging.
- Remember that while you are sick of your headline, your customers are likely just starting to understand it.

*Timestamp: 00:48:40*


## Rahul Vohra
*Rahul Vohra*

> "I believed that we needed to occupy a clear position that was unique and which was available and which reinforced our product strategy... In our case the pitches were simple. People would say, 'Dude, you have to use it, it's really fucking fast.' And that's it. That was the pitch. That's how I knew that speed would be a really great position for us to start with."

**Insight:** Effective positioning requires finding a unique, available attribute that reinforces product strategy and passes the 'cocktail party test.'

**Tactical advice:**
- Interview customers to find common pain points that incumbents struggle with (e.g., speed).
- Use the 'cocktail party test' to see if users can pitch your product in one simple, compelling sentence.

*Timestamp: 00:44:00*


## Robby Stein
*Robby Stein*

> "AI Mode as the name is such a good example of clarity. What is this? This is AI Mode... we could call it something random, but then what is that? And now you're working against yourself."

**Insight:** Clear, descriptive naming is often superior to 'clever' or abstract branding because it reduces cognitive load for the user.

**Tactical advice:**
- Choose names that describe exactly what the feature is (e.g., 'AI Mode') to leverage existing user understanding.
- Avoid 'clever' icons or names that require the user to learn a new vocabulary.

*Timestamp: 00:56:00*


## Sean Ellis
*Sean Ellis*

> "Step one was just reposition the product on antivirus. So that kind of creates a filter. So anyone who now is coming in to sign up for the product who doesn't care about antivirus is not going to convert, and those who are excited about antivirus are going to convert. We already know from the initial survey that people value that after they convert."

**Insight:** Effective positioning acts as a filter to attract users who are most likely to find the product a 'must-have.'

**Tactical advice:**
- Reposition the product based on the specific benefit valued by your 'must-have' users.
- Align marketing expectations with the actual value delivered in the first session.

*Timestamp: 00:10:50*


## Seth Godin
*Seth Godin*

> "A brand is a promise. It's what do I expect from you. It's would I miss you if you were gone... if you want to build a brand, you got to stand for something and you got to say what you don't do."

**Insight:** A strong brand is defined by a specific promise and the discipline to exclude certain features or audiences.

**Tactical advice:**
- Define exactly what promise the product makes to the user and keep it relentlessly.
- Explicitly decide what the product will NOT do to strengthen its core identity.

*Timestamp: 16:26*

---

> "The word remarkable means worth making a remark about. So I'm not talking about coming up with some viral video that's ridiculous in its gimmickry. I'm saying if you make something where the person's life gets better if they talk about you and you know in advance what you want them to say, then they are more likely to say it."

**Insight:** Remarkability is a product feature that enables word-of-mouth by giving users a specific, valuable story to tell.

**Tactical advice:**
- Identify the specific 'remark' you want users to make about your product.
- Build features that raise the user's status or utility when they talk about the product to others.

*Timestamp: 29:57*


## Shreyas Doshi
*Shreyas Doshi*

> "John would often make... observations about, well, if we just talked about the product in this manner, that will likely resonate a lot more with customers. And that got me thinking a lot about how I need to reframe my approach to basically separate the effort involved in building something with the effort you want to put behind talking about said thing."

**Insight:** Effective positioning requires decoupling the internal complexity of development from the external narrative that resonates with users.

**Tactical advice:**
- Avoid talking about features based on how much effort they took to build; focus on what resonates with the customer's needs.

*Timestamp: 00:21:08*


## Stewart Butterfield
*Stewart Butterfield*

> "You're not just responsible for creating the product. You're responsible for, to a certain degree, creating the market. ... It's much easier to take a couple of existing ideas and put them together. So it's much easier to say it's like Jaws meets Star Wars, or it's Uber for Pets or something like that, than to come up with an actual new idea."

**Insight:** Effective positioning involves framing a new product using familiar concepts to help users understand a category that doesn't yet exist.

**Tactical advice:**
- Use 'X for Y' analogies to leverage existing mental models
- Focus on creating the market for the product, not just the product itself

*Timestamp: 01:11:15*

---

> "If you want to sell Harley-Davidson's... when you're selling the motorcycle, you're selling the open road and freedom and the wind in your hair. ... instead of trying to convince men to build a ship, instill a yearning for the sea."

**Insight:** Sell the aspirational outcome and the 'yearning' for the experience rather than the technical specifications of the tool.

**Tactical advice:**
- Identify the 'open road' or aspirational outcome your product enables
- Message the transformation of the user rather than the features of the product

*Timestamp: 01:12:30*


## Todd Jackson
*Todd Jackson*

> "When we changed our positioning to play in an existing category of CLM, but a much better CLM, but customers are already looking for a CLM, they're already looking to spend money on a CLM, and just expand the definition of what that category is, things just started to click."

**Insight:** Positioning a product within an existing category where budget already exists is often more effective than trying to create a new category.

**Tactical advice:**
- Identify the 'Promise' (the third P) that resonates with the buyer's existing mental model of a category.
- Use the 'Four Ps' to align the promise with the specific problem the persona is facing.

*Timestamp: 00:48:10*


## Uri Levine
*Uri Levine*

> "If you start your story with, 'The problem we are solving is,' Then you focus on the problem. If your story start with, 'The value that we create for you is,' then you focus on the user. The last two are way better than focus on the solution."

**Insight:** Effective messaging prioritizes the problem or the user's value over the technical details of the solution.

**Tactical advice:**
- Avoid starting pitches or descriptions with 'Our company is' or 'Our AI system is.'
- Start with the problem being solved or the value created for the user.

*Timestamp: 00:05:47*


## Zoelle Egner
*Zoelle Egner*

> "Invest in having a decent photo or a decent illustration. If you have sample content, this is actually a big one, sample content for your productivity app as an example. Take the time to not have it be like Jane Doe 12 times in the name list. Have it be references to your industry so that people are like, 'Oh, hey. That's a joke about Steve Jobs. I'm a designer. This person is thinking about me.'"

**Insight:** High-quality, industry-specific sample content builds brand trust by signaling that the product was built with a specific customer in mind.

**Tactical advice:**
- Avoid generic placeholders like 'Jane Doe' in sample data
- Use industry-specific references or 'Easter eggs' to build rapport with target personas
- Invest in polished visual assets (photos/illustrations) to signal legitimacy

*Timestamp: 00:29:29*

---

> "Airtable, back in the day, got roasted on Twitter for having billboards that were not super specific about a specific problem... They were actually super effective for us because we had a different goal... signaling to some very large companies that we were a legitimate and large enough company that they could trust."

**Insight:** Billboards can serve as a powerful credibility signal for enterprise buyers, even if they don't drive direct lead generation.

**Tactical advice:**
- Use billboards in specific geographic concentrations where target enterprise offices are located
- Buy 'remnant inventory' at the end of cycles to get billboards at a lower cost
- Focus on brand legitimacy rather than specific feature messaging for high-contract enterprise targets

*Timestamp: 00:33:31*

---

> "If you could hold up either an existing or a brand new job and say, 'This is really important for much broader business metrics, whatever else. We're going to create community for those people to come together and it's all about the job,' and not about you. That can be very powerful and they'll take them with you."

**Insight:** Elevating a profession or job identity is more effective than trying to create a new software category.

**Tactical advice:**
- Focus on making the customer the hero of their own career progression
- Build community around a job function rather than the product itself
- Align the product with the professional identity of the user

*Timestamp: 00:55:47*


## Jeanne Grosser
*Jeanne Grosser*

> "80% of customers buy to avoid pain or reduce risk as opposed to increased upside, which is a good thing for startup founders to understand. We all love to talk about the art of the possible, everything we're going to enable in the future, but that's often really a sale that's going to resonate with another founder. For everybody else, particularly enterprises. You're avoiding the risk of not making your revenue target next quarter."

**Insight:** Enterprise buyers are primarily motivated by risk mitigation and pain avoidance rather than visionary upside.

**Tactical advice:**
- Pivot messaging from 'art of the possible' to risk reduction when selling to enterprises.

*Timestamp: 00:00:27*

---

> "The experience that you have of being sold to will increasingly actually differentiate a company and drive buying decisions if products are only different at the margin. And so then you really want to create a customer buying journey that feels like very unique experiences."

**Insight:** When technical differentiation is narrow, the sales experience itself becomes the primary differentiator.

**Tactical advice:**
- Design the customer buying journey as a unique, high-value experience rather than a transaction.

*Timestamp: 00:00:55*


## Josh Miller
*Josh Miller*

> "give something a new name, it sheds a lot of preconceived notions of what the thing should be... if you say you're building a browser history feature... everyone knows what you're talking about. And the downside is, everyone knows what you're talking about. And you show up with these preconceived notions of what it has to be."

**Insight:** Use non-standard or 'made-up' names for features and teams to force first-principles thinking and avoid falling into industry tropes.

**Tactical advice:**
- Avoid standard industry terms (like 'History' or 'Marketing') during the creative phase
- Use metaphors to redefine the scope of a project

*Timestamp: 01:05:01*


## Matt Dixon
*Matt Dixon*

> "Most salespeople are trying to figure out what's keeping the customer up at night... The challenger approach is about showing the customer what should be keeping them up at night. What's a risk that they don't know about but you do"

**Insight:** Effective positioning involves reframing the customer's world by identifying risks or opportunities they haven't yet recognized.

**Tactical advice:**
- Move beyond 'needs discovery' to 'insight delivery'.
- Teach the customer about a business problem they didn't know they had, which only your product can solve.

*Timestamp: 48:15*

---

> "They came in and they revised their sales pitch... leading to it. They're starting with an insight and giving the customer a reason to care about solving this business problem, and it turns out the only way to solve it is buying this XP-9000 drill"

**Insight:** Successful messaging leads *to* your unique solution by first establishing a high-stakes business problem (like employee absenteeism) that the solution uniquely addresses.

**Tactical advice:**
- Identify the 'ripple effects' of a problem (e.g., how equipment leads to injury, which leads to absenteeism, which leads to lost revenue).
- Ensure the connection between the insight and your unique product benefit is 'tight' and exclusive.

*Timestamp: 53:33*


## Krithika Shankarraman
*Krithika Shankarraman*

> "The work of marketing ended up becoming creating this use case epiphany."

**Insight:** Marketing's core job is creating use case epiphanies, not just awareness.

**Tactical advice:**
- Focus on specific use cases
- Capture customer language

*Timestamp: 00:00:18*


