---
name: post-mortems-retrospectives
description: Help users run effective post-mortems and retrospectives. Use when someone is reviewing a project that succeeded or failed, wants to establish learning practices, is dealing with failure aftermath, or needs to improve team learning loops.
---

# Post-mortems & Retrospectives

Help the user run effective post-mortems and retrospectives that drive genuine learning using frameworks from 11 product leaders.

## How to Help

When the user asks for help with post-mortems or retrospectives:

1. **Understand the context** - Ask whether this is after a failure, a success, or a routine checkpoint
2. **Set the right tone** - Help them frame the exercise as learning-focused rather than blame-focused
3. **Structure for insights** - Guide them toward formats that surface actionable learnings
4. **Ensure follow-through** - Help them create mechanisms to act on what they learn

## Core Principles

### Pre-mortems need kill criteria
Annie Duke: "A pre-mortem is only effective if it results in 'kill criteria' - pre-determined signals that will trigger a pivot or shutdown." Identify early signals that a project is failing during the pre-mortem and pre-commit to specific actions if those signals are met.

### Reframe failure as growth
Carole Robin: "The acronym is A-F-O-G, another F-ing... Another Fucking Opportunity for Growth. My question, when something has gone wrong or a person has experienced a failure, my first question is always, so what did you learn?" When a failure occurs, immediately ask "What is the lesson here?" to maintain perspective during painful setbacks.

### Call them retrospectives, not post-mortems
Eeke de Milliano: "Instead of calling something a postmortem, call it a retrospective, so that it's a positive thing. Like, 'Hey, we're learning from this thing.'" Reframing helps normalize failure and focuses the team on learning rather than blame.

### Institutionalize learning reviews
Ben Williams: "We have these team level impact and learnings reviews... The teams continuously document any learnings from data exploration, from experimentation, from user research." Hold weekly "Impact and Learnings" reviews focused on insights rather than status updates, and socialize learnings across the entire company.

### Grade OKRs for learning, not performance
Christina Wodtke: "What matters is, why 80%? Really focus on the learning... Make sure your grading is secondary to retrospective." The value of grading OKRs lies in the retrospective analysis of why a goal was or wasn't hit, not the number itself. Use end-of-quarter retrospectives to identify systemic blockers.

### Make it blameless
The goal is to understand what happened and why, not to assign blame. Create psychological safety so people can share honestly without fear of punishment.

## Questions to Help Users

- "What did we learn that we didn't know before starting this project?"
- "If we had to do this again with the same information we had at the start, what would we do differently?"
- "What signals did we see early that we ignored or missed?"
- "What systemic issues contributed to this outcome that we should address?"
- "What kill criteria should we set for similar projects in the future?"
- "How will we ensure these learnings actually influence future decisions?"

## Common Mistakes to Flag

- **Blame-focused framing** - Turning the exercise into finding fault rather than understanding systems
- **No follow-through** - Running retrospectives but never acting on the learnings
- **Only reviewing failures** - Missing the opportunity to learn from successes and understand what drove them
- **Optimizing the score, not the learning** - Focusing on what percentage of OKRs were achieved rather than why
- **One-time events** - Running retrospectives only for big failures instead of making them a regular practice

## Deep Dive

For all 13 insights from 11 guests, see `references/guest-insights.md`

## Related Skills

- running-effective-meetings
- running-decision-processes
- planning-under-uncertainty
