# Post-mortems & Retrospectives - All Guest Insights

*11 guests, 13 mentions*

---

## Annie Duke
*Annie Duke*

> "So a pre-mortem, it's great only if you set up kill criteria. Commit to actions that you're going to take if you see those signals."

**Insight:** A pre-mortem is only effective if it results in 'kill criteria'—pre-determined signals that will trigger a pivot or shutdown.

**Tactical advice:**
- Identify early signals that a project is failing during the pre-mortem.
- Pre-commit to specific actions (like killing the project) if those signals are met.

*Timestamp: 00:00:28*

---

> "What a pre-mortem allows you to do is to set up kill criteria. So kill criteria are just a set of signals that you might see that would tell you that it's time to pivot or stop because once we actually launch something, we're very, very slow to decide to quit."

**Insight:** Pre-mortems counteract the 'sunk cost' bias by establishing objective exit points before emotional attachment to a project grows.

**Tactical advice:**
- Ask the team: 'Imagine it is six months from now and the project has failed. What were the early signals?'
- Create a list of 'kill criteria' based on these signals (e.g., inability to get a decision-maker in the room).

*Timestamp: 01:06:18*


## Ben Williams
*Ben Williams*

> "We have these team level impact and learnings reviews... The teams continuously document any learnings from data exploration, from experimentation, from user research and so on. They document that in their weekly impact and learnings document... Most of it is spent discussing learnings that have been documented, their implications, how they can be leveraged in follow up work."

**Insight:** Institutionalizing a 'learnings review' ceremony ensures that experiment data is actually leveraged for future decisions.

**Tactical advice:**
- Hold weekly 'Impact and Learnings' reviews focused on insights rather than status updates
- Socialize learnings across the entire company to uplevel other teams

*Timestamp: 01:07:00*


## Carole Robin
*Carole Robin*

> "The acronym is A-F-O-G, another F-ing... Another Fucking Opportunity for Growth. Every student who ever took a class from me... knows that acronym because my question, when something has gone wrong or a person has experienced a failure, my first question is always, so what did you learn?"

**Insight:** Reframing failure as a learning opportunity is essential for long-term growth and resilience.

**Tactical advice:**
- When a failure occurs, immediately ask: 'What is the lesson here?'
- Use the AFOG acronym to maintain perspective during painful setbacks.

*Timestamp: 01:17:02*


## Christina Wodtke
*Christina Wodtke*

> "What matters is, why 80%? Really focus on the learning... It's all about the retrospectives. Make sure your grading is secondary to retrospective, is the biggest thing I would say, because that's what's going to be valuable."

**Insight:** The value of grading OKRs lies in the retrospective analysis of why a goal was or wasn't hit, not the number itself.

**Tactical advice:**
- Prioritize the 'why' behind the grade over the precision of the numerical score.
- Use the end-of-quarter retrospective to identify systemic blockers that prevented hitting 100%.

*Timestamp: 00:53:20*


## Eeke de Milliano
*Eeke de Milliano*

> "Instead of calling something a postmortem, call it a retrospective, so that it's a positive thing. Like, 'Hey, we're learning from this thing.'"

**Insight:** Reframing post-mortems as retrospectives helps normalize failure and focuses the team on learning rather than blame.

**Tactical advice:**
- Rename 'post-mortems' to 'retrospectives'
- Shine a light on failure to mitigate the fear of taking big swings

*Timestamp: 00:22:14*

---

> "Have people talk about the failure in these sort of public forums, where usually you talk about the successes. So have someone actually write a note that's like, 'Hey, here are all my learnings from this thing that we did.' And send it to the org."

**Insight:** Publicly celebrating the learnings from a failure reinforces a culture of innovation and psychological safety.

**Tactical advice:**
- Encourage teams to send 'learning notes' about failed projects to the entire company
- Have teams present failures and lessons learned at all-hands meetings

*Timestamp: 00:28:18*


## Janna Bastow
*Janna Bastow*

> "Retrospectives make such a big difference because they are indicative of psychological safety, which underpins so much, right? Once you start building in this psychological safety, the ability to ask questions and to start saying, 'What are we doing that's working? What are we doing that's not working? Okay, determine that something doesn't work. Are we allowed to go change it?'"

**Insight:** Retrospectives are a primary tool for fostering psychological safety and continuous improvement within a team.

**Tactical advice:**
- Use retrospectives to identify what is and isn't working and empower the team to change their situation

*Timestamp: 35:24*


## Maggie Crowley
*Maggie Crowley*

> "I remember... we decided we needed to do a rewrite, red flag number one... It didn't take six months, it took two and a half years... We skipped discovery. We didn't really write a one-pager, we just went for it."

**Insight:** Failed projects often stem from skipping discovery and underestimating the complexity of technical rewrites.

**Tactical advice:**
- Avoid 'side-by-side' rewrites of core products
- Never skip discovery or requirements gathering for large technical projects
- Be honest about 'sunk cost fallacy' when projects go off the rails

*Timestamp: 00:56:47*


## Melissa Perri
*Melissa*

> "I think the biggest message I can tell to anybody learning, is really, sit down, do a retrospective with yourself, and say, is this helping me get better at being a product manager? And if it's not, change it."

**Insight:** Personal growth in product management requires applying the retrospective framework to one's own career and learning habits.

**Tactical advice:**
- Regularly audit your own 'toolbox' of frameworks and discard those that no longer serve your specific context.

*Timestamp: 51:55*


## Mike Krieger
*Mike Krieger*

> "The confluence of those three things [mobile web deterioration, lack of viral spread, remote work]... we entered I guess 2024 and said, 'Look, there is a company to be built in the space. I'm not sure where the people would've built it. This concurrent incarnation we love, but it's not growing.'"

**Insight:** Shutting down a product requires recognizing when the 'energy' isn't in the system and having the intellectual honesty to call it early.

**Tactical advice:**
- Evaluate if the ratio of input (effort) to output (growth) is fundamentally broken.
- Consider external factors like platform deterioration (e.g., mobile web) and internal factors like team distribution when assessing failure.

*Timestamp: 00:38:39*


## Ronny Kohavi
*Ronny Kohavi*

> "To me, a surprising experiment is one where the estimated result beforehand and the actual result differ by a lot. ... So we focused not just on the winners, but also surprising losers, things that people thought would be a no-brainer to run. And then for some reason, it was very negative. And sometimes, it's that negative that gives you insight."

**Insight:** Focus retrospectives on 'surprising' results—where the delta between prediction and reality is largest—to maximize organizational learning.

**Tactical advice:**
- Hold quarterly meetings specifically to review the most surprising experiment results
- Analyze 'surprising losers' to uncover hidden factors like battery life impact or user friction

*Timestamp: 00:17:53*


## Shreyas Doshi
*Shreyas Doshi*

> "The idea is simple, which is when you are working on an important project or initiative, you get together with your team early on in the products or the projects' life to see in advance what could go wrong. And the way I describe a pre-mortem is that if you do a pre-mortem right, you will not have to do an ugly post-mortem."

**Insight:** Pre-mortems use a hypothetical failure state to create psychological safety, allowing team members to voice concerns they would otherwise withhold.

**Tactical advice:**
- Start with the prompt: 'Imagine this project has failed six months from now. What went wrong?'
- Categorize risks into 'Tigers' (lethal threats), 'Paper Tigers' (perceived threats), and 'Elephants' (unspoken issues).
- Include cross-functional members from engineering, sales, support, and marketing.

*Timestamp: 00:24:38*


