---
name: pricing-strategy
description: Help users design and optimize pricing strategies. Use when someone is setting prices for the first time, considering freemium vs paid models, optimizing monetization, dealing with willingness to pay questions, or transitioning between pricing models.
---

# Pricing Strategy

Help the user design and optimize pricing strategies using frameworks from 46 product leaders.

## How to Help

When the user asks for help with pricing:

1. **Understand the business model** - Ask about their current monetization approach and target customer segments
2. **Assess value delivery** - Determine what value they're creating and for whom
3. **Identify constraints** - Understand technical, market, and competitive pricing pressures
4. **Design for iteration** - Help them create pricing that can evolve as they learn

## Core Principles

### Price is a measure of value
Madhavan Ramanujam: "When we think about price, we think about it as a measure. Like liter is a measure of volume, price is a measure of value. And when you think of it this way, it really stands for, do people actually want your product?" Use willingness to pay (WTP) as a proxy for product value and conduct WTP conversations early in the development cycle.

### Never set it and forget it
Naomi Ionita: "Do not set it and forget it. I see companies do this, where they labor over designs and features... And then pricing's sort of plucked out of thin air, and then they don't revisit it." Treat pricing as a living part of the product roadmap, revisiting it every 6-12 months as new value is added.

### Self-serve has a ceiling
Elena Verna: "Self-serve monetization has a cap of about $10,000. That's just how much we're able to process on the credit cards before they start getting flagged and declined." Transition to sales-led motions for contracts exceeding $10,000-$15,000 due to technical payment limits and individual spending authority.

### Sample premium features in the free experience
Albert Cheng: "What if we actually sampled a number of different paid suggestions and interspersed them to free users across their writing? All of a sudden, people were seeing Grammarly as a much more powerful tool." Interspersing paid features within the free experience is more effective for conversion than keeping them hidden behind a hard paywall.

### Reduce early friction to unlock success
Archie Abrams: "When you can lower the barriers to monetary friction in some form... you can actually causally change your ability to become successful, because I've given you a little bit more time to try that idea." Reducing early monetary friction can causally improve user success by extending their "runway" to find value in the product.

### Prioritize roadmap by willingness to pay
Madhavan Ramanujam: "You cannot prioritize a product roadmap without having a willingness to pay conversation. If you're just prioritizing based on what you think or what you feel or technical resources, you're getting it wrong." Prioritize the 20% of features that drive 80% of the willingness to pay.

### Pricing changes are two-way doors
Eeke de Milliano: "Move faster on reversible decisions like pricing by grandfathering existing users." Most pricing changes can be reversed or adjusted, especially when you protect existing customers through grandfathering.

## Questions to Help Users

- "What would customers pay for this if they had to pay today? Have you asked them directly?"
- "What value does your product create, and for which customer segment is that value highest?"
- "When did you last revisit your pricing? What has changed about your product since then?"
- "What's preventing you from charging more? Is it competition, value delivery, or assumption?"
- "How do free users experience the value of paid features today?"
- "At what price point does your sales motion need to change from self-serve to sales-assisted?"

## Common Mistakes to Flag

- **Pricing as afterthought** - Setting prices based on gut feel rather than willingness to pay research
- **Never iterating** - Launching with a price and never revisiting it as the product evolves
- **Hard paywalls on premium** - Hiding all premium value instead of sampling it in the free experience
- **Ignoring the self-serve ceiling** - Trying to close $50K deals through credit card checkout
- **Racing to the bottom** - Competing on price rather than differentiating on value

## Deep Dive

For all 76 insights from 46 guests, see `references/guest-insights.md`

## Related Skills

- retention-engagement
- product-led-sales
- positioning-messaging
