---
name: prioritizing-roadmap
description: Help users prioritize product roadmaps and backlogs. Use when someone is deciding what to build next, sequencing features, allocating resources across projects, handling stakeholder requests, or struggling with too many competing priorities.
---

# Prioritizing Roadmap

Help the user prioritize product roadmaps and backlogs using frameworks from 75 product leaders.

## How to Help

When the user asks for help with prioritization:

1. **Understand the decision context** - Ask about their goals, constraints, and stakeholder landscape
2. **Assess the portfolio** - Determine if they need to balance incremental vs big bets, or core vs new
3. **Provide frameworks** - Recommend appropriate prioritization approaches for their situation
4. **Challenge assumptions** - Help them question whether their current priorities are truly the most impactful

## Core Principles

### Separate truth from hypothesis
Alex Hardimen: "The idea of being able to take all of these crazy inputs, trying to create a very structured model to figure out, 'Okay, what is true? Where do we have conviction? Where do we have questions?'" Categorize inputs by conviction level vs. questions and rally the team around a shared context.

### Use "seasons" in fast-changing markets
Asha Sharma: "We think about it as what season are we in? Season one might've been prototyping of AI and then it was all around models and reasoning models, and now it's the advent of agents." In rapidly changing environments, align the team on secular market shifts rather than rigid long-term roadmaps.

### Build a common currency for comparison
Dan Hockenmaier: "The most difficult thing about making that kind of effort is developing a common currency by which you can trade off their efforts... The growth model is the function that lets you do that." Use growth models to make projected impacts comparable across different teams during planning.

### Force big thinking in planning
Eeke de Milliano: "At the bottom of every team charter we have a section called, Think Bigger. 'With 20% more time, what would you do that isn't on this list already?'" Explicitly ask for big ideas in planning documents to prevent teams from only focusing on incremental improvements.

### Balance cannonballs and lead bullets
Adriel Frederick: "I'm going to have some cannonballs... and I'm going to have a bunch of lead bullets. Maybe it's 80% of your energies on those big cannonballs, 20% on the lead bullets." A healthy roadmap balances high-investment "cannonballs" with incremental "lead bullets" to avoid purely incremental thinking.

### Roadmaps should be reality checks
Jackie Bavaro: "A roadmap in strategy is not a commitment. Instead, it's a way to double check if your plan makes any sense at all and is even anywhere near feasible." Use roadmaps to identify if you need to hire more people or take bigger swings, not as promises.

### Prioritization is the highest-leverage PM skill
Ian McAllister: "Given the same amount of skill intelligence and resources, a product manager with a great innate ability to prioritize is going to generate 5X the impact of someone without that skill." Prioritize themes, sequence projects within those themes, and apply prioritization to personal time management.

### Kill low-usage features
Gibson Biddle: "These two percenters, I would kill them. If I launched something and it was only 2%... just get rid of it." Maintain product simplicity by removing features used by only a tiny fraction of users that add unnecessary complexity.

## Questions to Help Users

- "If you could only ship one thing this quarter, what would it be and why?"
- "What's on your roadmap that you secretly believe won't move the needle?"
- "Which items are you most confident about? Which are you least confident about?"
- "What would you do differently if you had 20% more resources? What if you had 20% fewer?"
- "What's the common currency you use to compare impact across different types of work?"
- "When did you last remove something from the product rather than add to it?"

## Common Mistakes to Flag

- **Prioritizing by loudest voice** - Letting stakeholder pressure override evidence-based prioritization
- **All incremental, no big bets** - Filling the roadmap with safe optimizations instead of transformative features
- **Feature lists without narrative** - Treating roadmaps as spreadsheets rather than strategic stories
- **Never saying no** - Continuously adding without removing, leading to product bloat
- **ROI-only thinking** - Optimizing for quick wins at the expense of high-uncertainty, high-upside bets

## Deep Dive

For all 91 insights from 75 guests, see `references/guest-insights.md`

## Related Skills

- planning-under-uncertainty
- scoping-cutting
- running-decision-processes
- problem-definition
