# Prioritizing Roadmap - All Guest Insights

*75 guests, 91 mentions*

---

## Adam Fishman
*Adam Fishman*

> "Prioritization and road mapping. So you have to be able to sequence the work much like in building a product, right? Building your growth strategy, you have to sequence it. That sequence has to make sense based on your growth models."

**Insight:** Growth roadmaps must be sequenced based on the underlying growth model and available resources rather than just a list of features.

**Tactical advice:**
- Sequence growth experiments based on the potential impact on the growth model
- Build a series of hypotheses to test against solutions to ensure continuous learning

*Timestamp: 00:22:18*


## Alex Hardimen
*Alex Hardimen*

> "The idea of being able to take all of these crazy inputs, trying to create a very structured model to figure out, 'Okay, what is true? Where do we have conviction? Where do we have questions? What are the most important problems to solve? How do you prioritize? How do you get a team rallied around a shared context in one single goal?'"

**Insight:** Prioritization requires creating a structured model to separate known truths from hypotheses and rallying the team around a single goal.

**Tactical advice:**
- Categorize inputs by conviction level vs. questions
- Create a structured model to identify the most important problems
- Rally the team around a shared context

*Timestamp: 00:11:21*

---

> "It is a real wartime moment where you just need to blow up roadmaps, share context with everyone and say, 'Okay, everyone, we have a totally different mandate than what we did a couple weeks ago.'"

**Insight:** In times of crisis, leaders must be willing to completely discard existing roadmaps to address immediate, high-stakes mandates.

**Tactical advice:**
- Be prepared to 'blow up' roadmaps during crisis
- Communicate a clear new mandate to the entire team immediately

*Timestamp: 00:43:32*


## Adriel Frederick
*Adriel Frederick*

> "I'm going to have some cannonballs. I'm going to work on a couple cannonballs and I'm going to have a bunch of lead bullets. And maybe it's 80% of your energies on those big cannonballs, 20% on the lead bullets, and having a constraint like that forces you to choose the fewer experiments that are actually probably the really good ones."

**Insight:** A healthy product roadmap balances high-investment 'cannonballs' with incremental 'lead bullets' to avoid the trap of purely incremental thinking.

**Tactical advice:**
- Allocate a specific percentage of resources (e.g., 80/20) between major bets and small optimizations.
- Adjust the portfolio based on product maturity: early-stage products should focus almost entirely on 'cannonballs'.

*Timestamp: 00:56:30*


## Alex Komoroske
*Alex Komoroske*

> "My approach at Google was 70% of my effort and my team's effort should go on things that everybody acknowledges are important and useful and create value. Maybe it's boring, linear value, but some kind of value... once you do this, you have 30% of your extra time that you can plant all these seeds."

**Insight:** Maintain organizational credibility by dedicating the majority of resources to 'legible' value while reserving a significant portion for experimental, high-upside 'seeds.'

**Tactical advice:**
- Allocate 70% of team effort to projects that are unambiguously recognized as important by the broader organization.
- Use the remaining 30% to allow team members to pursue 'emergent' ideas that they are intrinsically motivated by.

*Timestamp: 00:36:32*


## Andy Raskin
*Andy Raskin_*

> "We are constantly getting feature requests through sales, through customer success. And we had sort of no way, bar to decide well what do we take on, what don't we take on? And this clearly has become our bar."

**Insight:** A clear strategic narrative acts as a filter for prioritizing feature requests.

**Tactical advice:**
- Use the narrative's 'new game' rules as a bar for deciding which features to build.
- Reject features that support the 'old game' or 'old way' of working.

*Timestamp: 00:37:21*


## Amjad Masad
*Amjad Masad*

> "Being agile, not being stuck with roadmaps, being able to just say, oh, we're just going to switch priorities right away, is going to be super important... there's going to be capabilities that are going to drop. And you want to really, in some cases, if it really affects your business, you want to be able to jump on it really, really quickly."

**Insight:** In the AI era, rigid roadmaps are a liability; teams must be able to pivot instantly when new model capabilities are released.

**Tactical advice:**
- Maintain a flexible roadmap that can be 'slaughtered' or deprioritized when major AI breakthroughs occur.
- Build a culture that is comfortable with rapid priority shifts based on external technology drops.

*Timestamp: 00:57:59*


## Anuj Rathi
*Anuj Rathi*

> "We call them... First BB is Brilliant Basics... The second one is Bread and Butter... Then, there are Big Bets... Breaking Bad essentially is a different world altogether. That's where you want to redefine your company... it gets down to product managers eventually prioritizing between these four. So I don't think it's a tactical prioritization product manager call. It really is a product strategy call."

**Insight:** The '4 BB' framework (Brilliant Basics, Bread and Butter, Big Bets, Breaking Bad) elevates prioritization from tactical backlog grooming to a strategic conversation with leadership.

**Tactical advice:**
- Categorize all work into one of the four BB buckets to visualize resource allocation.
- Present three alternative allocation strategies to leadership to show the trade-offs between stability (Basics) and innovation (Breaking Bad).
- Use the framework to explain to stakeholders why certain bugs or features are being deprioritized in favor of existential 'Big Bets'.

*Timestamp: 00:43:46*


## Annie Pearl
*Annie Pearl*

> "I like this framework that's taken from a book called Playing to Win and it talks about how strategy is really just an integrated set of choices that outline how you're going to win in whatever marketplace you choose... it forces you to create clarity around where you're going to play and where you're not going to play. And so, this really helps the product team hone in on delivering value for a very clear set of people versus trying to build something for everyone."

**Insight:** Prioritization is driven by a strategy that explicitly defines which markets and personas the company will NOT pursue.

**Tactical advice:**
- Use the 'Playing to Win' framework to define the playing field.
- Explicitly decide which features or integrations (e.g., Venmo for Calendly) do not fit the core ICP to avoid dilution.
- Allocate resources across horizons (e.g., 70/30 split between Horizon 1 and 2) to balance short-term and long-term goals.

*Timestamp: 00:32:12*


## Anton Osika
*Anton Osika*

> "Just top line? I think identifying what is the biggest bottleneck, what's the biggest problem and iterating fast on saying, 'Okay, this is the biggest problem, let's really, really solve that problem.' And then picking in the next one and not overthinking, not dreaming out the long roadmap."

**Insight:** Focus on solving the single most critical bottleneck rather than building out extensive long-term roadmaps.

**Tactical advice:**
- Identify and solve the immediate biggest bottleneck
- Avoid over-planning long-term roadmaps in fast-changing environments

*Timestamp: 00:48:21*


## Asha Sharma
*Asha Sharma*

> "We think about it as what season are we in? Season one might've been prototyping of AI and then it was all around models and reasoning models, and now it's the advent of agents... grounding everybody on the ethos of what are the secular changes? What are the customer problems we need to solve? What does winning look like?"

**Insight:** In rapidly changing environments, use 'seasons' to align the team on secular market shifts rather than rigid long-term roadmaps.

**Tactical advice:**
- Define the current 'season' based on industry trends (e.g., 'The Rise of Agents')
- Align the team on the ethos and customer problems specific to that season

*Timestamp: 31:10*

---

> "I think the other thing is just we try to leave Slack in the system, not just for the unplanned, but for the slope. I think that we have to continuously be thinking about how we're going to disrupt the platform in our thinking and what we need to be investing in to make that possible."

**Insight:** Effective roadmapping requires intentional 'slack' to adapt to technological breakthroughs and self-disruption.

**Tactical advice:**
- Reserve capacity for unplanned shifts in the technology landscape
- Allocate time for teams to experiment with disrupting their own existing platform

*Timestamp: 32:47*


## Bob Moesta
*Bob Moesta*

> "So instead of just talking about features, it's typically talking about features for the first 90 to 120 days, but after that we just talk about struggling moments because that's the seed for real innovation and basically where new products come from."

**Insight:** Long-term roadmaps should be defined by the problems (struggling moments) to be solved rather than specific features, allowing for flexibility as technology changes.

**Tactical advice:**
- Limit feature-specific roadmapping to the next 3-4 months.
- Define the long-term roadmap based on the 'struggling moments' the team intends to address.

*Timestamp: 00:09:06*


## Bill Carr
*Bill Carr*

> "They then are running their own roadmap. They're deciding what are the most important things for us to go work on, and having a prioritized list of those things and be able to start at the top of the list and work their way down with the pool of resources that they have."

**Insight:** Roadmap prioritization should be owned by autonomous teams who focus on metrics they can directly control.

**Tactical advice:**
- Allow teams to own their own prioritized list of work
- Focus the roadmap on driving specific input metrics like latency or click-through rates

*Timestamp: 00:15:21*


## Brandon Chu
*Brandon Chu*

> "We went down from trying to ship maybe the 40 things that quarter to three and nothing else mattered. And that became the rhythm of the company for almost that entire year."

**Insight:** In times of crisis or 'war time,' roadmaps must be radically simplified to focus only on mission-critical survival features.

**Tactical advice:**
- Be willing to throw away existing roadmaps when the external environment changes
- Reduce focus to a handful of items where 'nothing else matters'

*Timestamp: 18:24*


## Brian Tolkin
*Brian Tolkin*

> "How do you be really focused on where to invest your time, effort, and energy technically, which is why most of the engineering effort for Uber was on the dispatching system and the pricing system. That's just where the leverage was at the time, given the scarcity of resources."

**Insight:** Identify where technology provides the most leverage for the business and concentrate scarce engineering resources there, even if other areas remain manual.

**Tactical advice:**
- Focus technical investment on core systems that drive the most business value (e.g., pricing or dispatching)
- Be explicit and transparent about which areas will not receive technical investment

*Timestamp: 00:18:15*


## Brian Chesky
*Brian Chesky*

> "We have a rolling two year product plan. Strategy. Product strategy roadmap that gets updated every six months with releases. We release products every May and every November or October."

**Insight:** Use a long-term, rolling roadmap updated frequently to maintain company-wide alignment and focus.

**Tactical advice:**
- Maintain a rolling two-year roadmap
- Update the roadmap every six months with major releases

*Timestamp: 00:13:23*

---

> "I now try to say no to what I call fake work, which is things that feel like work, but they don't actually move the ball down the field. And I really try to say yes to the work that's very meaningful."

**Insight:** Ruthlessly prioritize work that directly advances strategic goals over 'fake work' that feels productive but lacks impact.

**Tactical advice:**
- Identify and eliminate 'fake work' that doesn't move the ball down the field
- Prioritize meaningful work over reactive tasks

*Timestamp: 00:57:05*


## Chandra Janakiraman
*Chandra Janakiraman*

> "What you then do is you... down select from those 10 to 15 opportunity areas into ideally three... ranking them on, I would say four or five key dimensions or criteria."

**Insight:** Strategic prioritization requires evaluating opportunities based on impact, certainty, and the team's unique ability to solve them.

**Tactical advice:**
- Rank opportunities by expected impact and certainty of impact
- Evaluate 'clarity of levers' to ensure you actually know how to solve the problem
- Assess if the solution levers are unique and differentiated to your specific team or company

*Timestamp: 00:35:46*


## Christine Itwaru
*Christine Itwaru*

> "In less mature product orgs who first bring in product ops, the first thing they ask them to do is streamline the planning process... How do I actually just get the people to plan the same way and give me the thing that they're planning and doing?"

**Insight:** Standardizing the planning and prioritization process is often the first high-impact task for a new product operations function.

**Tactical advice:**
- Create a consistent planning template for all product teams to follow
- Focus on streamlining how teams communicate what they are building and why

*Timestamp: 00:30:56*


## Dan Hockenmaier
*Dan Hockenmaier*

> "The most difficult thing about making that kind of effort is developing a common currency by which you can trade off their efforts. So this team is saying they can move this metric by X and this team is moving this metric by Y. I have no way to make those two things comparable. The growth model is the function that lets you do that."

**Insight:** A growth model provides a 'common currency' to compare the impact of disparate projects across different teams during planning.

**Tactical advice:**
- Run different team scenarios through a central growth model to make their projected impacts comparable
- Use growth models during annual planning to decide pod allocation from first principles

*Timestamp: 00:17:56*

---

> "TAM or the size of the market actually matters very little because these are all big enough that they would dramatically inflect the curve of the business if you make them work. It's much more relevant to focus on a couple things. One is how adjacent is that to the business as a proxy for can we actually go get it?"

**Insight:** When expanding, prioritize market adjacency and the ability to execute over the theoretical size of the Total Addressable Market (TAM).

**Tactical advice:**
- Evaluate new market opportunities based on how closely they mirror your current operational model
- Prioritize expansions that accentuate existing network effects (e.g., shared supply or demand)

*Timestamp: 00:42:48*


## Dharmesh Shah
*Dharmesh Shah*

> "Start with the potential outcome, then look at probability not the other way around because then you're going to apply that mental filter and throw out ideas that may not have been worth throwing out."

**Insight:** Prioritize by looking at the magnitude of success before the likelihood of success to avoid killing high-impact 'moonshots' too early.

**Tactical advice:**
- Use the 4P framework: Potential (how big?), Probability (can we do it?), Passion (do we care?), and Prowess (why us?).
- Calculate 'expected value' by multiplying potential by probability.

*Timestamp: 01:11:37*


## Eeke de Milliano
*Eeke de Milliano*

> "At the bottom of every team charter we have a section called, Think Bigger. 'With 20% more time, what would you do that isn't on this list already?'"

**Insight:** Explicitly asking for 'big ideas' in planning documents prevents teams from only focusing on incremental improvements.

**Tactical advice:**
- Add a 'Think Bigger' section to every team charter or planning doc
- Ask teams: 'If you doubled the team today, what would you do?'

*Timestamp: 00:25:09*

---

> "70/20/10 investments model... 70% of your building time should really be going to your core product, that has product market fit. 20% of your time should be going to strategic initiatives that aren't core... And then, 10% of your time should be going towards bets."

**Insight:** Use a portfolio approach to resource allocation to balance core maintenance, strategic growth, and high-risk bets.

**Tactical advice:**
- Allocate 70% of resources to core product and maintenance
- Allocate 20% to non-core strategic initiatives
- Allocate 10% to experimental bets

*Timestamp: 00:48:37*


## Gaurav Misra
*Gaurav Misra*

> "We have what we think of as the public roadmap. This is basically what people have asked us for... So we have a second roadmap which we think of as a secret roadmap."

**Insight:** Balance user-requested features with a 'secret roadmap' of non-obvious, revolutionary ideas that change user behavior and provide a competitive edge.

**Tactical advice:**
- Maintain a public roadmap based on user feedback to stay competitive on table-stakes features.
- Create a secret roadmap for game-changing ideas that users haven't asked for but solve core problems in new ways.
- Run company-wide brainstorming sessions to source ideas for the secret roadmap from all functions.

*Timestamp: 00:26:58*


## Gia Laudi
*Gia Laudi*

> "The way that you make a decision on which one you focus on is similar to best customers. So high willingness to pay... urgent problem... high retention or even expansion potential... customers congregate in a way that make them really easy to market to... or you have an unfair advantage with this market."

**Insight:** Prioritize customer segments or 'Jobs to be Done' based on urgency of need, willingness to pay, and your company's unique market advantages.

**Tactical advice:**
- Evaluate segments based on 'painkiller' vs 'vitamin' status (urgency)
- Assess the ease of reaching specific customer congregations for marketing
- Focus on segments where the product has a clear unfair advantage

*Timestamp: 00:24:55*


## Gibson Biddle
*Gibson Biddle*

> "As a rule, I never used rules as thumbs, but these two percenters, I would kill them. If I launched something and it was only 2% we'd, we called it scraping the barnacles, just get rid of it."

**Insight:** Maintain product simplicity by removing 'two percenters'—features used by only a tiny fraction of the audience that add unnecessary complexity.

**Tactical advice:**
- Measure the reach of every feature in the product
- Identify 'two percenters' that create maintenance overhead without broad value
- Practice 'scraping the barnacles' by regularly deleting low-usage features

*Timestamp: 24:10*


## Gustav Söderström
*Gustav Söderström*

> "The idea is that, roughly, you shouldn't be spending more than 10% of your time planning versus executing or building. Which means that if you're working quarterly 10 weeks, you should spend one week planning."

**Insight:** Planning cycles should be strictly capped to 10% of the total time to ensure the majority of effort is spent on execution.

**Tactical advice:**
- Limit planning to one week for every ten weeks of work
- If planning takes longer than 10%, extend the execution period (e.g., move to six-month increments)

*Timestamp: 01:02:46*


## Gustaf Alstromer
*Gustaf Alstromer*

> "Whenever someone wants to have a strategy conversation, it assumes that they don't understand their priorities. The priorities is always a list from top to bottom where there's one thing that's more important than the others. You can't really have a strategy session about the other things because there's only one thing to work on."

**Insight:** In early startups, strategy is often a distraction from the singular most important priority.

**Tactical advice:**
- Maintain a strict stack-ranked list of priorities where only the top item truly matters

*Timestamp: 00:53:02*


## Hari Srinivasan
*Hari Srinivasan*

> "We started this thing where just basically we call it orange and red priorities... We said, these are the big rocks we got to get done. We're going to get those things done first. We're going to be upfront and honest with you, and these are the things and these are price. And then you can plan from there."

**Insight:** Use a 'big rocks' approach to set top-down priorities before allowing teams to conduct bottom-up planning.

**Tactical advice:**
- Categorize priorities (e.g., 'orange' and 'red') to signal importance levels
- Communicate non-negotiable 'big rocks' early in the planning cycle

*Timestamp: 01:00:44*


## Ian McAllister
*Ian McAllister*

> "Given the same amount of skill intelligence and resources, a product manager with a great innate ability to prioritize is going to generate 5X the impact of someone without that skill."

**Insight:** Prioritization is the highest-leverage skill for a PM, directly correlating to the total impact generated by the team.

**Tactical advice:**
- Prioritize themes in a roadmap
- Sequence projects within those themes
- Apply prioritization to personal time management

*Timestamp: 00:18:18*


## Itamar Gilad
*Itamar Gilad*

> "I suggest using ICE, impact, confidence and ease. I think I have a slide coming on this. So impact, confidence and ease which is basically a way to assign three values to each idea."

**Insight:** Use the ICE framework to move prioritization from a battle of opinions to a transparent, evidence-based evaluation.

**Tactical advice:**
- Use 'Ease' (the opposite of effort) to keep the scoring intuitive
- Evaluate impact specifically against the North Star metric or top business KPI
- Use a 'Confidence' score to adjust for the uncertainty of impact and ease estimates

*Timestamp: 00:35:33*

---

> "I recommend using outcome roadmaps saying by October we want to achieve this outcome. By Q4 we want to launch in another three countries, or we want to grow our usage in India by that much... Otherwise you want to keep it open and the roadmaps can kind of suffocate this process if you decide upfront with low confidence that this particular idea must be launched."

**Insight:** Shift from 'release roadmaps' (dates and features) to 'outcome roadmaps' (goals and metrics) to maintain flexibility for discovery.

**Tactical advice:**
- Commit to outcomes (e.g., reducing churn) rather than specific feature delivery dates
- Only put high-confidence, already-tested ideas into a delivery-focused roadmap

*Timestamp: 01:03:04*


## Jackson Shuttleworth
*Jackson Shuttleworth*

> "When you can be really laser focused on, my goal each quarter is to make this metric go up, I think it's much easier to make sure that you're working on the highest ROI thing. I think when you think more about like, oh, I want to make this feature better, I think it's easier to get lost in what better means."

**Insight:** Metric-based goals provide clearer prioritization than feature-based goals.

**Tactical advice:**
- Structure teams around moving a specific metric (e.g., CURR) rather than owning a specific feature.

*Timestamp: 01:05:13*


## Jackie Bavaro
*Jackie Bavaro*

> "A roadmap in strategy is not a commitment. Instead, it's a way to double check if your plan makes any sense at all and is even anywhere near feasible. Because what happens to every team I see do these roadmaps, you put it together and you realize 'We're not going to hit our vision in five years or 10. This is like a 30 year vision, if we keep going at the pace we're going.'"

**Insight:** The primary strategic value of a roadmap is as a 'reality check' for the feasibility of the product vision.

**Tactical advice:**
- Work backwards from the vision to see if the timeline is realistic
- Use the roadmap to identify if you need to hire more people or take 'bigger swings'

*Timestamp: 24:34*


## Jake Knapp + John Zeratsky
*Jake Knapp + John Zeratsky*

> "It's not about how do I go faster? How do I get more efficient? It's about how do I put the thing that is the most important first in my day or in my life, and then build everything else around that and accept that you're going to need to do a bunch of those little things."

**Insight:** Effective prioritization is about placing the most important task first rather than seeking general efficiency.

**Tactical advice:**
- Identify the single most important project or task (Project A).
- Build the rest of your schedule around that primary priority.

*Timestamp: 00:10:16*


## Janna Bastow
*Janna Bastow*

> "The whole point about a roadmap is that it's not designed to be your plan. I think about it as being a prototype for your strategy. What I mean by that is we talk about prototyping all the time in the lean world and a prototype is essentially a way of checking your assumptions."

**Insight:** A roadmap should be treated as a prototype for strategy to test assumptions rather than a fixed execution plan.

**Tactical advice:**
- Use the roadmap to lay out assumptions about problems being solved
- Share early assumptions with the team and customers to check if you are on the right path

*Timestamp: 00:00*

---

> "So we sat down and we came up with a three column roadmap, current, near term, future, which became now, next, later. And it took away the simple concept of a timeline at the top."

**Insight:** The Now, Next, Later framework replaces rigid timelines with buckets that reflect the 'cone of uncertainty.'

**Tactical advice:**
- Organize work into Now, Next, and Later columns
- Avoid putting dates on everything to prevent penalizing the team for the natural uncertainty of long-term planning

*Timestamp: 25:08*


## Jason Fried
*Jason Fried*

> "I don't plan long-term because I want to do what I think, not what I thought... Every six weeks, we rethink what we're going to do next. We're very much an in-the-now company, making it up as we go."

**Insight:** Avoid long-term roadmaps to maintain the flexibility to act on current information and intuition.

**Tactical advice:**
- Re-evaluate all priorities every six weeks
- Avoid making promises for work far in the future
- Focus on 'in-the-now' decision making to stay responsive to the market

*Timestamp: 01:03:33*


## Jeff Weinstein
*Jeff Weinstein*

> "You are one of the best people I've ever worked with at solving problems three through 100, but I need you stuck on problems one and two."

**Insight:** High-performing leaders often default to clearing easy tasks (3-100) instead of tackling the most difficult, existential problems (1-2).

**Tactical advice:**
- Identify the top two most difficult problems and refuse to discuss lower-priority items until they are addressed.

*Timestamp: 02:33:22*


## Jess Lachs
*Jess Lachs*

> "You have to be very intentional to carve out time for exploratory work for deep dives because as you mentioned, there are always more questions and more work to be done than hours in the day."

**Insight:** Exploratory data work requires dedicated, protected time to prevent it from being crowded out by reactive requests.

**Tactical advice:**
- Use hackathons to carve out dedicated days for self-directed deep dives into data.
- Set explicit goals for the team around finding insights through exploratory work to ensure accountability.

*Timestamp: 00:15:47*

---

> "When something comes up to be able to say, 'Hey, this data poll that you want me to do, is this more important than these other three things that I was going to be working on? Yes or no?'"

**Insight:** Effective prioritization requires making the trade-offs of new requests visible to stakeholders.

**Tactical advice:**
- Always present the 'opportunity cost' when a stakeholder introduces a new urgent request.
- Use weekly standups with business partners to re-evaluate and align on the most impactful work.

*Timestamp: 00:21:49*


## Jiaona Zhang
*Jiaona Zhang*

> "You're telling a story. So what I want from you is I want themes, I want a story. Why are these things the biggest things to invest in these levers, the biggest ones to pull? And what I really don't want, what I think is a very common mistake from road mapping is people thinking a spreadsheet with a bunch of projects, the RICE framework, everything has an impact, a cost and an effort column filled out. They think that is prioritization and that is a roadmap."

**Insight:** A roadmap should be a narrative driven by strategic themes rather than just a spreadsheet of projects with impact scores.

**Tactical advice:**
- Focus on themes and narrative over granular project lists
- Use written documents instead of decks to allow for more granularity in remote-first cultures
- Link roadmap themes to live execution tools like Jira to keep them up to date

*Timestamp: 00:23:59*


## John Mark Nickels
*John Mark Nickels*

> "I think you can go too far either direction, right? It's like everything in life is about balancing the polarity between two opposing forces. And so in this one it's like, yeah, you go too hard in division and theory land... And you just get wrapped around the axle of like, well, that sounds really good in theory, but I have no idea how to even start executing on this... But you could probably go too far into execution land too... It was like, people would be like, 'I'm just going to run through a wall. I have no idea if that's the right wall to run through.'"

**Insight:** Product leadership is the art of balancing the polarity between high-level theory and ground-level execution.

**Tactical advice:**
- Identify if the team is currently 'wrapped around the axle' of theory and needs to shift to execution
- Recognize when 'ready, fire, aim' execution has lost its strategic direction

*Timestamp: 00:41:48*


## Karina Nguyen
*Karina Nguyen*

> "AI research progress is bottlenecked by management, research management. It's because you have constrained set of compute and you need to allocate the compute to the research paths that you feel the most convinced about. It was like you need to have a really high conviction in the research paths to put the compute, and it's more return on investment kind of situation."

**Insight:** In AI research, prioritization is driven by the scarcity of compute and the need for high conviction in specific experimental paths.

**Tactical advice:**
- Prioritize experiments based on 'return on investment' for compute usage.
- Cut research paths early if they lack 'signs of life' to save resources for higher-conviction projects.

*Timestamp: 00:46:28*


## Karri Saarinen
*Karri Saarinen*

> "The cycles is just a way to say that for the next week or the next two weeks or whatever timeframe, we are going to work on these things and these other things we think are the priority or the focus for this timeframe."

**Insight:** Using automated, time-bound cycles helps teams ignore the 'infinite backlog' and focus on a small set of immediate priorities.

**Tactical advice:**
- Implement automated cycles (e.g., 1-2 weeks) to define short-term focus.
- Use cycles to provide a clear 'no' to new requests that fall outside the current timeframe.

*Timestamp: 00:41:35*

---

> "Internally, we also talk about this, you knowing RPG games, you have the main quest lines and then you have the side quest lines. And we often talk about the companies avoid the side quests. There's always ideas people have... This doesn't progress the main quest line, which is building this product and making it awesome for these customers."

**Insight:** Prioritization can be simplified by categorizing tasks as 'Main Quests' (core value) or 'Side Quests' (distractions).

**Tactical advice:**
- Audit the roadmap for 'side quests' that don't directly contribute to the core product mission.
- Ask: 'Is this important to do now, or can it be done later?' to filter out shiny objects.

*Timestamp: 00:55:38*


## Lane Shackleton
*Lane Shackleton*

> "The ritual is essentially you can take any set of problems or solutions or themes or whatever you want to get people's input on, and you put those into a table and then people can basically vote with their dollars and usually you allocate $100. And so people will go through and say, "Oh, I want to allocate $10 to this and $20 to this and $50 to this because I think it's really important.""

**Insight:** Use '$100 voting' to surface the 'elephant in the room' and quantify team alignment on priorities.

**Tactical advice:**
- Give each team member $100 virtual dollars to distribute across potential projects.
- Analyze the spread of votes to identify areas of high disagreement for further discussion.

*Timestamp: 00:48:02*


## Logan Kilpatrick
*Logan Kilpatrick*

> "One, going back to the mission, is this actually going to help us get to AGI? So there's a huge focus on there's this potential shiny reward right in front of us, which is optimize user engagement... And is that really the thing?"

**Insight:** Prioritize roadmap items based on their alignment with the core mission (e.g., AGI) rather than short-term engagement metrics.

**Tactical advice:**
- Filter 'shiny' feature requests through the lens of the company's long-term mission.
- Prioritize reliability and robustness as core tenets before adding new modalities or endpoints.

*Timestamp: 00:36:14*


## Madhavan Ramanujam
*Madhavan Ramanujam*

> "Literally, for your product folks, the number one lesson... you cannot prioritize a product roadmap without having a willingness to pay conversation. If you're just prioritizing based on what you think or what you feel or technical resources, you're getting it wrong."

**Insight:** Willingness to pay is the ultimate filter for roadmap prioritization.

**Tactical advice:**
- Prioritize the 20% of features that drive 80% of the willingness to pay
- Avoid giving away high-value features for free in an MVP if they are the primary value drivers

*Timestamp: 00:21:36*


## Manik Gupta
*Manik Gupta*

> "You don't need 20 features to solve a problem. You just need one or two features which work really well. This whole concept of critical user journeys. How do you make sure that, if you're solving problem X, any feature that you build in the product... should be well designed and it should have the focus and prioritization so that you're only getting things for the critical journey so that the user can use it and not get confused."

**Insight:** Effective prioritization means ruthlessly narrowing focus to one or two high-quality features that address the 'critical user journey' to avoid user confusion.

**Tactical advice:**
- Keep the initial product scope extremely small to ensure the core problem is solved elegantly.
- Audit every feature against the 'critical user journey' to ensure it adds value without adding noise.

*Timestamp: 00:31:54*


## Maggie Crowley
*Maggie Crowley*

> "The best PMs not only can find the one thing to work on, but they can stay with that one thing long enough to actually finish it."

**Insight:** Great prioritization requires the discipline to stick with a single focus until completion despite competing fires.

**Tactical advice:**
- Find the one truly necessary task among many priorities
- Maintain focus long enough to finish the work
- Be the person 'beating the drum' to keep the team engaged

*Timestamp: 00:05:31*

---

> "Getting to the one thing you should do is extremely difficult and being able and having the gumption to say no to all those other things is really hard, because there's probably at any given time, 10 things you should do, but you can't do 10 things."

**Insight:** The hardest part of prioritization is the emotional and professional courage required to say no to good ideas.

**Tactical advice:**
- Limit top-line priorities to three or fewer
- Be willing to take responsibility for the 'bet' of picking one thing over others

*Timestamp: 00:15:31*


## Matt LeMay
*Matt LeMay*

> "The Low Impact Death Spiral is the dynamic in which every medium to large company I've ever worked with finds itself in one way or another... It starts with adding little features here and there, making little cosmetic improvements because it's easier, it invites less scrutiny and you're less likely to mess up something important"

**Insight:** Teams often prioritize 'safe' low-impact work (like cosmetic features) over 'risky' high-impact work (like core engine improvements), leading to a bloated product that is harder to improve.

**Tactical advice:**
- Identify if your team is working on 'rhinestones' (cosmetic additions) versus the 'engine' (core value).
- Proactively seek out high-impact work even if it requires more cross-team coordination.

*Timestamp: 00:24:00*

---

> "Are we estimating and measuring impact in the same unit of measure as our goals? Because if we're doing that, then we're keeping ourselves honest and we're saying, 'Does this actually have a chance of contributing?' Whereas again, if we get really clever and we come up with a proprietary scoring system and all these little intermediate steps, we can feel like we're doing really awesome work and being very, very terribly smart. But we again, run the risk that we are going to lose our connection with why we're setting about to do this work in the first place."

**Insight:** Prioritization frameworks like ICE or RICE are only effective if 'Impact' is measured in the same units as the team's primary business goal.

**Tactical advice:**
- Replace abstract impact scores (1-10) with actual projected units of your goal (e.g., 'number of users converted').
- Use impact estimation to identify 'big bets' that are the only ones capable of hitting the target.

*Timestamp: 01:06:11*


## Marty Cagan
*Marty Cagan*

> "In a feature team, basically you are handed a typical roadmap. Almost everybody, even though I wish this wasn't the case, almost everybody to have the same thing, that it's a prioritized list of features and projects. So some stakeholders got together, usually quarterly, and they say, "Look, to run our part of the business, we need these features. It's not really complicated. We need these features.""

**Insight:** Feature-based roadmaps are often the result of stakeholder negotiations rather than product discovery.

**Tactical advice:**
- Recognize that a prioritized list of features is a sign of a 'feature team' culture
- Move away from quarterly stakeholder-driven feature lists toward outcome-based planning

*Timestamp: 00:08:00*


## Melissa Perri + Denise Tilles
*Melissa Perri + Denise Tilles*

> "He was looking for a portfolio roadmap of what everybody's doing and he wanted to see what are the big pushes we're making from a feature perspective and how do they tie back to our overall strategy and our goals."

**Insight:** Executive leadership requires a high-level portfolio view of the roadmap to ensure R&D allocation aligns with company strategy.

**Tactical advice:**
- Roll up individual team roadmaps into a portfolio view for executives
- Explicitly map feature 'pushes' to specific strategic objectives and goals

*Timestamp: 01:03:29*


## Mayur Kamat
*Mayur Kamat*

> "You work on problems that have a 10X positive or a negative impact... That's what you focus on. That's what you spend bulk of your time."

**Insight:** Effective prioritization means ignoring 'important' tasks to focus exclusively on those with 10x leverage.

**Tactical advice:**
- Identify the 10x leverage problems (usually growth or compliance in FinTech) and ignore the rest.
- Be willing to 'move your desk'—metaphorically or literally—to the highest leverage problem area.

*Timestamp: 01:07:00*


## Melissa Perri
*Melissa*

> "It just always comes back to how do I set strategy, how do I deploy strategy, and how do I make sure it's well communicated and that everything that we're doing on the tech teams, on the product teams, is laddered up into a company strategy that's well prioritized."

**Insight:** The core challenge of scaling is ensuring every tactical team activity is prioritized to support the high-level company strategy.

**Tactical advice:**
- Audit the roadmap to ensure every feature or enhancement ladders up to a specific business objective or vision.

*Timestamp: 09:00*

---

> "A good test is you go to all of your teams, and you ask them what they're doing and why... They can connect everything they're doing, from the tactical stuff on the team, all the way back up to the business metrics."

**Insight:** Roadmap prioritization is successful when individual contributors can articulate the business value and market impact of their specific tasks.

**Tactical advice:**
- Ask team members: 'What are you working on, and how does it move the business metrics or help us enter new markets?'

*Timestamp: 27:48*


## Michael Truell
*Michael Truell*

> "Some of the normal things that people would maybe reach for in building the company early on, we really let those fires burn for a long time, especially when it came to things like sales and marketing. And so just working on the product, and building a product that you like first, your team likes, and then also then adjusting it for some set of users, that can kind of sound simple, but then, as you know, it's hard to do that well."

**Insight:** In the early stages of a product-led growth company, it is often necessary to intentionally ignore non-core functions to maintain absolute focus on product quality.

**Tactical advice:**
- Let 'fires burn' in non-essential areas like sales and marketing to focus 100% on product development.
- Prioritize building a product that the internal team genuinely loves and uses daily.

*Timestamp: 00:29:15*


## Nan Yu
*Nan Yu*

> "The stuff that we absolutely have to say no to is the exact kind of thing that leads to this bloatedness that makes ICs hate their lives. It's customization features requested by middle managers in order to make reporting a little bit easier at the cost of making IC workflows worse."

**Insight:** Avoid product bloat by refusing features that prioritize management reporting over individual contributor productivity.

**Tactical advice:**
- Identify where incentives are misaligned between different user types (e.g., managers vs. ICs).
- Say no to customization requests that add friction to the primary user's workflow.

*Timestamp: 00:16:14*

---

> "At any given moment, we have probably 20 or 30 opportunities that we could possibly explore, just product opportunities, like problems to solve, areas to improve for our users, but they're not ready yet. We don't have enough conviction around how we might approach it. So, we just accumulate understanding of this stuff and periodically, we accumulate some more stuff, and then we reevaluate."

**Insight:** Maintain a backlog of opportunities that you continuously research until you reach a threshold of conviction.

**Tactical advice:**
- Keep an up-to-date analysis of potential product areas so the whole team can contribute.
- Wait to action a roadmap item until you have a clear, elegant way to solve a specific part of the problem.

*Timestamp: 00:41:19*


## Nikita Bier
*Nikita Bier*

> "You have to be ruthless with prioritization as something scales up and put out the largest fires first, because that was something that I didn't really fully understand, is how many things go wrong."

**Insight:** During hyper-growth, prioritization shifts from feature development to survival and scaling infrastructure.

**Tactical advice:**
- Focus exclusively on the 'largest fires' that threaten to take the system offline during breakout success

*Timestamp: 00:34:25*


## Noah Weiss
*Noah Weiss*

> "I think the way that we think about, or us to think about our roadmap for any feature team at Slack is that it's a portfolio and it's meant to be a portfolio that's diversified a couple different ways. I think one is you want to diversify things that are meant to be new capabilities versus making the thing you've already built a little bit better every day... Are there things that are meant to be risky that you aren't sure are going to work but might have a lot of upside versus things that are known bets."

**Insight:** Treat the product roadmap as a diversified portfolio, balancing incremental improvements, new capabilities, and high-risk 'boulder bets.'

**Tactical advice:**
- Balance 'known bets' with 'risky bets' that have high potential upside.
- Allocate resources between learning about new possibility spaces and driving confident impact.

*Timestamp: 00:30:23*


## Noam Lovinsky
*Noam Lovinsky*

> "I remember doing really on is actually talking to the leadership team and being like, 'I don't think we should be putting 50 engineers on this project. Looking at the rest of the roadmap and the rest of the priorities, excuse me, I think this team would likely be better served elsewhere.'"

**Insight:** Be willing to advocate for canceling your own project if it isn't the highest priority for the business compared to other roadmap items.

**Tactical advice:**
- Evaluate your project's relative priority against the entire company roadmap
- Advocate for resource reallocation if your project is lower impact, even if it risks your current role

*Timestamp: 00:10:26*


## Paul Adams
*Paul Adams*

> "Difference versus table stakes, very simple... differentiation. So what's different and better? But critically, what's different and better in ways that customers care about?... on the other side, there's a entry requirement or table stakes... They're real basic stuff, boring stuff, and easy to ignore."

**Insight:** A balanced roadmap must trade off between unique differentiators that attract customers and 'table stakes' features that allow them to switch.

**Tactical advice:**
- Categorize roadmap items into 'Differentiation' vs. 'Table Stakes'.
- Ensure you aren't building 'different' features that customers don't actually care about.

*Timestamp: 00:55:03*


## Richard Rumelt
*Richard Rumelt*

> "Focus, it's the fundamental source of power and strategy. Trying to do too many different things is defocusing."

**Insight:** Strategic power comes from concentrating resources on a few pivotal objectives rather than spreading them thin.

**Tactical advice:**
- Limit your action agenda to a few key items rather than a long list of priorities.
- Avoid 'strategic assembly' where you just list everything you wish would happen.

*Timestamp: 00:25:18*

---

> "Which of your ambitions can you begin to make progress towards reaching, and what's holding you back? What are the barriers? What are the problems? So I approach the question of the problem now through the filter of the ambition."

**Insight:** Prioritization should be a balance between what is important (ambition) and what is actually achievable (addressable).

**Tactical advice:**
- Filter your ambitions by asking which ones you can actually make progress on today.
- Focus on 'addressable challenges' that overlap with your high-level goals.

*Timestamp: 01:00:52*


## Rahul Vohra
*Rahul Vohra*

> "You can classify anything that you build in a company into one of two categories, solution deepening and market widening. Now, solution deepening means making your product better for its existing users, but not making it available to more users. Whereas market widening means making your product available to more users, but not making the product itself any better."

**Insight:** Balance roadmap items between 'solution deepening' (retention) and 'market widening' (acquisition) to manage perceived velocity.

**Tactical advice:**
- Identify if a feature is deepening the solution for current users or widening the market for new ones.
- Communicate 'market widening' work clearly to avoid the perception of slowed product velocity.

*Timestamp: 00:15:30*


## Robby Stein
*Robby Stein*

> "You get to these points of just diminishing marginal return in every system where it feels like you could put 50 people on this project, it's just not going to dramatically move the needle... You then find your next growth driver or set of drivers."

**Insight:** Teams must recognize when a product has reached the plateau of its S-curve to shift resources toward new growth drivers.

**Tactical advice:**
- Quantify the expected value of investments to identify diminishing marginal returns.
- Shift from optimization to first-principles thinking when a core feature's growth plateaus.

*Timestamp: 00:41:05*


## Ryan J. Salva
*Ryan J. Salva*

> "As a general rule, as a general principle, I certainly try to make sure that we're always reserving some capacity for bold, audacious experimental research projects. You can think of those really uncertain bets as being five to 10% of the team's capacity. About 25, maybe 30% of the team's capacity should generally be on just operations. How do we keep our in-market products meeting customer expectations? And then the remainder of it, what is that, about 60% or so, is really on incremental progress for our end market products."

**Insight:** A healthy product portfolio balances high-risk moonshots (5-10%), operational maintenance (25-30%), and incremental improvements (60%).

**Tactical advice:**
- Allocate 5-10% of capacity to Horizon 2 and 3 'moonshot' projects
- Reserve 25-30% of capacity for operational fundamentals and customer expectations
- Dedicate ~60% of capacity to incremental progress on existing products

*Timestamp: 00:55:25*


## Sachin Monga
*Sachin Monga*

> "Substack is a pretty principled company... prioritization standpoint and from a strategic standpoint... all things equal, do the one that holds constant this principle of control."

**Insight:** Use core company principles (e.g., user agency and control) as the primary filter for roadmap prioritization.

**Tactical advice:**
- Evaluate features based on whether they increase or decrease user control over their experience.
- Choose the 'principled' path even if it appears harder to execute than a standard algorithmic approach.

*Timestamp: 00:21:40*


## Ryan Singer
*Ryan Singer*

> "What is our appetite for this? What is the maximum amount of time we’re willing to go before we actually finish something? And we have that startup moment... at least this, if not the whole project, this meaningful piece, we can literally walk away from."

**Insight:** Prioritization should be based on 'appetites' (how much time a problem is worth) rather than 'estimates' (how long a solution will take).

**Tactical advice:**
- Ask: 'Is this problem worth six weeks of our time?' before deciding how to solve it.
- Prioritize projects that result in a 'shippable' piece of value that can stand on its own.

*Timestamp: 00:19:39*


## Sarah Tavel
*Sarah Tavel*

> "What that ends up meaning when the when a new user signs up is that there's too much in the beginning to to take in and understand, and you don't then have a very focused product that gets the user to the thing that you most want them to do. And that's actually part of the importance of understanding level one, what your core action is."

**Insight:** Roadmap prioritization should focus on driving users toward a single 'core action' rather than diffusing attention across many features.

**Tactical advice:**
- Identify the one action most causal of long-term retention
- Remove features or UI elements that distract new users from completing that core action

*Timestamp: 00:30:19*


## Sean Ellis
*Sean Ellis*

> "In order to be able to effectively run a high velocity testing program, you need to be able to source ideas from across the company. And that's why I came up with ICE, that if you're having people submit ideas and you can't tell them why their idea was not chosen, they're just going to get upset... But if you have a systematic way of being able to compare ideas, it's more likely that people will be able to get it"

**Insight:** The ICE framework (Impact, Confidence, Ease) provides a transparent, systematic way to prioritize experiments and maintain team alignment.

**Tactical advice:**
- Use ICE to score and compare ideas from different departments.
- Communicate the reasoning behind prioritization to the broader team to encourage continued idea generation.

*Timestamp: 01:28:21*


## Shishir Mehrotra
*Shishir Mehrotra*

> "Brian also has another one... about how to rank your to-do list by finding leverage... he sorts his by which of these is most likely to create leverage of getting rid of the rest of my lists"

**Insight:** Prioritization should be based on 'leverage'—identifying the one task that makes other tasks unnecessary.

**Tactical advice:**
- Sort to-do lists or roadmaps by 'leverage' rather than just importance or urgency.
- Ask: 'Which of these tasks, if completed, eliminates the need for the rest of the list?'

*Timestamp: 00:45:45*


## Shreyas Doshi
*Shreyas Doshi*

> "L tasks which are leverage tasks... when you put in a certain amount of effort, you get 10X or 100X in return... neutral tasks (N)... overhead tasks (O)... as a product manager... all your tasks are not created equal, there are actually three type of tasks that you end up doing in such a role."

**Insight:** Effective prioritization requires categorizing tasks by leverage (L, N, O) and intentionally reducing effort on low-leverage tasks to preserve energy for high-leverage ones.

**Tactical advice:**
- Identify 'L' tasks (like strategy or difficult PRDs) and allow your inner perfectionist to shine only on those.
- Use 'placebo productivity' (doing N and O tasks) to build momentum before tackling a scary L task.
- Change your physical location to force focus when working on high-leverage tasks.

*Timestamp: 00:35:56*

---

> "You should stop doing work that simply provides a positive return on investment, ROI. And you should start focusing on work that minimizes opportunity cost... ROI mindset... end up trying to decrease the denominator... start working on the low hanging fruit. You start prioritizing the quick wins."

**Insight:** An ROI-only mindset leads to a backlog of 'quick wins' that prevents teams from pursuing high-uncertainty, high-upside strategic bets.

**Tactical advice:**
- Shift from asking 'Is this a good use of my time?' to 'Is this the best use of my time?'
- Use rough allocation guidance (e.g., 60% Incrementals, 30% Big New Initiatives, 10% Stability) to protect space for non-incremental work.

*Timestamp: 01:02:47*


## Stewart Butterfield
*Stewart Butterfield*

> "The idea is the first bit of effort you put into something doesn't result in a huge amount of value. And then there's some magic threshold where it produces an enormous amount of value and then continued investment doesn't really pay off."

**Insight:** Use utility curves to determine if a feature has reached its 'magic threshold' of value or if it is suffering from diminishing returns.

**Tactical advice:**
- Map features on an S-curve of effort versus utility
- Investigate if a feature is on the shallow or steep part of the value curve before allocating more resources

*Timestamp: 00:07:08*


## Sriram and Aarthi
*Sriram and Aarthi*

> "Don't fall for fads. It's do the thing that your customers are asking for and are willing to pay for... if you have something that is working, don't get distracted."

**Insight:** Startups often fail by chasing industry 'memes' or fads (like shared ownership or specific AI implementations) that don't fit their core hypothesis.

**Tactical advice:**
- Resist the urge to build secondary products (like SDKs or B2B pivots) before the core consumer product is stable.
- Evaluate new technologies against actual customer needs rather than investor trends.

*Timestamp: 01:03:30*


## Shweta Shriva
*Shweta Shriva*

> "The other big lesson... it's also very important to know what you're not building. And this one is not only in big companies, I would say even in startups, it's extremely important to know what you're not building because you could very easily get swayed by customer X telling you to do this, customer y telling you to do that. And a product that tries to be all things to all people usually doesn't end up going anywhere."

**Insight:** Effective prioritization requires being explicit about what is excluded from the roadmap to avoid building a diluted product.

**Tactical advice:**
- Clearly define and communicate what the team is NOT building.
- Resist the urge to accommodate every individual customer request to maintain product focus.

*Timestamp: 27:13*


## Varun Mohan
*Varun Mohan*

> "You don't win by doing 10 things well. You win by doing one thing really well and maybe you fail nine things. This is the thing that I've told the company, 'This is very different than school,' right? In school you optimize for your total GPA. But for companies, I just need to get an A+ on the one class that matters."

**Insight:** Startup success is driven by extreme excellence in one critical area rather than average performance across many.

**Tactical advice:**
- Identify the single most important 'A+' project and focus resources there
- Accept 'F' grades (deprioritization) on non-essential tasks to maintain focus

*Timestamp: 00:26:45*


## Vijay
*Vijay*

> "We took all the churn reasons that our customer success and sales teams had been painstakingly collecting for years, grouped them by category, which was roughly product features we needed to build, sorted descending by ARR, took the top 10 things and made that our roadmap"

**Insight:** In a competitive crisis, prioritize the roadmap by quantitatively mapping churn reasons to lost revenue (ARR).

**Tactical advice:**
- Group customer feedback and churn reasons into feature categories
- Sort these categories by the total ARR associated with the feedback
- Focus the roadmap on the top 10 items to optimize for speed and clarity

*Timestamp: 09:21*

---

> "One of the traps with RICE that we observed is that the C and E, the confidence and effort tends to cause you to prematurely deprioritize potentially high reach, high impact bets... ignore the C and E for a little longer than it's comfortable, and just sit with those high reach, high impact ideas with engineers and designers in the room committed to actually trying to solve them."

**Insight:** Standard prioritization frameworks like RICE can kill innovation if confidence and effort scores are applied too early to complex ideas.

**Tactical advice:**
- Temporarily ignore Confidence and Effort scores for high-impact ideas
- Spend a week with engineering and design to explore high-reach ideas before scoring them
- Look for high-confidence, lower-effort versions of innovative bets after the initial exploration

*Timestamp: 25:35*


## Ebi Atawodi
*Ebi Atawodi*

> "the big rocks are not a laundry list of 20 things because if I asked you to make me a cocktail, you would put ice in first. Then you would pour the drink. You would not put the drink and then put the ice... So it's like 3, 4, 5 things that anyone can remember that are the biggest things that if we land, this gets us closer to solving the problems."

**Insight:** A roadmap should focus on a small number of 'big rocks' that provide the most impact, rather than a long list of minor tasks.

**Tactical advice:**
- Limit the primary roadmap to 3-5 'Big Rocks' that everyone can remember
- Consolidate work if there are fewer than three engineers assigned to a specific problem

*Timestamp: 00:59:20*


## Megan Cook
*Megan Cook*

> "We've just started trying something new called the $10 game for priorities... you and your manager might come in and you can list out all of your priorities and then show you through just dividing up $10 where you're spending all of your time. And I've done this with people and we've sort of gotten down to like, 'I'm putting 10 cents here this week.'"

**Insight:** Use a 'currency' allocation exercise to visualize time spent on priorities and identify where resources are being spread too thin.

**Tactical advice:**
- List all individual or team priorities
- Allocate a fixed 'budget' (e.g., $10) across those priorities based on actual time spent
- Identify and cut 'low-spend' items that are not moving the needle

*Timestamp: 00:14:24*


## Paige Costello
*Paige Costello*

> "Before, we planned annually primarily. Now, we plan every six months, but for a rolling 12 months. So we have higher confidence in the immediate half, lower confidence in the following half, but we just plan every 12 months, every six months because it gives our business more confidence in what's coming and a better opportunity to align our go-to-market and product planning."

**Insight:** A rolling 12-month planning cycle revisited every six months balances long-term strategic confidence with the agility to pivot.

**Tactical advice:**
- Plan for a 12-month horizon but revisit and update the plan every 6 months.
- Assign higher confidence to the immediate 6-month window and lower confidence to the subsequent 6 months.

*Timestamp: 00:08:14*


## Scott Belsky
*Scott Belsky*

> "What we realized is that some things were taking off, and some things weren't... we decided to kill the Tip Exchange. And suddenly, the publishing of projects in the portfolio went up... we killed groups. And lo and behold, more people published more projects... if you make the whole product about one thing, everyone does that. That core crank operates at 10X the velocity."

**Insight:** Aggressively removing secondary features can significantly accelerate the velocity and success of your core product metric.

**Tactical advice:**
- Identify the 'core crank' metric and remove features that distract users from it
- Whenever adding a new feature, consider what existing feature can be replaced or removed
- Monitor if removing a feature leads to an increase in the primary desired user action

*Timestamp: 00:23:10*


## Varun Parmar
*Varun Parmar*

> "We have a rolling six month roadmap that gets updated every three months and the first three months of that roadmap, we have a 80% position level... For the next three months... we have a 50% [level]."

**Insight:** A rolling roadmap with tiered confidence levels (80% for near-term, 50% for mid-term) balances predictability with agility.

**Tactical advice:**
- Update the 6-month roadmap every quarter to reflect new market insights or technical breakthroughs.
- Communicate clearly to stakeholders that items in the 3-6 month window are only 50% likely to ship as described.

*Timestamp: 00:47:43*


