---
name: problem-definition
description: Help users define problems clearly before jumping to solutions. Use when someone is scoping a new feature, validating a product idea, struggling to articulate what they're building, or falling into the "shiny object trap" with new technology.
---

# Problem Definition

Help the user define problems clearly before jumping to solutions using frameworks from 91 product leaders.

## How to Help

When the user asks for help with problem definition:

1. **Understand the current framing** - Ask how they're currently thinking about the problem
2. **Dig into the struggling moment** - Help them articulate the specific context where users feel stuck
3. **Separate problem from solution** - Ensure they haven't conflated a desired feature with the underlying need
4. **Validate the problem matters** - Help them confirm the problem is urgent and widespread enough to solve

## Core Principles

### Digitizing analog isn't enough
Bret Taylor: "Why use this instead of the Yellow Pages? It was a digital version of something that had come before." Simply digitizing an analog predecessor often fails because it lacks a native reason to exist on the new platform. Ask "why should a customer give this the time of day?"

### Prototype to define the problem
Jake Knapp + John Zeratsky: "This idea of getting unstuck and turning maybe some abstract ideas or some concepts that you've been discussing, turning that into a concrete prototype, something that you can look at and you can click around." Moving from abstract concepts to concrete prototypes is the fastest way to define and solve a problem.

### Avoid the shiny object trap
Marily Nika: "There is something called the shiny object trap, and I'm always telling people, 'Hey, don't do AI for the sake of doing AI.' Make sure there is a problem there." Ensure AI (or any new technology) is used to solve a specific, validated user pain point rather than for its own sake.

### Struggling moments cause demand
Bob Moesta: "A struggling moment causes demand. And you start to realize that in some cases that struggling moment exists and can exist for a long time and nobody solved it." Demand is created by a specific "struggling moment" in a user's life, not by the product itself. Study the context that makes users' behavior rational.

### See the end from the beginning
Ryan Singer: "We are not going to start something unless we can see the end from the beginning. We're not going to take a big concept and then say, 'What's the estimate for this thing?'" Ensure the team can visualize the completed feature before committing resources. Avoid starting with fuzzy concepts.

### The solution is what customers buy
Marty Cagan: "People don't buy the problem, they buy your solution. Obviously they don't buy it if it's not solving something they care about, but there are many products that are solving what they care about." While understanding the problem is necessary, competitive advantage comes from the quality of the solution. Don't over-rotate on problem validation if the problem is well-understood.

### Spend more time on the problem
Christopher Lochhead: "Spend more time on the problem than the solution." Deeply understanding the customer's perspective of the problem is more valuable than internal product brainstorming. Listen to hear their perspective rather than just pitching your solution.

### Qualify the problem type
Christopher Miller: "I don't know that we even talk about problems without a qualifier. Are we talking about a business problem? Are we talking about a customer problem?" Effective problem definition requires distinguishing between business needs and customer pain points to avoid "customer-hostile" solutions.

## Questions to Help Users

- "What is the user doing right before they encounter this problem? What are they trying to accomplish?"
- "Why hasn't this problem been solved already? What makes it hard?"
- "Is this a business problem or a customer problem? Are they the same?"
- "If you solved this problem perfectly, how would the user's life be different?"
- "Can you describe a specific person experiencing this problem in a specific moment?"
- "What are people doing today to work around this problem?"

## Common Mistakes to Flag

- **Solution-first thinking** - Starting with a feature idea and working backward to justify it
- **Technology-first thinking** - Wanting to use AI/blockchain/etc. and looking for problems to apply it to
- **Abstract problem statements** - Defining problems so broadly they don't point to any specific solution
- **Conflating business and customer problems** - Solving for internal metrics without addressing user needs
- **Skipping the struggling moment** - Not understanding the specific context where pain occurs

## Deep Dive

For all 123 insights from 91 guests, see `references/guest-insights.md`

## Related Skills

- positioning-messaging
- prioritizing-roadmap
- scoping-cutting
- product-taste-intuition
