---
name: product-operations
description: Help users build and scale product operations functions. Use when someone is scaling a product team, struggling with cross-functional coordination, needs to standardize product processes, or wants to improve how insights reach product teams.
---

# Product Operations

Help the user build and scale product operations functions using frameworks from 5 product leaders.

## How to Help

When the user asks for help with product operations:

1. **Understand the pain points** - Ask what's breaking down in their current product processes
2. **Assess organizational scale** - Determine if they're at the stage where dedicated product ops makes sense
3. **Define the scope** - Help them clarify what product ops should own vs. what PMs should retain
4. **Design the systems** - Create processes that enable product teams without creating bureaucracy

## Core Principles

### Product ops bridges product and operations
Brian Tolkin: "One solution to that problem, our solution at the time was to start up a new function called product operations who had accountability and reported into operations but physically sat with and operated much like a member of the product team." Product ops originated as a bridge between centralized product teams and distributed operations, ensuring product decisions account for operational reality.

### Product ops creates systems for product teams to thrive
Christine Itwaru: "Product operations for a VP or a head of product or a product manager is the creation of some system that allows you to thrive or allows your team to thrive in product management." The function is about building systems that enable product management, not doing product management itself.

### Product ops enables scaling velocity
Geoff Charles: "We invested early on in product operations... they basically are tasked with a lot of the work that needs to get done to continue shipping products and scaling product development." Product ops handles release management, enablement, and operational tasks that would otherwise distract PMs from their core work.

### Product ops informs, not decides
Melissa Perri + Denise Tilles: "Product operations does not take away decision making rights from the product manager. It's there to inform them." Product ops provides insights and infrastructure but doesn't make product decisions - that remains with PMs.

### Product ops helps with standardization and insights at scale
Melissa Perri: "Product management at scale is really hard, and that's where product operations comes in. So what it does is it helps you get the right insights to the team, and then help standardize those outputs and those check-ins." The function focuses on standardizing roadmaps, scaling user research, and surfacing data insights across the organization.

## Questions to Help Users

- "What operational tasks are currently taking PMs away from product work?"
- "How do insights from sales, support, and operations currently reach product teams?"
- "What would be different if every PM had standardized processes and tools?"
- "Where are the biggest coordination gaps between product and other functions?"
- "At what point did your product org start struggling with scale?"

## Common Mistakes to Flag

- **Product ops as PM work** - Asking product ops to make product decisions instead of enabling PMs
- **Too early investment** - Building a product ops function before the product org is large enough to need it
- **Process for process's sake** - Creating standardization that slows teams down rather than enabling them
- **Siloed from product** - Product ops reporting into operations without close connection to product teams
- **Unclear ownership** - Ambiguity about what product ops owns vs. what PMs own

## Deep Dive

For all 5 insights from 5 guests, see `references/guest-insights.md`

## Related Skills

- prioritizing-roadmap
- running-effective-meetings
- platform-infrastructure
