---
name: retention-engagement
description: Help users improve retention and engagement metrics. Use when someone is dealing with churn, optimizing activation flows, building habit-forming products, or trying to increase user engagement and lifetime value.
---

# Retention & Engagement

Help the user improve retention and engagement using frameworks from 29 product leaders.

## How to Help

When the user asks for help with retention:

1. **Understand the retention curve** - Ask about their current retention shape and where drop-off occurs
2. **Identify the aha moment** - Help them define what first experience of value looks like for their users
3. **Assess habit formation** - Determine if they're building for habitual vs. occasional use
4. **Design retention loops** - Create mechanisms that compound user value over time

## Core Principles

### Retention is gold for subscription businesses
Albert Cheng: "User retention is gold for consumer subscription companies. If you don't retain your users, then a lot of the onus is on getting them to pay on day one." Retention reduces pressure for immediate monetization and is the primary driver of subscription success.

### Products should get better with use
Sarah Tavel: "The test for me, of whether you're building a product that has the ingredients to create a retentive product on a micro level, just at the user level, is that the product should get better the more you use it, and you'll have more to lose by leaving it." True retention is built when a product creates accruing benefits and mounting loss over time.

### Daily return is the biggest problem to solve
Jackson Shuttleworth: "What Duolingo really focuses on is, how do we help users build habits around language learning? Getting user come back the next day is the biggest problem to solve." For habit-forming products, next-day return is the most critical metric to optimize.

### Onboarding is the highest-leverage retention investment
Kristen Berman: "I've consistently seen that improving onboarding is one of the highest leverage opportunities for both signup conversion and increasing long term retention. Getting people to your aha moment more quickly and reliably is so incredibly important." Accelerating time to value in onboarding compounds across the entire user lifecycle.

### Define your aha moment with data
Hila Qu: "I think [the aha moment] as a moment, as a first time a user experienced value of your product... At GitLab we actually did a bunch of analysis. We ended up have something along the line of two users, two features used in the first 14 days." The aha moment should be defined by data correlation with retention, often involving multi-user or multi-feature milestones.

### Create mounting loss
Products that retain well make users feel they have more to lose by leaving. This could be data, customization, social connections, or accumulated history.

### Focus on the core loop
Great retention comes from a core product loop that delivers value repeatedly, not from notifications or gamification layered on top of a weak product.

## Questions to Help Users

- "Where in your funnel are you losing the most users? First session? First week? First month?"
- "What specific action, when completed, correlates most strongly with long-term retention?"
- "What do retained users have that churned users are missing?"
- "How does your product get better the more someone uses it?"
- "What would a user lose if they stopped using your product today?"
- "How quickly do new users reach your aha moment?"

## Common Mistakes to Flag

- **Notification spam** - Trying to drive retention through more notifications rather than better product
- **Undefined aha moment** - Not knowing what experience correlates with retention
- **Slow time to value** - Complex onboarding that delays the first moment of user value
- **No mounting loss** - Products that don't accumulate user-specific value over time
- **Optimizing activation over retention** - Focusing on getting users in without ensuring they stay

## Deep Dive

For all 47 insights from 29 guests, see `references/guest-insights.md`

## Related Skills

- pricing-strategy
- product-led-sales
- problem-definition
