# Retention & Engagement - All Guest Insights

*29 guests, 47 mentions*

---

## Albert Cheng
*Albert Cheng*

> "User retention is gold for consumer subscription companies. If you don't retain your users, then a lot of the onus is on getting them to pay on day one."

**Insight:** Retention is the primary driver of success for consumer subscriptions, as it reduces the pressure for immediate monetization.

**Tactical advice:**
- Focus on retention before aggressive day-one upselling.

*Timestamp: 00:00:18*

---

> "When you lose a game now as opposed to surfacing your blunders and your horrible stuff that you did, we flip it on its head and so we show you your brilliant moves, your best moves, and we have coach say something encouraging, 'Losing, just part of learning, keep it up.' That type of thing. That change alone was pretty dramatic for us. It grew game reviews by 25%, subscriptions by 20%, user retention by a lot as well."

**Insight:** Positive reinforcement after a failure (like losing a game) can significantly improve engagement and retention compared to highlighting mistakes.

**Tactical advice:**
- Audit product feedback loops to ensure they are encouraging rather than discouraging after a user failure.
- Surface 'brilliant moves' or successes even in a losing context.

*Timestamp: 00:12:04*

---

> "I think when you have your D one retention somewhere around the 30 or 40% mark, that's quite solid I think for a consumer app. If it's much lower than that, then sometimes I might question the intent of the user or the ability for that, you to I guess acquire just mathematically acquire enough users such that you can grow a big enough daily active user base."

**Insight:** A 30-40% Day 1 retention rate is a healthy benchmark for consumer applications to sustain growth.

**Tactical advice:**
- Benchmark Day 1 retention at 30-40% to validate product-market fit and acquisition scalability.

*Timestamp: 00:29:42*

---

> "It's actually worth spending some time making sure that that resurrected, for lack of a better word, experience inside the product is really excellent and that you find novel ways to try to bring them back."

**Insight:** For mature products, the pool of dormant users is often larger than new users, making resurrection a high-leverage growth lever.

**Tactical advice:**
- Create a specific 'resurrected user experience' that helps returning users catch up or re-onboard.
- Use social notifications (e.g., 'your friend joined') to trigger resurrection.

*Timestamp: 00:33:00*

---

> "Jorge actually had this model of gamification patterns having essentially three pillars to it. You have the core loop, you have the metagame, and then you have the profile."

**Insight:** Effective gamification requires a tight core loop, a long-term metagame for motivation, and a profile that reflects user investment.

**Tactical advice:**
- Build a core loop that rewards daily habits.
- Implement a metagame (like leaderboards or paths) for long-term striving.
- Ensure the user profile reflects their accumulated progress and investment.

*Timestamp: 01:05:08*


## Alexander Embiricos
*Alexander Embiricos*

> "One of the things that I'm constantly reminding myself of is that a tool like Codex naturally is a tool that you would become a power user of... it's just critically important to go look at your D7 retention. Just go try the product, sign up from scratch again."

**Insight:** For AI tools, Day 7 retention is a critical health metric to ensure the product is providing immediate, repeatable value rather than just novelty.

**Tactical advice:**
- Prioritize D7 retention as a primary success metric
- Regularly dogfood the 'first-mile' experience by signing up from scratch to identify onboarding friction

*Timestamp: 00:55:51*


## Aishwarya Naresh Reganti + Kiriti Badam
*Aishwarya Naresh Reganti + Kiriti Badam*

> "In ChatGPT, if you are liking the answer, you can actually give a thumbs up. Or if you don't like the answer, sometimes customers don't give you thumbs down, but actually regenerate the answer. So that is a clear indication that the initial answer that regenerator is not meeting the customer's expectation. So these are the kind of implicit signals you always need to think about."

**Insight:** In AI products, implicit signals like 'regenerations' are often more accurate indicators of user dissatisfaction than explicit feedback like 'thumbs down.'

**Tactical advice:**
- Monitor 'regeneration' rates as a key metric for response quality.
- Track implicit user signals to identify where the product is failing to meet expectations.

*Timestamp: 00:33:47*


## Archie Abrams
*Archie Abrams*

> "The way we think about churn is really going back to Shopify as a kind of our mission and what we want to do, which is to increase the amount of entrepreneurship on the internet. And so as a business, we want to make it as easy as possible to get started with your online store, with your business. But most businesses do ultimately fail. And so the way we look at it is can we lower the barriers to getting started and get as many people in the door trying their hand at entrepreneurship?"

**Insight:** High churn can be an acceptable byproduct of a mission to lower barriers to entry, provided the monetization model captures massive value from the few successful 'winners.'

**Tactical advice:**
- Lower barriers to entry to maximize the number of users attempting to use the product.
- Focus on power-law metrics (like total GMV per cohort) rather than average per-user retention.

*Timestamp: 00:06:48*

---

> "The simplest way to increase my signup to activated thing is just make it harder to sign up. Nuts and bolts, that will always happen is when you have teams on that local conversion rates, you get all these weird team incentives, because they're optimizing to basically implicitly make it harder to do the step before them."

**Insight:** Optimizing for local conversion rates often creates perverse incentives for teams to restrict the top of the funnel to ensure only high-intent users pass through.

**Tactical advice:**
- Monitor if conversion rate improvements are coming at the cost of total volume from the previous funnel step.
- Incentivize teams based on the absolute number of users reaching a milestone rather than the percentage rate.

*Timestamp: 00:25:27*


## Bangaly Kaba
*Bangaly Kaba*

> "It turned out that what was happening anecdotally is that people were revving up Instagram, following a bunch of people, following a lot of celebrities... and then when they actually went to make their first post... none of their friends were following them. And so there was posting into an echo chamber."

**Insight:** Retention is driven by early social validation; ensure new users connect with real-world friends rather than just high-profile accounts.

**Tactical advice:**
- Prioritize human-to-human connections in the onboarding flow to ensure users receive likes and comments on their first posts.
- Reduce 'account access churn' by making it easier for users to log back in via trusted devices or saved credentials.

*Timestamp: 01:18:00*


## Crystal W
*Crystal W*

> "If it's a free product, 60%. It has to be at least 60%. If it's a free product, we go over a week. If it's a paid product, I usually look at that more as maybe 20 to 30%."

**Insight:** High-performing free consumer products should aim for a 60% week-one retention benchmark.

**Tactical advice:**
- Aim for 80% retention among friends and family as an early signal
- Look for the step immediately preceding conversion to identify the highest leverage friction points
- Implement 'pause' or 'snooze' features to prevent permanent churn when users feel overwhelmed

*Timestamp: 00:25:32*


## Dylan Field
*Dylan Field 2.0*

> "I think it is important to get someone into a product and very quickly have them experience some special sauce, something that's amazing about the product... shortening the time to scene and having that incredible moment and seeing the true value of the product."

**Insight:** Shortening 'time to value' by quickly exposing users to the product's 'special sauce' is critical for activation.

**Tactical advice:**
- Identify the 'special sauce' moment and move it earlier in the user journey
- Use collaborative 'multiplayer' moments to demonstrate value quickly

*Timestamp: 00:39:52*

---

> "Specific things that he's encouraged us to focus on are not just innovative features but a consistent emphasis on fixing the blocking issues that might prevent a user from adopting... removing the blockers is as important for retaining users as adding cool new stuff."

**Insight:** Removing adoption blockers is just as important for retention as adding new features.

**Tactical advice:**
- Create a dedicated 'Blockers' team to systematically remove friction points
- Monitor metrics to see how striking down individual blockers improves activation

*Timestamp: 00:42:08*


## Elena Verna
*Elena Verna 2.0*

> "It was 12 months plus of usage that had to happen before sales contracts can be created on sustainable way... it takes a year of usage to escalate the problem from individual to a company-level solution."

**Insight:** The transition from individual product usage to an enterprise-level contract is a long-term cycle, typically taking a year.

**Tactical advice:**
- Measure the time from first sign-up to enterprise contract to set realistic sales expectations
- Monitor behavioral signals like 'admin switches' or visits to 'terms of use' pages as high-intent indicators

*Timestamp: 01:10:02*

---

> "Growth teams are often too obsessed about removing friction... just removing steps or yanking or simplifying things to an oblivion where you lose an identity of what you even do or what you're capable of doing is a completely failed growth tactic."

**Insight:** Removing friction is only effective if it solves user confusion; over-simplification can strip the product of its value and identity.

**Tactical advice:**
- Focus on reducing 'cognitive load' (confusion) rather than just the number of steps in a flow.
- Avoid 'simplifying onboarding' as a standalone goal; ensure it solves a specific problem like lack of education or user drop-off.

*Timestamp: 01:13:03*


## Gia Laudi
*Gia Laudi*

> "Recurring revenue businesses, you cannot think about marketing and growth and the business overall as ending an acquisition, otherwise you're not in business anymore. And the vast, vast majority of these models don't take post-acquisition, retention, expansion, all of that into account."

**Insight:** In SaaS, growth strategy must encompass the entire lifecycle, including post-acquisition retention and expansion, rather than stopping at the point of sale.

**Tactical advice:**
- Incorporate post-acquisition metrics into your growth model
- Focus on retention and expansion as core components of the marketing and growth function

*Timestamp: 00:00:45*

---

> "The only way to catch them if they fall is if you're measuring something meaningful along the way. We have that storyboard that we were talking about. We also have a map where it's the experience to get them to a certain value moment, but then that win back experience to get them back in should they fall out for any reason."

**Insight:** Effective retention requires mapping 'win-back' experiences triggered by specific drops in measurable engagement milestones.

**Tactical advice:**
- Create proactive customer experiences (in-app or email) to guide users to value
- Design reactive 'win-back' flows for users who fail to reach specific milestones

*Timestamp: 00:42:55*


## Gina Gotthilf
*Gina Gotthilf*

> "I really believe that... the most important thing for the growth of anything tech, maybe in general, is retention. Of course, you need acquisition, but retention is important. And I simplify it a little bit because retention, I don't think of it in terms of like, wow, I must retain this user. It's like, is this thing valuable or not? That's what retention is to me. Either it's actually providing real value or it's not. If it's providing real value, people stick around. It's as simple as that."

**Insight:** Retention is the ultimate metric for product value; if users don't stay, the product isn't solving a real problem.

**Tactical advice:**
- Treat retention as a proxy for product-market fit and core value.
- Prioritize understanding why users leave over simply acquiring more users.

*Timestamp: 00:31:38*


## Jackson Shuttleworth
*Jackson Shuttleworth*

> "What Duolingo really focuses on is, how do we help users build habits around language learning? Getting user come back the next day is the biggest problem to solve."

**Insight:** Habit formation is the core driver of long-term retention in learning products.

**Tactical advice:**
- Focus on the daily return as the primary problem to solve.

*Timestamp: 00:00:00*

---

> "We've looked at the data for our retention curves, and what we found is that once you get to seven days, loss aversion kicks in, and you retain. So, going from a one to a two-day streak, huge jump in retention, two to three day streak, slightly less but still huge and it's up until day seven. Once you hit day seven, it flans out."

**Insight:** Loss aversion becomes a powerful retention lever once a user reaches a seven-day milestone.

**Tactical advice:**
- Focus disproportionate experimentation on the zero-to-seven day user experience.
- Use the seven-day mark as the target for 'locking in' user behavior.

*Timestamp: 00:19:13*

---

> "The metric that is most effective, where a percentage change in that metric is most effective at driving DAUs is current user retention rate (CURR). And this is just users who are not new or resurrected, getting them to come back tomorrow."

**Insight:** Current user retention rate is the most sensitive lever for driving overall DAU growth.

**Tactical advice:**
- Prioritize CURR over new user acquisition or resurrection for sustainable growth.

*Timestamp: 00:35:50*


## John Cutler
*John Cutler*

> "Our CS team developed 110-page bulk of research from working directly with customers around retention engagement, then we had a PM and a great content writer, Archana, zero in and kind of make it palatable, then we did ARC for it. So, it didn't just magically appear... It's a company filled with passionate experts of these things, and it was like tested, iterated, tested, iterated, expanded, tested, put into motion, put into practice."

**Insight:** Deep expertise in retention and engagement is built through massive, iterative research projects that combine customer success insights with product management.

*Timestamp: 00:13:17*


## Jules Walter
*Jules Walter*

> "I was able to ship changes in the new user experience, especially on mobile. That moved the needle by a lot, like double-digit percentages... We're talking about top line metrics like activation."

**Insight:** Focusing on the mobile onboarding experience can drive double-digit improvements in user activation metrics.

**Tactical advice:**
- Prioritize the new user experience (onboarding) to impact top-line activation.
- Apply growth frameworks specifically to mobile user flows to find high-leverage improvements.

*Timestamp: 00:08:14*


## Kayvon Beykpour
*Kayvon Beykpour*

> "The reason that the Periscope app failed, it really comes down to a few things. One, we did not address the core problem that retention wasn't good. Our poor retention was mapped by just an incredible surge in top-line user growth."

**Insight:** Explosive top-line growth can dangerously mask underlying retention issues.

**Tactical advice:**
- Prioritize fixing retention issues even during periods of massive user acquisition.

*Timestamp: 01:01:14*


## Kristen Berman
*Kristen Berman*

> "I've consistently seen that improving onboarding is one of the highest leverage opportunities for both signup conversion and increasing long term retention. Getting people to your aha moment more quickly and reliably is so incredibly important."

**Insight:** Onboarding is a critical lever for both initial conversion and long-term retention by accelerating the time to value.

**Tactical advice:**
- Focus on getting users to the 'aha moment' quickly and reliably.

*Timestamp: 02:26*

---

> "We are all present bias, which means we prioritize our present self over our future self, so there are plenty of reasons that somebody, your customer, your user should take an action, but you actually have to give them a reason to take an action today."

**Insight:** To drive engagement, products must provide immediate benefits to satisfy the user's present bias rather than just long-term value.

**Tactical advice:**
- Build in immediate rewards like completion checkboxes or social notifications to provide instant gratification.

*Timestamp: 22:30*

---

> "When you want to get somebody to do something more, you make it easier. When you want someone to do something less, you make it... Put up barriers."

**Insight:** To decrease negative user behaviors (like sharing misinformation), introduce intentional friction or 'barriers'.

**Tactical advice:**
- Use 'Are you sure?' popups or labels to slow users down in a 'hot state'.
- Introduce logistical friction to redirect users toward better behaviors.

*Timestamp: 30:36*


## Laura Schaffer
*Laura Schaffer*

> "The analogy I have for this is pilling a hot dog. So if anyone's got a dog or an animal you have to feed a pill to, it's like you can't just feed the pill to the animal, it's never going to happen. But if you shove it inside of a hot dog, which looks good and that's exciting, then you can get them to consume it more easily."

**Insight:** Improve onboarding conversion by embedding intimidating but necessary steps inside familiar, 'safe' experiences.

**Tactical advice:**
- Identify the 'bogeyman'—the specific step that psychologically trips up your users
- Bury scary technical tasks (like configuring a phone number) inside comfortable environments (like documentation)
- Prioritize the user's psychological readiness over the logical sequence of setup steps

*Timestamp: 00:32:53*


## Lauryn Isford
*Lauryn Isford*

> "Onboarding is that first really important choke point that from which downstream of onboarding so many important metrics and results flow for the business, from converting someone to a paid customer to closing a deal to growing, how many people in an organization are using your product. So, all of that really comes back to onboarding and if you can get that right, lots of good things will follow."

**Insight:** User onboarding is the most critical growth lever because it dictates all downstream retention and monetization metrics.

**Tactical advice:**
- Treat onboarding as the primary gateway to long-term retention
- Focus on reducing cognitive load during the initial user experience
- Align onboarding goals with the user's desired outcome rather than the business's feature list

*Timestamp: 00:12:22*


## Madhavan Ramanujam
*Madhavan Ramanujam 2.0*

> "To stop churn, you need to attract customers who won't leave. That sounds counterintuitive, but that's the best way to actually stop churn... The way to stop churn is to start acquiring customers who won't leave. And that is the most important thing. So if you look back at your data and say, 'Who are the types of customers who actually tend to stay longer?'"

**Insight:** The most effective way to manage churn is through 'top-of-funnel' retention—acquiring the specific customer segments that naturally have higher stickiness.

**Tactical advice:**
- Analyze historical data to identify characteristics of long-term, loyal customers
- Focus acquisition spend on segments with naturally high retention rates

*Timestamp: 00:56:29*


## Nick Turley
*Nick Turley*

> "We don't care at all how much time you spend in the product. In fact, our incentive is just to solve your problem and if you really like the product, you'll subscribe, but there's no incentive to keep you in the product for long."

**Insight:** For utility-based AI, retention is driven by problem-solving efficiency rather than time-spent metrics.

**Tactical advice:**
- Optimize for 'time to value' rather than 'time spent'
- Monitor 'smile curves' in retention where users return and increase usage as they learn to delegate to AI

*Timestamp: 00:26:39*


## Nikita Bier
*Nikita Bier*

> "If you can't demonstrate value in the first three seconds, it's over... You really have to craft onboarding everything to ensure that that's where the design part comes in."

**Insight:** The 'Aha moment' must occur almost instantly in modern consumer apps due to extremely short attention spans.

**Tactical advice:**
- Invert the time-to-value so the core experience happens within seconds of opening the app
- Eliminate any onboarding steps that delay the primary value proposition

*Timestamp: 01:27:18*


## Patrick Campbell
*Patrick Campbell*

> "There is strategic retention and then there's tactical retention... tactical retention, it's typically about 25 to 40% of your churn problem, which is a significant amount, but you don't really look at it because again, you're like, 'I've got to go focus on features.'"

**Insight:** A significant portion of churn is 'tactical' (e.g., credit card failures) and can be solved with simple marketing funnels rather than complex product changes.

**Tactical advice:**
- Optimize cancellation flows by asking 'Why are you leaving?' followed by 'What did you like about the product?'
- Implement automated recovery funnels for failed credit card payments
- Offer salvage offers, pause plans, or maintenance plans during the offboarding process

*Timestamp: 00:24:38*


## Sahil Mansuri
*Sahil Mansuri*

> "Take your best sales people and make them CSMs... What we cannot under any circumstances do is lose our existing customers because replacing them is going to be impossible. So it's kind of like you got your leaky bucket, you got to patch that leak really, really fast and really hard."

**Insight:** In a downturn, prioritize protecting existing revenue by moving top sales talent into customer success roles.

**Tactical advice:**
- Move top-performing Account Executives to Customer Success (CSM) roles
- Shift product marketing to focus on research and benchmarks for existing customers
- Create exclusive content or data reports that help current customers survive the downturn

*Timestamp: 00:43:59*


## Sarah Tavel
*Sarah Tavel*

> "The test for me, of whether you're building a product that has the ingredients to create a retentive product on a micro level, just at the user level, is that the product should get better the more you use it, and you'll have more to lose by leaving it."

**Insight:** True retention is built when a product creates accruing benefits and mounting loss for the user over time.

**Tactical advice:**
- Ensure the product experience personalizes or improves based on user input
- Create 'mounting loss' by making the product a repository for user identity or data

*Timestamp: 00:11:03*

---

> "I particularly love to look at that on a weekly active user completing the core action pieces of like, are users completing the core action? How is that changing overtime for each of the cohorts? And then also, looking at activity level within those cohorts."

**Insight:** Retention should be measured by the percentage of users in a cohort who consistently perform the product's core action.

**Tactical advice:**
- Track weekly cohorts based on sign-up date
- Monitor the 'smile graph' where users become more retained over time rather than just dwindling

*Timestamp: 00:28:00*

---

> "Until you reach a point with your cohorts where there is a plateau, you have more work to do on figuring out the retention of your users."

**Insight:** A product only has a viable foundation when cohort retention curves eventually flatten out rather than dropping to zero.

**Tactical advice:**
- Analyze cohort plateaus to determine if the 'leaky bucket' problem is solved

*Timestamp: 00:29:04*

---

> "The happiness loop, the idea is you have a lot of new sellers coming in, and of course you have new buyers, but you want to make sure that you are matching your buyers with the sellers that are going to give them the best experience."

**Insight:** In marketplaces, retention is driven by 'happiness loops' that identify and reward high-quality participants while filtering out poor ones.

**Tactical advice:**
- Use search ranking to reward suppliers who provide the best user experience
- Allow for healthy churn of low-quality suppliers to protect the buyer experience

*Timestamp: 01:08:23*


## Sean Ellis
*Sean Ellis*

> "It's usually much more function of onboarding to the right user experience than it is about the kind of the tactical things that people try to do to improve retention."

**Insight:** Retention is primarily driven by successful initial activation rather than late-stage re-engagement tactics.

**Tactical advice:**
- Prioritize activation and onboarding over late-stage retention features.
- Focus on 'speed to value' to ensure users reach the 'aha moment' quickly.

*Timestamp: 00:13:57*

---

> "One of the things I've always said is just ignore the people who say they'd be somewhat disappointed. They're telling you it's a nice to have. They're as good as gone, so just ignore those guys."

**Insight:** Engagement efforts should be concentrated on users who find the product essential to avoid building for the wrong audience.

**Tactical advice:**
- Segment your engagement data by user sentiment (must-have vs. nice-to-have).

*Timestamp: 00:40:43*


## Sri Batchu
*Sri Batchu*

> "At Facebook, it was 10 friends the first seven days. At Instacart, it was three orders in the first month. And at Ramp, for our activation... we've got four events that the customer needs to do in the first 30 days."

**Insight:** Identify the specific 'escape velocity' actions that correlate with long-term user retention to focus activation efforts.

**Tactical advice:**
- Analyze data to find the number of key actions in a specific timeframe that predict long-term engagement
- Align the activation team specifically around driving those 'magic number' events

*Timestamp: 00:44:39*


## Sriram and Aarthi
*Sriram and Aarthi*

> "Facebook knew that it needed to get you to 10 friends in 14 days. If you got your 10 friends in 14 days, you were probably going to use Facebook."

**Insight:** Identifying a specific activation milestone (like 10 friends in 14 days) is critical for driving long-term retention.

**Tactical advice:**
- Identify the 'magic number' of actions or connections that correlates with long-term retention.
- Prioritize new user experiences that drive users toward that specific milestone.

*Timestamp: 00:00:00*


## Zoelle Egner
*Zoelle Egner*

> "I think they [templates] can be tremendously helpful if you are horizontal because they help to narrow the surface area for a user, so they understand how to connect the dots between their problem and your product."

**Insight:** Templates drive retention by reducing the cognitive load required for a user to find value in a horizontal product.

**Tactical advice:**
- Use templates to narrow the 'surface area' for new users
- Focus templates on specific use cases rather than generic product features
- Leverage templates to facilitate expansion within existing company accounts

*Timestamp: 00:58:38*


## Hila Qu
*Hila Qu*

> "I think [the aha moment] as a moment, as a first time a user experienced value of your product... At GitLab we actually did a bunch of analysis. We ended up have something along the line of two users, two features used in the first 14 days."

**Insight:** The 'Aha Moment' is the first time a user experiences the core value, often defined by a specific usage threshold.

**Tactical advice:**
- Define the 'Aha Moment' based on data correlation with retention
- Look for multi-user or multi-feature usage milestones in collaborative products

*Timestamp: 00:38:32*

---

> "I think how I think about retention, there are two steps. One is how to build a habit in their usage pattern, so that they are using this maybe every week, every day. The key to do that is, first of all, your product need to have a high enough frequency. If you are using this once per month, it's not likely you can build this into a habit."

**Insight:** Retention is driven by habit formation, which requires a product with high usage frequency.

**Tactical advice:**
- Build habit-forming or collaboration features directly into the workflow
- Identify or add high-frequency use cases to the product

*Timestamp: 00:56:08*

---

> "The second part around retention is I actually think extension is part of retention. Basically you already have a steady usage flow... What are the right moment to prompt you to think about maybe buying more? And there are three buckets of product-led extension. The first one is up upgrade to a higher tier. The second one is buying more seeds, buying more license. The third one is if you have some sort of a consumption add-on component."

**Insight:** Expansion revenue (upsells and seat growth) should be treated as a component of the retention strategy.

**Tactical advice:**
- Trigger upgrade prompts based on specific usage data signals
- Offer consumption-based add-ons to increase account value

*Timestamp: 00:56:08*


## Josh Miller
*Josh Miller*

> "what I'm really proud of is, 12 months later we've been inching it up and up and up, despite getting further away from the earliest most passionate adopters. So, our retention curve's going up and up a little bit"

**Insight:** The ultimate sign of product health is a retention curve that improves cohort-over-cohort even as you expand beyond early adopters.

**Tactical advice:**
- Monitor cohort-over-cohort retention improvements to validate product changes
- Look for 'D5/D7' retention in the low-to-mid 30s or 40s for high-utility software

*Timestamp: 00:07:37*


