---
name: running-decision-processes
description: Help users run effective decision-making processes. Use when someone is facing a high-stakes decision, dealing with analysis paralysis, needs to align stakeholders on a choice, or wants to establish decision frameworks like DACI or RAPID.
---

# Running Decision Processes

Help the user run effective decision-making processes using frameworks from 65 product leaders.

## How to Help

When the user asks for help with decision processes:

1. **Understand the decision type** - Ask if this is reversible or irreversible, high-stakes or routine
2. **Identify the blockers** - Determine what's preventing the decision from being made
3. **Structure the process** - Recommend an appropriate framework for the decision at hand
4. **Enable commitment** - Help them move from deliberation to action

## Core Principles

### Hesitation is destructive
Ben Horowitz: "The worst thing that you do as a leader is you hesitate on the next decision. The thing that causes you to hesitate is both decisions are horrible." Failing to make an explicit decision causes organizational anxiety. Recognize when you're avoiding a decision because all options are bad.

### Make implicit explicit
Annie Duke: "It's so incredibly necessary in improving decision quality to take what's implicit and make it explicit. It's not that intuition is crap... If you don't make it explicit, then you don't get to find out when it's wrong." Document the assumptions behind gut feelings so you can review them later and learn when intuition is right or wrong.

### Use curiosity loops for advice
Ada Chen Rekhi: "A curiosity loop is essentially going to a whole bunch of people... asking them, 'Hey, here are nine topics... What are two or three of the topics that resonate with you and why?'" Gather contextual advice by asking specific questions that solicit rationale, not biased yes/no answers.

### Act as a historian
Anneka Gupta: "I try to construct this past knowledge of what had happened and what were the decisions that were made and why were those decisions made, whether they were good or bad." Research past failed projects to understand the context of previous decisions and navigate current resistance.

### High-conviction decisions require leaps of faith
Brandon Chu: "Know how to make really, really hard high conviction decisions that actually can't be solved. You got to take a leap of faith and how to do that and bring teams through that type of ambiguity." Some decisions cannot be solved with data - take the leap and maintain high accountability for the choice.

### Distinguish decision types
Jeff Bezos: "Type 1 decisions are consequential and irreversible... Type 2 decisions are changeable, reversible." Spend more time on one-way doors. Move fast on reversible decisions.

### Disagree and commit
Once a decision is made, the team must commit fully even if individuals disagreed during deliberation. Without commitment, decisions get relitigated endlessly.

### Assign a clear decision-maker
Every decision needs a single accountable owner. Frameworks like DACI (Driver, Approver, Contributor, Informed) clarify who makes the call.

## Questions to Help Users

- "Is this a one-way door or a two-way door? How hard would it be to reverse this decision?"
- "What's the cost of waiting another week to decide? What's the cost of being wrong?"
- "Who is the single decision-maker here? Does everyone know who that is?"
- "What information would change your mind? Can you get that information quickly?"
- "What happened last time the team faced a similar decision?"
- "If you had to decide right now with the information you have, what would you choose?"

## Common Mistakes to Flag

- **Analysis paralysis** - Gathering more data when enough information already exists to decide
- **Decision by committee** - No clear owner leading to diffused accountability
- **Treating all decisions equally** - Applying the same rigor to reversible and irreversible decisions
- **Relitigating decisions** - Reopening settled decisions without new information
- **Implicit assumptions** - Making gut decisions without documenting the reasoning for later learning

## Deep Dive

For all 82 insights from 65 guests, see `references/guest-insights.md`

## Related Skills

- running-effective-meetings
- planning-under-uncertainty
- prioritizing-roadmap
