# Running Decision Processes - All Guest Insights

*65 guests, 82 mentions*

---

## Ada Chen Rekhi
*Ada Chen Rekhi*

> "A curiosity loop is essentially going to a whole bunch of people. In this case, I sent out an email very quickly to about 10 or 11 people and asking them, 'Hey, here are nine topics for Lenny's Podcast. What are two or three of the topics that resonate with you and why?'"

**Insight:** Use a structured 'Curiosity Loop' to gather contextual advice from a curated group to fight the bias of generic, non-contextual advice.

**Tactical advice:**
- Ask specific questions that solicit rationale rather than biased 'yes/no' answers.
- Curate a mix of subject matter experts and people who know you personally.
- Make the ask lightweight (e.g., 'pick top 2 of 9') to ensure a high response rate from busy people.
- Close the loop by processing the info and thanking participants for their impact on your decision.

*Timestamp: 00:04:08*

---

> "I looked at those values and I said, 'Well, if I draw a straight line from where I am right now and just extend it forward and play the rest of the movie as it plays out, given the current plot line, how well does that optimize for those values?'"

**Insight:** Use a personal values stack-rank as an 'internal scorecard' to evaluate if major life and career decisions align with your core identity.

**Tactical advice:**
- Filter a broad list of value words down to a top 3-5 list.
- Apply these values to specific opportunities to see if they pass or fail your internal criteria.
- Prioritize the 'inner scorecard' (personal fulfillment) over the 'outer scorecard' (status, wealth, titles).

*Timestamp: 00:37:12*


## Alisa Cohn
*Alisa Cohn*

> "How do we decide when we disagree? And that is a very good thing to explore because there's actually a lot of different ways to decide when you disagree... let's assume that the person who cares the most can win that argument. It might be, the person who's got the best perspective and the most expertise can win that argument."

**Insight:** Establishing a 'tie-breaking' protocol in advance prevents stalemates and resentment during disagreements.

**Tactical advice:**
- Decide if the 'most passionate' person wins or the 'most expert' person wins
- Consider a 'back and forth' system where partners take turns making the final call

*Timestamp: 01:05:57*


## Ami Vora
*Ami Vora*

> "As you get senior, the only problems you'll see are ones that are fundamentally unsolvable because otherwise, someone would've solved it before they got to you. And so all you're doing is choosing which branch of suboptimal you're going to put your name on and describing the principles you're using."

**Insight:** Senior leadership decisions are often about choosing the best possible 'suboptimal' path among difficult trade-offs.

**Tactical advice:**
- Acknowledge when a decision is suboptimal but necessary.
- Clearly communicate the principles and context used to arrive at a difficult choice.

*Timestamp: 01:01:59*


## Annie Duke
*Annie Duke*

> "It's so incredibly necessary in improving decision quality to take what's implicit and make it explicit. It's not that intuition is crap, your intuition is sometimes right. If you don't make it explicit, then you don't get to find out when it's wrong."

**Insight:** High-quality decision-making requires moving from 'gut feel' to explicit models that can be tested and refined.

**Tactical advice:**
- Document the implicit assumptions behind a 'gut' feeling.
- Review these explicit assumptions later to see where your intuition was right or wrong.

*Timestamp: 00:00:00*

---

> "There is no such thing as a long feedback loop. And the way you choose to shorten the feedback loop is to say, what are the things that are correlated with the outcome that I eventually desire?"

**Insight:** You can shorten any feedback loop by identifying and tracking leading indicators that are necessary for the final desired outcome.

**Tactical advice:**
- Identify 'necessary but not sufficient' milestones (e.g., funding at Series A as a proxy for a 10-year exit).
- Track these intermediate signals to evaluate decision quality in real-time.

*Timestamp: 00:00:40*

---

> "The word alignment is stupid... because it doesn't exist. You have 10 people in a room and they're all really different people with different opinions, and they're never going to come out of the room agreeing with each other. And it's really bad if the expectation is that they're supposed to... the meeting becomes coercive."

**Insight:** Seeking 'alignment' often leads to coercion; instead, aim for a process where everyone is heard, even if they don't agree with the final decision.

**Tactical advice:**
- Shift the goal from 'agreement' to 'conveying information.'
- Use the 'Nevertheless' framework: acknowledge the input, then state the decision path.

*Timestamp: 00:31:39*


## Anneka Gupta
*Anneka Gupta*

> "I try to construct this past knowledge of what had happened and what were the decisions that were made and why were those decisions made, whether they were good or bad it didn't matter, so that I could better understand how to make decisions going forward and to learn from the mistakes that I didn't personally live through."

**Insight:** Acting as a 'historian' helps leaders avoid past mistakes and navigate the emotional 'baggage' teams may have regarding certain strategies.

**Tactical advice:**
- Research past failed products or projects to understand the context of previous decisions.
- Ask long-tenured employees about the history of specific initiatives to understand current resistance.

*Timestamp: 00:29:07*

---

> "It's not about making the right decision, it's about making the decision. ... as long as your decision is like 70% right, you can iterate on that 20, 30% in either direction, but if you don't commit, then you don't actually get any new information that is high fidelity and high quality."

**Insight:** Decisiveness with imperfect information is superior to analysis paralysis because it generates real-world data for iteration.

**Tactical advice:**
- Commit to a decision once you have roughly 70% of the necessary information.
- Reward the 'learning' from a decision rather than just the outcome to encourage risk-taking.

*Timestamp: 00:30:42*


## Austin Hay
*Austin Hay*

> "This concept of thinking gray is so often in life and in our jobs, we are forced to make decisions very quickly. We have to think black or white about a problem set or a solution, and then decide. One of his tactics is this concept of thinking gray, which is actually to not decide for as long as you possibly can before you have to decide."

**Insight:** Delaying a decision until the last possible moment ('Thinking Gray') allows for more information gathering and better outcomes.

**Tactical advice:**
- Resist the urge to make immediate binary decisions when faced with pressure from stakeholders.
- Use the extra time to see if the problem evolves or if better solutions emerge.

*Timestamp: 01:12:26*


## Archie Abrams
*Archie Abrams*

> "Every single project that goes out has a few minute video with Figmas and everything, and everything that shipped. Needs to be okay-toed, so approved by the group lead. There's nothing that can ship without that okay-to approval. And that okay-to approval has to be Glen, Carl, myself with different groups."

**Insight:** A centralized 'okay-to' approval process ensures a consistent bar for quality and taste across a large, decentralized organization.

**Tactical advice:**
- Require a short video demo and design walkthrough for every project before it can be released.
- Designate specific 'taste-makers' or group leads who must personally approve all shipments to maintain a high quality bar.

*Timestamp: 00:52:12*


## Ben Horowitz
*Ben Horowitz*

> "The worst thing that you do as a leader is you hesitate on the next decision. The thing that causes you to hesitate is both decisions are horrible."

**Insight:** Hesitation is the most destructive leadership trait, often caused by having to choose between two poor options.

**Tactical advice:**
- Avoid the trap of avoiding a subject because both outcomes are bad
- Recognize that failing to make an explicit decision causes organizational anxiety

*Timestamp: 00:00:00*

---

> "The psychological muscle you have to build to be a great leader is to be able to click in the abyss and go, 'Okay, that way's slightly better. We're going to go that way. If everybody agrees with the decision, then you didn't add any value because they would've done that without you.' So the only value you ever add is when you make a decision that most people don't like."

**Insight:** True leadership value is created when making difficult, unpopular decisions that the organization wouldn't reach on its own.

**Tactical advice:**
- Build the psychological strength to choose the 'slightly better' path even in dire situations
- Measure your value by the decisions you make that lack consensus

*Timestamp: 00:00:29*

---

> "really, it's like all plane crashes are a series of bad decisions. And none of the decisions by themselves is that bad, but when you add them up, it's bad... if you can break psychologically, you can take the sunk cost, then that gets you out of a lot of bad paths."

**Insight:** Failure is often a cumulative result of small bad decisions; success requires the ability to ignore sunk costs and pivot.

**Tactical advice:**
- Identify and break the chain of small bad decisions before they accumulate
- Willingly accept sunk costs to exit a failing path

*Timestamp: 00:06:14*

---

> "What happens to as CEO, it's like, 'Okay, if we rearchitect, this product, the architecture is not actually get us to where we need to go. I kind of know that. But if we rearchitect it, we're going to probably miss all the features, miss the quarter, have trouble raising money, shudder, et cetera. So that's really bad. And then not rearchitecting is really bad, and so I'm just going to try to and avoid this subject because I don't even want to deal with either of those.' And that's the worst thing, because if action is the better choice and that's good."

**Insight:** Avoiding a 'lose-lose' decision is worse than picking the slightly better of two bad options.

**Tactical advice:**
- Run towards the 'pain in the darkness' rather than avoiding difficult trade-offs
- Trust your eyes and act on what you see rather than waiting for a perfect option

*Timestamp: 00:11:16*


## Bill Carr
*Bill Carr*

> "The data rarely makes the decision for you. What is happening is then a lot of judgment and interpretation of the data, weighing that, weighing various factors to then come to a decision. That is sort of the right a lot part. The right a lot part comes from having what we call sort of sound judgment, which generally come... Some people maybe are born with this, not a lot of them, mostly they get it through experience."

**Insight:** Decision-making is an exercise in judgment and data interpretation, not just following raw numbers.

**Tactical advice:**
- Develop sound judgment by observing others and learning from past mistakes
- Acknowledge that data informs but rarely dictates the final decision

*Timestamp: 00:33:03*


## Brandon Chu
*Brandon Chu*

> "know how to make really, really hard high conviction decisions that actually can't be solved. You got to take a leap of faith and how to do that and bring teams through that type of ambiguity and then how to lead by example and have accountability when you make those choices."

**Insight:** High-level leadership requires the ability to make high-conviction decisions in the face of unsolvable ambiguity.

**Tactical advice:**
- Take leaps of faith when data cannot solve the problem
- Maintain high accountability for the choices made

*Timestamp: 08:05*

---

> "the first thing it argues is that the most important thing to figure out when you're dealing with any decision is actually figuring out how important that decision is. Since we're faced with hundreds of decisions in any given moment around the product or whatever, and that we're only human and we can only prioritize a few, you got to figure out the importance of them so you can prioritize. And so it talks about things like either decision reversible or not."

**Insight:** The most important part of decision-making is categorizing the importance and reversibility of the decision to manage your own cognitive load.

**Tactical advice:**
- Evaluate if a decision is reversible or one-way before committing deep analysis
- Spend the vast majority of your time on the 1% of decisions that are truly critical
- Delegate or use gut instinct for low-importance, reversible decisions to maintain team velocity

*Timestamp: 36:36*


## Brian Chesky
*Brian Chesky*

> "If you want to improve the speed of a company, then make faster decisions. And fast decisions come from a bias of action. If we're in a meeting, we don't just say, 'Okay, let's circle back on this next week.' No, we'll have it done by next week. Let's stay in this meeting until it's done."

**Insight:** Organizational speed is a direct result of decision-making velocity and a bias for immediate action.

**Tactical advice:**
- Avoid 'circling back' by making decisions in the room
- Set a high tempo for follow-ups (e.g., check-ins within hours or the next morning)

*Timestamp: 00:47:22*


## Claire Hughes Johnson
*Claire Hughes Johnson*

> "If you're not sure who the decision maker is, one, it's probably you. And I'd rather you act that way than not because you're going to like slow the whole company down. Follow a process and get it done, and don't forget to actually make a decision."

**Insight:** In high-growth environments, individuals should default to ownership of decisions when the owner is unclear to maintain organizational momentum.

**Tactical advice:**
- Assume you are the decision maker if it's unclear to avoid slowing down the company
- Ask explicitly who the decision maker is if you are worried it is not you

*Timestamp: 00:00:00*

---

> "In the book, I talk about this framework that Bezos uses, type one, type two decisions. Is it high impact? Is it irreversible? Is it not? Really evaluate, what kind of decision is this? How hard is it? And then follow a process and get it done."

**Insight:** Categorizing decisions by their impact and reversibility helps determine the appropriate speed and process for making them.

**Tactical advice:**
- Evaluate if a decision is Type 1 (high impact, irreversible) or Type 2 (reversible)
- Use frameworks like SPADE to make the decision criteria and owner explicit

*Timestamp: 01:18:52*


## Dharmesh Shah
*Dharmesh Shah*

> "the calories you spend on a decision should be proportional to the consequences of that decision... He calls them one-way doors versus two-way doors... I'm taking it one level further, which is, it literally should be proportional."

**Insight:** Decision-making effort should be mathematically proportional to the impact and reversibility of the outcome.

**Tactical advice:**
- Identify the factors/variables that should impact a decision before choosing an option.
- Stack-rank the importance of those factors to guide the final choice.

*Timestamp: 01:07:21*

---

> "ours is debate, decide, unite. That's our kind of phrase that we use in HubSpot culture... once you make a decision, getting alignment around that decision... is extremely important"

**Insight:** A successful decision process requires open debate followed by total commitment from all parties, even those who disagreed.

**Tactical advice:**
- Designate a single person to make the final decision (DRI).
- Use the 'Unite' phase to ensure the team moves forward without lingering dissent.

*Timestamp: 01:04:42*


## Eeke de Milliano
*Eeke de Milliano*

> "Is it a trapdoor decision? Which I think is an Amazon concept. One-way door, or two-way door... Stripe was actually really good at being rigorous... about what actually was a trapdoor decision."

**Insight:** Distinguish between reversible (two-way door) and irreversible (one-way door) decisions to maintain velocity.

**Tactical advice:**
- Categorize decisions as 'trapdoor' or 'reversible' before debating them
- Move faster on reversible decisions like pricing by grandfathering existing users

*Timestamp: 00:16:01*


## Eoghan McCabe
*Eoghan McCabe*

> "It is the responsibility of the CEO to make brave and hard decisions unilaterally, yes, using their experts as inputs and be responsible for the outcome. If I make decisions that propel the company in the way that thankfully my decisions have, I get rewards and kudos... If I don't, I get fired."

**Insight:** High-stakes transformation requires a top-down, founder-led decision model rather than a democratic committee approach.

**Tactical advice:**
- Use experts for input but avoid 'decision by committee.'
- Take full personal responsibility for the results of unilateral decisions.

*Timestamp: 00:31:50*


## Eric Ries
*Eric Ries*

> "If you're asking whether you should pivot or not you probably know the answer already... give yourself a fixed period of time to take some decisive action and see if it feels better."

**Insight:** The need for a pivot is usually felt before it is admitted; use time-boxed experiments to force a decision.

**Tactical advice:**
- Set a fixed period (e.g., six weeks) to move the needle
- Focus 100% on the one thing that matters
- Have everyone state what they would do if they could start over

*Timestamp: 01:13:49*


## Ethan Evans
*Ethan Evans 2.0*

> "Bias for action says speed matters in business and many decisions are reversible. And so it's important to go faster. And I think people don't understand that in a competitive environment, being right is good, but being quick is necessary."

**Insight:** Speed is a competitive necessity, particularly for reversible decisions where the cost of delay outweighs the cost of a mistake.

**Tactical advice:**
- Distinguish between reversible and irreversible decisions to determine appropriate speed
- Actively work to disconfirm your own beliefs to remain open to new evidence
- Seek diverse perspectives to ensure decisions aren't limited by a narrow viewpoint

*Timestamp: 01:03:28*


## Gaurav Misra
*Gaurav Misra*

> "As long as it's possible for wherever it's like a two-way door, you can do whatever you want... If it's A one-way door, it's worth thinking about and sort of doing correctly."

**Insight:** Use the one-way/two-way door framework to determine the appropriate level of rigor for technical and product decisions.

**Tactical advice:**
- Move fast on two-way door decisions that are easily reversible.
- Slow down and apply more thought to one-way door decisions that impact long-term architecture.

*Timestamp: 00:23:54*


## Gibson Biddle
*Gibson Biddle*

> "Is this a high stakes decision or a low stakes decision? ... magnitude ... and then, is it reversible? Amazon calls those, this was a two-way door decision. It's reversible. The one way door, those are the bigger deal."

**Insight:** Categorize decisions by their magnitude and reversibility to determine the appropriate level of speed and caution.

**Tactical advice:**
- Determine if a decision is a 'one-way door' (irreversible) or 'two-way door' (reversible)
- Assess the magnitude of the decision relative to the total business revenue
- Empower teams to move faster on reversible, low-magnitude decisions

*Timestamp: 28:04*


## Heidi Helfand
*Heidi Helfand*

> "She taught us the RIDE framework for decision making clarity and it's who's requesting the change, who can give input to the change, who's the decider on the change, and who's going to execute on the change? So it's like R-I-D-E."

**Insight:** The RIDE framework provides clarity by defining specific roles for requesting, informing, deciding, and executing a change.

**Tactical advice:**
- Identify the Requester (R) who initiates the change
- Identify those who provide Input (I) to the process
- Clearly designate the Decider (D) who has final authority
- Assign the Executor (E) responsible for the rollout

*Timestamp: 00:14:11*


## Gustaf Alstromer
*Gustaf Alstromer*

> "Small startups agree on how they decide together. So after that, everyone just follow the process. That's usually how things work out... I think you just have to have a process so you don't rehash every decision after you made them a million times."

**Insight:** The specific decision-making style matters less than having a consistent, agreed-upon process that prevents rehashing.

**Tactical advice:**
- Define clear areas of expertise where individual founders have final say
- Commit to a decision once the process is complete to maintain velocity

*Timestamp: 00:55:42*


## Hari Srinivasan
*Hari Srinivasan*

> "We've put in things like we have something called RAPID, which is a really easy way to know who the decision-maker is... The R is for who's recommending it. The A, who has to agree. The I is for other people who may be able to be putting in an input. It's basically a list of people who need to be in the decision chain."

**Insight:** Use structured frameworks like RAPID to clarify roles and prevent bottlenecks in complex organizations.

**Tactical advice:**
- Ensure every decision has a single person named as the 'D' (Decision-maker)
- Implement a five-day escalation rule to resolve misalignments quickly
- If you have three back-and-forth emails, pick up the phone to reach a decision

*Timestamp: 00:37:35*


## Jackson Shuttleworth
*Jackson Shuttleworth*

> "Duolingo has very much, has a strong test it philosophy, we're willing to test a lot of different... Honestly, we'd much rather test it than debate it for days and days."

**Insight:** High-velocity experimentation is more efficient than prolonged internal debate.

**Tactical advice:**
- Default to A/B testing rather than long meetings when the cost of the test is low.

*Timestamp: 00:15:03*


## Jake Knapp + John Zeratsky
*Jake Knapp + John Zeratsky 2.0*

> "We're using this tactic that we call work alone together. And specifically the note and vote is this method where everyone's in silence... writing down their own answers to this question... then the team's going to vote on those. And then one person who's designated as the decider... is going to say, 'Okay, this is our decision for now.'"

**Insight:** Using structured silence and a designated decider allows teams to move through complex strategic choices at high velocity without groupthink.

**Tactical advice:**
- Use 'Note and Vote': individuals write ideas in silence, then the team votes.
- Designate a 'Decider' (usually the CEO or CPO) to make the final call after seeing the team's input.

*Timestamp: 00:21:38*


## Jason Fried
*Jason Fried*

> "I don't know how to make decisions by numbers or I don't find any joy in it, frankly. I've always been intuition driven and gut driven. And frankly, to be honest, I think everyone actually is... I think everything's a judgment call."

**Insight:** Acknowledge that most business decisions are ultimately judgment calls based on experience and intuition rather than purely rational data analysis.

**Tactical advice:**
- Value 'judgment and experience' as the primary criteria for executive decision-making
- Use data as one input among many, rather than the sole decider
- Ask 'How does this feel?' to tap into the team's collective intuition

*Timestamp: 00:44:15*


## Jerry Colonna
*Jerry Colonna*

> "Why is it that nobody on my team can make a decision without me? ... How does it make you feel when they make a decision that you disagree with? She said, 'I'm furious.' ... That's your growth edge. How can I be with the people in my life making boneheaded decisions about something that I care so much about?"

**Insight:** Decision-making bottlenecks are often emotional issues for the leader rather than process issues for the team.

**Tactical advice:**
- Examine your emotional reaction to team members making 'wrong' decisions.
- Shift from controlling decisions to managing the relationship and the 'growth edge' of allowing others to lead.

*Timestamp: 01:17:28*


## Jeremy Henrickson
*Jeremy Henrickson*

> "We're in the middle of a meeting, we need to make a decision. Let's either make the decision or if we can't, let's Slack call in the person that we need in order to make that decision. And we'll be done with the decision today."

**Insight:** High-velocity organizations prioritize immediate decision-making over scheduling future meetings.

**Tactical advice:**
- Pull necessary stakeholders into current meetings via Slack or calls to resolve blockers immediately
- Value the tempo of decision-making as a core cultural differentiator

*Timestamp: 00:27:15*

---

> "I am anti-process as a substitution for deep product thinking... I like to have just enough process to create a frame so that the right decisions can happen and no more."

**Insight:** Process should facilitate thinking rather than replace it; the right amount of process depends on the team's specific lifecycle.

**Tactical advice:**
- Avoid dogmatically applying frameworks like Scrum or Kanban if they don't fit the team's context
- Use process only to create a frame for decision-making

*Timestamp: 00:45:54*


## Jessica Hische
*Jessica Hische*

> "I feel like my strength with the work that I do in general is just being incredibly decisive and understanding that there's 10 good answers to every one question... I feel like I can look at 10 gray sofas and go, it feels like there's two or three categories of sofa here, and then within those categories, there's a couple of good options. Here's a brand that I recognize is known for being of high quality. That one's good enough. I can get to it really quickly."

**Insight:** Decisiveness comes from recognizing that multiple 'good' paths exist and choosing the most intuitive one rather than seeking a single 'perfect' answer.

**Tactical advice:**
- Categorize options into 2-3 buckets to simplify complex decision-making.
- Accept 'good enough' quickly to maintain momentum rather than over-analyzing every possible variation.

*Timestamp: 01:18:09*

---

> "Nothing is ever 100% perfect, and the most you can aspire and get to is 99.8 or whatever. That last 0.2%, you could spend your whole life trying to do that, or you could move on and do other things and understand that it's nearly perfect."

**Insight:** The final 0.2% of perfection often yields diminishing returns; recognize when a project is 'nearly perfect' and move on.

**Tactical advice:**
- Identify the point of diminishing returns in creative or technical work.
- Prioritize moving on to new projects over the exhaustive pursuit of absolute perfection.

*Timestamp: 01:18:09*


## Joe Hudson
*Joe Hudson*

> "What it tells us, and this is not exact, I'm paraphrasing for a podcast, but we make decisions in the emotional center of our brain. We use logic to try to figure out how we're going to feel. ... There's no such thing as a logical decision. That idea is like, I'm just going to be logical and just make a logical decision, it doesn't. Neurologically, it's just untrue."

**Insight:** Decisions are fundamentally emotional; logic is merely a tool used to predict future emotional states.

**Tactical advice:**
- Acknowledge the emotional drivers behind a decision rather than pretending it is purely logical.
- Increase your 'emotional fluidity' to access a wider range of solution sets that are otherwise blocked by emotional resistance.

*Timestamp: 00:13:31*

---

> "The other one that I find really, really useful and very hard to execute on until you really understand it is creating a set of principles to live by. ... if you really take a look at what it is you're making your decisions on and then really think about, well, what would be the five or six things that if I made decisions with these principles, I'm guaranteed success?"

**Insight:** Living by a small set of core principles automates effective decision-making and ensures consistency even during difficult times.

**Tactical advice:**
- Define a set of no more than five simple principles (e.g., 'Embrace intensity' or 'Connection first').
- Test each principle for five days to see if it produces the desired life or business outcomes.
- Define what each principle is NOT to provide clearer boundaries for action.

*Timestamp: 00:58:06*


## John Cutler
*John Cutler*

> "The better teams make high, better decisions faster... Company A buys into the whole idea of an extremely rigorous decision-making process. It's very process driven... Company B, maybe they're just all about this kind of mushy, diverse perspectives thing... Company C... very top down CEO driven."

**Insight:** There is no single 'best' decision process; high-performing teams succeed by choosing a process (rigorous, collaborative, or top-down) that is coherent with their leadership and culture.

**Tactical advice:**
- Identify if your company's decision-making style is process-driven, collaborative, or visionary-led, and align your team's workflow to match it.

*Timestamp: 00:31:21*

---

> "There's things like that out there. There's this thing Cynefin, which is a way to understand the systems and decision-making problems have, are you dealing with a clear system, a complicated system, a complex system, or a chaotic system?"

**Insight:** Effective decision-making requires first identifying the type of system you are operating in (clear, complicated, complex, or chaotic).

**Tactical advice:**
- Use the Cynefin framework to categorize a problem before choosing a decision-making approach.

*Timestamp: 01:23:57*


## Jonny Miller
*Jonny Miller*

> "The best decision-making is emotional... if you are on the other hand able to just welcome and be with whatever emotions would arise on the other side of a decision, you're able to decide clearly instead of being skewed one way or the other."

**Insight:** Effective decision-making requires the ability to process emotional data rather than suppressing it to avoid discomfort.

**Tactical advice:**
- Identify if you are making a decision primarily to avoid a specific feeling like conflict or anger
- Track 'somatic markers'—physical sensations in the body—as intuitive data points when evaluating options

*Timestamp: 00:50:16*


## Judd Antin
*Judd Antin*

> "The wisdom of the crowd works when the people involved with the decision are bringing diverse sources of information and judgment to the table... If you want to check your gut, get a bunch of different guts together, get a bunch of different people in the room who can bring evidence and intuition to bear."

**Insight:** Effective decision-making requires aggregating diverse sources of information to counteract individual cognitive biases.

**Tactical advice:**
- Engage 'System 2' (slow, analytical thinking) to check gut reactions.
- Facilitate decision meetings that include diverse perspectives and evidence types.

*Timestamp: 00:30:54*


## Kenneth Berger
*Kenneth Berger*

> "I think often the dangers of people saying, 'Oh, I don't have data to back this up. It's just what I think. And I'm not sure people are going to agree with me, so I'm just not going to say it.' So we don't have the data of all those gut opinions of these subject matter experts in the room, even though that gut information to me is just as important as anything we could get from the SQL database."

**Insight:** Expert intuition and 'gut data' are critical inputs to the decision-making process that are often suppressed in data-driven cultures.

**Tactical advice:**
- Encourage team members to share gut opinions even without supporting metrics
- Treat subjective opinions as valuable data points in the decision-making loop

*Timestamp: 00:33:50*


## Keith Coleman & Jay Baxter
*Keith Coleman & Jay Baxter*

> "One key attribute is there's one clear driver of the project, who's effectively a founder... and also there's one clear decision-maker that they go to... I think that's a big reason we're able to make decisions effectively, quickly, in a simple way."

**Insight:** The 'Thermal' model accelerates decision-making by isolating a team from corporate bureaucracy and giving them a single senior sponsor.

**Tactical advice:**
- Assign a single 'driver' (founder-equivalent) to the project
- Establish a 'Thermal' structure where the team is 100% focused and uses its own decision-making process

*Timestamp: 00:42:43*


## Kevin Aluwi
*Kevin Aluwi*

> "One relatively minor thing that I thought had a lot of impact with execution is being very clear that whoever is accountable for the results should also be the decider. I found that a lot of literature out there says that product teams should be this communal best ideas come from everywhere group... but I think not having it be super clear who is accountable and who is deciding often slows down execution a lot."

**Insight:** Clear individual accountability for decisions is superior to communal decision-making for maintaining execution speed.

**Tactical advice:**
- Ensure the person accountable for the results is the final decider for the project
- Avoid overly communal decision-making processes that obscure accountability and slow down progress

*Timestamp: 01:00:53*


## Kevin Yien
*Kevin Yien*

> "PMs need as many reps as possible in making decisions, documenting the rationale behind those decisions, and then crucially seeing the outcome of them... Look around you. There's other teams that are making decisions. What would you do if you were in that position with the information you have? Great, write it down."

**Insight:** Product sense is developed by making high-volume decision reps, documenting them, and reviewing the outcomes.

**Tactical advice:**
- Keep a decision log where you document the rationale for your choices.
- Simulate decisions for other teams or companies to get 'free' reps.
- Set calendar reminders to review the outcomes of your documented decisions months later.

*Timestamp: 00:35:32*


## Lane Shackleton
*Lane Shackleton*

> "Dharmesh Shah has this ritual from HubSpot called flash tags... It ranges from ... I think it's FYI, suggestion, recommendation, plea. FYI is basically like I had a thought, take it or leave it kind of thing. Suggestion is ... is this a hill I'm going to die on? And FYI is there's no hill in sight. Suggestion is there's a hill. I'm not going to die on it but this is what I would do if I were you. Recommendation is I'm climbing the hill. I'm not going to die here, but I've thought about this a lot, so don't ignore this. And then the fourth one, plea, is hopefully rarely used in the organization. It's like, I don't like dying on hills. That's not what we do here. But this is a pretty good candidate for it. You should really trust me."

**Insight:** Use standardized 'flash tags' to calibrate the weight and urgency of feedback.

**Tactical advice:**
- Label feedback as FYI, Suggestion, Recommendation, or Plea.
- Use these tags in shared documents or verbal meetings to clarify if a leader is mandating a change or just offering a thought.

*Timestamp: 00:36:24*

---

> "A very simple thing that he did probably in the last six months was he had a table of all the upcoming decisions and then at a tag-up ... he had all the upcoming decisions and then he let people hit a little reaction and say, "Oh, I don't need to be involved. Just notify me of the decision after." Or, "Hey, I have some opinions, but you can keep going." Or, "No, I really want to be heavily involved in this decision.""

**Insight:** Pre-qualify stakeholder involvement in decisions to prevent unnecessary bottlenecks.

**Tactical advice:**
- Create a table of upcoming decisions and let stakeholders opt-in to their level of involvement.
- Use 'notify me after' as a default for low-impact decisions to increase velocity.

*Timestamp: 00:51:30*


## Laura Schaffer
*Laura Schaffer*

> "I will definitely think that I would be described as someone who's going more by their gut when looking at date end results... I'm very comfortable and very common in using qualitative responses and things like that and supplement to quantitative data to make a decision."

**Insight:** Effective decision-making in growth requires balancing hard data with qualitative insights to move faster than statistical significance allows.

**Tactical advice:**
- Set the decision game plan and risk tolerance before running an experiment
- Use qualitative feedback to corroborate quantitative trends when confidence intervals are low
- Educate stakeholders on why a high volume of experiments is safer than a few high-confidence tests

*Timestamp: 00:42:51*


## Matt Mullenweg
*Matt Mullenweg*

> "If we had voted for whether we should do that or not, everyone would've voted against it or the majority would have. It was really a few core people of us in the community... that said, 'Hey, this is the future and it's going to take 10 years to do and it's going to be a long bet.'"

**Insight:** Critical long-term bets often require leaders to override majority consensus, especially when the transition period is expected to be difficult.

**Tactical advice:**
- Identify 'long bets' that may be unpopular in the short term but are necessary for future relevance
- Be prepared to endure years of negative feedback during major product transitions

*Timestamp: 01:03:12*


## Maya Prohovnik
*Maya Prohovnik*

> "I think where people get into trouble is when they think that they can rely solely on the data... I would think of your gut actually as a type of data and I think it's a totally valid one and it's just I think you need to be clear that that's what you're working with, but then it should be taken as seriously as any other data point."

**Insight:** Effective decision-making treats intuition as a valid data point that must be objectively explained to stakeholders.

**Tactical advice:**
- Treat 'gut feeling' as accumulated experience-based data
- Objectively explain the reasoning behind a gut feeling to influence others
- Use data to form and test hypotheses rather than as a sole decision-maker

*Timestamp: 00:18:21*


## Mayur Kamat
*Mayur Kamat*

> "There's no right or wrong decision. There's just low and fast decisions... for anything that's reversible, anything that's not going to get you in jail or kill your company, no right or wrong decisions, just slow or fast decisions."

**Insight:** Speed is the primary variable in decision-making for reversible actions.

**Tactical advice:**
- Categorize decisions as reversible or irreversible.
- Optimize for speed in all reversible decisions to gather data faster.

*Timestamp: 01:33:35*


## Melissa Tan
*Melissa Tan*

> "A DACI is a framework to think about the different roles on the team on a project or an area. So D stands for Driver... A is Accountable... C is Contributor... And I is informed. And so it's a nice simple framework for when you are working across teams and it needs to be clear who is in what role."

**Insight:** The DACI framework clarifies accountability and prevents decision-making bottlenecks in cross-functional projects.

**Tactical advice:**
- Assign one 'Driver' to push the project forward
- Identify one 'Accountable' person as the final decision-maker
- Explicitly list 'Contributors' and those who only need to be 'Informed'

*Timestamp: 00:54:36*


## Mihika Kapoor
*Mihika Kapoor*

> "I think that putting out an idea, even if it's totally wrong, is a much better catalyst for getting to a good solution because people are much more likely to react to an idea than to nothing."

**Insight:** Proposing a specific, even flawed, hypothesis is more effective at generating momentum and high-quality feedback than starting from a blank slate.

**Tactical advice:**
- Use the 'one-way doors vs. two-way doors' framework to maintain decision speed
- Enter research with an 'A-' idea to refine it rather than starting at zero
- Adopt a 'strong opinions, weakly held' mindset to remain agile when external signals change

*Timestamp: 00:25:11*


## Nabeel S. Qureshi
*Nabeel S. Qureshi*

> "When you started a new project, you basically had to organize what they called a murder board for it... the idea is, basically, you write up a two-page plan for the project. You invite three or four smart folks who don't know anything about the project and their job is just to tear apart your plan."

**Insight:** Use 'murder boards' to stress-test new project plans by inviting objective critics to find every possible flaw.

**Tactical advice:**
- Write a concise two-page plan covering vision, goals, tactics, and principles.
- Invite 'outsiders' to the project specifically to tear the plan apart.
- Include principles that are specific enough to be disagreed with (avoid platitudes like 'move fast').

*Timestamp: 00:12:30*


## Noah Weiss
*Noah Weiss*

> "Your job as to facilitate the pace and quality of decision making. That is very different than you are the person who makes all the decisions. In fact, I think one of the things that PM struggled with early on is how do you actually get the team to be able to make high quality decisions quickly without you arbitrarily playing tiebreaker all the time."

**Insight:** The PM's role is to facilitate the decision-making process, not to be the sole decision-maker or arbitrary tiebreaker.

**Tactical advice:**
- Focus on the *pace* and *quality* of the team's decisions rather than making them yourself.
- Avoid acting like a 'mini-CEO' or dictator; act as a facilitator.

*Timestamp: 01:06:30*


## Nilan Peiris
*Nilan Peiris*

> "You can't split test your way to love. ... This thing of building conviction on what matters, and I watch how teams slowly build this and you need the data there to make sure it doesn't become a hubris, right? That enables you to make much bigger changes than just experimenting away, and it forces you to get clear on what actually is the problem to solve here, and how do I solve it really, really well?"

**Insight:** High-impact product development requires building conviction through qualitative and quantitative insights rather than relying solely on incremental A/B testing.

**Tactical advice:**
- Use data to build long-term conviction rather than just validating small, isolated changes
- Encourage PMs to develop a 'gut feel' by talking to customers before deciding what to build
- Prioritize solving core problems 'really, really well' over running high volumes of low-conviction experiments

*Timestamp: 00:38:13*


## Patrick Campbell
*Patrick Campbell*

> "I found the model that people who aren't great at first principal thinking... is this thing called problem, cause, solution. So I learned this in debate in college and high school, and it basically is you have a problem that you're trying to solve. Well, you can't actually solve a problem... you want to break down what are all the causes."

**Insight:** First principles thinking can be operationalized by breaking a symptom (the problem) into its root causes and ranking them by magnitude before designing solutions.

**Tactical advice:**
- Use the 'Problem, Cause, Solution' framework to move from symptoms to root issues
- Rank causes by magnitude to ensure you are solving the most impactful part of the problem
- Apply this framework to everything from high-level strategy to individual support tickets

*Timestamp: 00:36:06*


## Paul Millerd
*Paul Millerd*

> "Tim Ferriss' fear setting, and he basically forces you to write down what are your fears, how could you mitigate these. But more powerfully, the second part is... And you're framing them around action. And so he reframes, what is the cost of inaction?"

**Insight:** Effective decision-making in career pivots requires weighing the cost of staying in a soul-crushing job against the risks of leaving.

**Tactical advice:**
- Write down specific fears and mitigation strategies
- Explicitly calculate the 'cost of inaction' over 6 months, 1 year, and 3 years

*Timestamp: 00:40:45*


## Rahul Vohra
*Rahul Vohra*

> "The idea here is that for important decisions, you should be able to identify one, one reason that on its own supports the decision. It's based on the observation that all too often we rely on a collection of weak reasons to justify decisions."

**Insight:** The 'Single Decisive Reason' (SDR) framework prevents teams from justifying poor decisions with a stack of weak arguments.

**Tactical advice:**
- Ask: 'If only one of these reasons was true, would we still make this decision?'
- Avoid 'pro/con' lists where a high volume of weak points outweighs a single critical factor.

*Timestamp: 01:19:35*


## Roger Martin
*Roger Martin*

> "Betterment is making that gap go away. And guess what happens if you make that gap go away? You can turn your attention to the next gap, and the next gap, and the next gap."

**Insight:** Strategy should be viewed as a problem-solving tool focused on 'betterment'—closing the gap between current and desired outcomes—rather than seeking perfection.

**Tactical advice:**
- Identify the single most painful gap between current results and aspirations.
- Apply the strategy cascade specifically to solve that one gap rather than trying to solve everything at once.
- Iterate by continuously identifying and closing the next most significant gap.

*Timestamp: 01:16:28*


## Shreyas Doshi
*Shreyas Doshi Live*

> "I guess what I'm saying, Lenny, is one of my other tactical tips would be sometimes it is useful to pause for two minutes, or two days, or two weeks before making that decision, right? Because frankly, most doors that look like two-way doors are actually one-way doors. They are two-way doors at Bezos' level, but as a PM leader, for you, they are a one-way door, and that's making you busy."

**Insight:** Many decisions framed as reversible 'two-way doors' are effectively irreversible for PM leaders due to the organizational debt and momentum they create.

**Tactical advice:**
- Pause before making decisions to think through customer motivation, differentiation, and distribution.
- Be wary of using 'two-way door' logic as an excuse for shallow thinking.
- Evaluate ideas separate from social proof, authority bias, or catchy metaphors.

*Timestamp: 23:55*


## Shishir Mehrotra
*Shishir Mehrotra*

> "Dory/Pulse... Everybody writes down what they think and we hide everybody else's until you're done writing. So you force yourself to be eloquent about your opinion, on the record about it, and unbiased. And then the second thing we do is called Dory, which is instead of randomly asking questions, we ask people to put the questions on the table and then we take a round of up quoting and down voting them"

**Insight:** Effective decision-making requires unbiasing input through 'pulsing' (private writing) and prioritizing discussion through upvoted questions.

**Tactical advice:**
- Use 'Pulse' to have everyone write their opinions simultaneously and hidden to avoid groupthink.
- Use 'Dory' to crowdsource and rank questions for meetings to ensure the most important topics are addressed.

*Timestamp: 00:27:26*

---

> "Coinbase has a ritual... they have this subtle nudge thing... the person running the meeting pre-fills that with what they want from that person. You are an approver... I need you to tell me do we have the budget or not? Or I need you to tell me am I authorized to make this change"

**Insight:** Clarifying specific roles (Approver, Decider, etc.) and the exact input needed from each person prevents consensus-seeking from slowing down decisions.

**Tactical advice:**
- Pre-fill decision documents with specific roles for each stakeholder.
- Explicitly state what specific answer or authorization is needed from each 'approver'.

*Timestamp: 00:36:44*


## Shaun Clowes
*Shaun Clowes*

> "We get paid in product management to make decisions, good decisions, paid to make good decisions that will deliver business benefit. And a decision with too little data is fatal. A decision that takes too long and collects too much data is also fatal."

**Insight:** The core value of a product manager is the ability to make timely, high-quality decisions that balance speed and information.

**Tactical advice:**
- Evaluate your performance based on the quality and speed of your decisions rather than just the volume of your activity.

*Timestamp: 01:14:07*


## Tanguy Crusson
*Tanguy Crusson*

> "Point A... had four stages called Wonder, Explore, Make and Impact... we basically write a six pager that looks at all the different aspects of all the questions that we're going to answer. And then we are in a meeting with the Point A stakeholders and the founders of Atlassian. And everyone reads that page for about 15 minutes and then question, answers, comments."

**Insight:** Use a structured lifecycle (Wonder/Explore/Make/Impact) and silent reading of 6-pagers for high-stakes product decisions.

**Tactical advice:**
- Implement a staged gate process for internal incubation
- Use 15 minutes of silent reading at the start of decision meetings to ensure everyone is informed

*Timestamp: 01:04:27*


## Tim Holley
*Tim Holley*

> "Nick, our CPO like to say you don't have to have the best ideas, but you have to choose the best ideas. And so really figuring out how you're selecting what you're going to build and then living with the consequences... when we need to move forward, it is the PM that is on the hook for those things."

**Insight:** The PM's primary role is to be the accountable decision-maker who selects the best path forward, even if they didn't generate the idea.

**Tactical advice:**
- Clarify who is ultimately accountable for the decision when consensus is unclear.
- Focus on selecting the best ideas from the team rather than generating them all yourself.

*Timestamp: 00:57:35*


## Tomer Cohen
*Tomer Cohen*

> "We might be wrong but we're not confused. It's a simple phrase, but it has in my opinion, so much depth into that and ultimately something I really believe in. It's rooted in clarity and principles that ultimately lead to leadership."

**Insight:** Prioritize clarity of thought and alignment over the fear of being wrong to ensure the entire organization moves in the same direction.

**Tactical advice:**
- Distinguish between 'clarity of thought' (problem definition) and 'clarity of execution' (resourcing).
- Avoid hedging; once a path is decided, ensure the entire team pulls in that direction to give the project a chance at success.

*Timestamp: 00:03:17*


## Varun Mohan
*Varun Mohan*

> "I wish I had... this idea of just being okay with being wrong faster. I always think about things on when we make decisions... I wish we had made the decision to do this a couple months earlier... re-evaluate your hypotheses and get into an uncomfortable space way more frequently."

**Insight:** The speed of re-evaluating wrong hypotheses is more important than being right initially.

**Tactical advice:**
- Set regular intervals to challenge and potentially kill existing company beliefs
- Optimize for the speed of the 'pivot' once new information contradicts initial assumptions

*Timestamp: 01:09:04*


## Ebi Atawodi
*Ebi Atawodi*

> "I'm in too many conversations where I'm like, 'Who is on the hook for this decision? Who cares if this decision is made?' It's not like six people with consensus. Who is the person? And I'm very big on people on count... There's one person who owns this decision and that's the person that we're going to empower to get all the context, get all the input, to make the decision."

**Insight:** Effective decision-making requires a single 'informed captain' rather than seeking group consensus, which often leads to delays and lack of accountability.

**Tactical advice:**
- Identify a single 'informed captain' for every major decision
- Empower the decider to gather input but ultimately make the final call independently

*Timestamp: 01:20:45*


## Keith Yandell
*Keith Yandell*

> "There needs to be someone that says, 'All right. We got to be clear on who the decision maker is here. If we haven't reached a consensus, who's the tiebreaker?'"

**Insight:** Speed in decision-making requires clear ownership and a pre-defined tie-breaker for when consensus cannot be reached.

**Tactical advice:**
- Explicitly name the tie-breaker (CEO, GM, or Head of Product) before the debate begins
- Set a strict time horizon for when the final decision must be made

*Timestamp: 29:32*


## Naomi Gleit
*Naomi Gleit*

> "Usually a meeting can be and hopefully a meeting is really either is a decision meeting. So if there is a decision, I need three options and I need a recommendation that should hopefully help focus the meeting."

**Insight:** Structure decision meetings around a set of three distinct options and a clear recommendation to drive focus.

**Tactical advice:**
- Always present three options and one recommendation for any major decision

*Timestamp: 01:08:28*


## Nickey Skarstad
*Nickey Skarstad*

> "I love the concept of one way versus two way door decision making... If your team is making a really critical long-term decision that's going to be limiting to a lot of the future things that you could want or need to do, that is a one way door decision. And you should spend time really thinking about discussing it... If it is a two-way door decision, it's not going to make a huge impact, you can change it later if you need to, let your team cruise on those things."

**Insight:** Distinguishing between reversible and irreversible decisions allows teams to maintain high velocity while protecting long-term strategy.

**Tactical advice:**
- Identify 'one-way door' decisions (e.g., marketplace standards) and slow down for deep review
- Empower teams to 'cruise' on 'two-way door' decisions to maintain autonomy

*Timestamp: 00:39:28*

---

> "If you can get teams to align on first principles early on, it saves you a lot of heartache later because you've got people to align way early days before you even got into the design process, or before you had to start thinking about how do we actually technically implement this."

**Insight:** Aligning on first principles at the start of a project prevents fundamental disagreements during the later design or technical phases.

**Tactical advice:**
- Write out first principles for every major feature or strategy
- Get alignment on these principles before starting design or technical implementation

*Timestamp: 00:45:36*


## Paige Costello
*Paige Costello*

> "We actually don't care. We don't want a daisy chain of approvals. We just want one person with whom the buck can stop with them, and they can be responsible for how the work moves forward."

**Insight:** Avoid 'daisy chains' of approvals by designating a single person responsible for the final decision to maintain momentum.

**Tactical advice:**
- Limit the number of formal reviewers to no more than three per piece of work.
- Ensure only one person is designated as the final 'blocker' or approver.

*Timestamp: 00:59:18*


## Sanchan Saxena
*Sanchan Saxena*

> "The idea that we have... is the idea of a directly responsible individual or DRI. For every project, we'll establish a DRI... DRI's job is to take all that input and make a decision. Not take all that input and do necessarily what's right by everybody, right? Still do what's right by the customer."

**Insight:** A DRI model prevents 'design by committee' by empowering one person to make the final call after hearing all cross-functional input.

**Tactical advice:**
- Assign a single DRI for every project to avoid convoluted decision-making
- Use a written 'RAPID' format for cross-functional input to ensure clarity
- Practice 'disagree and champion'—once a decision is made, everyone must evangelize it

*Timestamp: 00:44:26*


## Tobi Lutke
*Tobi Lutke*

> "You make you re-derive literally every decision that is valuable, every foundational assumption, every foundational ABC direction. And you want to see the observation you've made in the meantime since you last derived the next step. Re-running the entire function over the state that is now updated, the higher fidelity information, would you come to the very same thing?"

**Insight:** Treat decision-making as a pure function that should be re-evaluated whenever new high-fidelity information updates the 'state' of the problem.

**Tactical advice:**
- Re-run the decision function periodically to see if foundational assumptions still hold
- Identify the specific 'Boolean' or input that has changed to justify a pivot
- Avoid the sunk cost fallacy by being willing to land in a completely different 'landing zone' after re-evaluating facts

*Timestamp: 00:37:25*


## Will Larson
*Will Larson*

> "Will anyone remember what we decided in six months? Because I think people stress out about a lot of decisions, but I increasingly believe most decisions people stress out about just aren't that important."

**Insight:** Most decisions are not as critical as they feel in the moment; use the 'six-month rule' to calibrate the time spent on them.

**Tactical advice:**
- Ask 'Will anyone care in six months what we did here?' to decide how much time to invest in a decision

*Timestamp: 01:14:11*


