---
name: running-effective-1-1s
description: Help users run effective one-on-one meetings. Use when someone is a new manager setting up 1:1s, struggling to make 1:1s productive, wants to improve career conversations with reports, or needs to handle difficult 1:1 situations.
---

# Running Effective 1:1s

Help the user run effective one-on-one meetings using frameworks from 7 product leaders.

## How to Help

When the user asks for help with 1:1s:

1. **Understand the relationship** - Ask about their role, the report's tenure, and current dynamics
2. **Identify the purpose** - Determine if the 1:1 needs to focus on tactical work, career development, or emotional support
3. **Suggest structure** - Recommend appropriate formats based on the situation
4. **Coach on coaching** - Help them shift from advising to empowering their reports

## Core Principles

### Coach, don't advise
Rachel Lockett: "Great leaders know that when you try to advise and have the answer all the time, you're not actually equipping your team to go solve the hard problems. You're training your team to come to you with all of the hard problems." Shift energy into curiosity when a report brings a hard problem. Avoid the urge to provide the answer immediately.

### Dedicate time to deep career conversations
Kim Scott: "I would have three separate 45 minute conversations, so one about their past, one about their future, and one about their present to create a plan." Conduct a "Life Story" conversation to understand motivations, a "Future Dreams" conversation to identify long-term visions, and create a "Career Action Plan" to map current skill-building to those dreams.

### Monitor recovery and joy
Hilary Gridley: "In my one on ones... I'm asking them, 'What do you do for joy? Are you doing something every single day that's bringing you joy in your life?' And if they say no, I'm like, 'That's a problem.'" Ask reports directly about what brings them joy outside of work. Treat a lack of daily joy as a performance risk that needs a plan.

### Consider cutting standing 1:1s
Howie Liu: "I actually cut my one-on-one roster by default... Just having more standing one-on-ones actually precludes me from engaging in more timely topics." Consider a barbell approach: high-quality, less frequent relationship catch-ups (e.g., monthly walks) vs. urgent topical meetings scheduled as needed.

### Use 1:1s for emotional processing after crises
Matt Mochary: "With each and every person on the stay team, you have a one-on-one with their manager for one hour and all the manager does is say, 'I'd like to know your thoughts and feelings,' and the person shares and then all the manager does is make them feel heard." Post-crisis 1:1s should focus entirely on active listening and emotional processing.

### The 1:1 belongs to the report
The report should own the agenda. As manager, you're there to support their success, not to get status updates.

## Questions to Help Users

- "When your report brings you a problem, do you tend to give the answer or ask questions?"
- "When was the last time you had a deep career development conversation (not a performance review)?"
- "How do you know if your report is recovering well outside of work?"
- "Does your report own the 1:1 agenda, or do you drive it?"
- "Are your 1:1s tactical or strategic? What's the right balance?"

## Common Mistakes to Flag

- **Status update theater** - Using 1:1s for updates that could be async
- **Always advising** - Solving problems instead of coaching the report to solve them
- **Skipping career conversations** - Only discussing immediate work, never long-term development
- **Ignoring wellbeing** - Not noticing when a report is burning out
- **Manager-driven agenda** - The manager dictates topics instead of the report owning the time

## Deep Dive

For all 10 insights from 7 guests, see `references/guest-insights.md`

## Related Skills

- running-effective-meetings
- running-decision-processes
- post-mortems-retrospectives
