---
name: running-effective-meetings
description: Help users run more effective meetings. Use when someone is dealing with meeting overload, wants to improve meeting culture, is preparing an important meeting, or struggles to get decisions made in meetings.
---

# Running Effective Meetings

Help the user run more effective meetings using frameworks from 40 product leaders.

## How to Help

When the user asks for help with meetings:

1. **Question the meeting's necessity** - Ask if this could be async or if a meeting is truly needed
2. **Clarify the purpose** - Determine if it's for discovery, discussion, or decision
3. **Design the structure** - Help them create an appropriate agenda and process
4. **Ensure follow-through** - Guide them on capturing decisions and next steps

## Core Principles

### Separate strategic from operational meetings
Naomi Gleit: "We have one weekly sort of strategic meeting. It's more open-ended, there is time for discussion... We also have one weekly operational meeting, which is highly structured where we go through all of the priority projects." Don't mix unstructured strategic discussion with structured operational updates.

### Meetings are only for discussion
Annie Duke: "People generally think the purpose of a meeting is for three things, discover, discuss, decide. The only thing that's ever supposed to happen in a meeting is the discussion part." Discovery and decision-making should happen asynchronously. Reserve synchronous time for actual dialogue.

### End with three questions
Alisa Cohn: "My three questions to end the meeting are, what did we decide here? Who needs to do what by when? And who else needs to know?" Ending meetings with standardized questions ensures alignment and prevents re-meetings.

### Don't skip the priming phase
Evan LaPointe: "Meetings, generally speaking, are a combination of priming and decision making... A lot of meetings skip the priming step altogether." Most meeting dysfunction stems from skipping context-setting. Explicitly include a priming phase before diving into decisions.

### Clear the calendar for important decisions
Jake Knapp + John Zeratsky: "The big idea with a design Sprint is to go from a zero to a prototype and a test of that prototype in just five days. And it's a recipe, it's a scripted set of activities." High-stakes strategic decisions benefit from time-boxed, calendar-cleared workshops.

### Minimize meetings ruthlessly
Gibson Biddle: "Minimize meetings, okay? Minimize meetings. That sucks the life out of everybody, including you." Protect productivity by actively removing non-essential meetings. A full calendar is a badge of shame, not honor.

### State changes maintain engagement
Wes Kao: "The state change method is that you should punctuate your monologues with state changes. So state changes are anything that shakes your audience awake." In virtual meetings, break up monologues every 3-5 minutes with polls, chat prompts, or speaker changes.

### Pre-reads shift status updates to async
Matt Mochary: "If everyone pre-prepared their update... we could take a three hour meeting down to a 45 minute meeting." Require attendees to submit written updates and proposed solutions before the meeting. Dedicate the first part to silent reading.

## Questions to Help Users

- "Does this meeting need to happen, or could this be resolved async?"
- "What's the purpose of this meeting: discovery, discussion, or decision?"
- "What pre-work should attendees complete before the meeting?"
- "Who is the decision-maker, and does everyone know that?"
- "How will you capture and communicate decisions after the meeting?"
- "What would need to be true for you to cancel this recurring meeting?"

## Common Mistakes to Flag

- **Status update meetings** - Using synchronous time for information that could be shared async
- **No clear purpose** - Meetings without explicit objectives
- **Missing priming** - Jumping to decisions without establishing shared context
- **No documented outcomes** - Ending without capturing what was decided and who's doing what
- **Too many attendees** - Every additional person reduces candor and increases cost

## Deep Dive

For all 54 insights from 40 guests, see `references/guest-insights.md`

## Related Skills

- running-effective-1-1s
- running-decision-processes
- running-offsites
