# Running Effective Meetings - All Guest Insights

*40 guests, 54 mentions*

---

## Alisa Cohn
*Alisa Cohn*

> "My three questions to end the meeting are, what did we decide here? Who needs to do what by when? And who else needs to know?"

**Insight:** Ending meetings with standardized questions ensures alignment and prevents the need for 're-meetings.'

**Tactical advice:**
- Ask 'What did we decide here?' to surface differing interpretations
- Define clear action items with owners and deadlines
- Identify stakeholders who need to be informed of the decisions

*Timestamp: 00:50:01*

---

> "If you're in a meeting with a large executive team... you probably want to get a few people just to... I would just even say as a facilitator, two or three people, 'Okay, two or three people, what do we decide here?' And if you can kind of get common, great."

**Insight:** In larger meetings, use a sampling technique to verify alignment on decisions before adjourning.

**Tactical advice:**
- Designate a 'meeting czar' to handle follow-up
- Leave 5-10 minutes at the end specifically for these closing questions
- If time is short, put the decisions on a screen and ask for verbal confirmation

*Timestamp: 00:54:52*


## Annie Duke
*Annie Duke*

> "People generally think the purpose of a meeting is for three things, discover, discuss, decide. The only thing that's ever supposed to happen in a meeting is the discussion part."

**Insight:** Meetings should be reserved exclusively for discussion, while discovery and decision-making should happen independently and asynchronously.

**Tactical advice:**
- Separate the meeting into three phases: Discover, Discuss, and Decide.
- Ensure the 'Discuss' phase is the only part that happens live in the room.

*Timestamp: 00:00:16*

---

> "The best way to get somebody's opinion is independently of other people's opinions, independently asynchronously. So the way that I put is I want people to stop talking to each other so much."

**Insight:** To avoid groupthink and the influence of the loudest voices, gather individual opinions before the group meets.

**Tactical advice:**
- Gather opinions asynchronously before the meeting starts.
- Prevent the 'loudest' or 'most confident' person from dominating the discovery of ideas.

*Timestamp: 00:25:18*

---

> "So what I heard you say is that not all functions are created equal... Is that what you meant? And then they have the ability to say, 'Yes, that is what I meant'... you're reflecting back what they say without offering your own opinion."

**Insight:** Effective meeting facilitation involves active listening and reflecting back participants' views to ensure they feel heard without the facilitator imposing their own bias.

**Tactical advice:**
- Use active listening to reflect back a participant's point verbatim or summarized.
- Ask for clarification ('Is that what you meant?') before moving to the next person.

*Timestamp: 00:39:57*


## Anneka Gupta
*Anneka Gupta*

> "The first step that I found as very useful, and I use this tactic every single day in meetings, is just summarization. So, bringing people together, lots of different voices into a room and hearing what they have to say and at various times in the conversation summarizing what people are saying and summarizing what that means in terms of the direction that we could go in."

**Insight:** Frequent summarization in meetings is a powerful tactic that is often perceived as strategic leadership and ensures collective alignment.

**Tactical advice:**
- Pause circular discussions to summarize what has been heard and the proposed direction.
- Use whiteboards or Zoom chat to summarize points live without interrupting the flow of conversation.
- End a summary with a question to invite dissent and ensure the portrayal is accurate.

*Timestamp: 00:21:34*


## Christina Wodtke
*Christina Wodtke*

> "When you first start, it might take a half hour, but after that it should just take 10 minutes... It's all about those conversations about, is our current strategy, not just at the company level, but at each departmental level, are these strategies working?"

**Insight:** OKR review meetings should be fast, high-level, and focused on strategic health rather than granular task updates.

**Tactical advice:**
- Keep weekly OKR check-ins to 10 minutes by focusing only on the most important 'big rocks'.
- Use the meeting to discuss if the strategy is moving the numbers, not to list every IC task.

*Timestamp: 00:31:13*


## Claire Hughes Johnson
*Claire Hughes Johnson*

> "The work of a meeting is not calling the meeting. Calling a meeting is easy. In fact, that is a problem... What you really want to know... People need to know why are we meeting, and what is the point, what's the objective of this meeting? Is it to make a decision? Is it to share information? Who needs to be here?"

**Insight:** Meeting effectiveness is determined by the preparation and the explicitness of the objective rather than the act of gathering.

**Tactical advice:**
- Explicitly state if the meeting is for decision-making, information sharing, or brainstorming
- Identify the decision-maker and the criteria for the decision beforehand
- Ask if anyone does not need to be there and offer to send them notes instead

*Timestamp: 01:16:16*


## Claire Vo
*Claire Vo*

> "I am really thoughtful that reoccurring meetings do not drive next steps. It's a very tactical thing, but when somebody says, 'Oh, we'll discuss this or we'll decide this in the next meeting,' it's, 'No, we should discuss this now. We should decide this tomorrow.'"

**Insight:** Prevent organizational pace from degrading to the speed of the calendar by decoupling decision-making from recurring meeting cadences.

**Tactical advice:**
- Don't wait for the next meeting to make a decision
- Set a personal SLA to never be the bottleneck for the team
- Challenge artificial timelines introduced by calendar apps

*Timestamp: 00:23:45*


## Elizabeth Stone
*Elizabeth Stone*

> "If we're clear on the objectives of something, it might be that the last 20% of polish on the document is a really bad use of time... The reason we're doing the quarterly business review is to have a really candid conversation about how we think things are going... It's not to have a perfectly polished document for that conversation."

**Insight:** Prioritize the quality of the conversation and the clarity of objectives over the visual polish of meeting materials.

**Tactical advice:**
- Set expectations that documents should be 'crisp' but not over-polished at the expense of strategic thinking
- Focus meeting preparation on 'teeing up' the right debate rather than perfect formatting

*Timestamp: 00:25:21*


## Eric Simons
*Eric Simons*

> "We all meet every day. Pretty much the entire team gets on a call... every day at 8:00 AM Pacific, we're on a Zoom for at least an hour... everything, every day, is being audited front to back, and being discussed front to back."

**Insight:** During periods of extreme growth, daily all-hands meetings ensure zero communication loss and maintain high context across the entire team.

**Tactical advice:**
- Use daily syncs to audit all company activities during hyper-growth phases
- Prioritize communication fidelity over 'meeting cost' when the company is scaling rapidly

*Timestamp: 00:44:02*


## Evan LaPointe
*Evan LaPointe*

> "Meetings, generally speaking, are a combination of priming and decision making... A lot of meetings skip the priming step altogether. They launched directly into decision making."

**Insight:** Most meeting dysfunction stems from skipping the 'priming' phase where context and alignment are established.

**Tactical advice:**
- Explicitly include a priming phase in every meeting to ensure everyone is on the same page.
- Use the meeting invite to define the category of conversation (e.g., creative problem solving vs. tactical efficiency).

*Timestamp: 00:23:32*

---

> "It's way better to have a debate about the principles than it is to have a debate about the tactics that are rooted in the fact that you have super misaligned principles."

**Insight:** Aligning on underlying principles (e.g., speed vs. accuracy) prevents circular tactical arguments.

**Tactical advice:**
- Start meetings by debating and agreeing on the principles that will guide the decision.
- Identify if a conflict is tactical or actually a misalignment of core objectives.

*Timestamp: 00:28:44*


## Geoff Charles
*Geoff Charles*

> "The second thing that I would say is the biggest waste of time is meetings and status updates... I've never had a status meeting. I've never scheduled a status meeting. Statuses are done async."

**Insight:** Eliminate status meetings entirely to maximize execution time, moving all updates to asynchronous channels.

**Tactical advice:**
- Reserve meetings only for collaboration, ideation, and decision-making.
- Check Slack only at the top of the hour and turn off notifications during deep work.
- Use Slack 'snooze' or 'reminders' to manage tasks without losing focus.

*Timestamp: 00:25:48*


## Gibson Biddle
*Gibson Biddle*

> "minimize meetings, okay? Minimize meetings. That sucks the life out of everybody, including you."

**Insight:** Protect productivity by actively minimizing the number of meetings in your schedule.

**Tactical advice:**
- Audit your calendar to remove non-essential meetings
- Begin the day with intent by listing 3-5 key goals before meetings start

*Timestamp: 52:49*


## Hari Srinivasan
*Hari Srinivasan*

> "I'm trying this thing... could we get to 15-minute reviews basically instead of an hour and see if that alleviates some of this? I'm very curious to see if this is going to be a different kind of system where we might be able to get to clarity quicker, or realize we're not at clarity and then break and come back."

**Insight:** Drastically shortening review meetings forces teams to reach clarity faster or identify gaps immediately.

**Tactical advice:**
- Experiment with 15-minute product reviews to increase focus and speed
- If clarity isn't reached quickly, end the meeting and reschedule rather than dragging it out

*Timestamp: 01:02:00*


## Hilary Gridley
*Hilary Gridley*

> "Every additional person in a meeting has a cost, because every additional person in a meeting makes the people in that meeting less candid than they would have been if there were fewer people in that meeting. ... It's really important that you earn your place in this meeting and let's work on how to do that."

**Insight:** Meeting size inversely correlates with candor; every attendee must actively contribute to justify the 'cost' of their presence.

**Tactical advice:**
- Limit meeting attendance to maintain high levels of candor.
- Require attendees to contribute value (e.g., moving the conversation forward) rather than just observing.
- Encourage junior members to practice the skill of verbal expression in meetings to earn their spot.

*Timestamp: 00:24:23*


## Howie Liu
*Howie Liu*

> "I want to make most meetings very timely and very informed by real alpha. There's got to be some kind of value and insight to seed that with."

**Insight:** Shift from ritualistic standing meetings to urgency-driven meetings triggered by specific insights or 'alpha.'

**Tactical advice:**
- Make meetings urgency-driven rather than ritual-driven
- Seed meetings with 'real alpha' or specific insights to ensure value

*Timestamp: 00:17:20*


## Jake Knapp + John Zeratsky
*Jake Knapp + John Zeratsky*

> "The big idea with a design Sprint is to go from a zero to a prototype and a test of that prototype in just five days. And it's a recipe, it's a scripted set of activities that we developed over a number of many years."

**Insight:** A Design Sprint is a highly scripted, 5-day 'meeting' or workshop designed to bypass traditional planning cycles.

**Tactical advice:**
- Follow a scripted set of activities to move from idea to tested prototype in five days.
- Clear the team's calendar for a full week to focus on a single problem.

*Timestamp: 01:27:00*

---

> "The very beginning of your project, we recommend this kind of crazy idea that you clear your calendar. So the core team come together for 10 hours roughly and go through a sequence of activities so that we can make all of the key decisions together."

**Insight:** High-stakes strategic decisions are best made in a time-boxed, 'calendar-cleared' environment to ensure total focus and momentum.

**Tactical advice:**
- Clear the team's calendar for 10 hours (spread over two days) to execute a Foundation Sprint.
- Turn off Slack and email during these sessions to maintain deep focus.

*Timestamp: 00:00:23*


## Jason M Lemkin
*Jason M Lemkin*

> "The best salespeople never leave a meeting without a next step. The next step does not have to be a check... but what's the next meeting? ... Whatever the next step is, 'What's the next step we can get on our books?'"

**Insight:** A successful sales meeting must always conclude with a clearly defined next action to maintain momentum.

**Tactical advice:**
- Never end a call without scheduling the next meeting or step
- Ask 'Who else in the organization needs to see this?' to expand the stakeholder group

*Timestamp: 01:27:28*


## Joe Hudson
*Joe Hudson*

> "One of the things I like to say about how to change a company is that the atomic structure of a company is the meetings and the decisions. ... One of the things we do is we talk about what we call five-star meetings, which is how do you make every meeting enjoyable? Literally, how is it that everybody when they walk out of a meeting, they're like, oh, fuck, that was great?"

**Insight:** Meetings are the fundamental unit of organizational culture; making them enjoyable is a primary lever for increasing efficiency and identifying hidden problems.

**Tactical advice:**
- Set a goal for every meeting to be 'five stars' (highly enjoyable for all participants).
- Use 'sucking' meetings as a diagnostic tool—if a meeting is unenjoyable, it indicates a deeper problem in that specific area of the business.

*Timestamp: 01:05:04*


## Jonny Miller
*Jonny Miller*

> "If you are about to jump on a zoom or something, you can totally do it with your eyes closed. Things like expanding your awareness or bringing your awareness down to your feet and your hands, which creates a kind of grounding calming effect that also you can do if you're in a busy room."

**Insight:** Grounding techniques like expanding awareness or focusing on physical contact points can be used discreetly to maintain composure during meetings.

**Tactical advice:**
- Bring awareness to your feet and hands to create a grounding effect during stressful meetings
- Use the 'APE' (Awareness, Posture, Emotion) check-in before starting a call to assess your baseline state

*Timestamp: 00:18:10*


## John Mark Nickels
*John Mark Nickels*

> "I really try to spend more time being mindful of that and say, I want to hear from other people first. I want to create space and I don't need to win the argument in the meeting. There can be a follow-up. It's not like this is my last chance to say something, but that's also more true when you're more senior because when you're more junior, it's like, well, this is the one presentation I have with Dara for the next six months."

**Insight:** Senior leaders should prioritize hearing from others first to avoid biasing the room and to mitigate power imbalances.

**Tactical advice:**
- Wait to speak until others have shared their perspectives
- Create explicit space for junior team members to disagree or contribute

*Timestamp: 00:04:45*

---

> "I like a crisp dock and a messy meeting. The whole Amazon thing, if you have the three-page or seven-page narrative, it's written with the clarity of angels singing from on high, at least describing how the problem statement or feature or whatever. And so it's super crisp and organized and well articulated. And then you might have a meeting where you pick it apart and you talk a lot."

**Insight:** High-quality written preparation allows for productive, rigorous, and 'messy' verbal debates.

**Tactical advice:**
- Require a crisp, well-articulated narrative document before the meeting starts
- Use the meeting time for deep discussion and picking apart the document rather than just presenting it

*Timestamp: 00:45:41*


## Jonathan Lowenhar
*Jonathan Lowenhar*

> "Brain writing is I'm going to expose an idea and I want everyone to now write and weigh in on there... in an async way that no one else can see until it's all combined, maybe even ideally without authorship identified. Then when the founders weigh in, you don't know, they're just a part of the mass."

**Insight:** Brain writing prevents the 'founder effect' and loud-voice bias by collecting ideas asynchronously and anonymously before discussion.

**Tactical advice:**
- Have participants write their ideas in a shared doc or survey before the meeting.
- Keep authorship anonymous during the initial review phase to level the playing field.
- Take the first 10 minutes of the meeting for silent reading of all contributions before debating.

*Timestamp: 01:06:35*


## Keith Coleman & Jay Baxter
*Keith Coleman & Jay Baxter*

> "There is a very long-running doc that has had to be chopped and purged... It's really where we coordinate what we're doing. The team meets on a daily basis, we spend whatever amount of time we need to get on the same page about what we're building."

**Insight:** A single, living document can replace complex project management software for small, high-velocity teams.

**Tactical advice:**
- Use a single Google Doc to track daily coordination, goals, and roadmap changes
- Avoid heavyweight task management tools (Jira/Asana) in favor of lightweight, text-based coordination

*Timestamp: 00:50:47*


## Lane Shackleton
*Lane Shackleton*

> "We built Catalyst to really solve those two problems [standing attendees and single-threadedness]. And so the way it works is it's essentially three one hour blocks throughout the week, and the assumption is that the whole company is free. So you can get anyone in the company for those three hours. And each topic has essentially four roles. Driver, maker, braintrust, and interested... the day before, that hold that's on calendar gets removed, and then you have specific topics that get added. So there may be three topics going all at the same time because they don't have overlapping attendees."

**Insight:** Use a 'Catalyst' model to run multi-threaded reviews with dynamic, relevant attendees rather than fixed standing meetings.

**Tactical advice:**
- Set company-wide calendar holds for review blocks.
- Assign roles for each topic: Driver, Maker, Braintrust, and Interested.
- Run parallel sessions if attendees don't overlap to increase throughput.

*Timestamp: 00:44:29*

---

> "The core idea is have a group one-on-one with the key stakeholders... we'll have a tag-up with a small set of people from a given team... and then they meet with their braintrust and it's once a week. It's the same mindset of a one-on-one. It's their time. So anything that they need to unblock a decision or to make progress, they should use that time for."

**Insight:** Replace individual project updates in 1:1s with 'Tag-ups' involving the full cross-functional triad to avoid the 'telephone game'.

**Tactical advice:**
- Schedule weekly 'Tag-ups' for the product triad (PM, Eng, Design) and their braintrust.
- Use a 'Dory' (upvoted Q&A table) to prioritize the most important topics for the group.

*Timestamp: 00:53:17*


## Laura Modi
*Laura Modi*

> "Moving away from meeting culture and being able to be in a position where we can work async, whether it's one-hour sprint over Slack, make decisions and go back and forth, 20 people, and then everyone's made a decision by the end of the hour and we're moving forward."

**Insight:** Asynchronous 'sprints' can be more effective for decision-making than traditional meetings.

**Tactical advice:**
- Replace some meetings with one-hour Slack sprints for rapid decision-making.
- Focus on getting everyone's 'head into the moment' rather than over-processing with complex tools.

*Timestamp: 00:57:51*


## Matt Abrahams
*Matt Abrahams*

> "You can actually set up a lot of your communication situations, a presentation, a meeting, et cetera, as conversations. ... For example, what would it be like if you were to start a presentation by saying, 'Today I have three questions I'd like to answer. Question number one is...' And you state the question and then you answer it."

**Insight:** Reframing a formal presentation as a conversation or a series of answered questions reduces speaker anxiety and increases engagement.

**Tactical advice:**
- Structure meeting segments as answers to specific questions
- Use a 'facilitator' mindset rather than a 'presenter' mindset to ease into the content

*Timestamp: 00:22:01*


## Matt Mochary
*Matt Mochary*

> "You know what would be exquisite? It would be exquisite if everyone pre-prepared their update, which said how they're doing against their priorities, regular green, what they did last week, what they're going to do this week, and then they pre-route any problems they saw in the company and any proposed solution they had for those problems. If everyone did that, then we could spend the first 15 minutes of the meeting just reading, processing the decisions and we could take a three hour meeting down to a 45 minute meeting."

**Insight:** Moving status updates and problem routing to a pre-read format can reduce meeting times by over 75%.

**Tactical advice:**
- Require attendees to submit written updates and proposed solutions before the meeting.
- Dedicate the first part of the meeting to silent reading and processing rather than verbal presentations.

*Timestamp: 01:05:41*


## Mayur Kamat
*Mayur Kamat*

> "The leadership team, for example, met every day, and because the leadership team was spread across the world, we met at 11:00 PM when I was in Singapore every day... which meant that none of the decisions were blocked for more than 24 hours."

**Insight:** Daily leadership meetings ensure that organizational bottlenecks never last longer than a day.

**Tactical advice:**
- Implement a 'daily meeting' for urgent, high-priority projects to maintain momentum.
- Ensure the owner of an urgent problem has all hands on deck and reports updates daily.

*Timestamp: 00:07:33*

---

> "A full calendar is a badge of shame, not a badge of honor."

**Insight:** High-leverage work requires open space on a calendar to dive into deep details and solve complex problems.

**Tactical advice:**
- Maintain open blocks in your calendar to allow for deep dives into high-leverage issues.
- Avoid filling your schedule with recurring one-on-ones and status meetings if you want to be effective.

*Timestamp: 01:13:47*


## Melanie Perkins
*Melanie Perkins*

> "In the early days we'd stand up and everyone would present their goals... and then they started to become six hours long because we had so many people and so many teams. And so trying to find that right flavor at every stage of scale is definitely hard."

**Insight:** Meeting formats must be radically reinvented as a company scales to prevent them from becoming inefficient marathons.

**Tactical advice:**
- Re-evaluate meeting structures every time the company doubles in size
- Use 'Season Openers' to provide deep context and set goals for the entire company in a structured way

*Timestamp: 00:23:17*


## Nikhyl Singhal
*Nikhyl Singhal*

> "Sometimes I realize that at a scaled organization, the meeting operating system is as important as the products that we're building because it sort of speaks to how we scale and how we ensure we have the right degree of delegation, the right conversations, and then the right acceleration on the right decisions."

**Insight:** A leader's 'meeting operating system' is a product that requires intentional design and regular iteration.

**Tactical advice:**
- Treat your meeting structure as a product (e.g., 'Version 7.0') and reboot it every 90 days
- Define the cadence, attendees, and decision-making protocols for every recurring meeting
- When joining a new org, use your 'fresh eyes' to identify and fix meeting inefficiencies first

*Timestamp: 01:19:26*


## Nir Eyal
*Nir Eyal*

> "If we're going to have a business meeting or a personal meeting, we're going to declare these no-phone zones because that's who we are. We want to be indistractable."

**Insight:** Effective meetings require social norms that prohibit digital distractions to ensure all participants are present in body and mind.

**Tactical advice:**
- Declare 'no-phone zones' for meetings to prevent antisocial behavior and distraction.

*Timestamp: 00:59:09*


## Ray Cao
*Ray Cao*

> "We are using a reading format of meeting. So it's a doc reading. We just read in comments and understanding the context again. It is the doc, bring everybody together, and then we discuss the things that we want to make a decision with or the things that we feel is a blocker or things that we need to celebrate."

**Insight:** Silent document reading at the start of meetings ensures everyone has the same context before discussion begins.

**Tactical advice:**
- Use a 'doc reading' format where participants read and comment on a document before discussing.
- Include cross-functional members (Eng, Product, Sales) in the same context-setting meetings.

*Timestamp: 00:25:28*


## Sri Batchu
*Sri Batchu*

> "using calendar blocking to really effectively manage your time that way. And then doing calendar audits of yourself as well as of your team to say, okay, what are your highest priorities for this week, this day, this month? And how does your calendar reflect your priorities?"

**Insight:** High-velocity execution requires rigorous calendar management to ensure time spent aligns with top priorities.

**Tactical advice:**
- Perform regular calendar audits to see if time allocation matches stated priorities
- Use templates for calendar audits to help new hires adapt to a high-velocity culture

*Timestamp: 00:20:31*


## Sriram and Aarthi
*Sriram and Aarthi*

> "Clarify what kind of meeting is it. Is it just an update?... Or is it a decision in which case, what are the pros, cons, et cetera?"

**Insight:** Meeting failure often occurs when the purpose (update vs. decision) is not explicitly stated.

**Tactical advice:**
- Send a pre-read document before the meeting.
- Explicitly state if the meeting is for an update, a brainstorm, or a decision.
- Avoid 'hero meetings' by having a regular, high-frequency rhythm of check-ins.

*Timestamp: 00:59:10*


## Shweta Shriva
*Shweta Shriva*

> "I would give you an interesting one that I use a lot in my prior company and then I use a different form of it here in Waymo is what I used to call as the rule of seven. If there have been seven emails in an email thread and you still haven't resolved the issue, just call the person or get in a room huddle, resolve it live."

**Insight:** Set a strict threshold for asynchronous communication to prevent endless, non-convergent email threads.

**Tactical advice:**
- Implement a 'Rule of 7' (or 10): if an issue isn't resolved after that many emails, force a live meeting or call.
- Identify when a thread is no longer converging and move it to a real-time discussion.

*Timestamp: 39:09*


## Tim Holley
*Tim Holley*

> "a simple exercise of weekly focus. What are you focused on this week? And then reflecting on, did you get done the things you were focused on last week? Seems super simple, but just the exercise of thinking about what matters, writing it down, and having a little bit of social proof or articulating it out to others creates some degree of accountability"

**Insight:** A lightweight weekly focus ritual creates accountability and helps teams recognize patterns in their productivity.

**Tactical advice:**
- Have team members post their weekly focus in a shared channel on Mondays.
- Include a reflection on whether the previous week's focus areas were completed.

*Timestamp: 01:03:11*


## Wes Kao
*Wes Kao*

> "the state change method is that you should punctuate your monologues with state changes. So state changes are anything that shakes your audience awake and adds some variety. So it might be asking people to put something in the chat box. It might be switching from gallery view... to screen share... It might be having someone else speak."

**Insight:** To maintain engagement in virtual meetings, you must break up monologues with frequent shifts in activity or visual perspective.

**Tactical advice:**
- Punctuate monologues with a 'state change' every 3-5 minutes.
- Use tools like Zoom chat, polls, breakout rooms, or switching between screen sharing and gallery view.

*Timestamp: 00:23:07*

---

> "If you even take 30 seconds to one minute to ground yourself on why am I in this meeting? What do I want to share and make sure I get across in the time that we have, you're going to go in there so much more focused."

**Insight:** Brief mental preparation before a meeting significantly improves focus and concision.

**Tactical advice:**
- Spend 60 seconds before a call defining your goal for the meeting
- Decide beforehand what specific point you want to ensure you contribute

*Timestamp: 00:21:51*


## Farhan Thawar
*Farhan Thawar*

> "Once a year at a random time, we will delete all recurring meetings that have more than two people, so not one-on- ones, and are internal people only... it forces you to rethink, 'Do we need a recurring meeting? Or do we just need one meeting? Or do we need a different cadence?'"

**Insight:** Periodically reset the organization's calendar by deleting all recurring meetings to eliminate 'meeting debt' and inertia.

**Tactical advice:**
- Delete all internal recurring meetings with more than two people annually
- Enforce a two-week moratorium where no new recurring meetings can be added after the deletion

*Timestamp: 00:37:28*


## Megan Cook
*Megan Cook*

> "I personally hate having status updates as a meeting. So I make it really clear that if we're having a meeting, this is to solve a problem. And if it's just a status update, that's fine, then I can read that asynchronously at a time that works for me."

**Insight:** Maximize meeting efficiency by banning status updates and reserving synchronous time exclusively for problem-solving.

**Tactical advice:**
- Move all status updates to asynchronous tools or email
- Ensure every meeting has a clear problem-solving objective
- Protect deep work time by syncing leadership calendars to have long stretches of meeting-free hours

*Timestamp: 00:21:52*


## Naomi Gleit
*Naomi Gleit*

> "We have one weekly sort of strategic meeting. It's more open-ended, there is time for discussion. It's longer and it's sort of more unstructured. We also have one weekly operational meeting, which is highly structured where we go through all of the priority projects."

**Insight:** Separate strategic discussions from operational updates into different meeting formats to maintain focus and efficiency.

**Tactical advice:**
- Schedule a structured weekly operational meeting for project updates
- Schedule a separate, longer, unstructured meeting for strategic discussion

*Timestamp: 00:23:25*

---

> "I will often have a visual in a meeting. I will leverage that visual to literally real time edit what is being decided. For example, if we have multiple options, I will edit the slide that's being projected to say, 'We decided on option one, here are the next steps, 1, 2, 3.'"

**Insight:** Use live-editing of visuals during meetings to ensure immediate alignment on decisions and next steps.

**Tactical advice:**
- Project a document or slide during the meeting
- Edit the projected content in real-time to reflect decisions made

*Timestamp: 00:51:54*

---

> "What I will do is send an agenda 24 hours prior to the meeting. That agenda will include a pre-read... During the meeting... I think it's really important for a group of people to be looking at something and anchoring people on something."

**Insight:** Effective meetings require pre-reads sent 24 hours in advance and a visual anchor to keep participants focused.

**Tactical advice:**
- Send an agenda and pre-read at least 24 hours before the meeting
- Use a visual anchor so latecomers can immediately see the current topic

*Timestamp: 01:07:48*

---

> "After the meeting... within 24 hours post-meeting I will send the notes, reply all to the meeting invite and send the notes. So just tactically, I use the calendar invite as the canonical unit by which to handle all of this communication"

**Insight:** Use the calendar invite as the central hub for all meeting-related communication, including pre-reads and post-meeting notes.

**Tactical advice:**
- Reply-all to the calendar invite to send pre-reads
- Reply-all to the calendar invite within 24 hours after the meeting to share notes and decisions

*Timestamp: 01:08:28*


## Paige Costello
*Paige Costello*

> "If a meeting has more than 10 people on it, we ask the person hosting the meeting to kick out the other people and write better decision notes."

**Insight:** Capping meeting attendance and prioritizing high-quality decision notes increases organizational pace and clarity.

**Tactical advice:**
- Limit meeting attendance to 10 people or fewer.
- Require meeting hosts to provide written decision notes for those not in attendance.

*Timestamp: 00:59:18*

---

> "I use Asana to run all my meetings and assign pre-reads. So I use the multi-assign feature in subtasks all the time where I make a task with a due date that says, 'Read this thing by this date,' and then I assign it to a team or a set of individuals like that really quickly."

**Insight:** Use task management tools to formalize pre-reads and action items, ensuring meetings are focused on discussion rather than information sharing.

**Tactical advice:**
- Assign pre-reads as tasks with specific due dates before the meeting.
- Take live notes in a shared task and convert them into subtasks for immediate follow-up.

*Timestamp: 01:01:12*


## Tamar Yehoshua
*Tamar Yehoshua*

> "First he does not speak until everybody around the table speaks. So he goes around to all his leads and said, 'What do you think? What do you think? What do you think?'... And he always spoke last. He is by far the smartest person I've ever met in my life... But he wants to make sure that it's a team effort and that he's listening to what everybody in his organization thinks."

**Insight:** Leaders should speak last in meetings to ensure they hear unbiased input from the team and encourage a team effort.

**Tactical advice:**
- Go around the table and ask every lead for their opinion before sharing your own.

*Timestamp: 00:27:25*

---

> "We had a Slack channel for each team, their OKRs, a planning channel for each one. And people would post a doc and then a Slack video of going through the major points. And we had a time limit of how long they were allowed to be... And then Cal and I would do a marathon and we would watch them all together."

**Insight:** Moving status updates and planning to asynchronous video clips saves hundreds of hours of meeting time.

**Tactical advice:**
- Use a dedicated channel for each team's planning.
- Require teams to post a document and a short video summary (e.g., Slack Clips) instead of a live presentation.
- Only schedule follow-up meetings for high-priority projects or those with many questions.

*Timestamp: 00:42:00*


