---
name: running-offsites
description: Help users plan and run effective team offsites. Use when someone is organizing a team retreat, planning a strategy offsite, trying to improve remote team cohesion, or preparing for quarterly planning sessions.
---

# Running Offsites

Help the user plan and run effective team offsites using frameworks from 5 product leaders.

## How to Help

When the user asks for help with offsites:

1. **Clarify the purpose** - Ask what outcome they want from the offsite (strategy, connection, planning)
2. **Assess readiness** - Determine if there are underlying team issues that need addressing first
3. **Design the structure** - Help them balance work sessions with social connection
4. **Remove friction** - Guide them on logistics that make offsites productive

## Core Principles

### Use "bursts" for remote teams
Brandon Chu: "We've actually instituted with something we call bursts. So bursts at Shopify are the ability for your team generally maybe once a quarter or whatnot, to just come together to do really high velocity creative work together, to hang out together." Remote-first companies should schedule quarterly in-person sessions for high-velocity creative work that's difficult to do asynchronously.

### Offsites create space and imprint memory
Claire Hughes Johnson: "When you yank people out of their day-to-day routine, you create space, and also you imprint memory... you're basically activating new parts of their brain, and then you're also having a group experience that cements a belief system usually, or a set of plans." Remove the team from day-to-day routines like email to focus on brainstorming. Use offsites to collaboratively form plans rather than presenting pre-made ones.

### Address conflict before soft skills training
Donna Lichaw: "They pulled me aside halfway through the offsite, and they were just like, 'Honestly, storytelling is not going to fix our problems.'" Offsites focused on soft skills may fail if there are underlying interpersonal conflicts. Address team connection and conflict before attempting workshops on influence or communication.

### Go laptops-down and use whiteboards
John Mark Nickels: "It was like, laptops down, we're going to spend all day together on a whiteboard. It's like a lost art. People don't use the whiteboards anymore." Deep strategic work requires removing digital distractions. Physical collaboration tools like whiteboards facilitate co-creation and riffing.

### Balance social connection with strategy
Megan Cook: "We start off with just doing something fun... And then after that we talk about strategy. We do workshops on different elements of craft boosting that craft together." Start offsites with social activities to build human connection before diving into work. Use semi-annual gatherings to combine strategy alignment with skill-building.

## Questions to Help Users

- "What's the single most important outcome you want from this offsite?"
- "Are there underlying team conflicts that might undermine the offsite agenda?"
- "How will you ensure people disconnect from day-to-day work during the offsite?"
- "What's the right balance between work sessions and social time for this team?"
- "When did the team last meet in person? What worked well and what didn't?"

## Common Mistakes to Flag

- **Packed agendas** - Scheduling every minute without leaving space for organic conversation
- **Soft skills over hard problems** - Running workshops on communication when the real issue is conflict or strategy
- **Not disconnecting** - Allowing email and Slack to compete with offsite activities
- **Too infrequent** - Waiting too long between in-person gatherings for remote teams
- **Presenting rather than creating** - Using offsites to present pre-made plans instead of collaboratively building them

## Deep Dive

For all 5 insights from 5 guests, see `references/guest-insights.md`

## Related Skills

- running-effective-meetings
- running-decision-processes
- post-mortems-retrospectives
