---
name: sales-compensation
description: Help users design sales compensation plans. Use when someone is hiring their first sales rep, restructuring sales comp, trying to align sales incentives with business goals, or dealing with comp plan issues like sandbagging or churn.
---

# Sales Compensation

Help the user design effective sales compensation plans using frameworks from 2 product leaders.

## How to Help

When the user asks for help with sales compensation:

1. **Understand the business model** - Ask about their sales cycle, ACV, and customer retention patterns
2. **Identify current problems** - Determine if there are misaligned incentives or retention issues
3. **Design aligned incentives** - Help them create comp plans that drive the right behaviors
4. **Consider ramp and quotas** - Guide them on structuring pay for new hires

## Core Principles

### The standard 50/50 split is a starting point
Jason M Lemkin: "It's usually 50/50, right? 50% base, 50% bonus for a sales rep." The standard OTE structure is 50% base salary and 50% variable commission. This is a common baseline for quota-carrying roles.

### Traditional comp plans are misaligned
Sahil Mansuri: "Sales comp plans are stuck in the stone ages... What we haven't done is built a modern technical sales compensation plan that actually aligns the needs and incentives of the business, the customer and the rep." Consider designing comp that rewards long-term retention and net dollar retention, not just closed deals.

### Align incentives with customer success
If your business depends on customer retention, comp plans should include components tied to customer outcomes, not just initial bookings. Reps who close churny deals should earn less than those who close sticky customers.

### Ramp periods matter
New sales hires need ramp periods with guaranteed draws or reduced quotas while they learn the product and market. Typical ramps are 3-6 months for SMB and 6-12 months for enterprise.

### Simplicity drives behavior
Complex comp plans with many variables lead to confusion and gaming. Simple plans where reps understand exactly what actions increase their pay are more effective.

## Questions to Help Users

- "What percentage of new deals churn within the first year? Does your comp plan account for this?"
- "Is your comp plan so complex that reps don't know how to maximize their earnings?"
- "What behaviors are you trying to incentivize? Does your comp plan actually reward those behaviors?"
- "How long is your sales cycle, and how does that affect cash flow for reps?"
- "What's your ramp structure for new hires? Is it working?"

## Common Mistakes to Flag

- **Incentivizing only bookings** - Paying for closed deals without considering customer quality or retention
- **Over-complicated plans** - Too many variables that confuse reps and enable gaming
- **No ramp protection** - Expecting new hires to hit full quota immediately
- **Misaligned accelerators** - Bonuses that kick in at the wrong thresholds
- **Ignoring churn** - Comp plans that don't account for customers who don't renew

## Deep Dive

For all 2 insights from 2 guests, see `references/guest-insights.md`

## Related Skills

- sales-qualification
- product-led-sales
- pricing-strategy
