---
name: scoping-cutting
description: Help users scope projects and cut features effectively. Use when someone is defining an MVP, dealing with scope creep, trying to ship faster, or needs to make tradeoffs about what to build.
---

# Scoping & Cutting

Help the user scope projects and cut features effectively using frameworks from 15 product leaders.

## How to Help

When the user asks for help with scoping:

1. **Understand the hypothesis** - Ask what they're trying to learn or validate
2. **Identify the appetite** - Determine how much time/resources they're willing to invest
3. **Find the essential core** - Help them identify what must be present for the first version
4. **Design for learning** - Ensure the scope enables fast feedback, not just fast shipping

## Core Principles

### Use appetite, not estimates
Ryan Singer: "We're going to go the other way around and we're going to say, what is the maximum amount of time we're willing to go before we actually finish something?" Set a fixed time budget (appetite) and design a version of the solution that fits within it. Vary scope, not deadlines.

### MVP is a validation tool
Eric Ries: "MVP is simply for whatever the hypothesis is that we're trying to test, what is the most efficient way to get the validation we need about whether a hypothesis is true or not?" An MVP is not a low-quality product - it's the most efficient way to test a specific hypothesis.

### Cut the list in half, then half again
Eric Ries: "Write out the list of features that are necessary in your MVP. Cut it in half and cut it in half again and build that." Founders consistently overestimate what's "minimum." Aggressive cutting is required to reach a true baseline.

### Fixed time, small teams
Jason Fried: "Our appetite for any individual feature is no more than six weeks... So we have to figure out the simplest, most effective version of that to get that done within six weeks and get it done by two people." Constraints force creative solutions. Limit team size to maintain focus.

### Build the scooter, not the axle
Eeke de Milliano: "If you're trying to build the minimum viable product for a car, don't build just the wheels and the axle, build the scooter first." An MVP should be a functional, end-to-end version of a smaller value proposition, not an incomplete piece of a larger one.

### Use Wizard of Oz testing
Crystal W: "It's really this Wizard of Oz experience. We don't have to build anything. I coordinated with a bunch of interns and we were able to validate some of the value prop." Validate value propositions manually before investing in engineering. Use humans to simulate automated features.

### Kill projects that don't finish in time
Jason Fried: "If there's any work that's left over that's still on the left side of the hill, meaning we're still pushing it up, we don't know how we're going to do it and we're at our time limit, it almost certainly dies." Let projects die if they aren't completed within their allotted time to prevent never-ending work.

### Build the option to pivot into the process
Paige Costello: "We added into our product process a notion that we might pivot or cut from stuff that we put on our roadmap because it felt like once it was on the roadmap, it had to be done." Formalize the ability to cut or pivot from roadmap items to avoid the sunk cost fallacy.

## Questions to Help Users

- "What's the single hypothesis you're trying to validate with this version?"
- "What's the maximum time you're willing to invest before shipping something?"
- "What would you cut if you had to ship in half the time?"
- "Is there a way to test this manually before building automation?"
- "If this feature doesn't ship in time, will you kill it or extend?"
- "What's the smallest thing that still delivers complete value?"

## Common Mistakes to Flag

- **Estimating instead of time-boxing** - Asking "how long will this take?" instead of "what can we do in X weeks?"
- **Building the axle** - Shipping incomplete parts of a larger feature instead of complete smaller features
- **Never killing projects** - Extending deadlines instead of cutting scope or canceling
- **Over-engineering the MVP** - Building too much before testing the core hypothesis
- **Ignoring the Wizard of Oz** - Always defaulting to building when manual validation would be faster

## Deep Dive

For all 19 insights from 15 guests, see `references/guest-insights.md`

## Related Skills

- prioritizing-roadmap
- planning-under-uncertainty
- problem-definition
