# Scoping & Cutting - All Guest Insights

*15 guests, 19 mentions*

---

## Anton Osika
*Anton Osika*

> "A lot of jargon that I like to use to emphasize what we should be striving for is building a minimum lovable product and then building a lovable product and then building an absolutely lovable product. So I took that jargon with me in the company name."

**Insight:** Shift the focus from 'Minimum Viable Product' to 'Minimum Lovable Product' to ensure the initial release resonates emotionally with users.

**Tactical advice:**
- Aim for 'lovability' rather than just 'viability' in early versions
- Iterate from Minimum Lovable to Absolutely Lovable

*Timestamp: 00:00:31*


## Crystal W
*Crystal W*

> "It's really this Wizard of Oz experience. We don't have to build anything. I coordinated with a bunch of interns and we were able to validate some of the value prop and conversion rates that we would expect in a subscription service."

**Insight:** Use manual 'Wizard of Oz' testing to validate product value propositions before investing in engineering resources.

**Tactical advice:**
- Use WhatsApp groups to manually simulate automated features
- Test onboarding flows using simple in-app message overlays on existing screens
- Use Typeform for quick feature validation like personality quizzes

*Timestamp: 00:14:46*


## Daniel Lereya
*Daniel Lereya*

> "I really love using the deadline trap and it makes you focused... It removes all the theoretical discussions that people have and things like that."

**Insight:** Setting hard time-boxes (traps) forces teams to prioritize the core value and prevents 'death by a thousand cuts' from over-engineering.

**Tactical advice:**
- Set a fixed deadline (e.g., 3 weeks) and cut scope to fit the time rather than extending the date
- Use external events like earnings calls as 'traps' to force product delivery

*Timestamp: 00:53:48*


## Dharmesh Shah
*Dharmesh Shah*

> "we had a rule in the HubSpot product... that every time you added what we thought of as a knob or dial, called a feature, you had to take one out somewhere else. That's a net amount of... it just at least forces you to think about it"

**Insight:** To fight product entropy, enforce a 'one-in, one-out' rule for features to keep complexity constant.

**Tactical advice:**
- Evaluate the 'third-order' cost of a feature: the dimensional complexity it adds to every future decision and chart.

*Timestamp: 00:41:00*


## Eeke de Milliano
*Eeke de Milliano*

> "Build the scooter, not the axle. So if you're trying to build the minimum viable product for a car, don't build just the wheels and the axle, build the scooter first. And then from there, you build the bicycle, and the motorcycle, and then the car."

**Insight:** An MVP should be a functional, end-to-end version of a smaller value proposition, not an incomplete piece of a larger one.

**Tactical advice:**
- Identify the smallest 'slice' that allows a customer to complete a valuable task
- Ensure the MVP is a standalone functional product (the 'scooter') rather than a component (the 'axle')

*Timestamp: 00:47:34*


## Eric Ries
*Eric Ries*

> "MVP is simply for whatever the hypothesis is that we're trying to test, what is the most efficient way to get the validation we need about whether a hypothesis is true or not?"

**Insight:** An MVP is a validation tool for a specific hypothesis, not just a low-quality version of a product.

**Tactical advice:**
- Identify the core hypothesis first
- Determine the most efficient way to get validation
- Contain the liability of making a mistake

*Timestamp: 00:28:22*

---

> "The first tip is, write out the list of features that are necessary in your MVP. Cut it in half and cut it in half again and build that. Honestly, if you just do that, that's really not that bad."

**Insight:** Founders consistently overestimate what is 'minimum' for an MVP; aggressive cutting is required to reach a true baseline.

**Tactical advice:**
- List all features deemed 'necessary'
- Cut the list in half
- Cut the remaining list in half again

*Timestamp: 00:43:02*


## Jackson Shuttleworth
*Jackson Shuttleworth*

> "We really resist the urge to do the big V1. And I think this is, I shared the streak goal example, where, a lot of times when we're exploring something we will say, okay, well, that's cool, how do we strip away a bunch of stuff and figure out what our core hypothesis is? And then, just ship that thing first as a V1."

**Insight:** Shipping the simplest possible version of a hypothesis allows for faster learning and avoids 'whistle' bias.

**Tactical advice:**
- Strip away all non-essential features to isolate the core hypothesis.
- Avoid adding 'bells and whistles' to a V1 just to ensure it wins; test the core mechanic first.

*Timestamp: 01:10:44*


## Jason Fried
*Jason Fried*

> "We instead have appetites. And our appetite for any individual feature is no more than six weeks. Essentially that's our budget we're willing to spend. I'm only willing to spend six weeks in any feature. So we have to figure out the simplest, most effective version of that to get that done within six weeks and get it done by two people."

**Insight:** Use a fixed time budget (an 'appetite') rather than an estimate to force the team to find the simplest, most effective version of a feature.

**Tactical advice:**
- Set a hard maximum of six weeks for any feature development
- Treat time as a budget to be spent rather than a deadline to be estimated
- Limit team size to two people (one designer, one programmer) to maintain focus

*Timestamp: 00:34:21*

---

> "If we say we're going to give it six weeks and we give it seven or eight or nine or 10, then we're not really giving it six weeks, we're giving it 10, then we don't really have a system... If there's any work that's left over that's still on the left side of the hill, meaning we're still pushing it up, we don't know how we're going to do it and we're at our time limit, it almost certainly dies."

**Insight:** Maintain the integrity of time constraints by killing projects that aren't completed within their allotted 'appetite' window.

**Tactical advice:**
- Let projects 'die' if they aren't finished in the cycle to prevent never-ending work
- Only grant extensions of a few days if the work is in the final execution phase ('downhill')
- Avoid the demoralization of long-running projects by enforcing strict cycle ends

*Timestamp: 00:36:27*


## Matt LeMay
*Matt LeMay*

> "And they did get it done, and they got it done through subtracting. They streamlined the experience. They took out steps that people were getting stuck on. They made things easier. They did the kinds of things that are rarely celebrated in the way that traditional feature launches were celebrated, but because they had this clear, impactful, specific sense of what success looks like, they were able to take on that work themselves"

**Insight:** Impact is often achieved through subtraction and streamlining rather than adding new features.

**Tactical advice:**
- Look for steps in the user journey to remove rather than features to add.
- Focus on the 'commercial heart' of the business (e.g., the first successful action) when deciding what to cut.

*Timestamp: 00:32:15*


## Ronny Kohavi
*Ronny Kohavi*

> "Try to decompose your redesign if you can't decompose it to one factor at a time, to a small set of factors at a time. And learn from these smaller changes what works and what doesn't. ... Do them in smaller increments, learn from, it's called OFAT one-factor-at-a-time. Do one factor, learn from it, and adjust."

**Insight:** Decompose large redesigns into 'One Factor At a Time' (OFAT) increments to avoid the risk of a single massive failure.

**Tactical advice:**
- Break down complex projects into smaller, testable increments
- Use incremental testing to identify which specific changes in a redesign are actually providing value

*Timestamp: 00:38:42*


## Ryan Singer
*Ryan Singer*

> "We’re going to go the other way around and we’re going to say, what is the maximum amount of time we’re willing to go before we actually finish something? How do we come up with a idea that’s going to work in the amount of time that the business is interested in spending?"

**Insight:** Instead of estimating how long a feature will take, set a fixed time budget (appetite) and design a version of the solution that fits within it.

**Tactical advice:**
- Set a maximum time limit (e.g., six weeks) for any project to maintain visibility and control.
- Vary the scope of the solution rather than the deadline to ensure shipping.

*Timestamp: 00:00:37*

---

> "The second piece is this work that we call shaping and the shaping work is, how do we actually take this fixed amount of time that we’ve given for ourselves and vary the scope? How do we come up with a idea, some version of this that’s going to work in the amount of time that the business is interested in spending?"

**Insight:** Shaping is the creative process of adjusting a solution's complexity to match the available time budget.

**Tactical advice:**
- Wrestle with the problem and solution simultaneously until the idea fits the time box.
- Identify the 'must-have' moving parts that make the feature valuable and cut the rest.

*Timestamp: 00:21:07*

---

> "If a project is not on track to actually finish after the six weeks, we’re just going to cancel it and rethink... we’re not going to keep reinvesting in something that we don’t understand. So, let’s take this out of build mode and bring this back into shaping mode."

**Insight:** Use a 'circuit breaker' to stop projects that exceed their time box rather than allowing them to drag on indefinitely.

**Tactical advice:**
- If a project fails to ship, return it to the shaping phase to identify hidden complexities.
- Avoid 'overtime' debt by treating the end of a cycle as a hard stop for reinvestment decisions.

*Timestamp: 00:31:34*


## Sander Schulhoff
*Sander Schulhoff 2.0*

> "Depending on what the user wants, we might be able to restrict the possible actions of the agent ahead of time, so it can't possibly do anything malicious... CAMEL would look at my prompt... and say, 'Hey, it looks like this prompt doesn't need any permissions other than write and send email.'"

**Insight:** The CAMEL framework allows for dynamic scoping of agent permissions based on the specific user intent, reducing the attack surface.

**Tactical advice:**
- Implement dynamic permissioning to restrict agent actions to the minimum necessary for a specific task
- Separate 'read' and 'write' permissions to prevent automated data exfiltration

*Timestamp: 01:05:34*


## Vijay
*Vijay*

> "Instead of making the estimate an output of planning, you make the time box or an appetite the input, and you say, 'We want to solve X problem and we're willing to invest six weeks solving that problem.'"

**Insight:** Use 'appetite' (fixed time) as an input to force scope-hammering, rather than using variable estimates as an output.

**Tactical advice:**
- Set a fixed time box (e.g., 6 weeks) for a problem and adjust scope to fit
- Perform a thought exercise: 'What would we do differently if we only had 4 weeks vs 8 weeks?' to find the efficient frontier of cost and impact

*Timestamp: 27:23*


## Zoelle Egner
*Zoelle Egner*

> "The power of having a laughably small MVP for something... In the beginning it was truly, basically, a spreadsheet, and phones, and that was it. Even that... not only had tremendous impact... but also gave us so much information about we actually needed to build that was going to be helpful."

**Insight:** Starting with the smallest possible infrastructure allows for rapid learning and prevents building based on incorrect assumptions.

**Tactical advice:**
- Use existing simple tools (spreadsheets, phones) to validate a concept before building custom software
- Focus on the core utility that provides immediate impact
- Prune features aggressively to maintain agility as requirements change

*Timestamp: 00:15:51*


## Paige Costello
*Paige Costello*

> "We added into our product process a notion that we might pivot or cut from stuff that we put on our roadmap because it felt like once it was on the roadmap, it had to be done, and that's just not smart."

**Insight:** Explicitly build the option to pivot or cut features into the product process to avoid the 'sunk cost' fallacy of roadmaps.

**Tactical advice:**
- Formalize a process step where teams can decide to cut or pivot from items already on the roadmap.
- Encourage iterative shipping and prototyping to validate scope early.

*Timestamp: 00:10:38*


