---
name: setting-okrs-goals
description: Help users set effective OKRs and goals. Use when someone is creating quarterly objectives, defining key results, setting team goals, planning annual targets, or struggling with goal alignment across their organization.
---

# Setting OKRs & Goals

Help the user create effective objectives and key results using frameworks and insights from 55 product leaders.

## How to Help

When the user asks for help with OKRs or goal setting:

1. **Understand context** - Ask about their company stage, team size, and whether they have existing goals or are starting fresh
2. **Clarify the level** - Determine if these are company, department, team, or individual goals
3. **Identify the strategy** - Ensure they have a clear strategy before setting goals (goals should be the end of strategy, not the beginning)
4. **Guide the structure** - Help them write inspiring objectives and measurable key results that avoid common pitfalls

## Core Principles

### Goals should be one step from company goals
Matt LeMay: "No more than one step away from company goals. Don't let it get cascaded into oblivion." Ensure team goals orbit directly around the primary company objective rather than being buried under layers of organizational cascading.

### Build systems, not just goals
Lane Shackleton: "Instead of being obsessed with the goal, be obsessed with the system that gets you there." Replace one-time OKR targets with recurring 'default-on' systems like standing customer meetings that build long-term instincts.

### OKRs bridge strategy to execution
Christina Wodtke: "The main benefit is that there's a lot of concrete action through an OKR that you don't always get from strategy." Use OKRs to turn abstract strategy into concrete quarterly numbers while creating a learning cycle through end-of-quarter grading.

### Triangulate with three key results
Christina Wodtke: "I like three. Something that's really hardcore numbers, something that's a little squishier like quality, and something that involves a dollar sign." Balance quantitative, qualitative, and financial metrics for a complete view of success.

### Use absolute numbers, not ratios
Archie Abrams: "Ratios and percentages are dangerous metrics because they can be 'gamed' by reducing the denominator." Shift goals from 'conversion rate' to 'absolute number of users reaching a specific state' to prevent gaming.

### Ambitious goals force new thinking
Daniel Lereya: "Put ambitious goals, it'll make you think differently. We really love to do it even when we don't know it's possible." Set goals impossible to achieve through 'working harder' alone to force 'working smarter' and fundamental rethinks.

### Separate strategy from OKR discussions
Lane Shackleton: "OKRs are not actually strategy. It's critical to disconnect strategy discussions from OKR discussions." Create a distinct strategy ritual before OKR planning to ensure the 'why' isn't lost in the 'what'.

### Limit planning overhead
Lane Shackleton: "The 10% planning rule - ensure you're not planning for more than 10% of that execution period." If planning for a quarter, spend no more than about a week on the planning process.

### Focus on outcomes, not outputs
Marty Cagan: "In a real product team, you celebrate when you actually solve the problem. That's why we say product teams are about outcomes, not output." Define success by problem resolution rather than feature shipment.

### Goals are communication tools
Molly Graham: "No company needs more than three company goals. The point is to help people know what the most important things are." Keep goals simple, ensure one wins in a fight, and assign exactly one owner to every goal.

## Questions to Help Users

- "What is your company's primary goal right now, and how does this team goal connect to it?"
- "How will you know if you've succeeded - what specific number would change?"
- "Is this objective inspiring enough to motivate the team through obstacles?"
- "Are your key results outcomes (how you know you succeeded) or tasks (a to-do list)?"
- "What system could you build to make progress on this goal 'default-on'?"
- "If you achieve this goal but hurt user experience, would it still be a success?"

## Common Mistakes to Flag

- **Key results that are tasks** - Key results should be measurable outcomes, not a checklist of activities to complete
- **Too many goals** - Companies need no more than three goals; more than that dilutes focus and prevents trade-offs
- **Vague objectives** - Objectives should make you excited to get out of bed, not generic corporate language
- **Goals set before strategy** - If you don't have a real strategy, OKRs become meaningless exercises in false precision
- **Over-indexing on a single metric** - This can incentivize keeping customer-hostile features that happen to move the number

## Deep Dive

For all 74 insights from 55 guests, see `references/guest-insights.md`

## Related Skills

- Writing North Star Metrics
- Defining Product Vision
- Prioritizing Roadmap
- Stakeholder Alignment
