# Setting OKRs & Goals - All Guest Insights

*55 guests, 74 mentions*

---

## Ami Vora
*Ami Vora*

> "Maybe instead of motivating everyone on GMV, you motivate them on GMV per surface and you divide up the surfaces, or maybe you motivate them on actually different goals that underlie... Can you goal on those input metrics, can you goal on number of people who visit, number of people who convert, number of people who reorder?"

**Insight:** Avoid 'toddler soccer' (everyone chasing the same metric) by detangling goals into specific input metrics for each team.

**Tactical advice:**
- Break down high-level output metrics (like GMV) into movable input metrics (like conversion or reorder rate).
- Assign unique 'swim lanes' or surfaces to different teams to prevent overlap and friction.

*Timestamp: 00:56:27*


## Anuj Rathi
*Anuj Rathi*

> "I've seen OKRs fail multiple times when you're running this kind of a marketplace. Big bets work much better... because the fundamental assumption here is that it is solving for a kind of user... But if it is working for three different kinds of users, then all the goals will all the time be in conflict with each other."

**Insight:** Standard OKRs often fail in multi-sided marketplaces because the goals of different user groups (e.g., consumers vs. delivery partners) are inherently in conflict.

**Tactical advice:**
- In complex marketplaces, replace granular OKRs with 'Big Bets' that tell a holistic story of how a lever pull affects all sides of the market.
- Acknowledge that moving one lever in a marketplace (like delivery fees) will inevitably stretch other levers (like restaurant commissions).

*Timestamp: 00:59:43*


## Annie Pearl
*Annie Pearl*

> "We have three main OKRs that we're focused on for this year, for example, across the whole company. And then we have department level OKRs, many of which are in support of the company level OKRs... this has been a really incredible transformation of dependency mapping, being able to make sure that we're pulling all the levers across the organization to drive our most important objective."

**Insight:** Effective OKRs require tight integration between company-level objectives and department-level key results to ensure alignment and dependency mapping.

**Tactical advice:**
- Limit company-level OKRs to a small number (e.g., three) to maintain focus.
- Ensure department OKRs directly support company-level objectives.
- Use OKRs as a tool for dependency mapping across the organization.

*Timestamp: 00:19:11*


## Asha Sharma
*Asha Sharma*

> "The second thing that we do is that we have kind of loose quarterly OKR. So like, 'Okay, if we believe that, what do we need to do next quarter to actually put ourselves on a path to that?' And then from there, teams are operating in squads and they're kind of setting out four to six week goals."

**Insight:** Use a tiered goal-setting system that combines loose quarterly objectives with tight, short-term execution cycles.

**Tactical advice:**
- Set 'loose' quarterly OKRs to provide direction without over-baking the plan
- Empower squads to set 4-6 week goals for specific problem areas

*Timestamp: 32:06*


## Archie Abrams
*Archie Abrams*

> "When you have teams naturally break up the world into different funnel stages or different points in the journey, it gets very seductive to look at my part of the funnel, and what's my conversion rate through that part of the funnel? ... But in practice, I talked about it's actually almost always easier to just make it harder to do the thing right before your step in the funnel to increase your conversion rate."

**Insight:** Ratios and percentages are dangerous metrics because they can be 'gamed' by reducing the denominator; absolute numbers are more robust for growth teams.

**Tactical advice:**
- Shift team goals from 'increasing conversion rate' to 'increasing the absolute number of users' reaching a specific state.
- Be wary of LTV or retention improvements that are accompanied by a corresponding drop in total volume.

*Timestamp: 00:27:29*

---

> "We ran against KPIs are basically banned as OKRs or banned and all that. And so certainly, in growth you have metrics, but they take a different form. And then in core, it truly is, do we have conviction that this is the right technical foundation to build the future of commerce?"

**Insight:** Banning traditional KPIs and OKRs in core product teams can prevent short-termism and allow for more ambitious, vision-led development.

**Tactical advice:**
- Use 'taste' and 'conviction' as primary drivers for core product decisions rather than short-term metric lifts.
- Reserve metric-driven accountability for growth-specific teams while allowing core teams to focus on long-term foundations.

*Timestamp: 00:48:31*


## Bill Carr
*Bill Carr*

> "We realized we're not really actually working on things that matter to customers that are going to move the needle over the long term... So we then figured out ways to measure them creating a set of input metrics. And so then when we would develop our operating plans and review our business each week and set our goals, we were hyperfocused on those inputs and the input metrics."

**Insight:** Focus goals on controllable input metrics (the 'flywheel') rather than just output metrics like revenue.

**Tactical advice:**
- Identify the inputs that drive your growth flywheel (e.g., selection, price, speed)
- Set goals based on improving these inputs rather than just hitting financial targets
- Use the DMAIC (Define, Measure, Analyze, Improve, Control) process to understand and improve inputs

*Timestamp: 00:55:03*


## Christina Wodtke
*Christina Wodtke*

> "The main benefit is that there's a lot of concrete action through a OKR that you don't always get from strategy... It creates a cadence of progress... It creates alignment... it creates this learning cycle."

**Insight:** OKRs bridge the gap between high-level strategy and weekly execution while fostering a continuous learning environment.

**Tactical advice:**
- Use OKRs to turn 'Muji Muji' strategy into concrete quarterly numbers.
- Grade OKRs at the end of the quarter to identify what got in the way and inform the next cycle.

*Timestamp: 00:07:51*

---

> "I would say, "What am I doing this week to get closer to our goals?" If you could answer that question, you could give up all the OKR stuff, but if you just asked the question, "What are we doing this week to get closer to our strategic goals, our longer term goals?" That is the very heart of it"

**Insight:** The fundamental unit of an OKR is the weekly commitment to moving toward a long-term strategic outcome.

**Tactical advice:**
- Tie OKRs to 'temporal landmarks' like Mondays and quarters to create natural starting points.
- Ask the team every week: 'What are we doing right now to solve the tomorrow problem?'

*Timestamp: 00:11:44*

---

> "I like three. I think about it as triangulating. I always like something that's really hardcore numbers. I like something that's a little squishier, like a quality, make sure you don't forget about it. And I usually like something that involves a dollar sign"

**Insight:** Effective OKRs use a mix of quantitative, qualitative, and financial metrics to provide a balanced view of success.

**Tactical advice:**
- Limit key results to three per objective to maintain focus.
- Triangulate success by including one hard number, one quality metric, and one financial metric.

*Timestamp: 00:23:06*

---

> "Objectives, people make them so fluffy that they don't have any meaning... Your objectives should make you, when your alarm goes off and you wake up, you go, "Oh yeah, I'm changing the world today..." And then the key results, it's always going to be tasks."

**Insight:** Common OKR failures include uninspiring, vague objectives and key results that are merely a to-do list of tasks.

**Tactical advice:**
- Write objectives that are motivating and meaningful, not just 'shipping a thing'.
- Ensure key results are outcomes (how we know we succeeded) rather than a list of tasks.

*Timestamp: 00:25:09*

---

> "I recommend some pretty long brainstormings on the key results, but the objective is sort of a manifestation of the strategy at a one quarter level."

**Insight:** Spend significant time brainstorming diverse ways to measure an objective to move past obvious metrics to insightful ones.

**Tactical advice:**
- Spend at least 10 minutes brainstorming every possible way to measure an outcome to find non-obvious insights.
- Ensure the objective is a direct quarterly manifestation of the broader strategy.

*Timestamp: 00:29:12*

---

> "give my book to your best team and say, "We're thinking about OKRs. Can you guys see if it works?"... because the best team always wants to be better. I love piloting with the best team, but they're still very imbued in your culture, so they'll figure out where OKRs in your culture don't fit."

**Insight:** Roll out OKRs by piloting with high-performing teams who can adapt the framework to the specific company culture.

**Tactical advice:**
- Pilot OKRs with your best multidisciplinary team first rather than a struggling team.
- Use the pilot team's feedback to create a template for the rest of the organization.

*Timestamp: 00:38:13*

---

> "instead of having your boss approve it, you write your OKRs, you get three... teams that work with you enough to know what you're up to, to look them over and they just look them over, 24 hour turnaround."

**Insight:** The approval process for OKRs should be peer-based and rapid to avoid bureaucratic delays that stall execution.

**Tactical advice:**
- Use the 'Rule of Three': have three peer teams review your OKRs with a 24-hour turnaround.
- Avoid top-down approval chains that take weeks to finalize.

*Timestamp: 00:50:23*


## Chip Conley
*Chip Conley*

> "Brian had that he had to maybe create ridiculous goals, because even if we hit half of that goal, it was very encouraging. What he missed in that was the fact that when you miss a goal... you're setting people up for a lot of stress."

**Insight:** Setting 'ridiculous' or impossible goals can be demotivating and stressful if not balanced with emotional intelligence.

**Tactical advice:**
- Be cautious of the psychological impact of setting goals that are intentionally unreachable

*Timestamp: 00:16:53*


## Claire Hughes Johnson
*Claire Hughes Johnson*

> "Stripe, we have an annual set of numeric targets that we put together, we have a system of goals or OKRs, objectives and key results... what is your structure for setting milestones that you want to achieve, whether they're numeric or more like a binary, we got this thing launched, we didn't?"

**Insight:** A consistent goal-setting structure provides organizational stability and a clear way to measure progress against the plan.

**Tactical advice:**
- Set annual numeric targets and quarterly OKRs
- Use a mix of numeric targets and binary milestones (e.g., 'launched' vs 'not launched')
- Ensure the goal-setting process replicates from the company level down to individuals

*Timestamp: 00:58:38*


## Daniel Lereya
*Daniel Lereya*

> "Put ambitious goals, it'll make you think differently. And, we really love now to do it even when we don't know it's possible and it actually works for us time after time."

**Insight:** Ambitious goals force teams to abandon incremental thinking and invent entirely new workflows or architectures.

**Tactical advice:**
- Set goals that are impossible to achieve through 'working harder' alone to force 'working smarter'
- Use 10X goals to trigger a fundamental rethink of product architecture

*Timestamp: 00:10:10*

---

> "PM in Monday, first and foremost, is responsible for creating the shared understanding on what would be impactful for our customers... and second, how we will know that we moved the needle."

**Insight:** Goal setting should focus on the intended impact and the specific metric that proves the needle has moved, rather than the solution itself.

**Tactical advice:**
- Define the 'opportunity' and 'problem' before discussing any specific features
- Establish clear success metrics that validate real-world impact

*Timestamp: 00:18:30*


## Eeke de Milliano
*Eeke de Milliano*

> "Those documents, to me, are the charter: 'What is your mission, your vision and your strategy?' The goals: 'What are you aiming to do and how are you going to measure success?' And then the roadmap: 'What is the thing that you're shipping?'"

**Insight:** Every team should maintain three core documents: a charter, a set of goals, and a roadmap.

**Tactical advice:**
- Ensure every product team has a mission/vision/strategy charter
- Shift the time horizon of charters based on company maturity (3 months for early stage, 10 years for mature)

*Timestamp: 00:43:00*


## Eli Schwartz
*Eli Schwartz*

> "Whatever it is, there has to be a conversion metric that matters for the business... driving traffic to something that doesn't convert for you wouldn't be a good idea."

**Insight:** SEO success should be measured by business-relevant conversions (like MQLs or sales) rather than vanity metrics like total traffic.

**Tactical advice:**
- Define a specific conversion metric for SEO traffic (e.g., MQLs, sign-ups, or page views for media)
- Audit existing content and consider deleting high-traffic pages that do not convert

*Timestamp: 00:49:48*

---

> "Really understanding who it is that they're trying to attract with SEO that's the metric we're going to use. And again, I don't know why SEO... this happens with SEO but not any other channel. No one doing paid marketing will ever say, 'This is how many times I'm number one on this search...'"

**Insight:** SEO requires the same analytical rigor as paid marketing, focusing on efficiency and business impact rather than just 'ranking number one.'

**Tactical advice:**
- Move away from 'rankings' as a primary KPI
- Track the efficiency of SEO spend in driving bottom-line business results

*Timestamp: 00:51:02*


## Emily Kramer
*Emily Kramer*

> "If our goal is to write 10 blog posts this month. And I'm like, no, that's not a goal, that's maybe a tactic. But the goal should be traffic and the conversion rate from that traffic or the signups that come from that. So you shouldn't have activity goals, you should have impact goals."

**Insight:** Marketing teams must be measured by impact (funnel metrics) rather than activity (volume of content).

**Tactical advice:**
- Replace activity-based goals (e.g., 'number of posts') with impact-based goals (e.g., 'signups' or 'traffic').
- Always pair volume goals with quality thresholds (e.g., signups with a specific activation rate).

*Timestamp: 00:51:02*


## Geoff Charles
*Geoff Charles*

> "We moved from quarterly, very expensive quarterly planning, which took one month every three months, so basically 33% of the time was planning, to a biannual one-pager on, these are the company priorities and it's much more smooth and much faster."

**Insight:** Reduce planning overhead by moving from rigid quarterly OKRs to high-level biannual priority documents.

**Tactical advice:**
- Avoid using OKRs for product teams if they lead to political manipulation of metrics.
- Use a biannual one-pager for company priorities instead of monthly/quarterly cycles.
- Align the roadmap with a financial plan where specific levers have clear owners.

*Timestamp: 00:39:30*


## Gibson Biddle
*Gibson Biddle*

> "I just need you to force rank these three factors for me: growth, engagement, and monetization. And I need the two of you to agree."

**Insight:** Align leadership by force-ranking Growth, Engagement, and Monetization (the JAM model) to resolve fundamental strategic conflicts.

**Tactical advice:**
- Force-rank Growth, Engagement, and Monetization with key stakeholders
- Define a specific proxy metric for engagement (e.g., monthly retention)
- Use a 'SWAG' (Stupid Wild-Ass Guess) to initiate the goal-setting conversation

*Timestamp: 44:15*


## Gokul Rajaram
*Gokul Rajaram*

> "At the very early stage, it needs to be a weekly plan, where while as you grow the granularity, you still need weekly plans, but you also need quarterly plans that wrap around that. You start with quarterly goals."

**Insight:** Planning granularity should evolve from weekly execution in early stages to quarterly strategic goals as the company scales.

**Tactical advice:**
- Use weekly plans for very early-stage startups to maintain agility
- Introduce quarterly planning after a Series A to align the team on longer-term objectives

*Timestamp: 00:18:30*


## Graham Weaver
*Graham Weaver*

> "I wrote down at the top of the page every single morning, I wrote down, 'I am the number one rower in the country.'... And then I wrote down three things I was going to do that day to move toward that goal. And I did that every single day that I was in college."

**Insight:** Daily repetition of a primary goal combined with three immediate actions creates massive momentum and subconscious alignment.

**Tactical advice:**
- Write your primary goal at the top of a page every single morning
- List exactly three things you will do that day to move toward that goal
- Use this daily practice to achieve more in three months than others do in three years

*Timestamp: 00:41:07*


## Ian McAllister
*Ian McAllister*

> "The WBR or Weekly Business Review... It would be a series of metrics for different parts of the business... The way he ran that meeting would lead all those leaders to build these muscles because you wanted to be prepared to speak to the variances or trends in your business in a key metric and know your business and know what you were doing based on that thing."

**Insight:** Regular, rigorous metrics reviews build an organizational 'muscle' for understanding business drivers and taking corrective action.

**Tactical advice:**
- Review metrics weekly to identify variances and trends
- Prepare to explain the 'why' behind metric changes and the resulting action plan

*Timestamp: 00:43:27*


## Itamar Gilad
*Itamar Gilad*

> "Once you have these two [North Star and Top KPI], you can further break them down into what I call metrics trees. So there's a metric three for the North Star metric and there's the metric three for the top KPI... and usually they overlap."

**Insight:** Deconstruct high-level goals into a metrics tree to identify the specific levers teams can influence to drive the North Star.

**Tactical advice:**
- Map out the mathematical relationship between sub-metrics and the North Star
- Use the metrics tree to define team ownership and topology around specific goals

*Timestamp: 00:28:57*


## Janna Bastow
*Janna Bastow*

> "Because it has spaces in there to say, 'Did you measure success? And was it successful or not successful? This roadmap thing is completed, what was the outcome of it?' So by creating all these spaces, it creates all these reminders for the team to go back and think about this stuff before they do work and after they do work."

**Insight:** Effective goal setting requires closing the loop by measuring outcomes after a feature is shipped, rather than just focusing on the build.

**Tactical advice:**
- Explicitly document the intended outcome and the actual measured success for every roadmap item

*Timestamp: 41:15*


## Jonathan Lowenhar
*Jonathan Lowenhar*

> "In any given time, Lenny, companies are working backwards from one of four things, whether they like it or not. I am working backwards from an exit. I'm working backwards from a next fundraise. I'm working backwards from profitability or I'm working backwards from winding down."

**Insight:** Effective planning requires identifying which of the four primary business milestones you are currently working toward.

**Tactical advice:**
- Identify if you are working toward an exit, fundraise, profitability, or wind-down.
- Codify the qualitative and quantitative requirements needed to unlock that specific milestone.
- Determine the resources and cadence required to hit those quantified results.

*Timestamp: 00:23:02*

---

> "Founders often make the mistake when planning for the year ahead of I need to be at this revenue to justify this multiple. And then all of the funnel math is a plug, and that's death, as opposed to here's what's been true for the last three months, six months, nine months, 12 months."

**Insight:** Avoid 'top-down' goal setting where funnel metrics are just plugs to reach a desired valuation; use historical data for bottoms-up planning.

**Tactical advice:**
- Build plans based on actual historical funnel performance from the last 3-12 months.
- Identify the gap between realistic projections and financial needs to have a mature conversation about ambition.
- Model changes to top-of-funnel, conversion rates, and deal size based on recent history rather than guesses.

*Timestamp: 01:13:25*


## Judd Antin
*Judd Antin*

> "I never asked for research teams to have their own separate OKRs. I said... shouldn't the PMs, the engineers, the designers and the research, everybody should have the same set of metrics for success because either we're doing it together or we're not."

**Insight:** Research impact is maximized when researchers share the same success metrics and OKRs as the cross-functional product team.

**Tactical advice:**
- Avoid creating siloed research-only OKRs.
- Ensure researchers are accountable for the same business metrics as PMs and engineers.

*Timestamp: 00:31:38*


## Kayvon Beykpour
*Kayvon Beykpour*

> "If the only way the organization is trained to think about what to build and what not to build is OKRs, it's equally unhelpful at the limit because sure, you can have a good sense of what you should build to drive metrics, but by the way, you might be focusing on the wrong metrics or that might not help you have the right balance of things to build."

**Insight:** Over-reliance on OKRs can lead to building for metrics rather than building for the customer.

**Tactical advice:**
- Ensure OKRs don't blind the team to 'hostile' customer experiences that happen to drive positive metrics.

*Timestamp: 00:49:14*

---

> "One of our key metrics that we always optimized... was DAU... but we often had features that would not lead to a good customer experience and the team would just be blind towards leaving hostile customer experiences in place because it was good for metrics and aggregate."

**Insight:** Strict adherence to a single North Star metric (like DAU) can incentivize keeping features that users actually dislike.

**Tactical advice:**
- Watch for 'metric-positive but customer-hostile' features as a sign that your goal-setting framework is failing.

*Timestamp: 00:50:43*


## Karri Saarinen
*Karri Saarinen*

> "In terms of specific features, we don't have goals for those... We just think that there should be features that help companies and sometimes we can look at the metrics before we start working on it... but we don't necessarily want to set, oh, we need to increase this specific metric by X. It's more like we want to solve this problem."

**Insight:** Focusing on problem-solving rather than arbitrary metric targets prevents teams from optimizing for the wrong outcomes.

**Tactical advice:**
- Define success by whether a customer problem is solved rather than a specific metric increase.
- Use data to understand the current state of the product rather than to set rigid future targets.

*Timestamp: 00:44:27*


## Kristen Berman
*Kristen Berman*

> "In order to change behavior, you have to pick a behavior that you want to change. So, companies are really good at outcomes, but just not as sharp at picking the behavior... we need to get uncomfortably specific, we say. Just really specific in the behavior."

**Insight:** Effective goal setting requires defining 'uncomfortably specific' target behaviors rather than just broad business outcomes.

**Tactical advice:**
- Define target behaviors by specific actions (e.g., 'two 10-minute workouts with two different instructors within seven days').

*Timestamp: 19:13*

---

> "setting the incentive, and the KPI, and the product, and the marketing team on the behavior is going to result in a more customer-friendly product and outcome."

**Insight:** Aligning team incentives with specific user behaviors leads to more ethical and customer-centric product results.

**Tactical advice:**
- Set KPIs on the behavior itself rather than just active use or retention.
- Increase the duration of the incentive (e.g., annual vs. quarterly) to encourage long-term thinking.

*Timestamp: 27:18*


## Lane Shackleton
*Lane Shackleton*

> "Instead of being obsessed with the goal, be obsessed with the system that gets you there. And so the phrase I sometimes use is goals with good intentions don't work. I really need to give a common example. A really common example is teams that are trying to learn about customers or do research. And one thing I've observed is a team may have a goal like an OKR of talking to 10 customers this quarter and they may or may not hit that OKR. And then if you watch closely, the next quarter, they may not have a goal of talking to customers anymore. And so their learning is going up and down."

**Insight:** Focus on building 'default-on' systems rather than one-off OKRs to ensure consistent progress.

**Tactical advice:**
- Replace one-time goals with recurring systems (e.g., a standing Friday customer meeting).
- Identify 'default-on' behaviors that build long-term instincts rather than short-term metrics.

*Timestamp: 00:18:34*

---

> "The first that I end up seeing a lot is just this idea that OKRs are not actually strategy. So I think the way that we plan and the way that our customers plan, the key point is it's critical to disconnect strategy discussions from OKR discussions."

**Insight:** Separate strategy development from goal-setting to ensure the 'why' isn't lost in the 'what'.

**Tactical advice:**
- Create a distinct strategy ritual that occurs before or separately from OKR planning.
- Ensure the team has a separate strategy framework that informs the goals.

*Timestamp: 01:20:30*

---

> "The other rule that we live by on the planning side is what we call a 10% planning rule, which is essentially just ensure that you're not for a given time period planning for more than 10% of that execution period."

**Insight:** Limit the time spent on planning to 10% of the total execution window to avoid over-planning.

**Tactical advice:**
- If planning for a month, spend no more than three days on the planning process.
- If planning for a week, limit planning to half a day.

*Timestamp: 01:21:06*


## Laura Schaffer
*Laura Schaffer*

> "Commit to something that you can do over the course of a year and low, medium, high is always helpful in that space... It deviates from this notion of like, here's the single number that we're going to hit."

**Insight:** Growth goals should be framed as a range (low, medium, high) over longer timeframes to account for the lumpy nature of experimental success.

**Tactical advice:**
- Categorize growth bets into 'safe' vs. 'lightning in a bottle' buckets
- Report on growth metrics over annual or quarterly cycles rather than weekly
- Avoid vanity metrics by ensuring the team isn't pressured into short-term wins

*Timestamp: 00:53:01*


## Logan Kilpatrick
*Logan Kilpatrick*

> "I've personally used a GPT, the private GPT that I use myself that helps with some of the planning stuff for different quarters, and just making sure that I'm being consistent in how I'm framing things like driving back to individual metrics, stuff that, when people do planning, they often miss in our data."

**Insight:** Custom GPTs can be used as 'planning coaches' to ensure consistency and rigor in goal-setting processes.

**Tactical advice:**
- Feed a GPT best practices from planning articles to create a custom planning assistant.
- Use AI to generate timelines, success metrics, and identify cross-functional stakeholders during the OKR process.

*Timestamp: 00:17:43*


## Maggie Crowley
*Maggie Crowley*

> "The really, really good PMs remember to follow up... if a PM comes back to me and says, 'Hey, remember we did that thing, here's what happened.' I can't tell you how rare that is."

**Insight:** Closing the loop on metrics after a launch is a rare but high-value activity that demonstrates accountability to leadership.

**Tactical advice:**
- Set calendar reminders to check metrics 2 weeks, 1 month, and 6 months after launch
- Proactively share results with stakeholders without being prompted

*Timestamp: 00:07:55*


## Matt LeMay
*Matt LeMay*

> "So the first is in setting team goals, no more than one step away from company goals. Don't let it get cascaded into oblivion."

**Insight:** Effective team goals should orbit directly around the primary company goal rather than being buried under multiple layers of organizational cascading.

**Tactical advice:**
- Ensure team goals are no more than one step removed from top-line company objectives.
- Avoid 'sweating the middle' where goals become too abstract to trace back to business impact.

*Timestamp: 00:45:05*

---

> "She stands and she's like, 'Okay, we're going to do things differently.' She steps up to the whiteboard, puts 1 million on the right end of the whiteboard, draws a line, 'This is the year,' draws a little tick on the line. 'This is where we are now. It's a smaller number than a million. This is where we need to get to. If our conversation doesn't start with this, I don't want to have the conversation.'"

**Insight:** High-impact teams start every planning conversation with the top-line target and evaluate all work based on its ability to move that specific needle.

**Tactical advice:**
- Visualize the gap between current state and the final goal to drive urgency.
- Reject any initiative that doesn't have a clear path to contributing to the primary target.

*Timestamp: 00:54:15*

---

> "I just put this out on a whiteboard. I'm like, 'All right, a hundred million in profits by the end of the next financial year right now we're here. What else should be on this timeline?' Somebody said, 'Well, we're launching this in October.' So I put October up there. I go, 'Okay, so if we don't ship anything until October, and right now it's March, how much profit do we make until?' And they said, 'About 10 million.' I'm like, 'Okay. So that means that between October and March, we need to generate 90 million pounds of profits.'"

**Insight:** Breaking down a large financial goal against a shipping timeline reveals the true 'impact gap' and forces teams to reconsider their delivery strategy.

**Tactical advice:**
- Map your launch dates against your financial targets to see if the math actually works.
- Use the resulting 'impact gap' to justify shipping sooner or validating ideas faster.

*Timestamp: 00:59:45*


## Marty Cagan
*Marty Cagan*

> "Another difference is when you're given a problem to solve, that's not output, that's outcome, so you either solve it or you don't. ... In a real product team, you celebrate when you actually solve the problem, when you accomplish those results. That's why we say product teams are about outcomes, they're not about output."

**Insight:** Success should be measured by the resolution of a problem (outcome) rather than the shipment of a feature (output).

**Tactical advice:**
- Define success by the results achieved, not the number of releases
- Align team celebrations with problem resolution milestones

*Timestamp: 00:09:49*


## Matt Mochary
*Matt Mochary*

> "You need to have goals and at the company level, at the department level, at the individual level, you then need to track those goals. You need to track all the agreements that people make, all the actions they say they'll do."

**Insight:** A rigorous system of cascading goals and tracked agreements is essential for organizational alignment.

**Tactical advice:**
- Set goals at three levels: company, department, and individual.
- Use a shared tool like Asana to make all agreements and actions visible across the team.

*Timestamp: 00:38:53*

---

> "The second one is top goal, which is this concept from McKeown, who wrote Essentialism, which is everyone is making requests of you, but if all you do is spend all day is responding to other people's requests, you never actually march towards your own priorities. You need to A, create priorities and then set aside some amount of time each day, 30 minutes, an hour, two hours that you just work on your own priority."

**Insight:** Leaders must proactively block time for their 'Top Goal' to avoid being consumed by reactive tasks.

**Tactical advice:**
- Identify one 'Top Goal' per day that represents your own priority.
- Schedule 30-120 minutes of uninterrupted time daily to work exclusively on that goal.

*Timestamp: 00:40:33*


## Melissa Perri + Denise Tilles
*Melissa Perri + Denise Tilles*

> "We also had to build a way to track the OKRs that were deployed and actually see where it was. So we had to build the dashboards for that."

**Insight:** Effective goal setting requires automated tracking and visibility to ensure teams are progressing toward their objectives.

**Tactical advice:**
- Build centralized dashboards to track OKR progress across the organization

*Timestamp: 01:04:00*


## Melanie Perkins
*Melanie Perkins*

> "The thing that I love about a crazy big goal is that you feel completely inadequate before it. You want to work really hard to will it into existence."

**Insight:** Set 'Crazy Big Goals' that are ambitious enough to feel daunting, ensuring they are important enough to sustain long-term effort.

**Tactical advice:**
- Set goals that feel 'realistic' only in the context of a 10-year horizon
- Ensure goals are important enough that you won't abandon them when roadblocks appear

*Timestamp: 00:14:50*


## Melissa Tan
*Melissa Tan*

> "The North Star is ARR, Annual Recurring Revenue. And then you break it down into the levers that drive ARR, the leading indicator, so that could be activation rates, the number of customers you bring in, et cetera."

**Insight:** Effective goal setting involves deconstructing a lagging North Star metric into actionable leading indicators for individual teams.

**Tactical advice:**
- Identify the primary North Star metric (e.g., ARR)
- Map out the leading indicators (activation, retention, conversion) that drive that North Star
- Assign specific levers to individual PMs or sub-teams

*Timestamp: 00:29:15*


## Molly Graham
*Molly Graham*

> "No company needs more than three company goals and the point of company goals is to help people know what the most important things are to success."

**Insight:** Goals are primarily communication tools that must be simple, prioritized, and clearly owned to create organizational clarity.

**Tactical advice:**
- Limit company goals to three or fewer to ensure focus.
- Ensure one goal 'wins in a fight' to clarify prioritization when trade-offs are necessary.
- Assign exactly one owner to every goal; if two people own it, no one owns it.
- Strategy should hurt; if the goal-setting process isn't painful, you aren't making enough trade-offs.
- Establish a follow-up process to hold people accountable, as goals alone do not change behavior.

*Timestamp: 00:48:58*


## Phyl Terry
*Phyl Terry*

> "When you start interviewing, I want you to create your own version of the job description... I want you to create what I call a job mission with OKRs... It needs to be something where you are saying, 'Here's what I think I'm going to be accountable for. Here's what I'm going to actually... the outcomes I'm going to deliver,' right?"

**Insight:** Proactively define your own job mission and success metrics during the interview process to differentiate yourself and align expectations.

**Tactical advice:**
- Draft a private version of the job description based on interview insights.
- Include specific Objectives and Key Results (OKRs) you intend to deliver.
- Share the draft with the hiring manager to validate assumptions and demonstrate accountability.

*Timestamp: 00:49:15*


## Rachel Lockett
*Rachel Lockett*

> "The reason I like the one-page plan concept is, it's simplifying. It's a way for the leadership team to come together and align... puts your vision and your values on the first column, your strategic intentions and your KPIs on the second column, your annual goals on the third, and your quarterly goals on the fourth."

**Insight:** A one-page plan ensures that daily and quarterly goals are always visually and strategically linked to the long-term vision.

**Tactical advice:**
- Consolidate vision, values, strategy, and goals into a single view.
- Use a 'People First Operating Rhythm' to review the plan quarterly.

*Timestamp: 01:33:14*


## Ravi Mehta
*Ravi Mehta*

> "I think about all of the pieces of the strategy stack as being really clear about what is the end destination that you're solving for, and then you should work on goals to the extent that they help you reach that destination... I've had a few people yell at me about this. Typically, what happens is goals are almost the start of a strategic process rather than the end of it."

**Insight:** Goals should be the final step of the strategy process, serving as a measurement of progress toward a destination rather than the destination itself.

**Tactical advice:**
- Define the destination (strategy) before setting the mileage (goals).
- Be willing to leave metric gains on the table if they pull the product away from its strategic destination.

*Timestamp: 00:43:17*

---

> "I refer to that as the frontier of understanding. There's a point at which what the team knows and what the team doesn't know... if you don't understand how to move a particular metric, then the right answer is to set a goal to increase your understanding not to move that metric."

**Insight:** Goal setting should be calibrated against the team's 'frontier of understanding'—moving from understanding risk to execution risk to strategic risk.

**Tactical advice:**
- If you don't know what drives a metric (e.g., retention), set a goal to 'understand the levers' rather than 'increase the metric'.
- Use 'execution goals' (e.g., number of experiments) when you have a hypothesis but need to test the team's ability to move the needle.

*Timestamp: 00:48:33*


## Ray Cao
*Ray Cao*

> "We don't take OKR as a shell, but we take OKR as its core is cross-functional alignment, cross-functional goal silo... The things that we can improve is the input and output. The output is very clear, but what is actually the input sometimes is debatable."

**Insight:** OKRs should be used primarily for cross-functional alignment rather than just as a tracking mechanism.

**Tactical advice:**
- Focus on connecting one team's output to another team's input within the OKR framework.
- Use OKRs as a 'North Star' to drive behavior and alignment across the company.

*Timestamp: 00:44:59*


## Sahil Mansuri
*Sahil Mansuri*

> "My suggestion is to really think about forecasting conservatively, setting up checkpoints and milestones around what future success may or may not look like. If you hit those goals, then decelerating or accelerating into it depending upon what you get there, and coming to an agreement with your board, with your sales team, with your sales leadership in advance so that there's no debate about what to do when you actually get there."

**Insight:** Move away from static annual forecasts toward dynamic, milestone-based planning to mitigate founder optimism bias.

**Tactical advice:**
- Forecast conservatively for the year with specific quarterly checkpoints
- Pre-determine decisions for acceleration or deceleration based on hitting specific targets
- Get board and leadership alignment on reforecasting triggers in advance

*Timestamp: 00:18:29*


## Shreyas Doshi
*Shreyas Doshi Live*

> "I noticed that actually, if you have a real product strategy, a real one that everybody is aligned with, that you have got pre-alignment on, then a lot of this nonsense we tend to do with annual planning actually goes away. Now, you still have to do some resource allocation and all of that, but even there, you don't need that false precision."

**Insight:** A robust, pre-aligned product strategy eliminates the need for lengthy, ritualistic annual planning and false precision in resource allocation.

**Tactical advice:**
- Focus on creating a real product strategy earlier in the year to simplify planning.
- Avoid filling out templates that don't make sense for your specific product context.
- Don't get bogged down in 'false precision' regarding exact headcounts for the following year.

*Timestamp: 16:25*


## Sri Batchu
*Sri Batchu*

> "the local team has their own metric that they can directly influence... And then we created via the finance and data team, a translation layer for every team's metric into MAO."

**Insight:** Effective goal setting involves holding teams accountable for metrics they can directly control while showing how those metrics roll up to company goals.

**Tactical advice:**
- Use regression analysis or holdouts to determine the impact of input metrics on the North Star
- Update translation factors every six months to ensure planning remains accurate

*Timestamp: 00:33:42*


## Teresa Torres
*Teresa Torres*

> "It starts with an outcome at the root of the tree, and then it branches into the opportunity space and then it branches into solutions, and maybe even assumption tests from there."

**Insight:** Product work should be anchored in a specific business outcome rather than a list of features to build.

**Tactical advice:**
- Start with an outcome at the root of your planning
- Map opportunities and solutions back to that primary outcome

*Timestamp: 06:06*


## Tomer Cohen
*Tomer Cohen*

> "I actually believe in, especially when it comes to products, to really set ambitious goals but then try to over-deliver on them... I see a mountain, you see the peak and the peak exactly how it looks like, you see base camp, you know how to start and maybe the middle of the mountain is kind of blurry, but you'll figure this out."

**Insight:** Set 'mountain peak' goals that are massive and inspirational, even if the exact path to reach them is not yet fully defined.

**Tactical advice:**
- Start from the potential of what a product could be rather than current numbers.
- Define a clear 'base camp' (starting point) to ground the ambitious vision.

*Timestamp: 00:13:14*


## Upasna Gautam
*Upasna Gautam*

> "We've used OKRs for a long time, and they've served as an anchor for my team over the last three years... we break those OKRs down of course even further into, we look two to three years out and build goals based off of that. Then we break them down by quarter and month, and then out of that for my team and what I do I need to, for my own sake and my team's sake, break those down by the week."

**Insight:** OKRs provide stability in long-term platform migrations by acting as a constant anchor across different time horizons.

**Tactical advice:**
- Break long-term (2-3 year) goals into quarterly, monthly, and weekly increments
- Ensure squad-level OKRs track directly up to organizational objectives

*Timestamp: 18:52*


## Vijay
*Vijay*

> "The anatomy of a bet is that it's problem we want to solve, our hypothesis on the solution, and then some plan to win, some plan to actually get there and a way to measure that you got there."

**Insight:** Structure goals as 'bets' that combine problem definition, hypothesis, execution plan, and success metrics.

**Tactical advice:**
- Define the 'evidence of demand' for every goal
- Include a 'plan to win' that outlines how the hypothesis will be validated

*Timestamp: 21:18*


## Yuhki Yamashata
*Yuhki Yamashata*

> "I think that, for me, there are three things that really matter about the good OKR, and one is legibility. People look at it and understand what it is, and it's not some weird obfuscated metric that doesn't mean anything to anyone. I think actionability, I want OKR to inspire action. You look at that and you're like, it's stirs action, makes me want to do something differently. And the third one is authenticity, which is, does this actually, honestly depict what you're doing, what you're trying to do on a day-to-day basis?"

**Insight:** OKRs should prioritize legibility, actionability, and authenticity over performative metrics that teams don't actually use to make daily decisions.

**Tactical advice:**
- Start with 'headlines' or philosophical goals before stressing about measurement
- Ensure OKRs are legible enough that any engineer can recite them
- Use a 'report card' approach where teams self-score based on qualitative and quantitative inputs

*Timestamp: 00:46:38*


## Garrett Lord
*Garrett Lord*

> "With Handshake AI, we've been way more focused on operating with data, and metrics, and rigor from an early stage. There's a gentleman named Sahil on our team who's been doing an incredible job with that... this weekly, monthly, quarterly operating cadence."

**Insight:** Rapidly scaling a new business requires a rigorous, data-driven operating cadence from the very beginning.

**Tactical advice:**
- Establish a weekly, monthly, and quarterly operating rhythm to track progress
- Assign a specific lead to manage data and metrics rigor

*Timestamp: 00:51:35*


## Hila Qu
*Hila Qu*

> "I added basically a section in the dock, in the ticket stack. Ask the PMs to write the success metric ahead of time. As well as adding which of the growth lever this is helping. Is this contributing to acquisition, activation, retention, monetization?"

**Insight:** Forcing PMs to define success metrics and growth levers upfront improves strategic alignment.

**Tactical advice:**
- Require success metrics to be written in the product document before development
- Map every feature or experiment to a specific growth lever (acquisition, activation, etc.)

*Timestamp: 01:29:51*


## Farhan Thawar
*Farhan Thawar*

> "We do six-week reviews. So, teams have this notion of every six weeks actually coming together and walking through the roadmap, the resourcing, and what they're working on... six weeks is a very good cadence, because it's short enough that you can remember the context and it's long enough... you can do a lot."

**Insight:** Implement a six-week review cycle to maintain high intensity and ensure leadership alignment without the lag of quarterly planning.

**Tactical advice:**
- Conduct deep-dive project reviews every six weeks with senior leadership
- Focus reviews on what has been learned and what progress has been made since the last cycle

*Timestamp: 00:30:18*


## Nickey Skarstad
*Nickey Skarstad*

> "Good OKRs to me are just clear articulations of your strategy, whatever it is that are important to you, and it boils it down into the next three months, here's what we're working on. And I think that is just really good for teams because, again, if you're always in the clouds, it starts to get hard to really bring things down to the feature level."

**Insight:** OKRs serve as the bridge between abstract strategy and concrete feature-level execution.

**Tactical advice:**
- Boil strategy down into 3-month actionable goals
- Ensure every Jira ticket or feature connects back to a specific objective

*Timestamp: 00:35:04*

---

> "You should have some sort of goal framework that is shared across functions is useful no matter the size or the scale of your business... because again, it takes your strategy and it brings it down into the now. So you can act on, in the next three months, you can bring something to life."

**Insight:** The specific framework (OKRs vs. others) matters less than having a shared, cross-functional language for goals.

**Tactical advice:**
- Implement a shared goal framework across all functions (Eng, Design, Product)
- Start the planning process in the third month of the current quarter

*Timestamp: 00:37:23*


## Paige Costello
*Paige Costello*

> "We have an R&D set of metrics, we have pillar metrics, we have area metrics, and then at the team level, there's often one or two that they're really driving forward. So you can think of it as a nested structure around our product strategy as well as how we measure success."

**Insight:** Use a nested metric structure (R&D -> Pillar -> Area -> Team) to align high-level product strategy with specific team-level execution.

**Tactical advice:**
- Define metrics at multiple altitudes to create a clear through-line from strategy to team tasks.
- Ensure each team has one or two primary metrics they are driving forward.

*Timestamp: 00:07:23*


## Tamar Yehoshua
*Tamar Yehoshua*

> "We used OKRs to drive our processes and we would have the teams present OKRs to us... we iterated every quarter, just like you iterate on a product. So every quarter we would say did the OKR planning work or not, and then we would adjust."

**Insight:** The process for setting and reviewing goals should be treated as a product that requires constant iteration.

**Tactical advice:**
- Review the time cost of OKR planning and move to async formats if it becomes too burdensome.
- Use a 'red, yellow, green' status system and only discuss the 'red' (at-risk) items in live meetings.

*Timestamp: 00:42:00*


## Tobi Lutke
*Tobi Lutke*

> "Goodhart's law just says, 'Any metric that becomes a goal ceases to be a good metric.'... Why? Because no metric by itself is a complete heuristic for a complex business because business are complex. There's a million of different tensions in a company and you can't all keep them in harmony by optimizing for one fix. It's true that we don't have KPIs and we don't have at least OKRs in the Silicon Valley sense but we are extremely data-informed."

**Insight:** Avoid turning metrics into rigid goals to prevent 'overfitting' and the loss of unquantifiable values like quality and taste.

**Tactical advice:**
- Use data to inform decisions rather than letting metrics dictate goals
- Balance quantifiable metrics with unquantifiable values like delight and brand representation
- Recognize that no single metric can serve as a complete heuristic for a complex business

*Timestamp: 00:14:53*


