---
name: stakeholder-alignment
description: Help users align stakeholders and get buy-in. Use when someone is struggling to get approval, facing resistance to their ideas, needs to influence without authority, or is preparing for an important executive presentation.
---

# Stakeholder Alignment

Help the user achieve stakeholder alignment using frameworks and insights from 88 product leaders.

## How to Help

When the user asks for help with stakeholder alignment:

1. **Understand the situation** - Ask who the stakeholders are, what decision needs to be made, and where resistance is coming from
2. **Identify motivations** - Help them understand what each stakeholder cares about and their definition of success
3. **Structure the approach** - Guide them on pre-alignment, communication sequence, and how to present options
4. **Prepare for objections** - Help anticipate the Most Obvious Objections (MOOs) and prepare responses

## Core Principles

### Understand how they think, not what they think
Hilary Gridley: "What's more helpful than understanding what your CEO thinks is understanding how your CEO thinks." Analyze recurring themes in a leader's feedback to translate it into actionable principles rather than chasing specific opinions.

### Present options with a recommendation
Matt LeMay: "Options and a recommendation is the magic formula. When you present a single option, people just start poking holes." Always present at least three options with clear trade-offs and a specific recommendation to encourage constructive discussion.

### Get pre-alignment on strategy
Shreyas Doshi: "If you have a real product strategy that everybody is aligned with, a lot of the nonsense we do with annual planning goes away." Secure alignment on strategy before formal planning seasons to prevent endless friction.

### Approach disagreements with curiosity
Ami Vora: "She would respond, 'Fascinating, you have to tell me more why you think that.'" When you hear an idea you strongly disagree with, assume the other person has information you don't have yet.

### Distinguish disagreement from misunderstanding
Tomer Cohen: "Are you disagreeing or misunderstanding? If misunderstanding, let's spend the time. If disagreeing, let's stop wasting time arguing." Ask the other party to articulate your point of view in their own words to verify understanding.

### Trust is built through consistency
Ian McAllister: "Trust is the currency of a product leader. Trust is built by repeatedly setting and meeting expectations." Tell the truth, launch what and when you said, and own mistakes immediately.

### Use concentric circles for communication
Lulu Cheng Meservey: "Go out in concentric circles. Each circle assumes the inner circle knows better." Never skip a circle in the communication sequence (Team -> Stakeholders -> Leadership -> External).

### Repeat messages relentlessly
Zoelle Egner: "I repeated the same three talking points 5,000 times. You just have to get used to saying the same stuff." Act as 'repeater-in-chief' across multiple formats because people require multiple exposures to internalize a message.

### Learn the business constraints
Marty Cagan: "You have to know how it's marketed, how it's sold, how it monetizes. You have to convince stakeholders you understand what the issues are." Build trust by demonstrating deep understanding of legal, finance, sales, and compliance constraints.

### Frame requests as trade-offs
Wes Kao: "I can design this PDF for you. That means the page redesign will have to wait until later this week." When asked for new tasks, explicitly state what current work will be deprioritized rather than saying yes or no.

## Questions to Help Users

- "What does success look like specifically for this stakeholder - what do they care about most?"
- "Have you identified the 'gatekeepers' who need 1:1 alignment before the broader meeting?"
- "What is the Most Obvious Objection you expect, and how will you address it?"
- "Are there repeated disagreements that signal an unaligned strategy rather than a tactical issue?"
- "How will you communicate this across different modalities (written, verbal, visual)?"
- "What trade-offs are you asking them to accept, and have you been explicit about them?"

## Common Mistakes to Flag

- **Presenting a single option** - This invites criticism; always present multiple options with trade-offs
- **Skipping pre-alignment** - Treating buy-in as a single high-stakes meeting rather than a collaborative journey
- **Framing as pushback** - Thinking of disagreement as conflict rather than a constructive effort to align on business success
- **Assuming one communication is enough** - Messages need to be repeated across multiple channels and formats
- **Not understanding motivations** - Trying to align someone without knowing what they personally care about and fear

## Deep Dive

For all 124 insights from 88 guests, see `references/guest-insights.md`

## Related Skills

- Written Communication
- Giving Presentations
- Running Effective Meetings
- Managing Up
