# Stakeholder Alignment - All Guest Insights

*88 guests, 124 mentions*

---

## Adam Fishman
*Adam Fishman*

> "How do you manage stakeholders? And this is hard in growth because often growth can be viewed as at odds with really thoughtful and quality craftsmanship and product building, but it's not. Those things go hand in hand. And so you really have to win people over on what it means to do growth."

**Insight:** Growth leaders must bridge the gap between rapid experimentation and product craftsmanship to gain organizational buy-in.

**Tactical advice:**
- Communicate how a series of experiments fit into a larger strategic bet
- Identify the 'currency' different stakeholders trade in to tailor your communication style

*Timestamp: 00:24:06*


## Adriel Frederick
*Adriel Frederick*

> "The hardest part is taking my own shoes off. Basically going, Yo, okay, I came into this, there's something I wanted, I wanted to get rid of that. Now just talk to this person and try to understand what's going on with them... Once I have the empathy, I'm then able to think about what we as an organization broadly want to achieve."

**Insight:** True alignment requires 'taking your own shoes off'—temporarily setting aside your own goals to understand a stakeholder's motivations and fears.

**Tactical advice:**
- Identify common objectives to overcome the 'us vs. them' mentality in cross-functional relationships.
- Ask stakeholders about their life goals and what they are scared of to build genuine empathy.

*Timestamp: 01:01:15*


## Albert Cheng
*Albert Cheng*

> "Surfacing those [experiment wins] across the company... the onus is on them to clearly articulate what their hypothesis is, what they found such that then as a growth leader, I can encourage people to swarm around that and try a bunch of different ideas."

**Insight:** Growth leaders should act as a bridge, taking insights from one team and encouraging other teams to 'exploit' those learnings in their own domains.

**Tactical advice:**
- Create a centralized way to share experiment hypotheses and results to encourage cross-team 'swarming' on winning insights.

*Timestamp: 00:13:58*


## Ami Vora
*Ami Vora*

> "Working with Ami, it was like watching an alien because she could have the most profound disagreement in the world with somebody and they would say something that she thought was not just wrong, but crazy wrong, and she would respond, 'Fascinating, you have to tell me more why you think that.'"

**Insight:** Approach deep professional disagreements with genuine curiosity to dismantle defensiveness and find common ground.

**Tactical advice:**
- Use the phrase 'Fascinating, tell me more why you think that' when you hear an idea you strongly disagree with.
- Assume the other person has information you don't have yet.
- Take a pause before responding to allow your 'primal' visceral reaction to calm down.

*Timestamp: 00:10:17*

---

> "Assume that executives have a little tiny dinosaur brain. We all have a little brontosaurus brain and we can really only hold three facts at the same time. We will never be able to go deep in the way that you are able to do on everything that crosses our desk. And so the best service you can do is actually do the work of making a recommendation."

**Insight:** Executives need concise, opinionated recommendations because they lack the bandwidth to process all the raw data themselves.

**Tactical advice:**
- Present the minimal amount of information needed to support a recommendation.
- Own the recommendation while letting the manager/executive own the broader context.
- Use product reviews to calibrate on principles rather than just getting a single 'yes/no' decision.

*Timestamp: 00:17:31*


## Anneka Gupta
*Anneka Gupta*

> "One of the tactics I use is I ask people to present their strategies for things that I think we may need to do a course correction on, and I have them come in and then I ask them questions and then I make suggestion. And I'm able to do that in a forum where it doesn't feel like I'm coming in and rewriting the entire strategy, but I'm giving them there an opportunity to present their best thinking..."

**Insight:** Guide teams toward course corrections by asking probing questions and sharing hypotheses rather than overriding their work.

**Tactical advice:**
- Invite teams to present strategies early to provide feedback before decisions are finalized.
- Seed hypotheses based on external data (e.g., customer feedback) to open a discussion rather than shutting it down.

*Timestamp: 00:15:51*

---

> "I really try to understand what drives that person. What is it that they really care about? ... I just need to understand what it is that they really care about, and then if I need something from them, what is it that I can do to motivate them to find what I need from them important?"

**Insight:** Aligning difficult stakeholders requires understanding their personal and professional motivations to frame your needs in their context.

**Tactical advice:**
- Talk to peers or direct reports of a difficult stakeholder to understand what makes them 'tick.'
- Connect your project's success to the specific goals or desires of the stakeholder you are trying to influence.

*Timestamp: 00:39:08*


## April Dunford
*April Dunford*

> "if we're going to fix this thing, we can't just have the marketing department or just the product managers sit down and cook up new positioning and then heave it over the wall to everybody else, it actually needs to be a group effort. It's a team sport."

**Insight:** Effective positioning requires cross-functional collaboration rather than being siloed within a single department.

**Tactical advice:**
- Avoid 'heaving positioning over the wall' from marketing to other teams
- Involve sales and product early in the positioning process

*Timestamp: 00:13:00*

---

> "if we're going to do a positioning exercise, ideally we've got marketing, product, sales, customer success, and anybody else we need from the executive team, particularly the CEO, together in a room when we're building it. So that we can all bring our expertise to the table, bring our understanding of what customers do and our product to the table, thrash around on it a little bit until we get agreement on it."

**Insight:** Successful positioning implementation depends on achieving executive and cross-functional consensus through shared workshops.

**Tactical advice:**
- Include the CEO, Sales, Product, and Customer Success in positioning workshops
- Facilitate 'thrashing' sessions to surface different perspectives on customer behavior

*Timestamp: 00:13:41*


## Austin Hay
*Austin Hay*

> "I think that this person, the secret sauce is more of how good of a cross-functional team player are they. I almost view them like a true quarterback... marketing technology because it lives between so many departments, it plays that role of having to call plays and pull on different departments."

**Insight:** Technical roles that sit between departments require high levels of persuasion and cross-functional 'quarterbacking' to succeed.

**Tactical advice:**
- Focus on building relationships with heads of Revenue Ops, Product, and Data to ensure system changes are supported.
- Use persuasion and salesmanship to justify engineering resources for internal platform improvements.

*Timestamp: 00:19:10*


## Bangaly Kaba
*Bangaly Kaba*

> "I found this framework... called managing complex change. It's got these five components to it, vision, skills, incentives, resources, action plan, and you need all of those to have change."

**Insight:** Organizational change requires alignment across five pillars; missing any one leads to specific failure modes like confusion, anxiety, or resistance.

**Tactical advice:**
- Diagnose team issues by identifying the symptom: confusion (missing vision), anxiety (missing skills), resistance (missing incentives), frustration (missing resources), or false starts (missing action plan).
- Start with action plans as they are easier to institute than changing vision or skills.

*Timestamp: 00:41:42*


## Barbra Gago
*Barbra Gago*

> "A big part of rebranding also means that you have to bring the whole company along too and make sure they feel really good about the outcome. And that was probably one of my big takeaways, is just at that time, we were already about a hundred people, so it wasn't a super small company, and everybody had thoughts and feelings and the company had been around for quite a long time before that."

**Insight:** Internal alignment is as critical as external branding, especially in established companies where employees have deep emotional ties to the existing identity.

**Tactical advice:**
- Involve the whole company in the rebranding process to ensure buy-in
- Acknowledge and manage the emotional connection employees have to the old brand

*Timestamp: 34:09*

---

> "With the rebrand at Miro, it was very much rebrand as a product approach. It was very much a product development process with sprint teams and agile, coming back, and you had owners for different parts of things and all reporting back and it really required everybody in some way to be involved... mobilizing, having a really strong clear process and delegating and letting go in the marketing role."

**Insight:** Treating a major rebrand like a product development cycle with agile sprints helps manage complexity and cross-functional involvement.

**Tactical advice:**
- Use agile sprint teams for rebranding tasks
- Assign clear owners for different components of the rebrand
- Delegate tasks across the organization rather than centralizing everything in marketing

*Timestamp: 35:34*


## Benjamin Mann
*Benjamin Mann*

> "I think part of why we publish these things is we want other labs to be aware of the risks... I think if you talk to policymakers, they really appreciate this kind of thing because they feel like we're giving them the straight talk and that's what we strive to do, that they can trust us, that we're not going to paper things over or sugarcoat things."

**Insight:** Radical transparency about product risks and failures builds long-term trust with regulators and policymakers.

**Tactical advice:**
- Publish 'straight talk' about model risks and laboratory failures to establish credibility with external stakeholders
- Use a 'Responsible Scaling Policy' (ASL levels) to communicate risk thresholds to non-technical stakeholders

*Timestamp: 00:36:48*


## Ben Horowitz
*Ben Horowitz*

> "the job is fundamentally a leadership job. And it's a tricky leadership job because nobody is actually reporting to you. So it's like this influence, how do I get people to do what I want even though I'm not paying them. I can't fire them. I can't promote them"

**Insight:** Product management is defined by the ability to influence cross-functional teams without formal authority.

**Tactical advice:**
- Focus on clarity of communication to ensure engineering understands the 'why' and 'what'
- Build authority through vision and market insight rather than organizational hierarchy

*Timestamp: 00:43:07*

---

> "The way it works is there's somebody who's got to consolidate, get all the good ideas, prioritize them, decide which good ideas we're going to do, and then get everybody on the same page, so that they have very high fidelity understanding of what that is."

**Insight:** Alignment is about synthesizing diverse inputs into a single, high-fidelity direction that the whole team understands.

**Tactical advice:**
- Act as the 'consolidator' of ideas rather than the sole source of them
- Ensure the team has a 'high fidelity understanding' of the chosen path

*Timestamp: 00:49:40*


## Bob Baxley
*Bob Baxley*

> "I knew that design can't bring you this stuff into the world on its own. We can't raise this baby, we need the village, and we need the village to fall in love with the baby. And so until that happens, you're not really quite sure if this thing's going to take off or not."

**Insight:** True alignment isn't just 'buy-in'; it's getting cross-functional partners to emotionally invest in the product's success.

**Tactical advice:**
- Bring key engineers and PMs into the process at the moment of inception so they feel like co-creators rather than order-takers.

*Timestamp: 00:33:14*


## Bill Carr
*Bill Carr*

> "What it means is that have backbone and disagree, meaning when we are making any kind of a decision, important decision, if you are part of that team, part of that unit, it is your obligation to voice your point of view if you disagree with your approach that's been taken. The point of that disagreement, by the way, is to provide usually additional information or a new point of view that people have not considered."

**Insight:** Alignment is achieved by obligating team members to surface all dissenting data before a decision is finalized.

**Tactical advice:**
- Make it an obligation for team members to voice disagreements during the decision process
- Ensure the leader acknowledges and understands the dissenting point of view before asking for commitment

*Timestamp: 00:25:49*

---

> "The point is you provided your information, they've processed that information and they've decided to go this way with the knowledge of that. That is the point for them to commit. Because the point is you provided your information, they've processed that information and they've decided to go this way with the knowledge of that. That is the point for them to commit."

**Insight:** Commitment is not about agreeing, but about knowing your perspective was heard and factored into the final decision.

**Tactical advice:**
- Once a decision is made, commit fully to the direction even if you still disagree
- Reflect the final decision's rationale back to your own organization to ensure alignment

*Timestamp: 00:28:11*


## Boz
*Boz*

> "We really did not communicate effectively, I think, with the market around our future investments... we had to tell the company, 'You don't want to work at a company that, when times are tough, kills all future growth...'"

**Insight:** During downturns, alignment requires a clear defense of long-term 'future' investments to prevent a retreat into only shoring up the core business.

**Tactical advice:**
- Address the delta between internal reality and external perception (e.g., stock market or media narratives).
- Explain the rationale for a balanced portfolio of investments to both employees and investors.

*Timestamp: 01:15:15*


## Brandon Chu
*Brandon Chu*

> "I actually found that writing externally and getting momentum externally was a better way to influence internally what was happening, to the effect that Tobi would read my post here and there and he'd be like, 'Great post.'"

**Insight:** External thought leadership can be a powerful tool for building internal credibility and aligning with senior executives.

**Tactical advice:**
- Use external platforms to build momentum for ideas that might be lost in internal noise
- Build your 'trust battery' with executives by demonstrating clear thinking in public forums

*Timestamp: 33:20*


## Brian Tolkin
*Brian Tolkin*

> "There was a bidirectional feedback loop that wasn't super strong and that feedback loop was basically when the EPD teams in San Francisco built new features, how do we effectively put it in global markets and then how do we effectively get input from global markets to better build features."

**Insight:** Effective alignment between centralized product teams and distributed operations requires a formal bidirectional feedback loop.

**Tactical advice:**
- Embed operational representatives within product teams to provide qualitative insights from the field
- Create a formal process for rolling out global features to local markets

*Timestamp: 00:08:23*


## Cam Adams
*Cam Adams*

> "In terms of board meetings, I think it's been very helpful that our financials and our growth have been amazing for so many years that we don't need to focus on it and we can just have that one slide with the graph going up and to the right. We've also attracted investors who believe in us and who understand that us driving product and getting as much product value out to our customers is probably the most important thing we can be doing. So that's why the board meetings do focus on that because what we are launching in the product, what's ahead is really determining the success of the company."

**Insight:** Aligning stakeholders around product milestones rather than just financial metrics keeps the organization product-led.

**Tactical advice:**
- Structure board decks to prioritize product updates and roadmap over financial minutiae
- Select investors who prioritize long-term product value over short-term margin pulling

*Timestamp: 00:10:32*


## Chandra Janakiraman
*Chandra Janakiraman*

> "Leadership interviews are a very important part of a strategy formulation process... It could be made so much better if you just engage with your leaders before you actually build a strategy."

**Insight:** Engaging leaders early prevents the 'fruit story' trap where reviewers reject a finished product because they weren't consulted on the ingredients.

**Tactical advice:**
- Interview leaders to define what success and failure look like to them
- Ask leaders for their 'pet ideas' to remove the mystery and build creative buy-in
- Identify 'gatekeepers' for 1:1 pre-alignment before a broad strategy rollout

*Timestamp: 00:21:53*

---

> "I would start with what I call gatekeepers. And these are people who are absolutely... You have to get their one-on-one alignment and blessing on this before it moves forward."

**Insight:** A successful rollout relies on securing individual buy-in from key decision-makers before presenting to the wider organization.

**Tactical advice:**
- Pre-flight the strategy with 2-3 key gatekeepers in 1:1 meetings
- Conduct small-group roadshows (8-10 people) to allow for conversational Q&A
- Use the criteria and scoring from the strategy sprint to defend choices during reviews

*Timestamp: 00:58:10*


## Christine Itwaru
*Christine Itwaru*

> "We created this product digest... it's more about here's how you get ready for it, here's how you get jazzed about, and then the handoff... we don't teach them to sell... but we know that the product intimately enough to help them understand the new value."

**Insight:** A regular product digest can bridge the gap between product and revenue teams by focusing on value education rather than sales tactics.

**Tactical advice:**
- Publish a regular product digest for internal stakeholders
- Focus internal communications on helping revenue teams understand the 'new value' of features

*Timestamp: 00:45:43*


## Chris Hutchins
*Chris Hutchins*

> "you think that customer research is all you need to build a product at a company, but figuring out how to create excitement internally and get buy-in from other teams because they're the ones that are going to build it. They're the ones that are going to help market. It's all a team effort."

**Insight:** Internal excitement and cross-functional buy-in are as essential to product success as external customer validation.

**Tactical advice:**
- Build influence within the company to support your product bets
- Focus on persuading internal teams who will execute the vision

*Timestamp: 00:12:37*

---

> "when you push so hard for your ideas and you have really strong beliefs, you have to also make sure you state your intent. Because sometimes people think you're acting out of self-interest... 'Hey guys, I've got some crazy ideas, but before I say them, I just want you to know that all I care about is that the company is successful.'"

**Insight:** Explicitly stating your intent to help the company succeed prevents colleagues from interpreting strong product opinions as self-serving.

**Tactical advice:**
- Prefix controversial or bold ideas with a statement of intent
- Clarify that you do not care about 'owning' the idea, only its success

*Timestamp: 00:19:27*


## Chip Conley
*Chip Conley*

> "Process knowledge allows you to understand, how do you deal with an org chart and get things done partly because you understand the motivations of different groups?"

**Insight:** Alignment is often achieved through 'process knowledge'—understanding the underlying motivations of different departments to navigate the org chart.

**Tactical advice:**
- Study the motivations of cross-functional groups to better navigate internal politics and get projects approved

*Timestamp: 00:30:08*


## Claire Hughes Johnson
*Claire Hughes Johnson*

> "Never think that one communication, meaning an email or an all hands, reaches the audience. You have to be smart about how you communicate... Just like a marketer, use different channels. Some people read emails, some people watch videos, some people attend the meeting. Repeat."

**Insight:** Alignment requires a multi-channel communication strategy that repeats key messages until they are fully understood.

**Tactical advice:**
- Repeat core messages across multiple channels (email, video, meetings)
- Adopt the role of 'repeater-in-chief' to ensure alignment

*Timestamp: 01:12:23*


## David Placek
*David Placek*

> "Most clients... come to a naming project absolutely believing, with full confidence, that they're going to know it when they see it, and the truth is it almost never happens."

**Insight:** Stakeholders often have a false expectation that the right name will be immediately obvious and comfortable.

**Tactical advice:**
- Educate stakeholders early that they likely won't 'know it when they see it'
- Warn teams that the best names often feel uncomfortable initially

*Timestamp: 00:08:37*

---

> "We look for polarization. We look for tension in a team arguing about these things. Polarization is a sign of strength in the word."

**Insight:** Internal disagreement and tension are often indicators of a strong, high-energy name.

**Tactical advice:**
- Don't seek consensus; look for names that spark debate and strong reactions

*Timestamp: 00:00:37*

---

> "We really try to give that advice for it because it is about being successful in the marketplace. And so first of all, we try to separate the clients that we work with. We really want to work with clients that play to win, that want to win, not just want to not lose in a marketplace."

**Insight:** Alignment should be focused on market success rather than internal executive preference.

**Tactical advice:**
- Frame naming decisions around market winning rather than internal comfort
- Use prototypes (mock-up ads, merchandise) to help executives visualize the name in the real world

*Timestamp: 00:53:27*


## Dr. Fei Fei Li
*Dr. Fei Fei Li*

> "I realized that Silicon Valley did not talk to Washington DC and or Brussels or other parts of the world. And given how important this technology is, we need to bring everybody on board. So we created multiple programs from congressional bootcamp to AI index report to policy briefing, and we especially participated in policymaking."

**Insight:** For civilization-level technologies, alignment must extend beyond technical teams to include government, policy makers, and global regulatory bodies.

**Tactical advice:**
- Create educational bridges (like bootcamps or reports) to help non-technical stakeholders understand complex technology.
- Advocate for shared resources, such as a national AI research cloud, to democratize access and align interests.

*Timestamp: 01:12:10*


## Deb Liu
*Deb Liu*

> "What if I called it educating your manager about all the great work your team has been doing? What if I called it helping people see why your team should get more resources, you have to actually share what you do."

**Insight:** Reframing self-promotion as 'stakeholder education' helps individual contributors and introverts align with leadership and secure necessary resources.

**Tactical advice:**
- Frame status updates and self-reviews as educational tools for your manager
- Connect your personal achievements to the team's need for continued support and resources

*Timestamp: 00:00:28*


## Dmitry Zlokazov
*Dmitry Zlokazov*

> "It also requires a product owner to be able to get things done, just getting people down to consensus and understanding how your stakeholders, how to get them to the necessary decision and then blocking UTM so that eventually the value is shipped to customers."

**Insight:** Product owners must act as 'steamrollers' to drive consensus and unblock their teams when dealing with complex stakeholder environments.

**Tactical advice:**
- Proactively drive stakeholders toward necessary decisions to prevent team stagnation
- Focus on 'getting things done' by navigating regulatory and internal blockers

*Timestamp: 00:54:13*


## Dylan Field
*Dylan Field 2.0*

> "One of them is just, how do you unpack context? How do you get the context you've got in your head and really unpack it for a group? Another is, how to make sure that you're showing up in a way that folks know that we're all working towards the same goal?"

**Insight:** Effective leadership requires explicitly sharing the internal context in your head to ensure the group is aligned on the same goal.

**Tactical advice:**
- Explicitly 'unpack' the context behind your thinking for the team
- Ensure the team understands that everyone is working toward a unified objective

*Timestamp: 00:19:48*

---

> "I think it's your job as a leader to always try to investigate those areas, push on them, and if something's not adding up, really ask the hard questions and not shy away from them... I just try to keep pushing through that until we get to a point of, 'Okay, we at least know what we're trading off.'"

**Insight:** Clarity is achieved by leaning into 'murky' areas and asking difficult questions until trade-offs are fully understood.

**Tactical advice:**
- Investigate areas of a project that feel 'murky' or unclear
- Push for clarity on trade-offs even if the team doesn't fully agree on the path

*Timestamp: 00:21:15*


## Eeke de Milliano
*Eeke de Milliano*

> "We are doing a science fair. Where, each product team has a little booth. And they get to stand there, and anyone who has questions about the product can come... from the go-to-market side, can come and ask questions, and get demos, and go as deep as they need to."

**Insight:** A 'Science Fair' format allows for more interactive and deep-dive alignment between product and sales than a standard roadmap presentation.

**Tactical advice:**
- Host a 'Science Fair' where product teams demo features at individual booths
- Allow GTM teams to self-select which product areas they need to go deep on

*Timestamp: 00:55:40*


## Elizabeth Stone
*Elizabeth Stone*

> "A big part of my role is, can I explain how we're going to approach those technical problems in a way that builds competence with the content team? Can I try to understand their content strategy in a way that sets the technical teams up for success and we understand what we need to be able to deliver on here in terms of requirements."

**Insight:** Cross-functional alignment requires a leader to act as a translator between technical capabilities and business/content strategies.

**Tactical advice:**
- Translate technical roadmaps into business value to build confidence with non-technical partners
- Deeply understand the partner's strategy to define better technical requirements

*Timestamp: 00:16:27*


## Emily Kramer
*Emily Kramer*

> "We had a list of areas of responsibility which is just who owns what, it's not your job title. It's what are the things that you are the DRI for? It doesn't mean you're not going to collaborate with people on those things. So what are you the directly responsible individual for? And this made it really easy to know who to go to."

**Insight:** Use 'Areas of Responsibility' (AORs) to define clear ownership beyond job titles to reduce cross-functional friction.

**Tactical advice:**
- Maintain a public list of DRIs for specific tasks (e.g., website tests, onboarding copy).
- Update AORs as the team grows to ensure new hires know exactly what they own.

*Timestamp: 00:41:11*


## Evan LaPointe
*Evan LaPointe*

> "The starting point for influence is to choose your character and choose your mode... Am I the devil's advocate approach, or I'm the break it and see if it still stands after I hit it really hard with a sledgehammer kind of guy."

**Insight:** Effective influence requires being intentional about your 'character' or style and seeking permission for that role.

**Tactical advice:**
- Choose an influence 'character' (e.g., protector, caregiver, logic-based) that fits your personality.
- Explicitly ask for permission to play a specific role, like 'devil's advocate,' to reduce friction.

*Timestamp: 01:08:00*

---

> "The moderate influence... is the concept of teaching people something. And then when they live with this new knowledge, they'll see things that they weren't seeing before."

**Insight:** Influence can be achieved by providing stakeholders with new information that shifts their perspective over time.

**Tactical advice:**
- Use the 'Challenger' approach: teach stakeholders something new and let them experience the world with that knowledge.
- Avoid 'cramming' ideas down throats; give people a few days to live with new information before seeking a decision.

*Timestamp: 01:10:37*


## Fareed Mosavat
*Fareed Mosavat*

> "It is not just your job to get what you can get done with the resources in front of you. It's your job to marshal resources both inside your org and across your organization... you need to go out and do that work now. It is not just your job to get what you can get done with the resources in front of you."

**Insight:** Product leaders must move beyond working within existing constraints to actively marshaling the cross-functional resources and buy-in necessary to achieve business outcomes.

**Tactical advice:**
- Propose the specific resources (people, budget, cross-functional support) required to solve a problem rather than just accepting what is assigned
- Partner deeply with marketing, sales, and finance to ensure their roadmaps support your product goals
- Own the business outcome and impact rather than just the delivery of a specific feature set

*Timestamp: 00:38:57*


## Gaurav Misra
*Gaurav Misra*

> "As the company gets bigger, you can actually create alignment by causing internal virality... we would create these prototype products... and then we would just share the build and it would explode."

**Insight:** Use internal prototypes to generate excitement and 'internal virality' to align a large organization around a new direction without traditional meetings.

**Tactical advice:**
- Build functional prototypes rather than just writing PRDs to demonstrate value to stakeholders.
- Share early builds internally to see if they resonate with employees before a full rollout.
- Use internal momentum to bypass slow alignment processes and create a sense of urgency.

*Timestamp: 00:47:04*


## Gia Laudi
*Gia Laudi*

> "It made communicating with especially the product team and the engineering team a lot easier for me. So we were using a shared language. The rest of the company who aren't necessarily customer facing really understood, I think, at a different level what we were all doing together in KPIs."

**Insight:** A customer-centric journey map acts as a shared language that aligns cross-functional teams (Product, Engineering, Marketing) around value delivery.

**Tactical advice:**
- Use a visual storyboard of the customer journey to create alignment across departments
- Democratize the journey map so non-customer-facing teams understand their impact on the user

*Timestamp: 00:17:13*


## Geoff Charles
*Geoff Charles*

> "Whenever things went wrong at Ramp, it was when I was being prescriptive with regards to the solution without actually explaining and aligning upstream on the goal, the hypothesis, and the data."

**Insight:** Effective alignment happens by debating goals, hypotheses, and data interpretation rather than specific solutions.

**Tactical advice:**
- Debate the interpretation of data and hypotheses before discussing solutions.
- As a leader, focus on providing context so teams can make their own decisions.
- Repeat the strategy and vision constantly to ensure alignment.

*Timestamp: 00:16:39*


## Gustav Söderström
*Gustav Söderström*

> "I think the promise we should make to all employees is that even if they don't agree, they should be entitled to understand why you're making the decision. What I don't think is acceptable is to say, 'No, we're going to do it this way because I'm more senior.'"

**Insight:** Alignment is achieved not through consensus, but through the 'right to understand' the logic behind a decision.

**Tactical advice:**
- Use Socratic debate to ensure the best idea wins regardless of seniority
- Force yourself to explain instincts out loud; if you can't explain it, you likely don't understand it yet

*Timestamp: 01:06:06*


## Hilary Gridley
*Hilary Gridley*

> "What is much more helpful than understanding what your CEO thinks is, I think understanding how your CEO thinks. And that goes for all sorts of levels of the company. I want to understand how all the strategic leaders at my company think, and I want my team to understand how I think."

**Insight:** True alignment comes from understanding a leader's decision-making framework rather than just their current opinions.

**Tactical advice:**
- Analyze the recurring themes in a leader's feedback (e.g., 'this must feel like the future').
- Translate executive feedback into actionable principles for the team.
- Ask 'In what world does this make sense for this person?' to understand conflicting viewpoints.

*Timestamp: 00:29:44*

---

> "I talk about what I like to call the magic questions, but the thing about magic questions is they're not actually questions, they're statements and they end with, 'Do you agree?' Or 'Is that right?' ... I have found this, the most helpful way for kind of trying to understand a person's mental model is to just put facts in front of them and see what they say no to and what they say yes to."

**Insight:** Use declarative statements followed by a request for agreement to quickly map a stakeholder's mental model and boundaries.

**Tactical advice:**
- Instead of open-ended questions, state your interpretation of their rule or preference.
- End the statement with 'Is that right?' or 'Do you agree?'
- Use this to calibrate your judgment against theirs over time.

*Timestamp: 00:42:40*

---

> "Separate out my opinion from it, from the, 'Well, what is the insight that makes it make sense to this person' and explain their rationale. Even if I'm comfortable saying, 'I don't necessarily think this isn't how I would do it,' or 'I don't even really agree with how they're thinking about it, but from their point of view, from their perspective, their professional experience, whatever it is, I could see how this makes sense.'"

**Insight:** When disagreeing with a superior's decision, maintain team alignment by explaining the logical rationale from the leader's perspective.

**Tactical advice:**
- Perform the 'What if I'm wrong?' exercise to find the hidden insight in a leader's decision.
- Acknowledge your own disagreement while validating the leader's perspective to the team.
- Commit to executing the decision fully to see if the leader's hypothesis is correct.

*Timestamp: 00:40:04*


## Inbal S
*Inbal S*

> "A product manager role is a very influential role and a lot of the things you do is influencing other people... You need to influence the engineering team to build a product that you want them to build. You need to influence the revenue team to go with a go to market and sell the product the way you envision it."

**Insight:** Product leadership is primarily about influencing cross-functional partners who do not report to you.

**Tactical advice:**
- Build influencing skills early in your PM career
- Align the revenue team with the product vision to ensure effective go-to-market execution

*Timestamp: 40:16*

---

> "When I'm coming to something and I see all the issues that need to be fixed... you don't take people with you through that journey. So really analyzing that not everyone appreciate change the way you are... taking a step back and assessing what is happening so you can take the team with you on that journey of changing."

**Insight:** Driving change requires building a shared understanding of the 'why' rather than just executing on the 'what.'

**Tactical advice:**
- Slow down and explain the 'why' behind a change to get buy-in
- Adjust your communication style to fit the specific culture and character of the team

*Timestamp: 42:30*


## Ian McAllister
*Ian McAllister*

> "Trust is the currency of a product leader... Trust is just built by repeatedly setting and meeting expectations. And I think that's a good mantra to think about as a FM. Am I meeting the expectations that I set? And not just doing good things, but calling your shots, forecasting, setting a goal, and then hitting it."

**Insight:** Trust is built through the consistent cycle of forecasting outcomes and delivering on those promises.

**Tactical advice:**
- Tell the truth without fail
- Launch exactly what and when you said you would
- Own mistakes immediately rather than ignoring them

*Timestamp: 00:24:54*

---

> "I think it's trying to really understand, work backwards from that person and what are their goals and what are their organization's goals and honestly spend the time and the energy to try to get to alignment in the same place. And be willing, not just bullheaded... but taking some more time to try to forge an alliance with someone."

**Insight:** Effective alignment requires understanding the specific goals of other leaders and intentionally building alliances rather than just pushing a strategy.

**Tactical advice:**
- Work backwards from the stakeholder's specific goals and organizational needs
- Invest time in forging alliances before pushing for execution

*Timestamp: 00:34:09*


## Itamar Gilad
*Itamar Gilad*

> "I've seen cases where team B put aside their own ideas to jump on the ideas of team A, because of this model [the metrics tree]."

**Insight:** Visualizing goals through a metrics tree enables cross-functional teams to align on the highest-impact work regardless of team boundaries.

**Tactical advice:**
- Use a shared metrics tree to resolve resource conflicts between teams
- Review the 'GIST Board' with stakeholders bi-weekly to maintain alignment on learning milestones

*Timestamp: 00:31:10*


## Jackson Shuttleworth
*Jackson Shuttleworth*

> "All of our changes at Duolingo go through product review that are reviewed by Luis, so Luis reviews every single change that we propose, every experiment that we run."

**Insight:** Founder-level review of every experiment maintains a high product bar and prevents 'local maxima' traps.

**Tactical advice:**
- Establish a centralized product review with key leaders to ensure a cohesive user experience across experiments.

*Timestamp: 00:27:20*


## Jackie Bavaro
*Jackie Bavaro*

> "For the next two weeks, say yes to everything... I think you can find a way to do your job and still say yes to people. You can say, 'yes, I agree. That is a real problem. Yes. I think we could test this design with users' and just see what's different with two weeks of saying yes to people instead of no."

**Insight:** PMs can maintain alignment and collaboration by validating the problem behind a stakeholder's request rather than reflexively saying 'no' to the solution.

**Tactical advice:**
- Practice 'saying yes' to the validity of the problem being raised
- Use user testing as a collaborative way to evaluate stakeholder ideas instead of flat rejection

*Timestamp: 09:17*

---

> "Anytime you have these disagreements that feel really torny or they feel like a disagreement in values, that's a sign that really have a disagreement in strategy and that it's worth it to write down what your strategic framework is or what your strategic principle is and address the problem at that level, rather than fighting over individual features or individual decisions."

**Insight:** Persistent tactical disagreements are usually symptoms of unaligned high-level strategy or principles.

**Tactical advice:**
- Identify 'repeated disagreements' as a signal to pause and define strategy
- Resolve conflicts by aligning on strategic principles first

*Timestamp: 34:39*


## Jason M Lemkin
*Jason M Lemkin*

> "Every quarter, give your head of sales a certain budget, whether it's story points or 10% of the pie chart... you've got to decide now each quarter. And if you want to change during the course of the quarter... you can do it, but understand there's a high cost."

**Insight:** Reduce friction between Product and Sales by allocating a fixed percentage of engineering capacity for sales-driven feature requests.

**Tactical advice:**
- Allocate 10% of story points to the sales team for their priorities
- Hold a weekly meeting between the VP of Sales and VP of Product to manage this budget

*Timestamp: 01:13:21*


## Jason Shah
*Jason Shah*

> "Pushback is, I couldn't imagine a word more viscerally that makes you feel like you're sort of physically going against what somebody else wants, and it gears people into a mindset of then, well, how should I push back. It starts from a place of I need to disagree, I need to say no. It's a very negative mindset, purely based on the word that has come to label a behavior that alternatively could be about how do I shift the direction on something, or how do I help the business actually succeed when I disagree with somebody about something, and that's a very different mindset."

**Insight:** Reframe the concept of 'pushback' from a negative act of disagreement to a constructive effort to align on business success.

**Tactical advice:**
- Understand the underlying goal or issue the stakeholder has before disagreeing.
- Align your alternative direction with the stakeholder's ultimate goal.

*Timestamp: 00:00:00*


## Jeff Weinstein
*Jeff Weinstein*

> "Storyboard some solution visually with a Sharpie and not a pencil, not Figma initially... What is the unconstrained perfect solution to this burning problem? That's Pixar-style storyboard."

**Insight:** Low-fidelity, high-vision storyboarding aligns teams on the 'perfect' outcome before getting bogged down in technical constraints.

**Tactical advice:**
- Use a Sharpie to draw stick-figure storyboards of the ideal customer journey.
- Focus on the 'unconstrained' solution to inspire the team before scoping.

*Timestamp: 02:05:18*


## Jessica Hische
*Jessica Hische*

> "There's designers that will really fight you tooth and nail, because they're like, 'That is wrong, that is wrong,' but I know that some people just have to see it before they can let it go. Sometimes you have to walk down a path before you're able to understand what the right thing to do was all along."

**Insight:** Sometimes stakeholders need to see a 'wrong' direction visualized to gain the conviction needed to commit to the 'right' one.

**Tactical advice:**
- Allow stakeholders to explore 'bad' ideas (like specific colors or fonts) so they can mentally move past them.
- Use early explorations as validation for previous decisions rather than just as final outputs.

*Timestamp: 00:15:37*


## Judd Antin
*Judd Antin*

> "My metric for success is when they won't have that meeting without you. That's my metric for success. If they cannot have that decision making meeting without the researcher there, that means you've developed influence, strong, trusting relationships, you're an active participant in the process."

**Insight:** True stakeholder alignment for researchers is achieved when they are viewed as essential partners in the decision-making room, not just service providers.

**Tactical advice:**
- Build relationships where you are an active participant in product decisions from the beginning.
- Measure your influence by whether you are invited to key decision-making meetings.

*Timestamp: 00:31:38*

---

> "Did you read the last quarterly report, If it's a public company? Did you listen to the shareholder call?... Scour your Google Drive folder... look for all of the documents that are about this quarter, or this halves, or next half strategy. What are the OKRs? Understand the metrics and the conversion funnel."

**Insight:** To align with business stakeholders, researchers must learn the language of profit, metrics, and strategy.

**Tactical advice:**
- Read quarterly reports and listen to shareholder calls to understand business priorities.
- Frame research insights in the language of the conversion funnel and OKRs.

*Timestamp: 00:22:12*


## Julie Zhuo
*Julie Zhuo 2.0*

> "If you're like, 'My manager told me to do this, I think it's a terrible idea,' you've got to talk to your manager about it... once you engage in a dialogue, what will often happen is you'll learn more... you can probably decompose it from a blanket it's good or bad to like, 'Okay, this is a hypothesis, this is a hypothesis, this is a hypothesis.'"

**Insight:** To align on a controversial decision, break the proposal down into specific testable assumptions rather than judging it as a whole.

**Tactical advice:**
- Decompose a project you disagree with into its underlying hypotheses.
- Identify the specific assumption you disagree with and propose a small test to validate it.

*Timestamp: 01:12:44*


## Katie Dill
*Katie Dill*

> "What we do, and I've been doing it for the last decade or more, is having people within the design team share as a screenshot or a prototype of what they're working on in a shared deck... And we send it to the product managers and the engineer leaders and the leaders in the company because it is also a really great way for them to understand what's happening and what are we building together."

**Insight:** Visual status updates (screenshots/prototypes) are more effective for alignment than text-heavy documents.

**Tactical advice:**
- Maintain a shared deck of work-in-progress screenshots updated on a regular cadence (e.g., monthly)
- Use visual updates to identify redundant projects or collisions early

*Timestamp: 00:57:54*


## Kenneth Berger
*Kenneth Berger*

> "I really disagree with this product decision and I would really prefer that we make this different decision. I know it's not my call and I'm just one opinion and a lot of people are going to see things differently and that's fine, but it's important to me that you know that. So what do you think? Are you willing to reconsider this?"

**Insight:** Influence is often more effective when you state your preference clearly but with deep humility and respect for the decision-maker's authority.

**Tactical advice:**
- Acknowledge that you don't have the final call
- State your preference as an opinion rather than an objective truth
- Ask the stakeholder if they are willing to reconsider based on your input

*Timestamp: 00:31:23*

---

> "I'm hearing maybe you're lukewarm on May 1st as a date. What would be a hell yes day for you where you could say, absolutely, we can deliver on that?"

**Insight:** True alignment requires 'enthusiastic consent' or a 'hell yes' rather than a lukewarm agreement that leads to missed deadlines.

**Tactical advice:**
- Treat anything short of a 'hell yes' as a 'no'
- Ask stakeholders what it would take to get them to a 'hell yes' state

*Timestamp: 00:17:03*


## Lulu Cheng Meservey
*Lulu Cheng Meservey*

> "The reason I say go out in concentric circles... is that's your way to control the message. Because each circle is going to assume that the inner circle knows better than them and they're going to follow the lead of the inner circle... If employees are not saying that, then people are going to look at employees and say, 'Well, they would know, they're closer to this than we are.'"

**Insight:** Internal alignment is the foundation of external credibility; if employees aren't excited, external audiences won't be either.

**Tactical advice:**
- Never skip a circle in the communication sequence (Employees -> Board -> Investors -> Users).
- Treat employees as the most critical messengers because they are perceived as the most credible sources of truth.

*Timestamp: 00:23:18*


## Marc Benioff
*Marc Benioff*

> "It's not just about the product. It's not just about sales. It's not just about marketing... It's about everything, so you better be ready to be an orchestra leader. You can't just be playing the clarinet... You have to be constantly playing the whole symphony, and you have to have a big mind to think about, 'Whoa, I have a lot of stakeholders in my company, not just one stakeholder.'"

**Insight:** Leadership at scale requires moving from a functional specialist to an 'orchestra leader' who aligns product, sales, marketing, and external stakeholders.

**Tactical advice:**
- Balance the needs of diverse stakeholders (investors, employees, customers) simultaneously
- Avoid 'narrowcasting' or focusing solely on one department like product or technology

*Timestamp: 44:56*


## Marily Nika
*Marily Nika*

> "Whenever I try to convince leadership about something that I want to do that's a big bet, I always use examples and I'm like, "Hey, this seemed crazy at the time, here's how they work. What I'm proposing is very similar to this crazy thing. And then I propose a little contingency plan, like hey, if that doesn't work out, here's the rollback plan, here's the maximum impact it will have done in a negative way, which is not going to be too much.""

**Insight:** De-risk big AI bets for leadership by using adjacent success stories and providing clear rollback plans.

**Tactical advice:**
- Use successful 'AI-first' products from other companies as proof of concept for your proposals.
- Include a contingency plan and a 'maximum negative impact' assessment to gain buy-in for risky projects.

*Timestamp: 00:31:15*


## Maggie Crowley
*Maggie Crowley*

> "The first person I go to is typically speaking my engineering counterpart and I say, shred this, go through it, rip it apart, vomit comments on it, tear this down how it gets better."

**Insight:** Inviting early, harsh feedback from cross-functional partners builds buy-in and improves the final product.

**Tactical advice:**
- Ask engineering and design leads to 'shred' strategy and spec documents early
- Share strategy docs broadly to surface disagreements with specific data points rather than general plans

*Timestamp: 00:52:48*


## Matt LeMay
*Matt LeMay*

> "If you're doing product management really well, you never have to say yes and you never have to say no. You're giving people options and you're helping them understand the trade-offs."

**Insight:** Effective stakeholder management involves presenting choices and consequences rather than binary 'yes' or 'no' responses.

**Tactical advice:**
- Frame requests in terms of how they affect the team's ability to hit its impact goals.
- If forced to take on a new task, explicitly adjust the projected impact of existing goals to reflect the trade-off.

*Timestamp: 01:08:52*

---

> "Options and a recommendation is kind of the magic formula... when you present a single option, people's instinct is just to... start poking holes in it... whereas if you come in and say, 'Here are three options, here are the trade-offs, here's the one we recommend,' then every little bit of back and forth makes those options clearer and stronger."

**Insight:** Presenting multiple options with a clear recommendation prevents stakeholders from fixating on a single path and encourages constructive trade-off discussions.

**Tactical advice:**
- Always present at least three options for major decisions.
- Include a specific recommendation to provide a starting point for the conversation.

*Timestamp: 01:12:00*


## Marty Cagan
*Marty Cagan*

> "The third is you have to learn the different parts of the business. You have to know how it's marketed, how it's sold, how it's paid for, how it monetizes. If there are any compliance, regulatory, privacy, security issues, you need to know what those are. So you have to convince those stakeholders that you understand what the issues are"

**Insight:** PMs must build trust with stakeholders by demonstrating a deep understanding of business constraints like legal, finance, and sales.

**Tactical advice:**
- Learn the specific constraints of marketing, sales, and compliance departments
- Show stakeholders prototypes early to ensure business viability

*Timestamp: 00:40:41*

---

> "The third is unencumbered access to the stakeholders because a good product is solving what's just now possible... in ways that work for the business, which is why the stakeholder access is so critical. If you have those three things, direct access to those three things, that's what's critical."

**Insight:** Direct communication with stakeholders is a 'sacred' requirement for effective product management to ensure business viability.

**Tactical advice:**
- Maintain direct, unmediated access to business stakeholders
- Do not delegate stakeholder management to intermediaries

*Timestamp: 00:50:47*

---

> "You are the person on the team that represents the compliance issues, the sales issues, the marketing issues, the financial cost issues, the monetization issues, go to market in general. This is all legal constraints. This is all the product manager."

**Insight:** The PM acts as the central point for navigating and representing various business constraints and stakeholder requirements.

**Tactical advice:**
- Deeply understand the constraints of legal, sales, marketing, and finance to represent them within the product team.
- Avoid 'design by committee' by having the PM bring stakeholder knowledge directly to the team's decision-making process.

*Timestamp: 00:24:09*


## Matt Mochary
*Matt Mochary*

> "If I want to make you really feel heard, I reflect back what I imagine are the thoughts in your head... I say something to you like, 'Lenny, I think what I'm hearing you say is you're off and you're thinking, screw you, Matt. How dare you walk into the office and not even say hello to me? Is that close?'"

**Insight:** Deep alignment is achieved by reflecting back the unspoken, often stronger emotions and thoughts of the other person.

**Tactical advice:**
- Repeat back what you heard until the other person confirms you understood them correctly.
- Try to articulate the 'unspoken' thoughts or frustrations you suspect the other person is feeling to make them feel truly understood.

*Timestamp: 00:33:00*


## Melissa Perri + Denise Tilles
*Melissa Perri + Denise Tilles*

> "They're not going to handle hard stakeholder conversations about trade-offs for you, all of those things that you are going to want to keep ownership of because at the end of the day as a product manager, your job is to produce outcomes."

**Insight:** Product managers must retain ownership of difficult stakeholder negotiations and trade-off decisions to remain accountable for outcomes.

**Tactical advice:**
- Own the final decision-making rights and the communication of trade-offs to stakeholders

*Timestamp: 00:25:49*


## Melissa Perri
*Melissa*

> "One of the biggest issues I see in organizations is when executives all have different goals, and they're not aligned on the same goals for the company... And the executive team should be one team."

**Insight:** Product strategy fails when the executive team operates with competing departmental goals rather than a unified company objective.

**Tactical advice:**
- Facilitate trade-off conversations between executives to align on which 'strategic intents' take priority.
- Ensure sales, marketing, and product are all measured against the same high-level business outcomes.

*Timestamp: 28:39*

---

> "What do we hope will happen when we release this? - best question anyone can ask."

**Insight:** This simple question aligns stakeholders around outcomes.

**Tactical advice:**
- Ask before starting any feature
- Get alignment on metrics

*Timestamp: 00:59:24*


## Molly Graham
*Molly Graham*

> "Escalation is a tool... People get stuck with two people with equal power trying to solve a problem. You can spend so much time bashing heads... actually what you just need to do is go up."

**Insight:** Escalation is a collaborative tool to gain clarity or decision-making power, not a personal failure or 'tattling.'

**Tactical advice:**
- When stuck in a disagreement, go together with the other party to a manager to present the case and get a decision.
- Use escalation to unblock work quickly when context or authority is missing.

*Timestamp: 01:16:04*


## Nancy Duarte
*Nancy Duarte*

> "When people can see that and it accompanies your verbal narrative, they can actually understand what you're conveying and move on... those moments of alignment are so, so important."

**Insight:** Visualizing abstract concepts through diagrams or live sketching is the most effective way to ensure a group has a shared mental model.

**Tactical advice:**
- Use whiteboards or napkins to draw what you see in your mind's eye
- Create architecture or process diagrams to clarify complex systems
- Ask others to sketch their understanding to identify gaps in alignment

*Timestamp: 00:37:20*


## Nicole Forsgren
*Nicole Forsgren*

> "Not pursuing this in both a top-down and a bottom-up structure, right. And I think that can really help drive success, and having good communication throughout is super, super important, right. So getting your ICs bought in and helping them understand that this is for them... And then chatting with leaders and understanding what their motivations are."

**Insight:** Organizational initiatives like improving developer experience require simultaneous buy-in from both leadership and individual contributors.

**Tactical advice:**
- Communicate to ICs that measurement is a tool for their benefit, not for surveillance.
- Translate technical improvements into business value points that resonate with executive leadership's strategic priorities.

*Timestamp: 00:45:53*

---

> "In part, it depends on what your leadership chain really cares about... If they've been talking about market share? Losing market share or competitiveness in the marketplace, if that's it, focus on speed... if they're talking about profit margin all the time... look for ways that you can save money and then translate that into recovered and recouped headcount cost."

**Insight:** To gain alignment for internal initiatives, frame the benefits using the specific business metrics and language that leadership prioritizes.

**Tactical advice:**
- Listen for recurring themes in leadership communication (e.g., 'velocity', 'margin', 'transformation').
- Translate technical improvements (like faster builds) into business outcomes (like cloud cost savings or faster time-to-market).

*Timestamp: 00:49:28*


## Nir Eyal
*Nir Eyal*

> "My wife and I used to have conflicts over who's going to pick up our daughter... we take maybe five minutes a week. Sunday evening, we sit down together. Let me look at your schedule. Let me look at my schedule. 'Okay, now we're synchronized.' We prevent so many conflicts just by doing this simple schedule sync process."

**Insight:** Regular 'schedule syncing' sessions prevent conflict by ensuring all stakeholders are aligned on time commitments and responsibilities.

**Tactical advice:**
- Hold a weekly 10-minute synchronization meeting to review the upcoming week's calendar.
- Use a physical or digital artifact (the calendar) as the basis for the alignment.

*Timestamp: 01:08:07*


## Noam Lovinsky
*Noam Lovinsky*

> "No one can be a bystander on product strategy. Just because you've got product in your title doesn't mean you're the only one that should be thinking about product strategy certainly at that level. ... The CFO, the head of people, everyone needs to have a seat at the table when it comes to product strategy."

**Insight:** Product strategy should be a collaborative effort across the entire leadership team, ensuring every function feels ownership of the company's direction.

**Tactical advice:**
- Present strategy in a way that allows non-product executives to engage and contribute
- Ensure every leadership team member feels their 'fingerprint' is on the company strategy

*Timestamp: 00:35:37*


## Richard Rumelt
*Richard Rumelt*

> "The problem of strategy inside an organization is diversity of interest and fear of action... action, when you do something in an organization of any size, it involves people changing what they do. It involves changing power relationships."

**Insight:** Organizational politics and conflicting interests are the primary barriers to executing a coherent strategy.

**Tactical advice:**
- Recognize that strategy will inevitably change power dynamics and prepare for resistance.
- Ensure there is a clear 'decider' to resolve disagreements among stakeholders.

*Timestamp: 01:14:11*


## Sachin Monga
*Sachin Monga*

> "I think the first thing was really treating my role in the beginning more as a facilitator than a decision maker when it comes to product... if Chris could have a really good sense of what all the teams are doing and if the teams knew where he was coming from and could start to get better at modeling him and his vision, that would be a win."

**Insight:** When joining a company with a product-minded founder, act as a facilitator to help the team 'model' the founder's vision and ensure the founder has visibility into team execution.

**Tactical advice:**
- Schedule weekly one-on-one syncs with the founder to align on big problems and worries.
- Focus on building trust by consistently delivering on the founder's core vision before asserting independent decision-making.

*Timestamp: 00:10:45*


## Seth Godin
*Seth Godin*

> "I started a newsletter internally... in it I would mention anybody in the engineering team who had worked on my project and I would say something good about them. And then I would print it out and put it in every single person's inner office mailbox. And within three months, four months, partly because the project was really good, 40 engineers were working for me and no one was reporting to me."

**Insight:** Publicly recognizing and celebrating the contributions of cross-functional partners builds social capital and alignment without formal authority.

**Tactical advice:**
- Create an internal communication channel (like a newsletter) to highlight the work of individual contributors.
- Deflect credit to the team to build de facto leadership and influence.

*Timestamp: 11:46*


## Shreyas Doshi
*Shreyas Doshi*

> "Jack was just listening through all of that... And then I remember very distinctly, he asked me one question which was something to the effect of, how does this make our users love Twitter more? Simple question. But then at some point I realized, yeah, we never really talked about that because we were so engrossed in all the other stuff."

**Insight:** Alignment can be achieved by cutting through technical and metric-based complexity with a single, vital, user-centric question.

**Tactical advice:**
- Use simple, fundamental questions about user value to refocus a distracted or overly technical stakeholder meeting.

*Timestamp: 00:19:38*

---

> "There are three levels of product work, impact, execution, and optics... we litigate the minutiae of whatever issue we are discussing, but we never really recognize that it's because we are default thinking at different levels. And so, this realization helped me better understand why there were conflicts between two very smart and well intentioned people."

**Insight:** Stakeholder conflict often arises from a mismatch in focus levels (e.g., a PM focused on execution vs. a CEO focused on impact).

**Tactical advice:**
- Identify the default 'level' of your stakeholder (Impact, Execution, or Optics) and adjust your communication to match it.
- Use the vocabulary of these three levels to objectively diagnose misalignments in product reviews.

*Timestamp: 00:46:12*

---

> "I noticed that actually, if you have a real product strategy, a real one that everybody is aligned with, that you have got pre-alignment on, then a lot of this nonsense we tend to do with annual planning actually goes away."

**Insight:** Securing pre-alignment on a core strategy prevents the friction and endless meetings typically associated with planning cycles.

**Tactical advice:**
- Get alignment on the strategy *before* the formal planning season begins.
- Use the strategy as a rigorous framework to handle escalations from sales or support.

*Timestamp: 16:25*


## Stewart Butterfield
*Stewart Butterfield*

> "We told every Slack administrator that this was coming weeks before it came. And we told them that we were going to set a default for their organization... but also that they could override that default, and also that the individual end users could override that system owner default."

**Insight:** When rolling out sensitive features, align stakeholders by providing advance notice and a tiered system of control and overrides.

**Tactical advice:**
- Provide administrators with advance notice of major feature changes
- Implement a hierarchy of defaults and overrides to balance organizational and individual needs

*Timestamp: 00:26:37*


## Shweta Shriva
*Shweta Shriva*

> "When you're working with let's say an engineering leader, being able to understand what are his or her constraints? Where is he or she coming from? What does impact look like to that person? And then understanding where you're aligned, where you're not aligned are things that you have to develop."

**Insight:** Alignment is built by understanding the specific constraints and definitions of success held by cross-functional partners.

**Tactical advice:**
- Identify what 'impact' means to your specific cross-functional partner (e.g., an engineering leader).
- Proactively map out areas of alignment and misalignment regarding constraints.

*Timestamp: 32:08*


## Tanguy Crusson
*Tanguy Crusson*

> "I misread the appetite and sense of urgency around that topic... we need a very strong trigger for why now to go after it. And I did not do a good enough job at articulating this. Why now? Why do we have to do this now versus in a year's time, in two years time?"

**Insight:** A successful business case requires a 'Why Now' trigger to move stakeholders from general excitement to active investment.

**Tactical advice:**
- Articulate why an opportunity is perishable or why delay is costly
- Identify the specific trigger that makes an investment urgent for the business

*Timestamp: 00:50:45*

---

> "Internal comms is everything there... weekly updates... tweet-sized update... weekly demo of the product and everything that we built. Show the momentum as much as possible... snippets from customer conversations. No one is going to read a research report that takes 30 minutes to read. Everyone is happy to watch a three-minute snippet with four customers talking about something."

**Insight:** Maintain momentum and protection for new bets through high-frequency, bite-sized internal communication.

**Tactical advice:**
- Send weekly 'tweet-sized' project updates to stakeholders
- Share short video snippets of customer interviews to build empathy and proof of value
- Use weekly demos to create a sense of an unstoppable 'high-speed train'

*Timestamp: 01:31:18*


## Tim Holley
*Tim Holley*

> "The old adage of you need to say something three times before people understand it. I would wager you need to say it another three times before they internalize it. And having that be part of the day-to-day conversation, it seems like such a small thing, but it adds up to having clarity on goal, the KPI point, and then clarity on why, the narrative point."

**Insight:** Effective alignment requires extreme repetition of the core narrative and KPI until they are fully internalized by the team.

**Tactical advice:**
- Repeat the core narrative at least six times to ensure internalization.
- Marry the 'what' (KPI) with the 'why' (narrative) in daily conversations.

*Timestamp: 00:11:36*


## Tomer Cohen
*Tomer Cohen*

> "Are you disagreeing or misunderstanding? If you're misunderstanding, let's spend the night. Let's get to a point where you can articulate my point of view in your words and I can do the same, but if we're disagreeing, let's stop. Why are we spending? Why wasting time just arguing it through?"

**Insight:** Efficient alignment requires identifying whether a conflict stems from a lack of understanding or a fundamental difference in opinion.

**Tactical advice:**
- Ask the other party to articulate your point of view in their own words to verify understanding.
- Stop the debate once a fundamental disagreement is identified rather than masking it as a misunderstanding.

*Timestamp: 00:09:03*


## Tristan de Montebello
*Tristan de Montebello*

> "This is a game for executive presence. If you think about somebody who you feel has great gravitas or great executive presence, they usually have, there's something about them that's saying, this person really believes in what they're saying. And what this game is showing you is that, hey, there's a way to fast track myself to that place. If I want to have more executive presence, let me bring a little bit more conviction to what I'm saying."

**Insight:** Executive presence is largely driven by the perceived conviction of the speaker, which can be developed through specific linguistic prompts.

**Tactical advice:**
- Use conviction-building phrases like 'I genuinely believe that' or 'This matters a ton' to anchor your points
- Practice advocating for ideas with high energy to ensure your message isn't lost to more vocal stakeholders
- Focus on 'thinking out loud' with confidence to match your communication style to your actual expertise

*Timestamp: 01:10:56*


## Upasna Gautam
*Upasna Gautam*

> "I implemented a system to manage that kind of intake with four different touch points or events. So we have weekly demo days, working sessions, breaking news dress rehearsals, and office hours."

**Insight:** A structured cadence of diverse touchpoints helps manage complex stakeholder relationships and product intake.

**Tactical advice:**
- Use 'Weekly Demo Days' to evangelize the product and preview features
- Host 'Office Hours' for troubleshooting and direct feedback
- Rename 'User Testing' to 'Working Sessions' to make them feel more collaborative for stakeholders

*Timestamp: 11:04*

---

> "When I'm talking to my journalists I'm not using technical terms or like content management technology terms. They have a whole different vocabulary that they use... you have to speak many different languages as a product manager."

**Insight:** Effective alignment requires translating product concepts into the specific 'lingo' and mental models of the stakeholder group.

**Tactical advice:**
- Learn the specific nicknames and shortcuts stakeholders use for existing tools
- Avoid technical jargon when communicating with non-technical users

*Timestamp: 38:27*


## Uri Levine
*Uri Levine 2.0*

> "We went back to the board and we offered them two options. Number one, we give you your money back. And number two, this is what we're going to try. And the interesting part is that investors don't want their money back. They did not invest in order to have their money back, they invest in order to make a significant impact."

**Insight:** When a major pivot is required, offering investors a choice between a refund and the new direction often secures their buy-in for the new path.

**Tactical advice:**
- Present a clear 'binary choice' to the board when pivoting: return capital or fund the new thesis.

*Timestamp: 01:01:43*


## Vikrama Dhiman
*Vikrama Dhiman*

> "There are three tenets that I define in working well as a product manager with others. Number one is raise difficult issues without being difficult to work with. Bring out important topics without drawing importance to yourself. And finally, you are in charge of getting the decisions made and not making all the decisions yourself."

**Insight:** Effective stakeholder management requires balancing the need to raise hard issues with a collaborative, ego-free approach to decision-making.

**Tactical advice:**
- Raise difficult issues without being difficult to work with
- Focus on getting decisions made rather than being the one who makes them
- Avoid seeking personal importance when highlighting critical topics

*Timestamp: 00:19:16*

---

> "What I've seen that people who do pushback very successfully and are still considered not difficult to work with, they are also able to bring the tempo of the conversation to a more logical space from an emotional space."

**Insight:** Successful pushback involves de-escalating emotional conversations and refocusing on logic.

**Tactical advice:**
- Bring the tempo of a conversation down to a logical space when emotions are high
- Use logical footing to make pushbacks feel like value-add rather than obstacles

*Timestamp: 00:25:38*


## Vijay
*Vijay*

> "One thing that I've found is the best way to get to a no, if you ultimately need to get there, is to try to make it work. Start trying to make yes work and document how you've tried to make yes work. And do that earnestly, not as an exercise of just an alternative that you're considering."

**Insight:** To effectively decline ideas, first sincerely attempt to find a path to 'yes' and document the process to provide a reasoned 'no'.

**Tactical advice:**
- Spend 10 minutes sincerely considering how an idea could work before defaulting to 'no'
- Document the exploration of the 'yes' path to show stakeholders the idea was taken seriously

*Timestamp: 04:55*


## Wes Kao
*Wes Kao*

> "watch for these different eyes light up moments because their face can't lie... those are great fodder for content that you might want to write about, for the angle of your sales pitch, for how you might want to explain something in the future. And you really cut out all the parts that make people go dead in the eyes and just say the parts that make their eyes light up."

**Insight:** Reading visceral physical reactions (like eyes lighting up) provides more honest data for alignment than verbal feedback.

**Tactical advice:**
- Observe the audience's face and demeanor to identify which specific points trigger genuine interest.
- Trim content that causes 'dead eyes' and double down on 'eyes light up' topics.

*Timestamp: 00:27:57*

---

> "Alex would always talk about trade-offs and he'd say, 'Wes, yes, I can design this PDF for you. That means that the thing that I was going to work on today, which was redesigning this page on the site, will have to wait until later this week.'... it went from being a conversation about yes or no... into, hey, how do we make sure that the important right things get done?"

**Insight:** Aligning with stakeholders on new requests is more effective when framed as a trade-off between existing priorities rather than a simple 'yes' or 'no'.

**Tactical advice:**
- When asked for a new task, explicitly state what current task will be deprioritized to accommodate it.
- Ask the stakeholder to help decide which priority is more important.

*Timestamp: 00:46:21*

---

> "A sales note is meant to get people excited to do the thing you want them to do, and to agree to do it. And only then after they have bought in, does it make sense to share the logistics."

**Insight:** Always secure buy-in on the 'why' (sales) before diving into the 'how' (logistics).

**Tactical advice:**
- Start with a 30-second 'sales' pitch even for small requests
- Explain why the task benefits the business or solves a specific problem before giving instructions

*Timestamp: 00:11:07*

---

> "I'm a big proponent of speaking accurately. You can avoid a lot of problems if you speak accurately about your level of conviction and about the actual amount of evidence that you have for something."

**Insight:** Communicating the precise level of certainty prevents teams from over-investing in unproven hunches.

**Tactical advice:**
- Explicitly label initial thoughts as a 'hunch' or 'initial thinking'
- Differentiate between 'this is X' (fact) and 'this could be X' (hypothesis)

*Timestamp: 00:42:41*

---

> "MOO stands for Most Obvious Objection. A lot of times we're surprised by the questions that we get especially in meetings, we feel blindsided. When really, if you thought for even two minutes about what are obvious objections that I'm likely to get, you often immediately come up with what some of those things are."

**Insight:** Anticipating the most likely pushback allows you to address concerns proactively and stay on the front foot.

**Tactical advice:**
- Spend two minutes before a pitch identifying the 'Most Obvious Objection'
- Volunteer the counter-argument upfront to show rigorous thinking

*Timestamp: 00:50:26*

---

> "I don't have that number off the top of my head, but in the last quarter the number has been 60 to 70% and it's grown in the past year... Are you wondering if we are investing in mobile appropriately or where's that commission coming from, basically?"

**Insight:** When you don't have a specific answer, provide directional data and probe for the 'question behind the question.'

**Tactical advice:**
- Provide a range or historical context if the exact current stat is unknown
- Ask clarifying questions to understand the underlying concern of the stakeholder

*Timestamp: 00:56:10*


## Zoelle Egner
*Zoelle Egner*

> "The importance of relentlessly repeating the exact same stuff over and over again, even if you feel like everyone definitely knows... I repeated the same three talking points about why what we were doing mattered 5,000 times... You just have to get used to saying the same stuff."

**Insight:** Leaders must act as 'repeaters-in-chief' to ensure alignment, as most people require multiple exposures to internalize a message.

**Tactical advice:**
- Identify three core talking points and repeat them consistently
- Communicate the same message across multiple formats (writing, speaking, async)
- Don't stop repeating a message just because it feels boring to you

*Timestamp: 00:14:26*


## Ebi Atawodi
*Ebi Atawodi*

> "In terms of evangelizing, I think about three concentric circles. So the core of your vision is your team... Then I kind of go to this next layer, which is the stakeholders... and then finally, once you've got the feedback from stakeholders, you then go to leadership, and leadership really as high as possible."

**Insight:** Vision evangelism should move outward in concentric circles, starting with the core team to build a foundation of support before moving to broader stakeholders and executives.

**Tactical advice:**
- Socialize the vision first with the core team (PM, Eng, Design)
- Open documents for comments (not just view-only) to allow stakeholders to feel they have a say
- Present the vision at all-hands or to high-level leadership once the core is aligned

*Timestamp: 00:43:50*


## Keith Yandell
*Keith Yandell*

> "One thing I found super effective in those contexts is I try to ask the other side. So, let's take the profitability side. I ask them to make the growth case. I say, 'Tell me the three best reasons why we should actually focus on growth here.'"

**Insight:** Forcing stakeholders to 'steel-man' the opposing view generates instant empathy and helps resolve complex trade-off debates.

**Tactical advice:**
- Ask stakeholders to articulate the three best reasons for the opposing strategy
- Identify the specific motivations and goals of each person in the room to find common ground

*Timestamp: 28:30*


## Megan Cook
*Megan Cook*

> "Most of the time when people come to me and they want to ask how to get by-in, they've got a date in mind, they've got a particular meeting and they have this idea where they're going to crop this perfect proposal... And that's the wrong attitude I think even to start with to getting buy-in. It's more of a journey."

**Insight:** Treat buy-in as a collaborative journey of early partnership rather than a single high-stakes presentation.

**Tactical advice:**
- Partner with stakeholders early when ideas are still fuzzy to incorporate their perspectives
- Identify cross-functional partners (CTO, CMO, Design) who will be impacted and seek their feedback before the final meeting
- Explicitly state at the start of a meeting whether you are seeking a decision, feedback, or hypothesis testing

*Timestamp: 00:25:17*


## Naomi Gleit
*Naomi Gleit*

> "Extreme clarity means everyone's on the same page. It definitely doesn't mean that they all agree with each other, but they just have the same understanding of the facts. So we can disagree, but we all believe in the facts, which is that there's A, B, C, our options are X, Y, Z and here are the trade-offs 1, 2, 3."

**Insight:** Alignment is about shared understanding of facts and trade-offs, not necessarily consensus on the final decision.

**Tactical advice:**
- Document the facts, options, and trade-offs to ensure everyone has the same context
- Focus discussions on resolving misunderstandings before debating opinions

*Timestamp: 00:48:57*

---

> "One way to ensure extreme clarity is we have the shared vocabulary... That is what canonical nomenclature is literally writing out all the words in their definitions, so when we communicate, we are using the same vocabulary."

**Insight:** Establish 'canonical nomenclature' to prevent team members from talking past each other using different terms for the same thing.

**Tactical advice:**
- Create a glossary of terms and definitions for every major project

*Timestamp: 00:50:07*


## Nickey Skarstad
*Nickey Skarstad*

> "I've seen a lot of director level people through my career who will try to work on strategy in a vacuum alone. They'll write a document and they'll be like, 'Okay, team. Here's what we're doing. Here's our strategy.' And it never goes well. And it doesn't go well. It might be the right strategy, but because you did not bring people along on that journey to come up with it, they did not feel like they had a hand in crafting it themselves."

**Insight:** Strategy fails without collaborative buy-in; people must feel they had a hand in crafting the direction to support it.

**Tactical advice:**
- Avoid writing strategy in a vacuum; involve the team early in the journey
- Talk to leadership and the CEO to ensure organizational context is baked into the strategy

*Timestamp: 00:27:43*

---

> "I used Loom, which is another one of my favorite products... And so I just recapped, 'All right, here's what I presented to leadership. Here are the feedback that we got. Here's the strategic feedback that we got. And here are the changes we're going to make. Any questions, let me know.' And I posted it in Slack."

**Insight:** Using asynchronous video tools like Loom keeps feedback loops tight and ensures the team feels informed about leadership decisions immediately.

**Tactical advice:**
- Record short Loom recaps of leadership meetings to share with the team immediately
- Post updates in Slack to maintain transparency and excitement without waiting for weekly meetings

*Timestamp: 00:48:10*


## Paige Costello
*Paige Costello*

> "Always answer the question that they should have asked... there's actually another altitude, another point of strategy when you've- in a meeting or in a conversation to make sure that you're covering the more important point, the bigger picture, the alternative that the person asking the question maybe didn't see or consider."

**Insight:** When communicating with leadership, address the strategic context or the 'better' question rather than just providing a literal answer to build trust and show strategic thinking.

**Tactical advice:**
- Identify the strategic intent behind a stakeholder's question.
- Provide the answer to the literal question but pivot to the more important strategic point or alternative.

*Timestamp: 00:32:08*


## Tobi Lutke
*Tobi Lutke*

> "When someone disagrees with me, I tend to immediately stop and say, 'Cool, let's figure out why there's disagreement.'... What I'm looking for is offer unstated foundational assumptions. What is our divergence point? Because you might be right. In fact, people often are, when it gets to this point, I found. Sometimes it's an unstated foundational assumption that I hold that is incorrect."

**Insight:** Resolve stakeholder conflict by identifying the specific unstated foundational assumptions where parties diverge.

**Tactical advice:**
- Actively seek out disagreement to build trust and uncover better ideas
- Ask 'What is our divergence point?' to find unstated assumptions
- Play devil's advocate if a proposal feels too predictable or lacks surprise

*Timestamp: 00:56:08*


## Carilu Dietrich
*Carilu Dietrich*

> "Big growth levers can't be individual department goals without being cross company strategy."

**Insight:** Major growth initiatives fail when treated as departmental vs company-wide goals.

**Tactical advice:**
- Push for company offsites
- Build shared OKRs

*Timestamp: 00:43:30*


