---
name: startup-ideation
description: Help users generate and evaluate startup ideas. Use when someone is brainstorming business ideas, trying to find a startup concept, evaluating whether an idea is worth pursuing, or looking for unique market opportunities.
---

# Startup Ideation

Help the user generate and evaluate startup ideas using frameworks and insights from 2 product leaders.

## How to Help

When the user asks for help with startup ideation:

1. **Understand their background** - Ask about their personal experience, skills, and what problems they've encountered firsthand
2. **Explore information sources** - Discuss what they read, who they talk to, and whether their information diet is differentiated
3. **Apply the Why Now test** - Help them identify what has changed that makes this idea newly possible
4. **Identify tarpit risks** - Flag common idea patterns that attract many founders but rarely succeed

## Core Principles

### Go off the beaten path
Dalton Caldwell: "Try to go more off the beaten path either from your personal experience." The best startup ideas come from unique personal experiences and perspectives that others don't have access to. Avoid starting from popular trends that everyone is chasing.

### Ask what's newly possible
Ryan Hoover: "What new thing can you build today that couldn't be built yesterday?" Look for technology shifts (like AI or Web3), behavior shifts, or infrastructure changes that create new opportunities that weren't viable before.

### Diversify your information diet
Build a unique perspective by consuming information from sources that most founders don't. If everyone reads the same articles and follows the same people, everyone will have the same ideas.

### Avoid idea tarpits
Certain startup ideas are attractive to many founders but rarely succeed. Be skeptical of ideas in crowded spaces where hundreds of companies have already tried and failed.

## Questions to Help Users

- "What problem have you personally experienced that frustrated you deeply?"
- "What do you know or have access to that most people don't?"
- "Why is this idea possible now when it wasn't possible two years ago?"
- "How many other startups are working on something similar, and why did they fail?"
- "What would have to be true for this to be a billion-dollar business?"

## Common Mistakes to Flag

- **Starting from trends instead of problems** - Chasing hot topics like AI without a specific problem leads to undifferentiated products
- **Identical information diet** - Reading the same sources as every other founder produces the same ideas
- **Ignoring the Why Now** - Ideas without a clear reason they're newly possible often indicate missed timing
- **Tarpit ideas** - Certain idea categories attract founders repeatedly despite low success rates

## Deep Dive

For all 2 insights from 2 guests, see `references/guest-insights.md`

## Related Skills

- Measuring Product-Market Fit
- Defining Product Vision
- Working Backwards
- Startup Pivoting
