---
name: startup-pivoting
description: Help users decide when and how to pivot their startup. Use when someone is questioning their current direction, seeing poor traction, considering a major strategy change, or stuck in the pre-PMF stage.
---

# Startup Pivoting

Help the user decide when and how to pivot their startup using frameworks and insights from 2 product leaders.

## How to Help

When the user asks for help with pivoting:

1. **Assess the current state** - Ask about their traction, how long they've been trying, and what they've learned
2. **Evaluate if possibilities are exhausted** - Determine if they've truly tried everything or just one version of the idea
3. **Challenge pivot magnitude** - Most founders pivot too little; help them consider if they need a 200% pivot, not 10%
4. **Apply the Four Ps framework** - Evaluate changes across Problem, Persona, Product, and Positioning

## Core Principles

### Have you exhausted the possibilities?
Stewart Butterfield: "The decision is about have you exhausted the possibilities?" A pivot should come from rational analysis of what's been tried, not emotional attachment to a failing idea. Create distance between yourself and the current approach to evaluate honestly.

### Most pivots are too small
Todd Jackson: "Most founders do a 10% pivot, and what they need to be doing is a 200% pivot." When stuck in pre-PMF, small adjustments rarely break through. Consider whether you need to fundamentally change your approach rather than tweak the existing one.

### Use the Four Ps framework
Evaluate pivots across four dimensions: Problem (are you solving the right problem?), Persona (are you targeting the right customer?), Product (is your solution the right approach?), and Positioning (are you framing this correctly?). Often the issue is not one but a combination.

### Maintain rational distance
Emotional attachment to an idea can prevent founders from seeing clearly. The best pivot decisions come from treating your company like an outside investor would evaluate it.

## Questions to Help Users

- "What have you tried so far, and what did you learn from each attempt?"
- "If you were an outside investor looking at this company, what would you conclude?"
- "Is this a tweak to your current approach or a fundamental rethink?"
- "Which of the Four Ps (Problem, Persona, Product, Positioning) might be wrong?"
- "What would a 200% pivot look like compared to what you're considering?"
- "Have you truly exhausted the possibilities, or just gotten tired of trying?"

## Common Mistakes to Flag

- **Pivoting too small** - Making 10% changes when 200% changes are needed to find PMF
- **Emotional attachment** - Continuing because of sunk cost rather than evidence of potential
- **Pivoting too quickly** - Changing direction before truly learning why the current approach isn't working
- **Only changing one P** - Often multiple dimensions (problem, persona, product, positioning) need to change together
- **Pivoting without a thesis** - Random pivots don't help; you need a specific hypothesis about what was wrong

## Deep Dive

For all 2 insights from 2 guests, see `references/guest-insights.md`

## Related Skills

- Startup Ideation
- Measuring Product-Market Fit
- Defining Product Vision
- Customer Research
