---
name: systems-thinking
description: Help users think in systems and understand complex dynamics. Use when someone is dealing with multi-stakeholder problems, trying to understand second-order effects, managing platform ecosystems, or analyzing complex organizational dynamics.
---

# Systems Thinking

Help the user apply systems thinking to complex problems using frameworks and insights from 6 product leaders.

## How to Help

When the user asks for help with systems thinking:

1. **Map the system** - Help them identify all players, their incentives, and how they interact with each other
2. **Identify stocks and flows** - Understand what accumulates (stocks) and what moves between states (flows)
3. **Trace second-order effects** - Work through what happens after the first-order impact of any change
4. **Find leverage points** - Identify where small interventions can create large systemic changes

## Core Principles

### See the system
Seth Godin: "What does it mean to be a strategic thinker? It means to see the system." Understanding the invisible rules, culture, and interoperability that govern how products and organizations succeed or fail is the foundation of strategic thinking.

### Think about all players and incentives
Sriram: "Systems thinking. Think of all the players in the system, think of all of their incentives and how they interact with each other." This approach is superior to Jobs-to-be-Done for handling complex product trade-offs and multi-agent incentives.

### Use stocks and flows
Will Larson: "Systems thinking is basically you try to think about stocks and flows. Stocks are things that accumulate and flows are the movement from a stock to another thing." Model business processes like hiring pipelines or user funnels using this framework.

### Consider second, third, and fourth-order effects
Hari Srinivasan: "The skillsets that you think through and manage in a complicated ecosystem are quite different." Managing complex ecosystems requires understanding effects that cascade beyond the immediate impact.

### Think beyond today's decisions
Nickey Skarstad: "Second order thinking is you being able to think beyond the decisions that you're making today." Consider how current decisions impact future constraints and ecosystem dynamics.

### Automate recurring pains
Melissa Perri + Denise Tilles: "Tell me about some process you really hated and ended up trying to automate or build a system around to make it better." Identify recurring manual pains and build automated systems or frameworks to solve them.

## Questions to Help Users

- "Who are all the players in this system, and what does each one want?"
- "If you make this change, what happens next? And then what happens after that?"
- "What accumulates over time in this system (the stocks), and what flows between states?"
- "Where are the feedback loops - both reinforcing and balancing?"
- "What constraint, if removed, would unlock the most value in this system?"
- "What recurring manual pain could be systematized?"

## Common Mistakes to Flag

- **Only seeing first-order effects** - Changes ripple through systems in ways that aren't immediately obvious
- **Ignoring incentives** - Every player in a system responds to their own incentives, not yours
- **Optimizing locally** - Improving one part of a system can make the whole system worse
- **Missing feedback loops** - Many systems have self-reinforcing or self-balancing dynamics that amplify or dampen changes
- **Treating symptoms instead of causes** - Systems problems often require addressing root causes, not visible symptoms

## Deep Dive

For all 6 insights from 6 guests, see `references/guest-insights.md`

## Related Skills

- Setting OKRs & Goals
- Defining Product Vision
- Platform Strategy
- Organizational Design
