---
name: team-rituals
description: Help users design effective team rituals. Use when someone is building team culture, creating recurring team practices, trying to improve team communication, or establishing operational rhythms for their organization.
---

# Designing Team Rituals

Help the user design effective team rituals using frameworks and insights from 2 product leaders.

## How to Help

When the user asks for help with team rituals:

1. **Understand the goal** - Ask what behavior or outcome they want the ritual to drive
2. **Apply the golden rituals framework** - Ensure rituals are named, templated, and known by every employee's first Friday
3. **Design for specificity** - Help create rituals that go beyond generic meetings to drive specific outcomes
4. **Plan for adoption** - Discuss how the ritual will be introduced and maintained over time

## Core Principles

### Great companies have a small list of golden rituals
Shishir Mehrotra: "Great companies have a very small list of golden rituals. And there are three rules: they're named, every employee knows them by their first Friday, and they're templated." Rituals are the primary vehicle for culture and operational efficiency.

### Rituals are the engine of a great team
Lane Shackleton: "The rituals that I've been writing down are very personal. They're my take on how to do this." Go beyond simple meeting management to create rituals like Catalyst sessions, Dory Q&A, Tag-ups, and Flash Tags that serve specific purposes.

### Name your rituals
A named ritual becomes a shared concept that can be referenced and improved. "Let's do a Catalyst" is more powerful than "let's brainstorm" because it carries specific expectations.

### Template your rituals
Provide structure so anyone can run the ritual consistently. Templates reduce friction and ensure quality even when the ritual creator isn't present.

### Teach rituals early
If a new employee doesn't learn your golden rituals in their first week, they'll develop their own habits that may not align with team culture.

## Questions to Help Users

- "What outcome are you trying to drive with this ritual?"
- "What will you call this ritual - what's its name?"
- "Can someone run this ritual with just a template, without you being present?"
- "How will new team members learn this ritual in their first week?"
- "Is this ritual solving a real problem, or is it just another meeting?"
- "What existing rituals could this replace or enhance?"

## Common Mistakes to Flag

- **Too many rituals** - Great companies have a small list of golden rituals, not dozens of meetings
- **Unnamed rituals** - Without a name, a ritual can't become part of the culture's vocabulary
- **No template** - Rituals without structure degrade in quality over time
- **Late introduction** - Rituals learned after someone's first week are much harder to adopt
- **Generic meetings disguised as rituals** - A ritual should have a specific purpose beyond "staying aligned"

## Deep Dive

For all 2 insights from 2 guests, see `references/guest-insights.md`

## Related Skills

- Running Effective Meetings
- Building Team Culture
- Written Communication
- Onboarding New Hires
