---
name: technical-roadmaps
description: Help users create technical roadmaps. Use when someone is planning engineering work, prioritizing tech debt, building architecture roadmaps, or aligning technical and product strategy.
---

# Technical Roadmaps

Help the user create effective technical roadmaps using frameworks and insights from 1 product leader.

## How to Help

When the user asks for help with technical roadmaps:

1. **Understand the context** - Ask about their current technical state, team size, and business constraints
2. **Ensure it's written down** - A strategy that isn't documented can't be debugged or aligned around
3. **Apply the Rumelt framework** - Structure as Diagnosis (what's the problem), Guiding Policies (principles for decisions), and Actions (what you'll do)
4. **Favor boring strategies** - Help them resist the urge to introduce new tools when existing ones would suffice

## Core Principles

### Write it down
Will Larson: "The first rule of strategy is that if you write it down, then you can improve it. If it's not written down, it's hard to say if this PM is just not a good PM or if they're trying to apply a strategy they've misunderstood." A written strategy provides a baseline that can be critiqued and improved.

### Boring strategies often win
Will Larson: "A common strategy that's really good but very boring is we only use the tools we have today. Engineers want to introduce new programming languages, new databases, new cloud providers. A really good strategy for almost all companies is we just use the standard kit we already have." Focus engineering energy on business-valued problems rather than technical novelty.

### Use the Rumelt framework
Structure technical strategy using Richard Rumelt's framework: Diagnosis (what's the core challenge?), Guiding Policies (what principles will guide decisions?), and Actions (what specific things will you do?).

### Create a standard kit
Define a list of approved tools, languages, and platforms. This limits technical sprawl and allows teams to focus on solving core product problems rather than reinventing infrastructure.

## Questions to Help Users

- "Is this technical strategy written down somewhere that anyone can reference?"
- "What is the core technical challenge you're trying to solve (the diagnosis)?"
- "What principles will guide your technical decisions (the guiding policies)?"
- "Are you adding new tools because you need them, or because they're interesting?"
- "What does your 'standard kit' of approved technologies look like?"
- "How does this technical roadmap connect to business outcomes?"

## Common Mistakes to Flag

- **Unwritten strategy** - A strategy that only exists in someone's head can't be debugged or aligned around
- **Tool proliferation** - Introducing new technologies when existing ones would work creates maintenance burden
- **No connection to business value** - Technical roadmaps that don't tie to product or business outcomes lack justification
- **All diagnosis, no action** - Good strategy requires specific actions, not just analysis of the problem
- **Missing guiding policies** - Without principles, every technical decision becomes a debate from scratch

## Deep Dive

For all 2 insights from 1 guest, see `references/guest-insights.md`

## Related Skills

- Managing Tech Debt
- Platform Strategy
- Engineering Culture
- Prioritizing Roadmap
