---
name: user-onboarding
description: Help users design effective product onboarding. Use when someone is creating first-user experiences, trying to improve activation rates, designing the first 30 seconds of product usage, or working on the path to the aha moment.
---

# User Onboarding

Help the user design effective product onboarding using frameworks and insights from 4 product leaders.

## How to Help

When the user asks for help with user onboarding:

1. **Understand the aha moment** - Ask what the key value moment is and how quickly users need to reach it
2. **Design the first 30 seconds** - Focus intensely on what happens immediately after signup
3. **Apply game design principles** - Use progressive disclosure and reward mechanics from game design
4. **Connect to retention** - Ensure the onboarding inflects the early user experience toward long-term engagement

## Core Principles

### Make the first 30 seconds magical
Grant Lee: "We are going to do everything we possibly can to make the first 30 seconds of the product feel magical." The first moments of the user experience are the primary driver for word-of-mouth growth. Invest disproportionately here.

### Retention wins come from early experience
Dan Hockenmaier: "Very often I think the biggest wins in retention come from inflecting the early user experience." The onboarding experience is the biggest lever for long-term retention, not just initial activation.

### Design from onboarding outward
Merci Grace: "I would design the game from the onboarding experience." Use game design principles where onboarding isn't an afterthought but the foundation from which the rest of the product is built.

### Remove blockers to the aha moment
Cam Adams: "We worked a lot on the onboarding process in the last couple of months of launch and that was really pivotal because the product features were there but there was this thing holding people back." Product features may be complete, but invisible friction can prevent users from experiencing them.

### Avoid common onboarding anti-patterns
Skip carousels, non-native frameworks, and explanatory screens that don't provide value. Get users into the core product experience as quickly as possible.

## Questions to Help Users

- "What is the single moment where users first experience the core value of your product?"
- "What happens in the first 30 seconds after a user signs up?"
- "What friction is between signup and the aha moment, and can any of it be removed?"
- "Have you watched real users go through onboarding and seen where they struggle?"
- "How quickly can a user do something meaningful, not just view something?"
- "What would the onboarding look like if designed like a game tutorial?"

## Common Mistakes to Flag

- **Explanation screens instead of action** - Users learn by doing, not by reading about doing
- **Delaying the aha moment** - Every screen between signup and value is a potential dropoff point
- **Carousels and tooltips** - These patterns often indicate the product itself isn't intuitive enough
- **Treating onboarding as separate** - Onboarding should be designed as part of the core product, not bolted on
- **Ignoring the first 30 seconds** - This is where most users decide whether to invest further

## Deep Dive

For all 4 insights from 4 guests, see `references/guest-insights.md`

## Related Skills

- Measuring Product-Market Fit
- Designing Growth Loops
- Retention & Engagement
- Usability Testing
