---
name: vibe-coding
description: Help users build software using AI coding tools. Use when someone is using AI to generate code, building prototypes without deep technical skills, or exploring how non-engineers can create functional software through natural language.
---

# Vibe Coding

Help the user build software using AI tools and natural language, using frameworks and insights from 3 product leaders.

## How to Help

When the user asks for help with vibe coding:

1. **Understand the goal** - Ask what they're trying to build and who it's for (prototype, internal tool, production app)
2. **Guide the approach** - Help them break down the problem into smaller pieces for iterative AI prompts
3. **Set expectations** - Discuss what vibe coding is good for (prototypes, MVPs) versus when professional engineering is needed
4. **Coach on iteration** - Help them understand how to refine output through follow-up prompts

## Core Principles

### Vibe coding is a new skill
Elena Verna: "I vibe code myself so I would put that as even as a skill on my resume now." This is a distinct, transformative skill for non-technical roles - PMs, marketers, designers - to build functional software using natural language.

### Replace Figma with prototypes
Kevin Weil: "Instead of showing stuff in Figma, we should be showing prototypes that people are vibe coding over the course of 30 minutes to illustrate proofs of concept." Functional code prototypes can be built in the time it takes to create static mockups.

### Build tools to build tools
Alexander Embiricos: "They'll vibe code an animation editor and then they use the animation editor to build the animation." Non-engineers can now build functional software and custom tools without deep technical mastery.

### Go beyond prompt engineering
Vibe coding is not just writing prompts - it's iteratively building functional software through conversation with AI. It requires understanding how to break problems down, test outputs, and refine through follow-up.

### Know the limits
Vibe-coded software is great for prototypes, internal tools, and MVPs. Production-grade systems with complex requirements still need professional engineering review.

## Questions to Help Users

- "What are you trying to build, and who will use it?"
- "Is this a throwaway prototype or something that needs to scale?"
- "Can you break this down into smaller pieces to build incrementally?"
- "What's the simplest version that would let you test your hypothesis?"
- "Have you tried describing what's not working and asking the AI to fix it?"
- "Do you need this to be production-grade, or is it okay if it's rough?"

## Common Mistakes to Flag

- **Trying to build everything at once** - Break complex projects into smaller, iterative builds
- **Not testing the output** - Always run and test what the AI generates; don't assume it works
- **Expecting production quality** - Vibe-coded apps are great for validation but may need engineering for production
- **Unclear specifications** - The clearer your description of what you want, the better the output
- **Giving up after one try** - Vibe coding is iterative; refine through follow-up prompts

## Deep Dive

For all 3 insights from 3 guests, see `references/guest-insights.md`

## Related Skills

- Writing PRDs
- Usability Testing
- Building with LLMs
- Shipping Products
