---
name: working-backwards
description: Help users apply the working backwards methodology. Use when someone is defining a new product, writing a PR/FAQ, planning from a future state, or trying to clarify a product's value proposition before building.
---

# Working Backwards

Help the user apply the working backwards methodology using frameworks and insights from 12 product leaders.

## How to Help

When the user asks for help with working backwards:

1. **Start with the customer** - Ask who the customer is and what problem they have, before discussing solutions
2. **Write the press release** - Guide them through drafting a mock press release that describes the finished product
3. **Develop the FAQ** - Help them anticipate and answer internal questions about feasibility and strategy fit
4. **Test the three criteria** - Evaluate if the idea is big enough, strategically appropriate, and has a viable plan

## Core Principles

### Start with the customer problem
Ian McAllister: "Working backwards is all about the problem and starting there. Teams that do it wrong don't work backwards - they have something they want to build." Avoid retrofitting a problem to a pre-existing solution. Start with the problem paragraph before defining the solution.

### Trust that results follow value
Bill Carr: "Jeff would say, we took it as an article of faith. If we served customers well, things like revenue and share price would follow." Work backward from the ideal customer solution and trust that business metrics will follow.

### Use backcasting to escape the present
Christopher Lochhead: "Standing in that future, five years out, looking back to the present, what did we do to make this different future happen? That's how you unshackle yourself from the past." Envision a radical future and work backward without being constrained by current limitations.

### The PR/FAQ forces clarity
Bill Carr: "We're going to start by writing a press release describing the feature in a way that speaks to the customer. The idea better jump off the page as something a customer will really need." Write a problem paragraph, a solution paragraph, a customer quote, and a leadership quote before building anything.

### Evaluate three things
Ian McAllister: "One, is it a big idea? Two, is it something we should be doing? Three, is there a legitimate plan to succeed?" A successful product proposal must pass all three tests. The FAQ proves whether a legitimate plan exists.

### Define the ideal state first
Melanie Perkins: "Column B is work from this dream reality and work backwards from how to achieve that." Imagine the 'castle on the hill' - the mythical perfect experience - first, then build rungs on a ladder from today to that vision.

### Align the entire machinery
Anuj Rathi: "You're working backwards from an entire machinery at a particular day that is working. What will be the machinery we would have created so that this product is successful?" Working backwards includes GTM strategy, organizational alignment, and stakeholder buy-in, not just the product itself.

### Define the theoretical ideal
Nilan Peiris: "What is the theoretical minimum cost for moving money? What is the theoretical maximum speed? Not just make it instant, make it cheap, but what actually is the lowest it could possibly be?" Define the best possible outcome and work backward from that, not from incremental improvements.

## Questions to Help Users

- "Who is the customer, and what is their problem - in their words?"
- "If you wrote a press release for this product today, what would the headline be?"
- "What would a customer quote say about how this changed their life?"
- "Is this idea big enough to matter? Is your company the right one to build it?"
- "What's the FAQ that addresses the elephant in the room?"
- "What does the theoretical ideal state look like, not just an improvement?"

## Common Mistakes to Flag

- **Starting with the solution** - The most common failure is having a solution and retrofitting a problem to it
- **Vague customer benefit** - The press release must jump off the page with clear customer value
- **Skipping the FAQ** - Internal questions about feasibility and strategy are crucial for honest evaluation
- **Incremental thinking** - Work backward from the ideal, not from small improvements to the status quo
- **Only product focus** - Working backwards should include GTM, organizational alignment, and stakeholder management

## Deep Dive

For all 15 insights from 12 guests, see `references/guest-insights.md`

## Related Skills

- Defining Product Vision
- Writing PRDs
- Startup Ideation
- Setting OKRs & Goals
