# Working Backwards - All Guest Insights

*12 guests, 15 mentions*

---

## Anuj Rathi
*Anuj Rathi*

> "Essentially what you're working backwards from is an entire machinery at a particular day that is working for... For the date of GTM, what do we need to do from here till that particular day so that the GTM is successful, but also, what will be the machinery we would have created so that this product is successful?"

**Insight:** Working backwards is about aligning the entire organizational machinery and GTM strategy toward a specific launch date, not just writing a customer quote.

**Tactical advice:**
- Use the PRFAQ to identify potential internal alliances or stakeholders who might derail the project.
- Write three divergent and fully thought-through press releases to help leadership compare alternative routes.
- Include mandatory FAQs for specific organizational needs like compliance, legal, or marketplace impact.

*Timestamp: 00:25:20*


## Bill Carr
*Bill Carr*

> "Jeff would say, we took it as an article of faith. If we served customers well, if we prioritized customers and delivered for them, things like sales, things like revenue and active customers and things like the share price and free cash flow would follow. So therefore, when we're making a decision thinking about a problem, we're going to start with what's best for the customer and then come backward from there."

**Insight:** Start with the customer's needs and work backward to the solution, trusting that business results will follow customer satisfaction.

**Tactical advice:**
- Start every decision by asking what is best for the customer
- Work backward from the ideal customer solution to determine the necessary engineering and resource requirements

*Timestamp: 00:00:00*

---

> "The principle states something along the lines of that great leaders start with the customer's needs and work backwards from there to sort of meet those needs or solve them. Then also because we created a process in this window I was talking about earlier, the 2004 to 2007 window, we created this process for new product innovation called the Working Backwards PR/FAQ process."

**Insight:** Working backwards is both a leadership principle and a specific tactical process for product innovation.

**Tactical advice:**
- Ignore initial financial or resource constraints to first define the ideal customer solution
- Use the PR/FAQ process to codify the working backwards approach

*Timestamp: 00:35:37*


## Christopher Lochhead
*Christopher Lochhead*

> "He calls it backcasting as distinct from forecasting. ... standing in that future, five years out, looking back to the present, what did we do to make this different future happen? That's category design. That's how you unshackle yourself from the past."

**Insight:** Backcasting allows entrepreneurs to envision a radical future without being constrained by current limitations.

**Tactical advice:**
- Envision your company five years in the future and work backward to determine the steps needed to get there.
- Reject the premise of how things are currently done to open up new possibilities.

*Timestamp: 01:01:54*


## Daniel Lereya
*Daniel Lereya*

> "How do I imagine the company and the product is going to be different and better for our customers in a quarter from now? And from that, walk it backwards."

**Insight:** Effective planning starts with a clear vision of the future state and reverse-engineers the steps to get there.

**Tactical advice:**
- Create a single slide describing how the customer's life is different in one year
- Use future-state descriptions to identify which current projects are actually impactful

*Timestamp: 00:28:00*


## Donna Lichaw
*Donna Lichaw*

> "Start with the ending. Come up with how you want things to turn out, and then work your way back. And start as far out as you want... imagine you're there. Engage all your senses... And then if you've got something exciting, go back to the beginning and then imagine how you got there and just write that journey out."

**Insight:** The 'working backwards' framework is highly effective for identifying subconscious life goals and creating a roadmap for career fulfillment.

**Tactical advice:**
- Visualize a specific future success in detail (sights, sounds, feelings) and then reverse-engineer the steps required to reach that state.

*Timestamp: 01:13:06*


## Ian McAllister
*Ian McAllister*

> "Working backwards is all about the problem and starting there and obsessing about the problem and being guided by it to then go into the solution. So when teams that do it wrong is they don't do that. They don't work backwards. They have something they want to build... And if you say we could and it's not grounded in a customer or customer's problem, you're not working backwards."

**Insight:** The most common failure in working backwards is retrofitting a problem to a pre-existing solution rather than starting with the customer's pain.

**Tactical advice:**
- Start with the problem paragraph before defining the solution
- Avoid combining 'ingredients in the pantry' just because they exist; ensure they solve a specific problem

*Timestamp: 00:48:03*

---

> "The press release has a paragraph about the problem. That's what you write. And then you write the solution paragraph and then the customer quote. And then the fact which is is there a legitimate plan to succeed?"

**Insight:** The PR/FAQ mechanism is a tool to enforce the discipline of working backwards from the customer.

**Tactical advice:**
- Write a problem paragraph, a solution paragraph, and a customer quote
- Use the FAQ to detail the internal components, finances, and technical hurdles

*Timestamp: 00:51:00*

---

> "One, is it a big idea? And then second, is it something we should be doing?... And the third test, is there a legitimate plan to succeed? And you got to have all three of those things. And I think the FAQ part of the working backwards process is that early stage legitimate test of whether this thing has a plan."

**Insight:** A successful product proposal must pass three tests: scale of the idea, strategic fit, and a viable execution plan.

**Tactical advice:**
- Evaluate if the idea is big enough to matter
- Assess if the company is the right entity to solve the problem
- Use the FAQ to prove a 'legitimate plan to succeed'

*Timestamp: 00:56:09*


## Jason Shah
*Jason Shah*

> "Amazon is well-known for is the working backwards process, and for those that don't know, the idea is try to define effectively an ideal end state... and usually the mechanism for doing this is what's called a PRFAQ, and that's a press release and frequently asked questions, and it forces a certain degree of clarity to have to actually write a press release about the product that you're going to eventually launch."

**Insight:** The working backwards process uses a mock press release to force extreme clarity on the product's value proposition before development begins.

**Tactical advice:**
- Write a press release including an introduction, problem statement, solution, customer quote, leadership quote, and call to action.
- Include internal FAQs to de-risk the launch and address 'the elephant in the room'.

*Timestamp: 00:22:14*


## Melanie Perkins
*Melanie Perkins*

> "So column A is the traditional just work from today's world. Column B is work from this dream reality and work backwards from how to achieve that."

**Insight:** 'Column B' thinking involves starting with a perfect, improbable future and building the 'ladder' back to the present.

**Tactical advice:**
- Imagine a 'castle on the hill' (the mythical perfect experience) first
- Build 'rungs' on a ladder that lead from today's microscopic steps to the moon-shot vision

*Timestamp: 00:05:35*


## Nikhyl Singhal
*Nikhyl Singhal*

> "Work backwards from your end state. Almost think of career as a product. So if you're building a good product, you think about, 'Well, here's what a great product would look like,' and then you break it into version one, version two, version three."

**Insight:** Apply product development frameworks like 'working backwards' to design your long-term career path.

**Tactical advice:**
- Define your ultimate career end-state first
- Break the journey into 'versioned' roles that build toward that end-state

*Timestamp: 00:08:12*


## Nilan Peiris
*Nilan Peiris*

> "instead of incrementally going, doing a jump to make it a little better, a little better, a little better, you can never get there. How do we take two years, and end up there? ... What is the theoretical minimum cost for moving money into a market? What is the theoretical maximum speed? Not just make it instant, make it cheap, but what actually is the lowest it could possibly be?"

**Insight:** True innovation comes from defining the theoretical ideal and working backwards to solve the hard infrastructure problems required to reach it.

**Tactical advice:**
- Define the 'theoretical minimum' or 'ideal state' for your core value proposition
- Plan on a multi-year horizon to solve systemic issues rather than seeking incremental quarterly gains
- Ask what the 'best it could possibly be' looks like and work backwards from that point

*Timestamp: 00:23:24*


## Ryan Singer
*Ryan Singer*

> "What we found was that six weeks is the maximum that we can see into the future where we could actually say, 'How do we work backward and figure out something we could build in that six weeks and really land it?'"

**Insight:** Start with the fixed time constraint and work backward to define a scope that fits.

**Tactical advice:**
- Use the time box as a creative constraint to force simpler, more elegant solutions.
- Identify the 'end state' of the six-week cycle and map the necessary steps to reach it.

*Timestamp: 00:20:03*


## Shweta Shriva
*Shweta Shriva*

> "Amazon has this great process where the PMs have to write a press release for the finished product even before they start building the product. That's the first thing that they have to do is to write that press release like the product is about to launch today. What are you telling the users about that product? Really forces them to think about the value proposition more thoroughly."

**Insight:** Drafting a press release before development begins forces product managers to clarify the value proposition and user benefits early.

**Tactical advice:**
- Write a press release as if the product is launching today before any code is written.
- Use the press release to define exactly what you will tell users about the product's value.

*Timestamp: 26:05*


