---
name: writing-job-descriptions
description: Help users write effective job descriptions. Use when someone is creating a job posting, defining a new role, preparing to hire, or trying to attract the right candidates for an open position.
---

# Writing Job Descriptions

Help the user write effective job descriptions using frameworks and insights from 6 product leaders.

## How to Help

When the user asks for help with job descriptions:

1. **Define success first** - Ask what success looks like 12 months after the hire, not what tasks they'll do
2. **Identify the spike** - Determine the one or two areas where this person needs to excel (not everything)
3. **Write for progress** - Frame the role around the progress to be made, not a list of arbitrary tasks
4. **Consider the signal** - Discuss whether the language attracts or repels the right candidates

## Core Principles

### Start with 12-month success
Jonathan Lowenhar: "Start with, it's 12 months later, you hired the person, 12 months have gone by, you're clinking champagne because of how great it's been. What's changed about the business?" Define success by business impact after one year, not a list of responsibilities.

### Job descriptions are made up
Bob Moesta: "Job descriptions are made up. They're literally just made up - a list of stuff the manager wants plus stuff they don't want to do." Focus on the 'progress' the role enables rather than arbitrary feature requirements.

### Identify where they should spike
Lauren Ipsen: "Trying to determine where this person should major and minor, where they should spike. Is this someone that's going to lean into design efforts or operate like a very senior PM?" Define specific competencies required rather than seeking a generalist who does everything.

### Frame requirements as outcomes
Bob Moesta: "Don't tell me I need Excel, PowerPoint, and Word skills. Tell me what I'm going to do with those. Tell me you're going to need to build PowerPoints for executive alignment." Replace 'X years of experience' with specific capabilities that time is supposed to represent.

### Iterate based on candidates
Jason Shah: "Taking a product mindset where I meet people and don't know exactly what role they're going to fill. A product mindset on hiring and iterating on it based on the candidates you're meeting." Treat job descriptions as iterative documents that evolve with market reality.

### Use polarizing language intentionally
Anton Osika: "Long hours, high pace, candidates must thrive under high urgency. Those seeking comfortable work need not apply." High-signal, polarizing language filters for candidates who thrive in specific environments.

### Codify emerging roles
Peter Deng: "I asked her to write up a job description of what this thing is. There's something magical here. The role was model designer." Ask high-performing individuals to write their own ideal job description to identify new functional needs.

## Questions to Help Users

- "If this hire is wildly successful, what will be different about the business in 12 months?"
- "What is the one thing this person absolutely must be great at?"
- "What are you describing as requirements that are actually just proxies for something else?"
- "Who do you want to attract with this language, and who do you want to filter out?"
- "Is this role solving a specific problem, or is it a collection of tasks no one wants?"
- "What would 'making progress' look like for this person in their first 6 months?"

## Common Mistakes to Flag

- **Lists of tasks instead of outcomes** - Focus on what will be different because of this hire, not what they'll do daily
- **Requiring generalists** - Identify specific spikes; trying to find someone good at everything finds no one
- **'Years of experience' as a proxy** - This tells candidates nothing about what they'll actually need to do
- **Static descriptions** - Iterate on the role definition after meeting candidates and understanding the market
- **Bland language** - Generic job postings attract generic candidates; be specific and even polarizing

## Deep Dive

For all 9 insights from 6 guests, see `references/guest-insights.md`

## Related Skills

- Conducting Interviews
- Evaluating Candidates
- Onboarding New Hires
- Building Team Culture
