# Writing North Star Metrics - All Guest Insights

*27 guests, 35 mentions*

---

## Adriel Frederick
*Adriel Frederick*

> "What I thought was brilliant about it was not the metric, it was the designing it to be understood and communicated... Zuck just said 10 friends, 14 days, go. It just got people past the academic debate of like, All right, got it. As many friends as possible, the fast as possible, let's go."

**Insight:** The value of a North Star metric lies more in its ability to galvanize and align an organization than in its mathematical perfection.

**Tactical advice:**
- Choose a discrete, memorable number and timeframe to simplify communication.
- Use the metric to end 'academic debates' and move the team toward execution.

*Timestamp: 00:49:45*


## Aparna Chennapragada
*Aparna Chennapragada*

> "When you're looking at something zero-to-one. If you decide on a metric two prematurely, that's false precision first of all, right? I mean, CTR. When you have a thousand people, it doesn't mean anything. Retention also may not mean anything. So really being very wary of this big guy, big girl of grownup metrics as I call it, right? You are looking for more qualitative, the sound of click."

**Insight:** Early-stage products should avoid 'grown-up' metrics like retention or CTR in favor of qualitative signals and specific 'magic moments.'

**Tactical advice:**
- Avoid false precision in early-stage metrics
- Look for qualitative 'sound of click' signals from early users
- Identify specific high-value actions (like setting a timer) to nail first before measuring broad engagement

*Timestamp: 00:39:17*


## Bill Carr
*Bill Carr*

> "You know it's an input metric if it is measuring something with respect to the customer experience. Which ones are the right metrics, which ones are the most causal to the outputs... basically through an iterative process of measuring, observing, improving, and looking at what the effect is on your outputs."

**Insight:** North star metrics should be customer-centric inputs that have a causal relationship with business outputs.

**Tactical advice:**
- Map the end-to-end customer experience to identify potential input metrics
- Test metrics for causality by observing if improvements in the input lead to improvements in the output

*Timestamp: 01:01:02*


## Chris Hutchins
*Chris Hutchins*

> "the GM's goal is to sell out the tickets and win the conference championship and it actually tiers it down... explain how it all levels up to this one North Star metric for the company or two in that case."

**Insight:** Metrics should form a hierarchy where individual team goals clearly level up to the company's North Star.

**Tactical advice:**
- Use analogies (like a sports team) to explain metric hierarchies
- Ensure every team understands how their specific work impacts the primary metric

*Timestamp: 00:16:30*


## Elena Verna
*Elena Verna 3.0*

> "My north star metric is insights per minute. That's what I try to use whenever I have any live meetings with people so it squarely fits within what I'm optimizing for."

**Insight:** A North Star metric should reflect the core value or 'insights' delivered per unit of time to ensure alignment with user goals.

**Tactical advice:**
- Define a metric that measures the density of value delivered (e.g., 'insights per minute') rather than just volume.
- Use this metric to guide the preparation and execution of live meetings and presentations.

*Timestamp: 00:05:23*


## Gia Laudi
*Gia Laudi*

> "A critical part of that process obviously is identifying we have to measure success along the way. There should be a KPI for each of those stages in that customer journey... we try to tie the KPI obviously to some sort of meaningful product usage of that key part of the product or product attribute."

**Insight:** Every milestone in the customer journey must have a specific KPI tied to meaningful product usage to track progress toward value realization.

**Tactical advice:**
- Define a KPI for 'first value' (activation) and 'value realization' (full engagement)
- Tie KPIs to specific feature usage that correlates with customer success

*Timestamp: 00:38:10*


## Hari Srinivasan
*Hari Srinivasan*

> "Everything at LinkedIn is a very connected ecosystem... how you make decisions based on the very complicated ecosystem is actually not very difficult because we're all here to help people connect to economic opportunity. Every time there's a discussion... everyone knows how that decision is going to be made."

**Insight:** A clear, high-level North Star simplifies decision-making across complex, interconnected product ecosystems.

**Tactical advice:**
- Establish a singular, company-wide mission that serves as the ultimate tie-breaker for product decisions

*Timestamp: 00:07:18*

---

> "We think a lot about number of hires, converting hires. How many people did we match? Which is a real tangible way of looking at opportunity. And then number of people who learned a skill, which is usually in this world measured more by time than anything if you learn."

**Insight:** Translate abstract visions into tangible output metrics like successful matches or time spent learning.

**Tactical advice:**
- Measure marketplace success through conversion events (e.g., hires) and engagement depth (e.g., time spent learning)

*Timestamp: 00:32:46*


## Itamar Gilad
*Itamar Gilad*

> "The North Star metric measures how much value we create for the market. For example, let's take WhatsApp. WhatsApp for a very long time measured messages sent because every message sent is a little incremental of value for the sender, the receiver... In Airbnb, I think one of your key metrics or the real North Star metric was nights booked."

**Insight:** A true North Star metric should measure the specific unit of value delivered to the user, distinct from the value the business captures.

**Tactical advice:**
- Identify the 'value exchange'—what the user gets versus what the business gets
- Select a metric that tracks the core utility provided to the customer (e.g., messages sent, nights booked)

*Timestamp: 00:27:01*


## Jackson Shuttleworth
*Jackson Shuttleworth*

> "Duolingo cares, our growth North Star is DAUs, the metric that is most effective, where a percentage change in that metric is most effective at driving DAUs is current user retention rate."

**Insight:** A North Star metric (DAU) should be supported by a high-sensitivity input metric (CURR).

**Tactical advice:**
- Identify the specific retention metric that has the highest correlation with your North Star growth metric.

*Timestamp: 00:35:50*


## Jeff Weinstein
*Jeff Weinstein*

> "What was the value that we're trying to produce for the customer and can we measure it from their perspective? ... We suggested this metric to ourselves, companies that have no support tickets through the incorporation service."

**Insight:** The best metrics measure the successful delivery of value from the customer's point of view, rather than internal activity.

**Tactical advice:**
- Define metrics based on the absence of friction (e.g., 'zero support tickets').
- Ensure the metric is something you would be proud to show the customer.

*Timestamp: 00:45:52*

---

> "Picking metric titles that make you feel something... 'companies with zero support,' that's it. And the brevity and the focus and the customer mindset built into the chart name can become currency inside the company."

**Insight:** The naming and aesthetic presentation of a metric determine its cultural adoption and motivational power within a team.

**Tactical advice:**
- Use simple, evocative names for metrics instead of technical database field names.
- Maintain high hygiene on dashboards (consistent X-axes, limited significant digits) to encourage daily viewing.

*Timestamp: 01:05:00*


## Jess Lachs
*Jess Lachs*

> "Retention is a terrible thing to goal on. It's almost impossible to drive in a meaningful way in a short term. Ultimately, you want to find a short-term metric you can measure that drives a long-term output."

**Insight:** Avoid using lagging indicators like retention as primary goals; instead, identify and move the short-term input metrics that predict them.

**Tactical advice:**
- Identify proxy metrics that are sensitive to experimentation and correlate with long-term goals.
- Focus on inputs that the team can realistically influence within a quarterly or monthly timeframe.

*Timestamp: 00:00:19*

---

> "Keeping things simple is another thing I've learned... if people understand it, if they have an intuition around it, if it's something that people can talk about across the company, it's going to be a much better metric in terms of driving real outcomes than your made up composite score that nobody understands."

**Insight:** Simple, intuitive metrics are more effective at driving organizational behavior than complex composite scores.

**Tactical advice:**
- Prioritize metrics that non-technical stakeholders can intuitively understand and discuss.
- Avoid composite metrics with complex coefficients that obscure the relationship between action and result.

*Timestamp: 00:45:44*

---

> "It's so important to find these edge cases in these fail states and actually set concrete goals around eliminating them because it can be really powerful."

**Insight:** Averages can hide critical business failures; teams should set specific goals to eradicate 'fail states' or 'disaster' experiences.

**Tactical advice:**
- Identify 'fail states' (e.g., 'Never Delivered' orders) that cause extreme churn and high costs.
- Set concrete goals to reduce the frequency of these edge cases, even if they represent a small percentage of total volume.

*Timestamp: 00:56:27*


## John Cutler
*John Cutler*

> "I wrote the North Star Playbook in partnership with Jason who was a co-writer with that. We did a lot of one-to-one coaching sessions. I had these things called product therapy sessions when I would just wake up in the morning and just kind of soak in whatever problem people were having for the day."

**Insight:** North Star metrics are most effective when treated as a qualitative model that helps teams align on value before adding measurement.

**Tactical advice:**
- Use the 'three games of product' framework to categorize how your North Star inputs function.

*Timestamp: 00:07:46*

---

> "In Amplitude, we have this data informed product loop that we would teach, and it's basically, you need a strategy, you need to develop qualitative models, you need to add measurement to those models. So Northstar framework would be an example of a qualitative model."

**Insight:** The North Star framework serves as a qualitative model that bridges high-level strategy with specific measurements.

**Tactical advice:**
- Develop a qualitative model of your product's value before attempting to measure it.

*Timestamp: 01:09:02*


## Julie Zhuo
*Julie Zhuo 2.0*

> "Management is still really critical. You have a north star, you have a vision, and you're just trying to figure out how to use the resources that you have to get that thing done."

**Insight:** Management is fundamentally about defining a clear outcome and organizing resources to achieve it.

**Tactical advice:**
- Define a clear North Star and vision for the team.

*Timestamp: 00:00:22*

---

> "The first is defining the goal and defining the outcome and being really, really crystal clear on what does success look like... figuring out how to boil it down so that an agent can really understand what success and failure looks like is a lot of the game."

**Insight:** Working with AI agents requires the same level of objective success criteria as managing human teams.

**Tactical advice:**
- Create objective criteria to distinguish between success and failure for automated tasks.
- Use evals to provide objective measures of performance.

*Timestamp: 00:12:16*


## Kristen Berman
*Kristen Berman*

> "The real question, what does engagement mean? Actually, a have fun exercise that people could do with their teams is if you ask everyone on the team what engagement means separately, you can compare answers and most likely, people are saying different things."

**Insight:** Teams often lack alignment on core metrics like 'engagement,' which leads to fragmented product development.

**Tactical advice:**
- Run a workshop where team members define the core success metric separately to identify and resolve misalignments.

*Timestamp: 35:56*


## Lauryn Isford
*Lauryn Isford*

> "An activation rate that falls in a lower percentage range, maybe for most companies five to 15%, is better than one that falls in a higher percentage range because it means that there's likely much higher correlation with long-term retention and you're really working hard to get most of your users to reach a state that they're not reaching today."

**Insight:** A high-bar activation metric that only a small percentage of users reach is often more valuable because it correlates more strongly with long-term retention.

**Tactical advice:**
- Select activation metrics that have a high correlation with long-term retention
- Aim for a 'hard' activation milestone (5-15% success rate) to ensure it represents true product value
- Break down the North Star metric into component levers to identify specific areas for optimization

*Timestamp: 00:25:58*

---

> "A north star metric should really be a measure of what you plan to do, the strategy you plan to deliver is delivering results for the business on the other side, rather than the other way around."

**Insight:** North Star metrics should be dynamic and evolve to reflect the current business strategy rather than remaining static forever.

**Tactical advice:**
- Revisit North Star metrics every 6-12 months to ensure they still align with business goals
- Be willing to shift from revenue-focused metrics to user-growth metrics if the strategy requires a long-term view
- Use the North Star as a measure of strategic success rather than the sole driver of all decisions

*Timestamp: 00:37:27*


## Logan Kilpatrick
*Logan Kilpatrick*

> "Even if revenue is a goal, it's like revenue is not actually the goal. Revenue is a proxy for getting more compute, which is then actually what helps us get towards getting more GPUs so that we can train better models and actually get to the goal."

**Insight:** North Star metrics should be understood as proxies for the ultimate mission-critical resource (e.g., compute for AGI).

**Tactical advice:**
- Identify the 'intermediate layers' of your goals to understand what your metrics are actually a proxy for.
- Align metrics like revenue or adoption directly with the resource needs of the primary mission.

*Timestamp: 00:39:20*


## Manik Gupta
*Manik Gupta*

> "Having the right metrics is important, but it's incredible how many times people have the metrics but they don't instrument them. They'll have all these debates, because the product is not instrumented properly. And everybody will talk about the same metric, but they'll have different nuances in terms of, 'Oh, what does it really mean? What is a daily active user? Okay, daily means... Okay, I understand it's on a daily basis. What is active?' And there'll be debates about what is active. Pick a definition, instrument it, codify it. No confusion."

**Insight:** Metrics only drive alignment when they are backed by precise, codified definitions and accurate technical instrumentation.

**Tactical advice:**
- Codify the exact definition of 'active' for your product to prevent cross-functional debates.
- Ensure instrumentation is a core part of the development process so data is indisputable.

*Timestamp: 00:33:00*


## Marty Cagan
*Marty Cagan*

> "It's not that hard to go to the stakeholder that requested that and say, "We're going to get to work on that, but can you tell me how are you measuring success? We want to make sure that what we do, you consider it successful. How are you measuring success?""

**Insight:** Defining success metrics upfront allows a team to transform a feature request into a measurable problem to solve.

**Tactical advice:**
- Ask stakeholders for specific success metrics for every feature request
- Use KPIs like conversion rate or cart value to define the goal of a project

*Timestamp: 00:37:55*


## Mike Krieger
*Mike Krieger*

> "Traditional engagement metrics might be misleading when depth matters more than frequency... I think overall though... I think you know when your product is really serving people... so much of when you get really metrics obsessed is when you're trying to convince yourself that it is when it's not."

**Insight:** AI products require a shift from traditional Web 2.0 engagement metrics (like time spent) to metrics that capture utility and task completion.

**Tactical advice:**
- Be wary of optimizing for 'likability' or 'sycophancy' in AI models as it can degrade actual utility.
- Focus on whether the tool is helping users 'get their work done' or 'unlock creativity' rather than just daily active usage.

*Timestamp: 01:01:13*


## Noah Weiss
*Noah Weiss*

> "We did a lot of quantitative research and data science and wound up coming up with this new metric we call successful teams... what we found was that if you could get five people using Slack, the majority of the work week to just communicate at all, that would be a successful team there were going to be 400% more likely to upgrade over the next six months."

**Insight:** Identify a 'Successful Team' metric (e.g., 5 people active for most of a week) that serves as a leading indicator for long-term retention and upgrades.

**Tactical advice:**
- Find the specific threshold of users and activity that predicts a 400% increase in upgrade likelihood.
- Rally feature teams around this activation metric rather than just top-of-funnel or revenue metrics.

*Timestamp: 00:49:09*


## Ronny Kohavi
*Ronny Kohavi*

> "The OEC or the overall evaluation criterion is something that I think many people that start to dabble in A/B testing miss. And the question is, what are you optimizing for? And it's a much harder question that people think because it's very easy to say we're going to optimize for money, revenue. But that's the wrong question, because you can do a lot of bad things that will improve revenue. So there has to be some countervailing metric that tells you, how do I improve revenue without hurting the user experience?"

**Insight:** Use an Overall Evaluation Criterion (OEC) that balances primary goals with guardrail metrics to ensure long-term health rather than short-term gains.

**Tactical advice:**
- Define an OEC that is causally predictive of the lifetime value of the user
- Include countervailing metrics (like churn or unsubscribe rates) to prevent gaming the system

*Timestamp: 00:28:14*


## Sean Ellis
*Sean Ellis*

> "Step two for me is then figure out a metric that essentially captures units of that value being delivered. And so when I think about a north star metric, that's what I'm thinking about is something that reflects how many people are coming in and experiencing that product-market fit experience, whatever that is."

**Insight:** A North Star Metric should measure the aggregate delivery of the product's core value to users.

**Tactical advice:**
- Define the North Star based on the 'must-have' value identified in PMF surveys.
- Ensure the metric is an aggregate number (not a ratio) that can grow over time.

*Timestamp: 00:49:45*

---

> "I think monthly purchases is great because it maps to value that people are getting from Amazon... units of value from the customer perspective I think is more important than overall revenue. ... revenue should be a product of doing things. Right. It shouldn't kind of guide your day-to-day actions."

**Insight:** Focusing on value delivery metrics is more effective for long-term growth than focusing directly on revenue metrics.

**Tactical advice:**
- Avoid using revenue as a North Star Metric; use a proxy for customer value instead.
- Select a timeframe (daily, weekly, monthly) that matches the natural usage cycle of the product.

*Timestamp: 01:21:17*


## Sri Batchu
*Sri Batchu*

> "At Instacart, for example, our north star metric for growth was monthly active orders... At Ramp... the north star was dollars of SQL pipeline."

**Insight:** A good North Star metric should be intuitive, motivating, and directly impactable by the growth team while linking to business value.

**Tactical advice:**
- Select a North Star that represents volume/growth and is easily understood by the team
- Create a 'translation layer' that maps local team metrics (like conversion or load time) back to the North Star

*Timestamp: 00:32:43*


## Tim Holley
*Tim Holley*

> "having GMS as our north star KPI, just having that, being absolutely front and center, being the drumbeat that we talk about in every meeting, the measuring stick that we measure the success of launches against. And maybe it's a bit surprising, but we didn't have that type of clarity in the past."

**Insight:** A single, clear North Star metric provides a universal measuring stick for prioritization and aligns the entire organization.

**Tactical advice:**
- Use the North Star metric as the primary drumbeat in every meeting.
- Measure the success of every launch against this primary KPI.

*Timestamp: 00:09:29*


## Hila Qu
*Hila Qu*

> "I would say north star metric, because I find it's not only valuable to growth, it's valuable to just everything. When I think about what do I want to do with my career, does that fit my own personal north star metric?"

**Insight:** The North Star Metric is a foundational concept that provides long-term direction for both products and personal careers.

**Tactical advice:**
- Use a North Star Metric to filter out short-term noise and focus on long-term value

*Timestamp: 01:31:02*


## Josh Miller
*Josh Miller*

> "we really focus on one key metric as it relates to tracking our growth or how we are doing. We call it D5, D7. A lot of other companies call it L5, L7. But the human explanation for that is how many people turn to Arc at least five days a week? That is all we obsess over from a metrics perspective, because for us it captures retention, engagement, and growth in a single metric."

**Insight:** Use a single high-frequency usage metric (like D5/D7) to capture retention, engagement, and growth simultaneously without the risk of gaming the numbers.

**Tactical advice:**
- Track the number of users who are active at least 5 out of 7 days
- Focus on the week-over-week growth rate of this metric rather than absolute numbers

*Timestamp: 00:05:15*


## Nickey Skarstad
*Nickey Skarstad*

> "One of the things Airbnb did for experiences is we had this balancing metric, which was basically using the review rate as sort our end all, be all top line goal... we were obsessed with making sure every person who booked actually had a good experience when they showed up to experiences."

**Insight:** A quality-based North Star metric, like review rate, can effectively balance and guide growth metrics in early-stage products.

**Tactical advice:**
- Use review rates as a top-line goal to ensure quality isn't sacrificed for growth
- Pick quality metrics that 'balance or conflate' with growth metrics

*Timestamp: 00:08:40*


